/*
 * Decompiled with CFR 0.152.
 */
package com.ismacontrolli.nE2Link.parser.binary;

import com.ismacontrolli.nE2Link.BNanoBaseComponent;
import com.ismacontrolli.nE2Link.parser.binary.AbstractNanoData;
import com.ismacontrolli.serialization.DataMarker;
import com.ismacontrolli.serialization.SerializableForm;
import java.util.Arrays;

public class ObjectIdsData
extends AbstractNanoData {
    private int[] globalIds;

    private ObjectIdsData(SerializableForm serializableObjectIdData) {
        super(serializableObjectIdData);
        Object[] objectIds = serializableObjectIdData.data;
        this.globalIds = Arrays.stream(objectIds).mapToInt(s -> Short.toUnsignedInt((Short)s)).toArray();
    }

    public static ObjectIdsData make(BNanoBaseComponent[] components) {
        int[] globalIds = Arrays.stream(components).filter(comp -> comp != null && comp.getGlobalIndex() != -1).mapToInt(BNanoBaseComponent::getGlobalIndex).toArray();
        Object[] globalIdsAsShortObjects = Arrays.stream(components).filter(comp -> comp != null && comp.getGlobalIndex() != -1).map(comp -> (short)(comp.getGlobalIndex() & 0xFFFF)).toArray(Object[]::new);
        SerializableForm serializableForm = new SerializableForm(DataMarker.ObjectIdsData, globalIdsAsShortObjects);
        return new ObjectIdsData(serializableForm);
    }

    public static ObjectIdsData parse(SerializableForm serializableObjectIdData) {
        if (serializableObjectIdData == null) {
            LOGGER.severe(String.format("[ObjectIdsData.parse()]): Unexpected null data for serializableForm", new Object[0]));
            return null;
        }
        if (!serializableObjectIdData.marker.equals((Object)DataMarker.ObjectIdsData)) {
            LOGGER.severe(String.format("[ObjectIdsData.parse()]): Unexpected Data type: Expected marker: '%s', Received marker: '%s'.\nSkipping data processing.", new Object[]{DataMarker.ObjectIdsData, serializableObjectIdData.marker}));
            return null;
        }
        return new ObjectIdsData(serializableObjectIdData);
    }

    public int[] getGlobalIds() {
        return this.globalIds;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ObjectIdsData that = (ObjectIdsData)o;
        return Arrays.equals(this.globalIds, that.globalIds);
    }

    public int hashCode() {
        return Arrays.hashCode(this.globalIds);
    }

    public String toString() {
        return "ObjectIdsData{globalIds=" + Arrays.toString(this.globalIds) + '}';
    }
}

