/*
 * Decompiled with CFR 0.152.
 */
package com.ismacontrolli.nE2Link.parser.binary;

import com.ismacontrolli.nE2Link.BNanoBaseComponent;
import com.ismacontrolli.nE2Link.parser.binary.AbstractNanoData;
import com.ismacontrolli.nE2Link.parser.binary.AbstractNanoRequest;
import com.ismacontrolli.nE2Link.parser.binary.AbstractNanoResponse;
import com.ismacontrolli.nE2Link.parser.binary.MoveRequest;
import com.ismacontrolli.nE2Link.parser.binary.ObjectData;
import com.ismacontrolli.nE2Link.parser.binary.ResponseCode;
import com.ismacontrolli.serialization.DataMarker;
import com.ismacontrolli.serialization.SerializableForm;
import java.util.List;

public class MoveResponse
extends AbstractNanoResponse {
    private MoveResponse(AbstractNanoRequest request, ResponseCode responseCode) {
        super(request, responseCode);
    }

    private MoveResponse(AbstractNanoRequest request, List<SerializableForm> response) {
        super(request, response);
    }

    public static MoveResponse make(AbstractNanoRequest request, ResponseCode responseCode) {
        return new MoveResponse(request, responseCode);
    }

    public static MoveResponse parse(AbstractNanoRequest request, List<SerializableForm> response) {
        return new MoveResponse(request, response);
    }

    @Override
    public ObjectData getResponseData() {
        return (ObjectData)super.getResponseData(0);
    }

    @Override
    protected boolean isMalformedResponse(SerializableForm responseContentElement) {
        return !responseContentElement.marker.equals((Object)DataMarker.ObjectData);
    }

    @Override
    protected AbstractNanoData doParseResponseContentElement(SerializableForm responseContentElement) {
        ObjectData nanoObject = ObjectData.parse(responseContentElement, this.getRequest().getNe2DeviceExt());
        return nanoObject;
    }

    @Override
    protected boolean isParsedDataInvalid(AbstractNanoData parsedData) {
        ObjectData objectData = (ObjectData)parsedData;
        return super.isParsedDataInvalid(parsedData) || objectData.getGlobalIndex() == -1;
    }

    @Override
    public String getLocalizedMessage(int index) {
        BNanoBaseComponent requestData = ((MoveRequest)this.getRequest()).getClientRequestData();
        String extTypeName = null != requestData ? requestData.getOriginNameFromLibrary() : "";
        String extAssemblyName = null != requestData ? requestData.getAssemblyInfo() : "";
        String nanoName = null != requestData ? requestData.getNanoName() : "";
        String message = "";
        switch (this.getResponseCode()) {
            case OK: {
                message = LEX.getText("MOVE_OK", new Object[]{nanoName, extTypeName, extAssemblyName});
                break;
            }
            case ERROR: {
                message = LEX.getText("MOVE_ERROR", new Object[]{this.getErrorMessage()});
                break;
            }
            case NOT_CONNECTED: {
                message = LEX.getText("MOVE_NOT_CONNECTED", new Object[]{nanoName, extTypeName, extAssemblyName});
                break;
            }
            case NO_RESPONSE: {
                message = LEX.getText("MOVE_NO_RESPONSE", new Object[]{nanoName, extTypeName, extAssemblyName});
                break;
            }
            case INVALID_RESPONSE: {
                message = LEX.getText("MOVE_INVALID_RESPONSE", new Object[]{nanoName, extTypeName, extAssemblyName});
                break;
            }
            default: {
                return LEX.getText("ILLEGAL_RESPONSE_CODE");
            }
        }
        return message;
    }
}

