/*
 * Decompiled with CFR 0.152.
 */
package com.ismacontrolli.nE2Link.parser.binary;

import com.ismacontrolli.ifnetclient.model.RemoteDevice;
import com.ismacontrolli.nE2Link.BNanoBaseComponent;
import com.ismacontrolli.nE2Link.BNe2DeviceExt;
import com.ismacontrolli.nE2Link.parser.binary.AbstractNanoRequest;
import com.ismacontrolli.nE2Link.parser.binary.MoveData;
import com.ismacontrolli.nE2Link.parser.binary.MoveResponse;
import com.ismacontrolli.nE2Link.parser.binary.ResponseCode;
import com.ismacontrolli.serialization.SerializableForm;
import java.util.ArrayList;

public class MoveRequest
extends AbstractNanoRequest {
    private MoveRequest(BNe2DeviceExt ne2DeviceExt, MoveData requestData) {
        super(ne2DeviceExt, null, requestData);
    }

    public static MoveRequest make(BNe2DeviceExt ne2DeviceExt, int targetParentId, int[] childrenIds) {
        return new MoveRequest(ne2DeviceExt, MoveData.make(targetParentId, childrenIds));
    }

    @Override
    public MoveData getRequestData() {
        return (MoveData)super.getRequestData();
    }

    public BNanoBaseComponent getClientRequestData() {
        return (BNanoBaseComponent)((Object)super.getClientRequestData());
    }

    @Override
    public MoveResponse postRequest(RemoteDevice remoteDevice) {
        if (remoteDevice == null || !remoteDevice.Remote.isConnected()) {
            return MoveResponse.make(this, ResponseCode.NOT_CONNECTED);
        }
        ArrayList<SerializableForm> response = remoteDevice.Remote.Move(this.getRequestData().getSerializableForm());
        if (response == null) {
            return MoveResponse.make(this, ResponseCode.NO_RESPONSE);
        }
        if (this.isResponseMalformed(response)) {
            return MoveResponse.make(this, ResponseCode.INVALID_RESPONSE);
        }
        return MoveResponse.parse(this, response);
    }

    @Override
    public String getLocalizedMessage() {
        BNanoBaseComponent requestData = this.getClientRequestData();
        return LEX.getText("MOVE_REQUEST", new Object[]{null != requestData ? requestData.getNanoName() : ""});
    }
}

