/*
 * Decompiled with CFR 0.152.
 */
package com.ismacontrolli.nE2Link.parser.binary;

import com.ismacontrolli.nE2Link.actions.BNanoInvocationArg;
import com.ismacontrolli.nE2Link.parser.binary.AbstractNanoData;
import com.ismacontrolli.nE2Link.parser.binary.AbstractNanoRequest;
import com.ismacontrolli.nE2Link.parser.binary.AbstractNanoResponse;
import com.ismacontrolli.nE2Link.parser.binary.InvokeRequest;
import com.ismacontrolli.nE2Link.parser.binary.ResponseCode;
import com.ismacontrolli.nE2Link.parser.binary.WriteData;
import com.ismacontrolli.serialization.DataMarker;
import com.ismacontrolli.serialization.SerializableForm;
import java.util.List;

public class InvokeResponse
extends AbstractNanoResponse {
    protected InvokeResponse(AbstractNanoRequest request, ResponseCode responseCode) {
        super(request, responseCode);
    }

    private InvokeResponse(AbstractNanoRequest request, List<SerializableForm> response) {
        super(request, response);
    }

    public static InvokeResponse make(AbstractNanoRequest request, ResponseCode responseCode) {
        return new InvokeResponse(request, responseCode);
    }

    public static InvokeResponse parse(AbstractNanoRequest request, List<SerializableForm> response) {
        return new InvokeResponse(request, response);
    }

    @Override
    public AbstractNanoData getResponseData() {
        return super.getResponseData();
    }

    @Override
    protected boolean isMalformedResponse(SerializableForm responseContentElement) {
        return !responseContentElement.marker.equals((Object)DataMarker.WriteData);
    }

    @Override
    protected AbstractNanoData doParseResponseContentElement(SerializableForm responseContentElement) {
        return WriteData.parse(responseContentElement);
    }

    @Override
    public String getLocalizedMessage(int index) {
        BNanoInvocationArg requestData = ((InvokeRequest)this.getRequest()).getClientRequestData();
        String sourceComponent = requestData.getActionSourceComponent().getNanoName();
        String actionProperty = null == requestData.getActionProperty() ? "" : requestData.getActionProperty().toString();
        String actionName = requestData.getActionName();
        String parameter = null == requestData.getActionParameter() ? "" : requestData.getActionParameter().toString();
        String message = "";
        switch (this.getResponseCode()) {
            case OK: {
                message = LEX.getText("INVOKE_OK", new Object[]{sourceComponent, actionProperty, actionName, parameter});
                break;
            }
            case ERROR: {
                message = LEX.getText("INVOKE_ERROR", new Object[]{sourceComponent, actionProperty, actionName, parameter});
                break;
            }
            case NOT_CONNECTED: {
                message = LEX.getText("INVOKE_NOT_CONNECTED", new Object[]{sourceComponent, actionProperty, actionName, parameter});
                break;
            }
            case NO_RESPONSE: {
                message = LEX.getText("INVOKE_NO_RESPONSE", new Object[]{sourceComponent, actionProperty, actionName, parameter});
                break;
            }
            case INVALID_RESPONSE: {
                message = LEX.getText("INVOKE_INVALID_RESPONSE", new Object[]{sourceComponent, actionProperty, actionName, parameter});
                break;
            }
            default: {
                return LEX.getText("ILLEGAL_RESPONSE_CODE");
            }
        }
        return message;
    }
}

