/*
 * Decompiled with CFR 0.152.
 */
package com.ismacontrolli.nE2Link.parser.binary;

import com.ismacontrolli.ifnetclient.model.RemoteDevice;
import com.ismacontrolli.nE2Link.BNe2DeviceExt;
import com.ismacontrolli.nE2Link.actions.BNanoInvocationArg;
import com.ismacontrolli.nE2Link.parser.binary.AbstractNanoRequest;
import com.ismacontrolli.nE2Link.parser.binary.InvokeResponse;
import com.ismacontrolli.nE2Link.parser.binary.ResponseCode;
import com.ismacontrolli.nE2Link.parser.binary.WriteData;
import com.ismacontrolli.serialization.SerializableForm;
import java.util.ArrayList;

public class InvokeRequest
extends AbstractNanoRequest {
    private InvokeRequest(BNe2DeviceExt ne2DeviceExt, BNanoInvocationArg clientRequestData, WriteData requestData) {
        super(ne2DeviceExt, (Object)clientRequestData, requestData);
    }

    public static InvokeRequest make(BNe2DeviceExt ne2DeviceExt, BNanoInvocationArg invocationArg) {
        return new InvokeRequest(ne2DeviceExt, invocationArg, WriteData.make(invocationArg));
    }

    @Override
    public WriteData getRequestData() {
        return (WriteData)super.getRequestData();
    }

    public BNanoInvocationArg getClientRequestData() {
        return (BNanoInvocationArg)((Object)super.getClientRequestData());
    }

    @Override
    public InvokeResponse postRequest(RemoteDevice remoteDevice) {
        if (remoteDevice == null || !remoteDevice.Remote.isConnected()) {
            return InvokeResponse.make(this, ResponseCode.NOT_CONNECTED);
        }
        ArrayList<SerializableForm> response = remoteDevice.Remote.Invoke(this.getRequestData().getSerializableForm());
        if (response == null) {
            return InvokeResponse.make(this, ResponseCode.NO_RESPONSE);
        }
        if (this.isResponseMalformed(response)) {
            return InvokeResponse.make(this, ResponseCode.INVALID_RESPONSE);
        }
        return InvokeResponse.parse(this, response);
    }

    @Override
    public String getLocalizedMessage() {
        BNanoInvocationArg requestData = this.getClientRequestData();
        String sourceComponent = requestData.getActionSourceComponent().getNanoName();
        String actionProperty = null == requestData.getActionProperty() ? "" : requestData.getActionProperty().toString();
        String actionName = requestData.getActionName();
        String parameter = null == requestData.getActionParameter() ? "" : requestData.getActionParameter().toString();
        return LEX.getText("INVOKE_REQUEST", new Object[]{sourceComponent, actionProperty, actionName, parameter});
    }
}

