/*
 * Decompiled with CFR 0.152.
 */
package com.ismacontrolli.nE2Link.parser.binary;

import com.ismacontrolli.nE2Link.parser.binary.AbstractNanoData;
import com.ismacontrolli.serialization.DataMarker;
import com.ismacontrolli.serialization.SerializableForm;
import java.time.LocalDateTime;
import java.util.Objects;

public class FolderItem
extends AbstractNanoData {
    private String name;
    private boolean isDirectory;
    private boolean isFile;
    private LocalDateTime dateTime;

    private FolderItem(SerializableForm serializableData) {
        super(serializableData);
    }

    public static FolderItem make(String folderPath) {
        Object[] folderData = new Object[]{folderPath};
        SerializableForm serializableForm = new SerializableForm(DataMarker.FolderData, folderData);
        return new FolderItem(serializableForm);
    }

    public static FolderItem parse(SerializableForm serializedItemData) {
        if (serializedItemData == null) {
            LOGGER.severe(String.format("[FolderItem.parse()]): Unexpected null data for serializableForm", new Object[0]));
            return null;
        }
        if (!serializedItemData.marker.equals((Object)DataMarker.FolderItem)) {
            LOGGER.severe(String.format("[FolderItem.parse()]): Unexpected Data type: Expected marker: '%s', Received marker: '%s'.\nSkipping data processing.", new Object[]{DataMarker.FolderItem, serializedItemData.marker}));
            return null;
        }
        FolderItem fi = new FolderItem(serializedItemData);
        fi.isDirectory = serializedItemData.data[0] == DataMarker.FolderData;
        fi.isFile = serializedItemData.data[0] == DataMarker.FileData;
        fi.name = (String)serializedItemData.data[1];
        fi.dateTime = (LocalDateTime)serializedItemData.data[2];
        return fi;
    }

    public String getName() {
        return this.name;
    }

    public boolean isDirectory() {
        return this.isDirectory;
    }

    public boolean isFile() {
        return this.isFile;
    }

    public LocalDateTime getDateTime() {
        return this.dateTime;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FolderItem that = (FolderItem)o;
        return this.isDirectory == that.isDirectory && this.isFile == that.isFile && Objects.equals(this.name, that.name) && Objects.equals(this.dateTime, that.dateTime);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.isDirectory, this.isFile, this.dateTime);
    }
}

