/*
 * Decompiled with CFR 0.152.
 */
package com.ismacontrolli.nE2Link.parser.binary;

import com.ismacontrolli.nE2Link.parser.binary.AbstractNanoData;
import com.ismacontrolli.nE2Link.parser.binary.FolderItem;
import com.ismacontrolli.serialization.DataMarker;
import com.ismacontrolli.serialization.SerializableForm;
import java.util.ArrayList;
import java.util.List;

public class FolderData
extends AbstractNanoData {
    private String path;
    private List<FolderItem> folderItems = new ArrayList<FolderItem>();

    private FolderData(SerializableForm serializableData) {
        super(serializableData);
    }

    public static FolderData make(String folderPath) {
        Object[] folderData = new Object[]{folderPath};
        SerializableForm serializableForm = new SerializableForm(DataMarker.FolderData, folderData);
        return new FolderData(serializableForm);
    }

    public static FolderData parse(SerializableForm serializedfolderData) {
        if (serializedfolderData == null) {
            LOGGER.severe(String.format("[FolderData.parse()]): Unexpected null data for serializableForm", new Object[0]));
            return null;
        }
        if (!serializedfolderData.marker.equals((Object)DataMarker.FolderData)) {
            LOGGER.severe(String.format("[FolderData.parse()]): Unexpected Data type: Expected marker: '%s', Received marker: '%s'.\nSkipping data processing.", new Object[]{DataMarker.FolderData, serializedfolderData.marker}));
            return null;
        }
        FolderData fd = new FolderData(serializedfolderData);
        fd.path = serializedfolderData.data[0].toString();
        for (SerializableForm serializedElement : serializedfolderData.elements.toSerializableForms()) {
            fd.folderItems.add(FolderItem.parse(serializedElement));
        }
        return fd;
    }

    public String getPath() {
        return this.path;
    }

    public List<FolderItem> getFolderItems() {
        return this.folderItems;
    }

    public boolean containsFile(String fileName) {
        return fileName != null && this.folderItems != null && this.folderItems.stream().anyMatch(folderItem -> folderItem.isFile() && folderItem.getName().equals(fileName));
    }

    public boolean containsDirectory(String directoryName) {
        return directoryName != null && this.folderItems != null && this.folderItems.stream().anyMatch(folderItem -> folderItem.isFile() && folderItem.getName().equals(directoryName));
    }
}

