/*
 * Decompiled with CFR 0.152.
 */
package com.ismacontrolli.nE2Link.parser.binary;

import com.ismacontrolli.nE2Link.BMarkerEnum;
import com.ismacontrolli.nE2Link.BNanoBaseComponent;
import com.ismacontrolli.nE2Link.BNanoDiscoverExtension;
import com.ismacontrolli.nE2Link.BNanoExtension;
import com.ismacontrolli.nE2Link.parser.binary.AbstractNanoData;
import com.ismacontrolli.nE2Link.parser.binary.AttributeData;
import com.ismacontrolli.nE2Link.parser.binary.Attributes;
import com.ismacontrolli.nE2Link.parser.binary.Slots;
import com.ismacontrolli.serialization.DataMarker;
import com.ismacontrolli.serialization.SerializableForm;
import java.util.List;
import javax.baja.sys.BFacets;

public class ExtensionSchema
extends AbstractNanoData {
    private BNanoExtension nanoExtension;

    private ExtensionSchema(SerializableForm extensionData) {
        super(extensionData);
    }

    public static ExtensionSchema parse(SerializableForm extensionData) {
        DataMarker marker = extensionData.marker;
        if (marker.getValue() != 47) {
            LOGGER.severe(String.format("[ExtensionSchema.parse()]: Unexpected Data type: marker: '%s'.\nSkipping data processing.", new Object[]{marker}));
            return null;
        }
        BNanoBaseComponent nanoExtension = null;
        BMarkerEnum markerEnum = BMarkerEnum.ExtensionSchema;
        int libraryId = -1;
        String nanoName = "";
        String baseName = "";
        boolean isMultipleAllowed = false;
        boolean isTransparent = false;
        boolean isManaged = false;
        String compatibleComponents = "";
        int typeId = -1;
        Attributes attributes = null;
        try {
            markerEnum = BMarkerEnum.make(marker.getValue());
            libraryId = Byte.toUnsignedInt((Byte)extensionData.data[0]);
            nanoName = extensionData.data[1].toString().trim();
            baseName = extensionData.data[2].toString().trim();
            attributes = Attributes.parse(extensionData.data[3]);
            isMultipleAllowed = (Boolean)extensionData.data[4];
            compatibleComponents = extensionData.data[5].toString().trim();
            typeId = Short.toUnsignedInt((Short)extensionData.data[6]);
            AttributeData transparentAttribute = attributes.getAttribute("transparent");
            if (transparentAttribute != null) {
                isTransparent = Boolean.parseBoolean(transparentAttribute.getAttrValue());
            }
            AttributeData managedAttribute = attributes.getAttribute("managed");
            AttributeData protectedAttribute = attributes.getAttribute("protected");
            boolean managed = managedAttribute != null && Boolean.parseBoolean(managedAttribute.getAttrValue());
            boolean protect = protectedAttribute != null && Boolean.parseBoolean(protectedAttribute.getAttrValue());
            boolean bl = isManaged = managed || protect;
            nanoExtension = baseName.equals("Library.Core.SDK.DiscoverExtension") ? new BNanoDiscoverExtension() : new BNanoExtension();
        }
        catch (Exception transparentAttribute) {
            // empty catch block
        }
        if (nanoExtension != null) {
            nanoExtension.setMarker(markerEnum);
            nanoExtension.setLibraryId(libraryId);
            nanoExtension.setTypeId(typeId);
            nanoExtension.setNanoName(nanoName);
            nanoExtension.setOriginNameFromLibrary(nanoName);
            nanoExtension.setBaseName(baseName);
            ((BNanoExtension)nanoExtension).setIsMultipleAllowed(isMultipleAllowed);
            ((BNanoExtension)nanoExtension).setIsTransparent(isTransparent);
            ((BNanoExtension)nanoExtension).setIsManaged(isManaged);
            ((BNanoExtension)nanoExtension).setCompatibleComponents(compatibleComponents);
            nanoExtension.setIsLibraryComponent(true);
            nanoExtension.setComponentFacets(attributes != null ? attributes.getAttributesAsFacets() : BFacets.NULL);
            List<SerializableForm> serializedSlots = extensionData.elements.toSerializableForms();
            Slots.addNanoSlots(serializedSlots, nanoExtension);
        }
        ExtensionSchema extensionSchema = new ExtensionSchema(extensionData);
        extensionSchema.nanoExtension = nanoExtension;
        return extensionSchema;
    }

    public BNanoBaseComponent getNanoExtension() {
        return this.nanoExtension;
    }
}

