/*
 * Decompiled with CFR 0.152.
 */
package com.ismacontrolli.nE2Link.parser.binary;

import com.ismacontrolli.nE2Link.BNanoExtension;
import com.ismacontrolli.nE2Link.BNe2DeviceExt;
import com.ismacontrolli.nE2Link.parser.binary.AbstractNanoData;
import com.ismacontrolli.serialization.DataMarker;
import com.ismacontrolli.serialization.SerializableForm;
import java.util.Objects;

public class ExtensionData
extends AbstractNanoData {
    private int typeId;
    private int extensionId;

    private ExtensionData(SerializableForm serializedExtensionData) {
        super(serializedExtensionData);
        this.typeId = Short.toUnsignedInt((Short)serializedExtensionData.data[0]);
        this.extensionId = Byte.toUnsignedInt((Byte)serializedExtensionData.data[1]);
    }

    public static ExtensionData make(BNanoExtension extension) {
        SerializableForm serializedExtensionData = new SerializableForm(DataMarker.ExtensionData, new Object[]{(short)extension.getTypeId(), (byte)extension.getExtensionId()});
        return new ExtensionData(serializedExtensionData);
    }

    public static ExtensionData parse(SerializableForm serializedExtensionData) {
        DataMarker marker = serializedExtensionData.marker;
        if (marker.getValue() != 79) {
            LOGGER.severe(String.format("ExtensionData.parse(): Unexpected Data type: Expected marker: '%s', Received marker: '%s'.\nSkipping data processing.", new Object[]{DataMarker.ExtensionData, marker}));
            return null;
        }
        return new ExtensionData(serializedExtensionData);
    }

    public int getExtensionId() {
        return this.extensionId;
    }

    public int getTypeId() {
        return this.typeId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExtensionData that = (ExtensionData)o;
        return this.typeId == that.typeId && this.extensionId == that.extensionId;
    }

    public int hashCode() {
        return Objects.hash(this.typeId, this.extensionId);
    }

    public BNanoExtension makeNiagaraNanoExtension(BNe2DeviceExt targetController) {
        BNanoExtension nanoExtension = (BNanoExtension)targetController.getLibraries().getLibraryComponentsCache().get(this.typeId);
        if (nanoExtension != null) {
            nanoExtension = (BNanoExtension)nanoExtension.newCopy();
            nanoExtension.setExtensionId(this.extensionId);
        }
        return nanoExtension;
    }

    public String toString() {
        return "ExtensionData{typeId=" + this.typeId + ", extensionId=" + this.extensionId + '}';
    }
}

