/*
 * Decompiled with CFR 0.152.
 */
package com.ismacontrolli.nE2Link.parser.binary;

import com.ismacontrolli.ifnetclient.model.RemoteDevice;
import com.ismacontrolli.nE2Link.BNe2DeviceExt;
import com.ismacontrolli.nE2Link.parser.binary.AbstractNanoRequest;
import com.ismacontrolli.nE2Link.parser.binary.DeleteFileResponse;
import com.ismacontrolli.nE2Link.parser.binary.FileData;
import com.ismacontrolli.nE2Link.parser.binary.ResponseCode;
import com.ismacontrolli.nE2Link.utils.BFileDataArgs;
import com.ismacontrolli.serialization.SerializableForm;
import java.util.ArrayList;

public class DeleteFileRequest
extends AbstractNanoRequest {
    private DeleteFileRequest(BNe2DeviceExt ne2DeviceExt, BFileDataArgs clientRequestData, FileData requestData) {
        super(ne2DeviceExt, (Object)clientRequestData, requestData);
    }

    public static DeleteFileRequest make(BNe2DeviceExt ne2DeviceExt, BFileDataArgs fileDataArgs) {
        return new DeleteFileRequest(ne2DeviceExt, fileDataArgs, FileData.make(fileDataArgs));
    }

    @Override
    public FileData getRequestData() {
        return (FileData)super.getRequestData();
    }

    public BFileDataArgs getClientRequestData() {
        return (BFileDataArgs)((Object)super.getClientRequestData());
    }

    @Override
    public DeleteFileResponse postRequest(RemoteDevice remoteDevice) {
        if (remoteDevice == null || !remoteDevice.Remote.isConnected()) {
            return DeleteFileResponse.make(this, ResponseCode.NOT_CONNECTED);
        }
        ArrayList<SerializableForm> response = remoteDevice.Remote.FileDelete(this.getRequestData().getSerializableForm());
        if (response == null) {
            return DeleteFileResponse.make(this, ResponseCode.NO_RESPONSE);
        }
        if (this.isResponseMalformed(response)) {
            return DeleteFileResponse.make(this, ResponseCode.INVALID_RESPONSE);
        }
        return DeleteFileResponse.parse(this, response);
    }

    @Override
    public String getLocalizedMessage() {
        BFileDataArgs requestData = this.getClientRequestData();
        String folderPath = requestData.getFolderPath();
        String filePath = requestData.getFilePath();
        return LEX.getText("DELETE_FILE_REQUEST", new Object[]{folderPath, filePath});
    }
}

