/*
 * Decompiled with CFR 0.152.
 */
package com.ismacontrolli.nE2Link.parser.binary;

import com.ismacontrolli.nE2Link.BNanoBaseComponent;
import com.ismacontrolli.nE2Link.actions.BNanoDeleteExtensionArg;
import com.ismacontrolli.nE2Link.parser.binary.AbstractNanoData;
import com.ismacontrolli.nE2Link.parser.binary.AbstractNanoRequest;
import com.ismacontrolli.nE2Link.parser.binary.AbstractNanoResponse;
import com.ismacontrolli.nE2Link.parser.binary.DeleteExtensionRequest;
import com.ismacontrolli.nE2Link.parser.binary.ObjectData;
import com.ismacontrolli.nE2Link.parser.binary.ResponseCode;
import com.ismacontrolli.serialization.DataMarker;
import com.ismacontrolli.serialization.SerializableForm;
import java.util.List;

public class DeleteExtensionResponse
extends AbstractNanoResponse {
    private DeleteExtensionResponse(AbstractNanoRequest request, ResponseCode responseCode) {
        super(request, responseCode);
    }

    private DeleteExtensionResponse(AbstractNanoRequest request, List<SerializableForm> response) {
        super(request, response);
    }

    public static DeleteExtensionResponse make(AbstractNanoRequest request, ResponseCode responseCode) {
        return new DeleteExtensionResponse(request, responseCode);
    }

    public static DeleteExtensionResponse parse(AbstractNanoRequest request, List<SerializableForm> response) {
        return new DeleteExtensionResponse(request, response);
    }

    @Override
    public ObjectData getResponseData() {
        return (ObjectData)super.getResponseData();
    }

    @Override
    protected boolean isMalformedResponse(SerializableForm responseContentElement) {
        return !responseContentElement.marker.equals((Object)DataMarker.ObjectData);
    }

    @Override
    protected AbstractNanoData doParseResponseContentElement(SerializableForm responseContentElement) {
        return ObjectData.parse(responseContentElement, this.getRequest().getNe2DeviceExt());
    }

    @Override
    public String getLocalizedMessage(int index) {
        BNanoDeleteExtensionArg requestData = ((DeleteExtensionRequest)this.getRequest()).getClientRequestData();
        BNanoBaseComponent parentComponent = requestData.getExtensionParent();
        int parentId = parentComponent.getGlobalIndex();
        int extensionId = requestData.getExtensionId();
        String parentComponentNavOrd = parentComponent != null ? parentComponent.getNavOrd().toString() : "unresolvable component";
        switch (this.getResponseCode()) {
            case OK: {
                return LEX.getText("DELETE_EXTENSION_OK", new Object[]{parentComponentNavOrd, parentId, extensionId});
            }
            case ERROR: {
                return LEX.getText("DELETE_EXTENSION_ERROR", new Object[]{parentComponentNavOrd, parentId, extensionId, this.getErrorMessage(), this.getExceptionMessage(), this.getStackTrace()});
            }
            case NOT_CONNECTED: {
                return LEX.getText("DELETE_EXTENSION_NOT_CONNECTED", new Object[]{parentComponentNavOrd, parentId, extensionId});
            }
            case NO_RESPONSE: {
                return LEX.getText("DELETE_EXTENSION_NO_RESPONSE", new Object[]{parentComponentNavOrd, parentId, extensionId});
            }
            case INVALID_RESPONSE: {
                return LEX.getText("DELETE_EXTENSION_INVALID_RESPONSE", new Object[]{parentComponentNavOrd, parentId, extensionId});
            }
        }
        return LEX.getText("ILLEGAL_RESPONSE_CODE");
    }
}

