/*
 * Decompiled with CFR 0.152.
 */
package com.ismacontrolli.nE2Link.parser.binary;

import com.ismacontrolli.ifnetclient.model.RemoteDevice;
import com.ismacontrolli.nE2Link.BNanoBaseComponent;
import com.ismacontrolli.nE2Link.BNe2DeviceExt;
import com.ismacontrolli.nE2Link.actions.BNanoDeleteExtensionArg;
import com.ismacontrolli.nE2Link.parser.binary.AbstractNanoRequest;
import com.ismacontrolli.nE2Link.parser.binary.DeleteExtensionData;
import com.ismacontrolli.nE2Link.parser.binary.DeleteExtensionResponse;
import com.ismacontrolli.nE2Link.parser.binary.ResponseCode;
import com.ismacontrolli.serialization.SerializableForm;
import java.util.ArrayList;

public class DeleteExtensionRequest
extends AbstractNanoRequest {
    private DeleteExtensionRequest(BNe2DeviceExt ne2DeviceExt, BNanoDeleteExtensionArg clientRequestData, DeleteExtensionData requestData) {
        super(ne2DeviceExt, (Object)clientRequestData, requestData);
    }

    public static DeleteExtensionRequest make(BNe2DeviceExt ne2DeviceExt, BNanoDeleteExtensionArg deleteExtensionArg) {
        return new DeleteExtensionRequest(ne2DeviceExt, deleteExtensionArg, DeleteExtensionData.make(deleteExtensionArg));
    }

    @Override
    public DeleteExtensionResponse postRequest(RemoteDevice remoteDevice) {
        if (remoteDevice == null || !remoteDevice.Remote.isConnected()) {
            return DeleteExtensionResponse.make(this, ResponseCode.NOT_CONNECTED);
        }
        ArrayList<SerializableForm> response = remoteDevice.Remote.RemoveExtension(this.getRequestData().getSerializableForm());
        if (response == null) {
            return DeleteExtensionResponse.make(this, ResponseCode.NO_RESPONSE);
        }
        if (this.isResponseMalformed(response)) {
            return DeleteExtensionResponse.make(this, ResponseCode.INVALID_RESPONSE);
        }
        return DeleteExtensionResponse.parse(this, response);
    }

    @Override
    public DeleteExtensionData getRequestData() {
        return (DeleteExtensionData)super.getRequestData();
    }

    public BNanoDeleteExtensionArg getClientRequestData() {
        return (BNanoDeleteExtensionArg)((Object)super.getClientRequestData());
    }

    @Override
    public String getLocalizedMessage() {
        BNanoDeleteExtensionArg requestData = this.getClientRequestData();
        BNanoBaseComponent parentComponent = requestData.getExtensionParent();
        int parentId = parentComponent.getGlobalIndex();
        int extensionId = requestData.getExtensionId();
        String parentComponentNavOrd = parentComponent != null ? parentComponent.getNavOrd().toString() : "unresolvable component";
        return LEX.getText("DELETE_EXTENSION_REQUEST", new Object[]{parentComponentNavOrd, parentId, extensionId});
    }
}

