/*
 * Decompiled with CFR 0.152.
 */
package com.ismacontrolli.nE2Link.parser.binary;

import com.ismacontrolli.ifnetclient.model.scheduleLogic.NotationOfSchedule;
import com.ismacontrolli.nE2Link.BNanoBaseComponent;
import com.ismacontrolli.nE2Link.datatypes.BUInt64;
import com.ismacontrolli.nE2Link.datatypes.choice.BDynamicChoiceRange;
import com.ismacontrolli.nE2Link.parser.binary.AbstractNanoData;
import com.ismacontrolli.nE2Link.schedules.BNanoSchedule;
import com.ismacontrolli.serialization.DataMarker;
import com.ismacontrolli.serialization.SerializableCollection;
import com.ismacontrolli.serialization.SerializableForm;
import java.util.List;
import java.util.Objects;
import javax.baja.schedule.BAbstractSchedule;
import javax.baja.sys.BValue;

public class CustomUserData
extends AbstractNanoData {
    private BUInt64 ownerPersistentId;
    private String baseLibraryName;
    private BValue niagaraObject;
    private static final String schedulesLibraryId = "Library.Schedules";

    protected CustomUserData(SerializableForm serializableForm) {
        super(serializableForm);
    }

    public static CustomUserData make(BUInt64 persistentId, BNanoSchedule schedule) {
        String baseLibraryId = schedulesLibraryId;
        SerializableForm serializableForm = new SerializableForm(DataMarker.CustomUserData, new Object[]{persistentId, baseLibraryId});
        serializableForm.elements = new SerializableCollection();
        serializableForm.elements.Add(NotationOfSchedule.WithSchedule(persistentId, (BAbstractSchedule)schedule));
        CustomUserData customUserData = new CustomUserData(serializableForm);
        customUserData.ownerPersistentId = persistentId;
        customUserData.baseLibraryName = baseLibraryId;
        customUserData.niagaraObject = schedule;
        return customUserData;
    }

    protected static CustomUserData parse(SerializableForm serializableForm, BNanoBaseComponent owner) {
        DataMarker marker = serializableForm.marker;
        if (marker != DataMarker.CustomUserData) {
            LOGGER.severe(String.format("CustomUserData.parse(): Unexpected Data type: Expected marker: '%s', Received marker: '%s'.\nSkipping data processing.", new Object[]{DataMarker.CustomUserData, marker}));
            return null;
        }
        CustomUserData customUserData = new CustomUserData(serializableForm);
        customUserData.ownerPersistentId = (BUInt64)serializableForm.data[0];
        customUserData.baseLibraryName = String.valueOf(serializableForm.data[1]);
        String originNameFromLibrary = owner.getOriginNameFromLibrary();
        boolean isCalendar = originNameFromLibrary.equals("Library.Schedules.Calendar");
        List<SerializableForm> elements = serializableForm.elements.toSerializableForms();
        Object niagaraObject = null;
        if (elements.size() > 0) {
            SerializableForm form = elements.get(0);
            switch (customUserData.baseLibraryName) {
                case "Library.Schedules": {
                    if (isCalendar) {
                        niagaraObject = NotationOfSchedule.ExtractCalendar(form);
                        break;
                    }
                    niagaraObject = NotationOfSchedule.ExtractSchedule(form, originNameFromLibrary);
                    break;
                }
                case "Library.Core": {
                    niagaraObject = BDynamicChoiceRange.parse(form, customUserData.getOwnerPersistentId());
                }
            }
        }
        if (niagaraObject == null) {
            LOGGER.severe(String.format("CustomUserData.parse(): Cannot parse custom user data for persistentId='%s', base library name='%s' into niagara object.\nNiagara object will be null", customUserData.ownerPersistentId, customUserData.baseLibraryName));
        }
        customUserData.niagaraObject = niagaraObject;
        return customUserData;
    }

    public String getBaseLibraryName() {
        return this.baseLibraryName;
    }

    public BValue getNiagaraObject() {
        return this.niagaraObject;
    }

    public BUInt64 getOwnerPersistentId() {
        return this.ownerPersistentId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CustomUserData that = (CustomUserData)o;
        return this.ownerPersistentId == that.ownerPersistentId && this.baseLibraryName == that.baseLibraryName;
    }

    public int hashCode() {
        return Objects.hash(this.ownerPersistentId, this.baseLibraryName);
    }

    public String toString() {
        return "CustomUserData{ownerId=" + this.ownerPersistentId + ", baseLibraryName=" + this.baseLibraryName + '}';
    }
}

