/*
 * Decompiled with CFR 0.152.
 */
package com.ismacontrolli.nE2Link.parser.binary;

import com.ismacontrolli.nE2Link.BMarkerEnum;
import com.ismacontrolli.nE2Link.BNanoApplication;
import com.ismacontrolli.nE2Link.BNanoApplicationContainer;
import com.ismacontrolli.nE2Link.BNanoBaseComponent;
import com.ismacontrolli.nE2Link.BNanoComponent;
import com.ismacontrolli.nE2Link.BNanoContainer;
import com.ismacontrolli.nE2Link.BNanoEquipment;
import com.ismacontrolli.nE2Link.BNanoFolder;
import com.ismacontrolli.nE2Link.BNanoInterfaces;
import com.ismacontrolli.nE2Link.BNanoLogService;
import com.ismacontrolli.nE2Link.BNanoNetworkContainer;
import com.ismacontrolli.nE2Link.BNanoSpecializedContainer;
import com.ismacontrolli.nE2Link.parser.binary.AbstractNanoData;
import com.ismacontrolli.nE2Link.parser.binary.Attributes;
import com.ismacontrolli.nE2Link.parser.binary.Slots;
import com.ismacontrolli.nE2Link.security.BNanoUser;
import com.ismacontrolli.serialization.DataMarker;
import com.ismacontrolli.serialization.SerializableForm;
import java.util.List;
import javax.baja.nre.util.Array;
import javax.baja.sys.BFacets;

public class ComponentSchema
extends AbstractNanoData {
    private BNanoBaseComponent component;

    private ComponentSchema(SerializableForm componentData) {
        super(componentData);
    }

    public static ComponentSchema parse(SerializableForm componentData) {
        DataMarker marker = componentData.marker;
        if (marker.getValue() != 46 && marker.getValue() != 44) {
            LOGGER.severe(String.format("[ComponentSchema.parse()]: Unexpected Data type: marker: '%s'.\nSkipping data processing.", new Object[]{marker}));
            return null;
        }
        BNanoBaseComponent component = null;
        int libraryId = -1;
        String nanoName = "";
        String baseName = "";
        String interfaces = "";
        int typeId = -1;
        Attributes attributes = null;
        try {
            libraryId = Byte.toUnsignedInt((Byte)componentData.data[0]);
            nanoName = componentData.data[1].toString().trim();
            baseName = componentData.data[2].toString().trim();
            attributes = Attributes.parse(componentData.data[3]);
            typeId = Short.toUnsignedInt((Short)componentData.data[4]);
            if (componentData.data.length > 5 && componentData.data[5] instanceof Array && ((Array)componentData.data[5]).size() > 0 && (interfaces = componentData.data[5].toString()).length() >= 2) {
                interfaces = interfaces.substring(1, interfaces.length() - 1).replace(',', ';');
            }
            block7 : switch (baseName) {
                case "Framework.SDK.Service": 
                case "Framework.SDK.Component": {
                    switch (nanoName) {
                        case "Framework.Core.Container": {
                            component = new BNanoContainer();
                            break block7;
                        }
                        case "Library.Core.Application": {
                            component = new BNanoApplication();
                            break block7;
                        }
                        case "Library.Core.Interfaces": {
                            component = new BNanoInterfaces();
                            break block7;
                        }
                        case "Library.Core.Equipment": {
                            component = new BNanoEquipment();
                            break block7;
                        }
                        case "Library.Core.Folder": {
                            component = new BNanoFolder();
                            break block7;
                        }
                        case "Framework.Core.User": {
                            component = new BNanoUser();
                            break block7;
                        }
                    }
                    component = new BNanoComponent();
                    break;
                }
                case "Framework.Core.Container": {
                    switch (nanoName) {
                        case "Framework.Core.ApplicationContainer": {
                            component = new BNanoApplicationContainer();
                            break block7;
                        }
                        case "Framework.Core.NetworkContainer": {
                            component = new BNanoNetworkContainer();
                            break block7;
                        }
                        case "Framework.Core.SpecializedContainer": {
                            component = new BNanoSpecializedContainer();
                            break block7;
                        }
                    }
                    component = new BNanoContainer();
                    break;
                }
                case "Framework.Core.SystemService": {
                    switch (nanoName) {
                        case "Framework.Core.LogService": {
                            component = new BNanoLogService();
                            break block7;
                        }
                    }
                    component = new BNanoComponent();
                    break;
                }
                default: {
                    component = new BNanoComponent();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (component != null) {
            component.setMarker(BMarkerEnum.make(marker.getValue()));
            component.setLibraryId(libraryId);
            component.setTypeId(typeId);
            component.setIsLibraryComponent(true);
            component.setNanoName(nanoName);
            component.setOriginNameFromLibrary(nanoName);
            component.setBaseName(baseName);
            component.setInterfaces(interfaces);
            component.setComponentFacets(attributes != null ? attributes.getAttributesAsFacets() : BFacets.NULL);
            List<SerializableForm> serializedSlots = componentData.elements.toSerializableForms();
            Slots.addNanoSlots(serializedSlots, component);
        }
        ComponentSchema componentSchema = new ComponentSchema(componentData);
        componentSchema.component = component;
        return componentSchema;
    }

    public BNanoBaseComponent getNanoComponent() {
        return this.component;
    }
}

