/*
 * Decompiled with CFR 0.152.
 */
package com.ismacontrolli.nE2Link.parser.binary;

import com.ismacontrolli.nE2Link.parser.binary.AbstractNanoData;
import com.ismacontrolli.nE2Link.parser.binary.AbstractNanoRequest;
import com.ismacontrolli.nE2Link.parser.binary.AbstractNanoResponse;
import com.ismacontrolli.nE2Link.parser.binary.ClearTrendRequest;
import com.ismacontrolli.nE2Link.parser.binary.ObjectData;
import com.ismacontrolli.nE2Link.parser.binary.ResponseCode;
import com.ismacontrolli.nE2Link.trends.BTrendRemovingArgs;
import com.ismacontrolli.serialization.DataMarker;
import com.ismacontrolli.serialization.SerializableForm;
import java.util.List;

public class ClearTrendResponse
extends AbstractNanoResponse {
    private ClearTrendResponse(AbstractNanoRequest request, ResponseCode responseCode) {
        super(request, responseCode);
    }

    private ClearTrendResponse(AbstractNanoRequest request, List<SerializableForm> response) {
        super(request, response);
    }

    public static ClearTrendResponse make(AbstractNanoRequest request, ResponseCode responseCode) {
        return new ClearTrendResponse(request, responseCode);
    }

    public static ClearTrendResponse parse(AbstractNanoRequest request, List<SerializableForm> response) {
        return new ClearTrendResponse(request, response);
    }

    @Override
    public ObjectData getResponseData() {
        return (ObjectData)super.getResponseData(0);
    }

    @Override
    protected boolean isMalformedResponse(SerializableForm responseContentElement) {
        return !responseContentElement.marker.equals((Object)DataMarker.ObjectData);
    }

    @Override
    protected AbstractNanoData doParseResponseContentElement(SerializableForm responseContentElement) {
        ObjectData nanoObject = ObjectData.parse(responseContentElement, this.getRequest().getNe2DeviceExt());
        return nanoObject;
    }

    @Override
    protected boolean isParsedDataInvalid(AbstractNanoData parsedData) {
        ObjectData objectData = (ObjectData)parsedData;
        return super.isParsedDataInvalid(parsedData) || objectData.getGlobalIndex() == -1;
    }

    @Override
    public String getLocalizedMessage(int index) {
        BTrendRemovingArgs requestData = ((ClearTrendRequest)this.getRequest()).getClientRequestData();
        String id = requestData.getGuid();
        long startedStampRemoving = requestData.getStartedStampRemoving();
        String message = "";
        switch (this.getResponseCode()) {
            case OK: {
                message = LEX.getText("CLEAR_TREND_OK", new Object[]{id, startedStampRemoving});
                break;
            }
            case ERROR: {
                message = LEX.getText("CLEAR_TREND_ERROR", new Object[]{this.getErrorMessage(), this.getExceptionMessage(), this.getStackTrace()});
                break;
            }
            case NOT_CONNECTED: {
                message = LEX.getText("CLEAR_TREND_NOT_CONNECTED", new Object[]{id, startedStampRemoving});
                break;
            }
            case NO_RESPONSE: {
                message = LEX.getText("CLEAR_TREND_NO_RESPONSE", new Object[]{id, startedStampRemoving});
                break;
            }
            case INVALID_RESPONSE: {
                message = LEX.getText("CLEAR_TREND_INVALID_RESPONSE", new Object[]{id, startedStampRemoving});
                break;
            }
            default: {
                return LEX.getText("ILLEGAL_RESPONSE_CODE");
            }
        }
        return message;
    }
}

