/*
 * Decompiled with CFR 0.152.
 */
package com.ismacontrolli.nE2Link.parser.binary;

import com.ismacontrolli.ifnetclient.model.RemoteDevice;
import com.ismacontrolli.nE2Link.BNe2DeviceExt;
import com.ismacontrolli.nE2Link.parser.binary.AbstractNanoRequest;
import com.ismacontrolli.nE2Link.parser.binary.ClearTrendResponse;
import com.ismacontrolli.nE2Link.parser.binary.ResponseCode;
import com.ismacontrolli.nE2Link.parser.binary.TrendRemovingData;
import com.ismacontrolli.nE2Link.trends.BTrendRemovingArgs;
import com.ismacontrolli.serialization.SerializableForm;
import java.util.ArrayList;
import java.util.List;

public class ClearTrendRequest
extends AbstractNanoRequest {
    private ClearTrendRequest(BNe2DeviceExt ne2DeviceExt, BTrendRemovingArgs clientRequestData, TrendRemovingData requestData) {
        super(ne2DeviceExt, (Object)clientRequestData, requestData);
    }

    public static ClearTrendRequest make(BNe2DeviceExt ne2DeviceExt, BTrendRemovingArgs trendRemovingArgs) {
        return new ClearTrendRequest(ne2DeviceExt, trendRemovingArgs, TrendRemovingData.make(trendRemovingArgs));
    }

    @Override
    public TrendRemovingData getRequestData() {
        return (TrendRemovingData)super.getRequestData();
    }

    public BTrendRemovingArgs getClientRequestData() {
        return (BTrendRemovingArgs)((Object)super.getClientRequestData());
    }

    @Override
    public ClearTrendResponse postRequest(RemoteDevice remoteDevice) {
        if (remoteDevice == null || !remoteDevice.Remote.isConnected()) {
            return ClearTrendResponse.make(this, ResponseCode.NOT_CONNECTED);
        }
        ArrayList<SerializableForm> response = remoteDevice.Remote.ClearTrend(this.getRequestData().getSerializableForm());
        if (response == null) {
            return ClearTrendResponse.make(this, ResponseCode.NO_RESPONSE);
        }
        if (this.isResponseMalformed(response)) {
            return ClearTrendResponse.make(this, ResponseCode.INVALID_RESPONSE);
        }
        return ClearTrendResponse.parse(this, response);
    }

    @Override
    public String getLocalizedMessage() {
        BTrendRemovingArgs requestData = this.getClientRequestData();
        String id = requestData.getGuid();
        long startedStampRemoving = requestData.getStartedStampRemoving();
        return LEX.getText("CLEAR_TREND_REQUEST", new Object[]{id, startedStampRemoving});
    }

    @Override
    protected boolean isResponseMalformed(List<SerializableForm> response) {
        return response.size() != 0;
    }
}

