/*
 * Decompiled with CFR 0.152.
 */
package com.ismacontrolli.nE2Link.parser.binary;

import com.ismacontrolli.nE2Link.parser.binary.AbstractNanoResponse;
import com.ismacontrolli.nE2Link.parser.binary.BResponseCode;
import com.ismacontrolli.nE2Link.parser.binary.BResponseResult;
import com.ismacontrolli.nE2Link.parser.binary.ResponseCode;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.BVector;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="responseCode", type="BResponseCode", defaultValue="BResponseCode.DEFAULT"), @NiagaraProperty(name="localizedMessage", type="String", defaultValue="")})
public class BResponseResults
extends BVector {
    public static final Property responseCode = BResponseResults.newProperty((int)0, (BValue)BResponseCode.DEFAULT, null);
    public static final Property localizedMessage = BResponseResults.newProperty((int)0, (String)"", null);
    public static final Type TYPE = Sys.loadType(BResponseResults.class);

    public void setResponseCode(BResponseCode v) {
        this.set(responseCode, (BValue)v, null);
    }

    public String getLocalizedMessage() {
        return this.getString(localizedMessage);
    }

    public void setLocalizedMessage(String v) {
        this.setString(localizedMessage, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public int length() {
        return this.getDynamicPropertiesArray().length;
    }

    private Property getItemProperty(int index) {
        return this.getDynamicPropertiesArray()[index];
    }

    public BResponseResult getItem() {
        return this.getItem(0);
    }

    public BResponseResult getItem(int index) {
        return (BResponseResult)this.get(this.getItemProperty(index));
    }

    public BResponseCode getResponseCode(int index) {
        return this.getItem(index).getResponseCode();
    }

    public BResponseCode getResponseCode() {
        return this.length() == 0 ? BResponseCode.ok : this.getItem(0).getResponseCode();
    }

    public boolean isChildLegal(BComponent child) {
        return child.getType().is(BResponseResult.TYPE);
    }

    public void add(BResponseResult result) {
        this.add(null, (BValue)result);
    }

    public BResponseResults() {
    }

    public BResponseResults(AbstractNanoResponse response) {
        this.setResponseCode(BResponseCode.make(response.getResponseCode()));
        this.setLocalizedMessage(response.getLocalizedMessage());
        for (int i = 0; i < response.getResponseDataSize(); ++i) {
            ResponseCode responseCode = response.getResponseCode(i);
            String localizedMessage = response.getLocalizedMessage(i);
            String errorMessage = response.getErrorMessage(i);
            String exceptionMessage = response.getExceptionMessage(i);
            String stackTrace = response.getStackTrace(i);
            this.add(new BResponseResult(responseCode, localizedMessage, errorMessage, exceptionMessage, stackTrace));
        }
    }
}

