/*
 * Decompiled with CFR 0.152.
 */
package com.ismacontrolli.nE2Link.parser.binary;

import com.ismacontrolli.nE2Link.parser.binary.ResponseCode;
import javax.baja.nre.annotations.NiagaraEnum;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.annotations.Range;
import javax.baja.sys.BFrozenEnum;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraEnum(range={@Range(value="no_response"), @Range(value="invalid_response"), @Range(value="not_connected"), @Range(value="error"), @Range(value="ok")}, defaultValue="ok")
public final class BResponseCode
extends BFrozenEnum {
    public static final int NO_RESPONSE = 0;
    public static final int INVALID_RESPONSE = 1;
    public static final int NOT_CONNECTED = 2;
    public static final int ERROR = 3;
    public static final int OK = 4;
    public static final BResponseCode no_response = new BResponseCode(0);
    public static final BResponseCode invalid_response = new BResponseCode(1);
    public static final BResponseCode not_connected = new BResponseCode(2);
    public static final BResponseCode error = new BResponseCode(3);
    public static final BResponseCode ok;
    public static final BResponseCode DEFAULT;
    public static final Type TYPE;

    public static BResponseCode make(int ordinal) {
        return (BResponseCode)no_response.getRange().get(ordinal, false);
    }

    public static BResponseCode make(String tag) {
        return (BResponseCode)no_response.getRange().get(tag);
    }

    private BResponseCode(int ordinal) {
        super(ordinal);
    }

    public Type getType() {
        return TYPE;
    }

    public static BResponseCode make(ResponseCode responseCode) {
        switch (responseCode) {
            case OK: {
                return ok;
            }
            case NO_RESPONSE: {
                return no_response;
            }
            case INVALID_RESPONSE: {
                return invalid_response;
            }
            case NOT_CONNECTED: {
                return not_connected;
            }
            case ERROR: {
                return error;
            }
        }
        throw new IllegalArgumentException(String.format("Unknown value for BResponseCode '%s'", new Object[]{responseCode}));
    }

    static {
        DEFAULT = ok = new BResponseCode(4);
        TYPE = Sys.loadType(BResponseCode.class);
    }
}

