/*
 * Decompiled with CFR 0.152.
 */
package com.ismacontrolli.nE2Link.parser.binary;

import java.util.Objects;
import java.util.logging.Logger;
import javax.baja.nre.util.Array;
import javax.baja.sys.BFacets;

public class AttributeData {
    public static final Logger LOGGER = Logger.getLogger("nE2Link");
    private String _attrName;
    private String _attrValueType;
    private String _attrValue;

    protected AttributeData(String attrName, String attrValueType, String attrValue) {
        this.setAttrName(attrName);
        this.setAttrValueType(attrValueType);
        this.setAttrValue(attrValue);
    }

    public static AttributeData parse(BFacets slotFacets, String attributeName) {
        String attrValue = slotFacets.gets("nano_attr_" + attributeName, null);
        String attrType = slotFacets.gets("nano_attr_type_" + attributeName, null);
        if (attrValue != null && attrType != null) {
            return new AttributeData(attributeName, attrType, attrValue);
        }
        return null;
    }

    public static AttributeData parse(Object serializedAttribute) {
        if (!(serializedAttribute instanceof Array)) {
            LOGGER.severe(String.format("[AttributeData.parse()]: Unexpected Data type. Expected: 'Array', Received: '%s'.\nSkipping attribute.", serializedAttribute.getClass()));
            return null;
        }
        Array attributeArray = (Array)serializedAttribute;
        if (attributeArray.size() != 3) {
            LOGGER.severe(String.format("[AttributeData.parse()]: Unexpected Data. Expected: '%s[%d]', Received: '%s[%d]'.\nSkipping attribute.", Array.class, 3, serializedAttribute.getClass(), attributeArray.size()));
            return null;
        }
        return new AttributeData(attributeArray.get(1).toString(), null != attributeArray.get(0) ? attributeArray.get(0).toString() : "Undefined", attributeArray.get(2).toString());
    }

    public String getAttrName() {
        return this._attrName;
    }

    public void setAttrName(String attrName) {
        this._attrName = attrName;
    }

    public String getAttrValueType() {
        return this._attrValueType;
    }

    public void setAttrValueType(String attrValueType) {
        this._attrValueType = attrValueType;
    }

    public String getAttrValue() {
        return this._attrValue;
    }

    public void setAttrValue(String attrValue) {
        this._attrValue = attrValue;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AttributeData that = (AttributeData)o;
        return Objects.equals(this._attrName, that._attrName) && Objects.equals(this._attrValueType, that._attrValueType) && Objects.equals(this._attrValue, that._attrValue);
    }

    public int hashCode() {
        return Objects.hash(this._attrName, this._attrValueType, this._attrValue);
    }

    public String toString() {
        return "AttributeData{" + this._attrName + '[' + this._attrValueType + "]=" + this._attrValue + '}';
    }
}

