/*
 * Decompiled with CFR 0.152.
 */
package com.ismacontrolli.nE2Link.parser.binary;

import com.ismacontrolli.ifnetclient.model.RemoteDevice;
import com.ismacontrolli.nE2Link.BNanoBaseComponent;
import com.ismacontrolli.nE2Link.BNanoExtension;
import com.ismacontrolli.nE2Link.BNe2DeviceExt;
import com.ismacontrolli.nE2Link.actions.BNanoAddExtensionArg;
import com.ismacontrolli.nE2Link.parser.binary.AbstractNanoRequest;
import com.ismacontrolli.nE2Link.parser.binary.AddExtensionData;
import com.ismacontrolli.nE2Link.parser.binary.AddExtensionResponse;
import com.ismacontrolli.nE2Link.parser.binary.ResponseCode;
import com.ismacontrolli.serialization.SerializableForm;
import java.util.ArrayList;

public class AddExtensionRequest
extends AbstractNanoRequest {
    private AddExtensionRequest(BNe2DeviceExt ne2DeviceExt, BNanoAddExtensionArg clientRequestData, AddExtensionData requestData) {
        super(ne2DeviceExt, (Object)clientRequestData, requestData);
    }

    public static AddExtensionRequest make(BNe2DeviceExt ne2DeviceExt, BNanoAddExtensionArg addExtensionArg) {
        return new AddExtensionRequest(ne2DeviceExt, addExtensionArg, AddExtensionData.make(addExtensionArg));
    }

    @Override
    public AddExtensionData getRequestData() {
        return (AddExtensionData)super.getRequestData();
    }

    public BNanoAddExtensionArg getClientRequestData() {
        return (BNanoAddExtensionArg)((Object)super.getClientRequestData());
    }

    @Override
    public AddExtensionResponse postRequest(RemoteDevice remoteDevice) {
        if (remoteDevice == null || !remoteDevice.Remote.isConnected()) {
            return AddExtensionResponse.make(this, ResponseCode.NOT_CONNECTED);
        }
        ArrayList<SerializableForm> response = remoteDevice.Remote.AddExtension(this.getRequestData().getSerializableForm());
        if (response == null) {
            return AddExtensionResponse.make(this, ResponseCode.NO_RESPONSE);
        }
        if (this.isResponseMalformed(response)) {
            return AddExtensionResponse.make(this, ResponseCode.INVALID_RESPONSE);
        }
        return AddExtensionResponse.parse(this, response);
    }

    @Override
    public String getLocalizedMessage() {
        BNanoAddExtensionArg requestData = this.getClientRequestData();
        BNanoBaseComponent parentComponent = requestData.getExtensionParent();
        BNanoExtension extension = requestData.getExtension();
        int parentId = parentComponent.getGlobalIndex();
        int extensionId = extension.getExtensionId();
        String extTypeName = extension.getOriginNameFromLibrary();
        String extAssemblyName = extension.getAssemblyInfo();
        String parentComponentNavOrd = parentComponent != null ? parentComponent.getNavOrd().toString() : "unresolvable component";
        String extensionNavOrd = extension != null ? extension.getNavOrd().toString() : "unresolvable extension";
        return LEX.getText("ADD_EXTENSION_REQUEST", new Object[]{parentComponentNavOrd, parentId, extensionNavOrd, extensionId, extTypeName, extAssemblyName});
    }
}

