/*
 * Decompiled with CFR 0.152.
 */
package com.ismacontrolli.nE2Link.notifications;

import com.ismacontrolli.nE2Link.notifications.BRefreshTargets;
import com.tridium.util.ContextThread;
import java.util.logging.Logger;
import javax.baja.job.BJobService;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BNotification;
import org.jetbrains.annotations.NotNull;

@NiagaraType
public class BRefreshNotification
extends BNotification {
    public static final Type TYPE = Sys.loadType(BRefreshNotification.class);
    public static final String COMPONENT_ORD_PROP = "componentOrd";
    public static final String REFRESH_TARGETS_PROP = "refreshTargets";
    public static final String DEBUG_MSG_PROP = "debugMessage";

    public Type getType() {
        return TYPE;
    }

    public static BRefreshNotification make(@NotNull BRefreshTargets refreshTargets) {
        return BRefreshNotification.make(refreshTargets, null, null);
    }

    public static BRefreshNotification make(@NotNull BRefreshTargets refreshTargets, String debugMessage) {
        return BRefreshNotification.make(refreshTargets, null, debugMessage);
    }

    public static BRefreshNotification make(@NotNull BRefreshTargets refreshTargets, BComponent component) {
        return BRefreshNotification.make(refreshTargets, component, null);
    }

    public static BRefreshNotification make(@NotNull BRefreshTargets refreshTargets, BComponent component, String debugMessage) {
        BRefreshNotification notification = new BRefreshNotification();
        notification.add(REFRESH_TARGETS_PROP, (BValue)refreshTargets);
        if (component != null && component.isMounted()) {
            notification.add(COMPONENT_ORD_PROP, (BValue)component.getHandleOrd());
        }
        debugMessage = debugMessage != null ? debugMessage : "";
        notification.add(DEBUG_MSG_PROP, (BValue)BString.make((String)debugMessage));
        return notification;
    }

    public final void raise(Context callContext) {
        if (callContext != null) {
            try {
                BString uid = (BString)callContext.getFacets().get("foxRemoteVmUuid");
                if (this.get("vmUuid") == null) {
                    this.add("vmUuid", (BValue)uid);
                } else {
                    this.set("vmUuid", (BValue)uid);
                }
            }
            catch (Exception e) {
                try {
                    Thread cur = Thread.currentThread();
                    Context cx = ((ContextThread)cur).getContext();
                    BString uid = (BString)cx.getFacets().get("foxRemoteVmUuid");
                    if (this.get("vmUuid") == null) {
                        this.add("vmUuid", (BValue)uid);
                    } else {
                        this.set("vmUuid", (BValue)uid);
                    }
                }
                catch (Exception noContextThread) {
                    Logger.getLogger(TYPE.getTypeSpec().getModuleName()).info("raise() to specific caller failed. Cannot find forRemoteVmUuid in callContext\nSending notification as broadcast");
                }
            }
        }
        ((BJobService)BJobService.getService()).fireNotification((BNotification)this);
    }
}

