/*
 * Decompiled with CFR 0.152.
 */
package com.ismacontrolli.nE2Link.notifications;

import com.ismacontrolli.nE2Link.notifications.BMessageTypeEnum;
import com.tridium.util.ContextThread;
import java.util.logging.Logger;
import javax.baja.job.BJobService;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BNotification;
import org.jetbrains.annotations.NotNull;

@NiagaraType
public class BMessageNotification
extends BNotification {
    public static final Type TYPE = Sys.loadType(BMessageNotification.class);
    public static final String TITLE_PROP = "title";
    public static final String MSG_PROP = "message";
    public static final String MESSAGE_TYPE_PROP = "messageType";

    public Type getType() {
        return TYPE;
    }

    public static BMessageNotification make(@NotNull BMessageTypeEnum messageType) {
        return BMessageNotification.make(messageType, null, null);
    }

    public static BMessageNotification make(@NotNull BMessageTypeEnum messageType, String title, String message) {
        BMessageNotification notification = new BMessageNotification();
        notification.add(MESSAGE_TYPE_PROP, (BValue)messageType);
        if (title != null) {
            notification.add(TITLE_PROP, (BValue)BString.make((String)title));
        }
        if (message != null) {
            notification.add(MSG_PROP, (BValue)BString.make((String)message));
        }
        return notification;
    }

    public final void raise(Context callContext) {
        if (callContext != null) {
            try {
                BString uid = (BString)callContext.getFacets().get("foxRemoteVmUuid");
                if (this.get("vmUuid") == null) {
                    this.add("vmUuid", (BValue)uid);
                } else {
                    this.set("vmUuid", (BValue)uid);
                }
            }
            catch (Exception e) {
                try {
                    Thread cur = Thread.currentThread();
                    Context cx = ((ContextThread)cur).getContext();
                    BString uid = (BString)cx.getFacets().get("foxRemoteVmUuid");
                    if (this.get("vmUuid") == null) {
                        this.add("vmUuid", (BValue)uid);
                    } else {
                        this.set("vmUuid", (BValue)uid);
                    }
                }
                catch (Exception noContextThread) {
                    Logger.getLogger(TYPE.getTypeSpec().getModuleName()).info("raise() to specific caller failed. Cannot find forRemoteVmUuid in callContext\nSending notification as broadcast");
                }
            }
        }
        ((BJobService)BJobService.getService()).fireNotification((BNotification)this);
    }
}

