/*
 * Decompiled with CFR 0.152.
 */
package com.ismacontrolli.nE2Link.notifications;

import com.ismacontrolli.nE2Link.BNe2DeviceExt;
import com.tridium.util.ContextThread;
import java.util.logging.Logger;
import javax.baja.job.BJobService;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BNotification;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="sourceOrd", type="BOrd", defaultValue="BOrd.NULL"), @NiagaraProperty(name="remainingTime", type="BRelTime", defaultValue="BRelTime.DEFAULT"), @NiagaraProperty(name="notificationCreationTime", type="BAbsTime", defaultValue="BAbsTime.NULL")})
public class BDisconnectNotification
extends BNotification {
    public static final Property sourceOrd = BDisconnectNotification.newProperty((int)0, (BValue)BOrd.NULL, null);
    public static final Property remainingTime = BDisconnectNotification.newProperty((int)0, (BValue)BRelTime.DEFAULT, null);
    public static final Property notificationCreationTime = BDisconnectNotification.newProperty((int)0, (BValue)BAbsTime.NULL, null);
    public static final Type TYPE = Sys.loadType(BDisconnectNotification.class);

    public BOrd getSourceOrd() {
        return (BOrd)this.get(sourceOrd);
    }

    public void setSourceOrd(BOrd v) {
        this.set(sourceOrd, (BValue)v, null);
    }

    public BRelTime getRemainingTime() {
        return (BRelTime)this.get(remainingTime);
    }

    public void setRemainingTime(BRelTime v) {
        this.set(remainingTime, (BValue)v, null);
    }

    public BAbsTime getNotificationCreationTime() {
        return (BAbsTime)this.get(notificationCreationTime);
    }

    public void setNotificationCreationTime(BAbsTime v) {
        this.set(notificationCreationTime, (BValue)v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public static BDisconnectNotification make(BNe2DeviceExt controller) {
        BDisconnectNotification notification = new BDisconnectNotification();
        notification.setSourceOrd(controller.getHandleOrd());
        notification.setRemainingTime(controller.getAutoDisconnectSettings().getDisconnectWarningTime());
        notification.setNotificationCreationTime(BAbsTime.now());
        return notification;
    }

    public final void raise(Context callContext) {
        if (callContext != null) {
            try {
                BString uid = (BString)callContext.getFacets().get("foxRemoteVmUuid");
                if (this.get("vmUuid") == null) {
                    this.add("vmUuid", (BValue)uid);
                } else {
                    this.set("vmUuid", (BValue)uid);
                }
            }
            catch (Exception e) {
                try {
                    Thread cur = Thread.currentThread();
                    Context cx = ((ContextThread)cur).getContext();
                    BString uid = (BString)cx.getFacets().get("foxRemoteVmUuid");
                    if (this.get("vmUuid") == null) {
                        this.add("vmUuid", (BValue)uid);
                    } else {
                        this.set("vmUuid", (BValue)uid);
                    }
                }
                catch (Exception noContextThread) {
                    Logger.getLogger(TYPE.getTypeSpec().getModuleName()).info("raise() to specific caller failed. Cannot find forRemoteVmUuid in callContext\nSending notification as broadcast");
                }
            }
        }
        ((BJobService)BJobService.getService()).fireNotification((BNotification)this);
    }
}

