/*
 * Decompiled with CFR 0.152.
 */
package com.ismacontrolli.nE2Link.jobs;

import com.ismacontrolli.nE2Link.jobs.BNanoDiscoverJob;
import java.util.Locale;
import javax.baja.naming.SlotPath;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BDouble;
import javax.baja.sys.BInteger;
import javax.baja.sys.BLong;
import javax.baja.sys.BSimple;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.util.Lexicon;

public class ScriptHelper {
    protected static Lexicon LEX = Lexicon.make(BNanoDiscoverJob.class);
    protected static String MODULE = ScriptHelper.LEX.module.getModuleName();
    public static final String SCRIPT_START = "{";
    public static final String SCRIPT_END = "}";
    public static final String SCRIPT_SEPARATOR = ".";
    public static final String DISCOVERED_OBJECT_REF = "discovered";

    public static BValue niagaraValueFromObject(Object value) {
        if (value instanceof String) {
            return BString.make((String)((String)value));
        }
        if (value instanceof Integer) {
            return BInteger.make((int)((Integer)value));
        }
        if (value instanceof Long) {
            return BLong.make((long)((Long)value));
        }
        if (value instanceof Double) {
            return BDouble.make((double)((Double)value));
        }
        if (value instanceof Boolean) {
            return BBoolean.make((boolean)((Boolean)value));
        }
        if (value instanceof BSimple) {
            return (BSimple)value;
        }
        if (value instanceof BComplex) {
            return ((BComplex)value).newCopy();
        }
        return null;
    }

    public static boolean isScript(Object value) {
        if (!(value instanceof String) && !(value instanceof BString)) {
            return false;
        }
        String scriptString = value instanceof BString ? ((BString)value).getString() : (String)value;
        return scriptString.startsWith(SCRIPT_START) && scriptString.endsWith(SCRIPT_END) && scriptString.contains(SCRIPT_SEPARATOR);
    }

    public static String getComponentReference(String scriptString) {
        if (!ScriptHelper.isScript(scriptString)) {
            return "";
        }
        int beginIndex = SCRIPT_START.length();
        int endIndex = scriptString.indexOf(SCRIPT_SEPARATOR);
        return scriptString.substring(beginIndex, endIndex);
    }

    public static String getPropertyReference(String scriptString) {
        if (!ScriptHelper.isScript(scriptString)) {
            return "";
        }
        int beginIndex = scriptString.indexOf(SCRIPT_SEPARATOR) + 1;
        int endIndex = scriptString.length() - SCRIPT_END.length();
        return scriptString.substring(beginIndex, endIndex);
    }

    public static boolean isDiscoveredObjectReference(String scriptString) {
        if (ScriptHelper.isScript(scriptString)) {
            String scriptType = ScriptHelper.getComponentReference(scriptString);
            return DISCOVERED_OBJECT_REF.equals(scriptType);
        }
        return false;
    }

    public static Object fixScriptReferences(Object value, int jsonFormatVersion) {
        if (!(value instanceof String)) {
            return value;
        }
        String strValue = (String)value;
        String newPropRef = null;
        if (ScriptHelper.isDiscoveredObjectReference(strValue)) {
            newPropRef = ScriptHelper.makeValidSlotNameForDiscoveredObject(ScriptHelper.getPropertyReference(strValue), jsonFormatVersion);
        } else if (ScriptHelper.isScript(strValue)) {
            switch (newPropRef = ScriptHelper.getPropertyReference(strValue)) {
                case "Id": {
                    newPropRef = "globalIndex";
                    break;
                }
                default: {
                    newPropRef = null;
                }
            }
        }
        if (newPropRef != null) {
            strValue = SCRIPT_START + ScriptHelper.getComponentReference(strValue) + SCRIPT_SEPARATOR + newPropRef + SCRIPT_END;
        }
        return strValue;
    }

    public static String makeValidSlotNameForDiscoveredObject(String jsonPropertyName, int jsonFormatVersion) {
        switch (jsonFormatVersion) {
            case 1: {
                return SlotPath.escape((String)jsonPropertyName.toUpperCase(Locale.ROOT).trim());
            }
        }
        throw new LocalizableRuntimeException(MODULE, "NanoDiscover.unknownFormatVersion", new Object[]{jsonFormatVersion});
    }
}

