/*
 * Decompiled with CFR 0.152.
 */
package com.ismacontrolli.nE2Link.jobs;

import com.ismacontrolli.ifnetclient.model.RemoteDevice;
import com.ismacontrolli.nE2Link.BNanoBaseComponent;
import com.ismacontrolli.nE2Link.actions.BNanoPropertyChangedArg;
import com.ismacontrolli.nE2Link.jobs.BDiscoveredNanoObject;
import com.ismacontrolli.nE2Link.jobs.BDiscoveredNanoObjects;
import com.ismacontrolli.nE2Link.jobs.BIdentifyingValues;
import com.ismacontrolli.nE2Link.jobs.BNanoDiscoverJob;
import com.ismacontrolli.nE2Link.jobs.BNanoRecipe;
import com.ismacontrolli.nE2Link.jobs.BNanoRecipeAction;
import com.ismacontrolli.nE2Link.jobs.BNanoRecipeActions;
import com.ismacontrolli.nE2Link.jobs.BNanoRecipeExecutorJobParam;
import com.ismacontrolli.nE2Link.jobs.BNanoRecipes;
import com.ismacontrolli.nE2Link.jobs.ScriptHelper;
import com.ismacontrolli.nE2Link.notifications.BMessageNotification;
import com.ismacontrolli.nE2Link.notifications.BMessageTypeEnum;
import com.ismacontrolli.nE2Link.parser.binary.AddRequest;
import com.ismacontrolli.nE2Link.parser.binary.AddResponse;
import com.ismacontrolli.nE2Link.parser.binary.ObjectData;
import com.ismacontrolli.nE2Link.parser.binary.ResponseCode;
import com.ismacontrolli.nE2Link.parser.binary.WriteRequest;
import com.ismacontrolli.nE2Link.parser.binary.WriteResponse;
import java.util.ArrayList;
import java.util.HashMap;
import javax.baja.job.BSimpleJob;
import javax.baja.job.JobLogItem;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.NoSuchSlotException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraActions(value={@NiagaraAction(name="AddComponent", parameterType="BNanoRecipeAction", defaultValue="new BNanoRecipeAction(\"\")", returnType="BNanoBaseComponent", flags=4), @NiagaraAction(name="SetSlotValue", parameterType="BNanoRecipeAction", defaultValue="new BNanoRecipeAction(\"\")", returnType="BValue", flags=4)})
public class BNanoRecipeExecutorJob
extends BSimpleJob {
    public static final Action AddComponent = BNanoRecipeExecutorJob.newAction((int)4, (BValue)new BNanoRecipeAction(""), null);
    public static final Action SetSlotValue = BNanoRecipeExecutorJob.newAction((int)4, (BValue)new BNanoRecipeAction(""), null);
    public static final Type TYPE = Sys.loadType(BNanoRecipeExecutorJob.class);
    protected static Lexicon LEX = Lexicon.make(BNanoDiscoverJob.class);
    protected static String MODULE = BNanoRecipeExecutorJob.LEX.module.getModuleName();
    private BOrd targetOrd;
    private BNanoBaseComponent target;
    private BNanoRecipes recipes;
    private BDiscoveredNanoObjects discoveredObjects;
    private HashMap<String, BValue> resultsMap = new HashMap();
    private boolean skipFollowingActions;

    public BNanoBaseComponent AddComponent(BNanoRecipeAction parameter) {
        return (BNanoBaseComponent)this.invoke(AddComponent, (BValue)parameter, null);
    }

    public BValue SetSlotValue(BNanoRecipeAction parameter) {
        return this.invoke(SetSlotValue, (BValue)parameter, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BNanoRecipeExecutorJob() {
    }

    public BNanoRecipeExecutorJob(BNanoRecipeExecutorJobParam params) {
        this(params.getDiscoveredObjects(), params.getRecipes());
    }

    public BNanoRecipeExecutorJob(BDiscoveredNanoObjects discoveredObjects, BNanoRecipes recipes) {
        this.recipes = recipes;
        this.targetOrd = recipes.getTargetOrd();
        this.discoveredObjects = discoveredObjects;
    }

    public void run(Context context) throws Exception {
        this.target = (BNanoBaseComponent)this.targetOrd.resolve((BObject)this, context).get();
        int discoveredObjectCount = this.discoveredObjects.length();
        int recipesCount = this.recipes.length();
        int totalActions = this.recipes.getRecipeActionCount() * discoveredObjectCount;
        int executedActions = -1;
        ArrayList<String> failedObjects = new ArrayList<String>();
        for (int discoveredObjectIndex = 0; discoveredObjectIndex < discoveredObjectCount; ++discoveredObjectIndex) {
            BDiscoveredNanoObject discoveredObject = this.discoveredObjects.getItem(discoveredObjectIndex);
            boolean noRecipeExecuted = true;
            for (int recipesIndex = 0; recipesIndex < recipesCount; ++recipesIndex) {
                BNanoRecipe recipe = this.recipes.getItem(recipesIndex);
                if (!recipe.isValidFor(discoveredObject)) continue;
                noRecipeExecuted = false;
                BNanoRecipeActions recipeActions = recipe.getRecipeActions();
                this.skipFollowingActions = false;
                for (int actionsIndex = 0; actionsIndex < recipeActions.length(); ++actionsIndex) {
                    this.updateProgress(++executedActions, 0, totalActions);
                    if (this.skipFollowingActions) continue;
                    BNanoRecipeAction actionInfo = recipeActions.getItem(actionsIndex);
                    String actionName = actionInfo.getActionName();
                    Action niagaraAction = this.getAction(actionName);
                    if (niagaraAction == null) {
                        throw new LocalizableRuntimeException(MODULE, "NanoRecipeExecutor.missingAction", new Object[]{actionName});
                    }
                    if (actionInfo.getProperty("discovered") == null) {
                        actionInfo.add("discovered", discoveredObject.newCopy());
                    } else {
                        actionInfo.set("discovered", discoveredObject.newCopy());
                    }
                    actionInfo = this.executeScripts(actionInfo, discoveredObject);
                    BValue result = null;
                    try {
                        result = this.invoke(niagaraAction, (BValue)actionInfo, context);
                    }
                    catch (Exception e) {
                        this.skipFollowingActions = true;
                        throw new LocalizableRuntimeException(MODULE, "NanoRecipeExecutor.executingActionFailureChecked", new Object[]{actionName}, (Throwable)e);
                    }
                    this.log().message(LEX.getText("NanoRecipeExecutor.executingActionSucceeded", new Object[]{actionName}));
                    String resultName = null;
                    try {
                        resultName = actionInfo.getString(actionInfo.getProperty("Out"));
                    }
                    catch (NullPointerException | NoSuchSlotException throwable) {
                        // empty catch block
                    }
                    if (resultName == null || result == null) continue;
                    this.resultsMap.put(resultName, result);
                }
                break;
            }
            if (!noRecipeExecuted) continue;
            failedObjects.add(discoveredObject.get("NAME").toString());
        }
        if (failedObjects.size() > 0) {
            BMessageNotification notification = BMessageNotification.make(BMessageTypeEnum.error, LEX.get("NanoRecipeExecutor.failedToAdd.title", "Failed to add object(s)"), LEX.getText("NanoRecipeExecutor.failedToAdd.message", new Object[]{"\n- " + String.join((CharSequence)"\n- ", failedObjects)}));
            notification.raise(context);
            throw new RuntimeException();
        }
    }

    private BNanoRecipeAction executeScripts(BNanoRecipeAction actionInfo, BDiscoveredNanoObject discoveredObject) {
        BNanoRecipeAction newActionInfo = (BNanoRecipeAction)actionInfo.newCopy();
        for (Property actionProperty : newActionInfo.getDynamicPropertiesArray()) {
            BValue value = newActionInfo.get(actionProperty);
            if (!ScriptHelper.isScript(value)) continue;
            String scriptString = value instanceof BString ? ((BString)value).getString() : value.toString();
            try {
                BValue propertyRefValue;
                String componentRef = ScriptHelper.getComponentReference(scriptString);
                String propertyRef = ScriptHelper.getPropertyReference(scriptString);
                switch (componentRef) {
                    case "discovered": {
                        propertyRefValue = discoveredObject.get(propertyRef).newCopy();
                        break;
                    }
                    default: {
                        propertyRefValue = this.resultsMap.get(componentRef);
                        if (!(propertyRefValue instanceof BComplex) || propertyRef.isEmpty()) break;
                        propertyRefValue = ((BComplex)propertyRefValue).get(propertyRef);
                    }
                }
                if (propertyRefValue.getType().is(actionProperty.getType())) {
                    newActionInfo.set(actionProperty, propertyRefValue);
                    continue;
                }
                newActionInfo.remove(actionProperty);
                newActionInfo.add(actionProperty.getName(), propertyRefValue);
            }
            catch (Exception e) {
                throw new LocalizableRuntimeException(MODULE, "NanoRecipeExecutor.unresolvableReference", new Object[]{scriptString}, (Throwable)e);
            }
        }
        return newActionInfo;
    }

    private void updateProgress(int current, int min, int max) {
        int calcProgress = min != max ? 100 / (max - min) * (current - min) : 100;
        if ((calcProgress = Math.min(100, Math.max(0, calcProgress))) > this.getProgress()) {
            this.progress(calcProgress);
        }
    }

    public BNanoBaseComponent doAddComponent(BNanoRecipeAction actionInfo, Context context) {
        String componentName;
        boolean exists;
        BDiscoveredNanoObject discoveredObject = (BDiscoveredNanoObject)actionInfo.get("discovered");
        String logMessage = LEX.getText("NanoRecipeExecutor.executingAction", new Object[]{actionInfo.getActionName(), discoveredObject.getDebugString(), ((Object)((Object)discoveredObject)).getClass().getSimpleName(), this.target.getSlotPath()});
        String logMessageDetails = actionInfo.getDebugString();
        this.log().add(new JobLogItem(0, logMessage, logMessageDetails));
        BIdentifyingValues identityCheck = (BIdentifyingValues)actionInfo.get("IdentifyingValues");
        BString componentType = (BString)actionInfo.get("ComponentType");
        boolean bl = exists = identityCheck != null && identityCheck.exists((BComponent[])this.target.getChildren(BNanoBaseComponent.class), discoveredObject);
        if (exists) {
            this.log().message(LEX.getText("NanoRecipeExecutor.alreadyExists", new Object[]{identityCheck.toString(context)}));
            this.skipFollowingActions = true;
            return null;
        }
        BNanoBaseComponent componentToCreate = this.target.getNe2DeviceExt().getLibraries().doGetComponentByTypeName(componentType);
        if (componentToCreate == null) {
            throw new LocalizableRuntimeException(MODULE, "NanoRecipeExecutor.noSuchLibraryComponent", new Object[]{componentType});
        }
        componentToCreate = (BNanoBaseComponent)componentToCreate.newCopy();
        String string = componentName = actionInfo.get("ComponentName") instanceof BString ? ((BString)actionInfo.get("ComponentName")).getString() : null;
        if (componentName == null) {
            throw new LocalizableRuntimeException(MODULE, "NanoRecipeExecutor.invalidProperty", new Object[]{"ComponentName", actionInfo.getDebugString()});
        }
        componentToCreate.setNanoName(componentName);
        componentToCreate.setParentGlobalIndex(this.target.getGlobalIndex());
        AddRequest addRequest = AddRequest.make(this.target.getNe2DeviceExt(), componentToCreate);
        RemoteDevice remoteDevice = this.target.getNe2DeviceExt().getRemoteDevice();
        AddResponse response = addRequest.postRequest(remoteDevice);
        ResponseCode responseCode = response.getResponseCode();
        if (!responseCode.equals((Object)ResponseCode.OK)) {
            throw new LocalizableRuntimeException(MODULE, "NanoRecipeExecutor.executingActionFailure", new Object[]{responseCode, response.getLocalizedMessage()});
        }
        ObjectData objectData = response.getResponseData();
        BNanoBaseComponent createdComponent = objectData.createNiagaraComponent(this.target.getNe2DeviceExt());
        this.log().message(LEX.getText("NanoRecipeExecutor.successfullyAddedComponent", new Object[]{SlotPath.unescape((String)createdComponent.getPropertyInParent().getName()), createdComponent.getOriginNameFromLibrary(), this.target.getSlotPath()}));
        return createdComponent;
    }

    public BValue doSetSlotValue(BNanoRecipeAction actionInfo, Context context) {
        Integer componentId = null;
        try {
            componentId = ((BInteger)actionInfo.get("ComponentId")).getInt();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (componentId == null) {
            throw new LocalizableRuntimeException(MODULE, "NanoRecipeExecutor.invalidProperty", new Object[]{"ComponentId", actionInfo.getDebugString()});
        }
        BNanoBaseComponent targetComponent = this.target.getNe2DeviceExt().getComponentCache().get(componentId);
        String logMessage = LEX.getText("NanoRecipeExecutor.executingAction", new Object[]{actionInfo.getActionName(), targetComponent.getNanoName(), targetComponent.getDefaultPropertyName(), targetComponent.getSlotPath()});
        String logMessageDetails = actionInfo.getDebugString();
        this.log().add(new JobLogItem(0, logMessage, logMessageDetails));
        String slotName = ((BString)actionInfo.get("SlotName")).getString();
        BValue newSlotValue = actionInfo.get("SlotValue");
        Property targetProp = targetComponent.getProperty(slotName);
        BValue currentSlotValue = targetComponent.get(targetProp).newCopy();
        newSlotValue = BNanoRecipeExecutorJob.convert(newSlotValue, currentSlotValue);
        BNanoPropertyChangedArg changedArg = new BNanoPropertyChangedArg(targetComponent, targetProp, currentSlotValue, newSlotValue);
        WriteRequest writeRequest = WriteRequest.make(this.target.getNe2DeviceExt(), changedArg);
        RemoteDevice remoteDevice = this.target.getNe2DeviceExt().getRemoteDevice();
        WriteResponse response = writeRequest.postRequest(remoteDevice);
        ResponseCode responseCode = response.getResponseCode();
        if (responseCode != ResponseCode.OK) {
            throw new LocalizableRuntimeException(MODULE, "NanoRecipeExecutor.executingActionFailure", new Object[]{responseCode, response.getLocalizedMessage()});
        }
        return null;
    }

    protected static BValue convert(BValue from, BValue to) {
        if (from != null && to.getClass().isAssignableFrom(from.getClass())) {
            return from.newCopy();
        }
        if (to instanceof BStatusValue) {
            BValue fromValue;
            BStatus newStatus = from != null ? BStatus.ok : BStatus.nullStatus;
            BValue toValue = ((BStatusValue)to).getValueValue();
            BValue bValue = fromValue = from instanceof BStatusValue ? ((BStatusValue)from).getValueValue() : from;
            if (fromValue instanceof BSimple && toValue instanceof BSimple) {
                toValue = BNanoRecipeExecutorJob.convertSimples((BSimple)fromValue, (BSimple)toValue);
                BStatusValue newValue = (BStatusValue)to.newCopy();
                newValue.setStatus(newStatus);
                newValue.setValueValue(toValue);
                return newValue;
            }
        }
        throw new LocalizableRuntimeException(MODULE, "NanoRecipeExecutor.conversionError", new Object[]{from.toString(), from.getClass(), to.getClass()});
    }

    protected static BValue convertSimples(BSimple from, BSimple to) {
        if (from != null && to.getClass().isAssignableFrom(from.getClass())) {
            return from;
        }
        if (to instanceof BDouble) {
            if (from instanceof BInteger) {
                return BDouble.make((double)((BInteger)from).getDouble());
            }
            if (from instanceof BString) {
                return BDouble.make((String)((BString)from).getString());
            }
            if (from instanceof BBoolean) {
                return BDouble.make((double)(from.equals((Object)BBoolean.FALSE) ? 0.0 : 1.0));
            }
        }
        if (to instanceof BInteger) {
            if (from instanceof BDouble) {
                return BInteger.make((int)((BDouble)from).getInt());
            }
            if (from instanceof BString) {
                return BInteger.make((String)((BString)from).getString());
            }
            if (from instanceof BBoolean) {
                return BInteger.make((int)(from.equals((Object)BBoolean.FALSE) ? 0 : 1));
            }
        }
        if (to instanceof BString) {
            if (from instanceof BDouble) {
                return BString.make((String)BDouble.encode((double)((BDouble)from).getDouble()));
            }
            if (from instanceof BInteger) {
                return BString.make((String)BInteger.encode((int)((BInteger)from).getInt()));
            }
            if (from instanceof BBoolean) {
                return BString.make((String)BBoolean.encode((boolean)((BBoolean)from).getBoolean()));
            }
        }
        if (to instanceof BBoolean) {
            if (from instanceof BDouble) {
                return ((BDouble)from).getDouble() <= 0.0 ? BBoolean.FALSE : BBoolean.TRUE;
            }
            if (from instanceof BInteger) {
                return ((BDouble)from).getInt() <= 0 ? BBoolean.FALSE : BBoolean.TRUE;
            }
            if (from instanceof BString) {
                return BBoolean.make((String)((BString)from).getString());
            }
        }
        if (to instanceof BEnum) {
            if (from instanceof BDouble) {
                return BDynamicEnum.make((int)((BDouble)from).getInt(), (BEnumRange)((BEnum)to).getRange());
            }
            if (from instanceof BInteger) {
                return BDynamicEnum.make((int)((BInteger)from).getInt(), (BEnumRange)((BEnum)to).getRange());
            }
            if (from instanceof BString) {
                return BDynamicEnum.make((int)BInteger.make((String)((BString)from).getString()).getInt(), (BEnumRange)((BEnum)to).getRange());
            }
            if (from instanceof BBoolean) {
                return BDynamicEnum.make((int)((BBoolean)from).getOrdinal(), (BEnumRange)((BEnum)to).getRange());
            }
        }
        throw new LocalizableRuntimeException(MODULE, "NanoRecipeExecutor.conversionError", new Object[]{from.toString(), from.getClass(), to.getClass()});
    }
}

