/*
 * Decompiled with CFR 0.152.
 */
package com.ismacontrolli.nE2Link.jobs;

import com.ismacontrolli.nE2Link.BNanoBaseComponent;
import com.ismacontrolli.nE2Link.BNanoDiscoverExtension;
import com.ismacontrolli.nE2Link.BNanoExtension;
import com.ismacontrolli.nE2Link.BNanoStatusNumeric;
import com.ismacontrolli.nE2Link.actions.BNanoAction;
import com.ismacontrolli.nE2Link.actions.BNanoPermanentSubscriptionArg;
import com.ismacontrolli.nE2Link.actions.BNanoPermanentUnsubscriptionArg;
import com.ismacontrolli.nE2Link.jobs.BDiscoveredNanoObject;
import com.ismacontrolli.nE2Link.jobs.BDiscoveredNanoObjects;
import com.ismacontrolli.nE2Link.jobs.BIdentifyingValue;
import com.ismacontrolli.nE2Link.jobs.BIdentifyingValues;
import com.ismacontrolli.nE2Link.jobs.BNanoDiscoverJobParam;
import com.ismacontrolli.nE2Link.jobs.BNanoRecipe;
import com.ismacontrolli.nE2Link.jobs.BNanoRecipeAction;
import com.ismacontrolli.nE2Link.jobs.BNanoRecipeActions;
import com.ismacontrolli.nE2Link.jobs.BNanoRecipes;
import com.ismacontrolli.nE2Link.jobs.ColumnInfo;
import com.ismacontrolli.nE2Link.jobs.ScriptHelper;
import com.ismacontrolli.nE2Link.utils.FileUtil;
import com.ismacontrolli.nE2Link.utils.rpc.serialization.Serializer;
import com.tridium.fox.util.FoxRpcUtil;
import com.tridium.json.JSONArray;
import com.tridium.json.JSONObject;
import com.tridium.json.JSONTokener;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.baja.job.BSimpleJob;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.rpc.NiagaraRpc;
import javax.baja.rpc.Transport;
import javax.baja.rpc.TransportType;
import javax.baja.space.BComponentSpace;
import javax.baja.space.BISpaceNode;
import javax.baja.status.BStatusEnum;
import javax.baja.status.BStatusString;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Subscriber;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="params", type="BNanoDiscoverJobParam", defaultValue="new BNanoDiscoverJobParam()"), @NiagaraProperty(name="columnsLoaded", type="boolean", defaultValue="false"), @NiagaraProperty(name="discoveredObjectsCount", type="int", defaultValue="-1")})
@NiagaraActions(value={@NiagaraAction(name="getDiscoveredObjects", returnType="BDiscoveredNanoObjects", flags=4), @NiagaraAction(name="getRecipes", returnType="BNanoRecipes", flags=4)})
public class BNanoDiscoverJob
extends BSimpleJob {
    public static final Property params = BNanoDiscoverJob.newProperty((int)0, (BValue)new BNanoDiscoverJobParam(), null);
    public static final Property columnsLoaded = BNanoDiscoverJob.newProperty((int)0, (boolean)false, null);
    public static final Property discoveredObjectsCount = BNanoDiscoverJob.newProperty((int)0, (int)-1, null);
    public static final Action getDiscoveredObjects = BNanoDiscoverJob.newAction((int)4, null);
    public static final Action getRecipes = BNanoDiscoverJob.newAction((int)4, null);
    public static final Type TYPE = Sys.loadType(BNanoDiscoverJob.class);
    protected static Lexicon LEX = Lexicon.make(BNanoDiscoverJob.class);
    protected static String MODULE = BNanoDiscoverJob.LEX.module.getModuleName();
    private static int OK_VALUE = 8;
    protected ExecutorService fileProcessingExecutor = Executors.newSingleThreadExecutor();
    protected Object jobUpdateLock = new Object();
    private BNanoBaseComponent target;
    private BNanoExtension discoverExt;
    private Property discoverProgressProp;
    private Property discoverFileProp;
    private String discoveryFilePath;
    private boolean isDiscoveryRunning;
    private boolean isDiscoveryFinished;
    private Exception lastDiscoveryException;
    private ArrayList<ColumnInfo> columns;
    private BNanoRecipes recipes;
    private BDiscoveredNanoObjects discoveredNanoObjects;
    DiscoverExtSubscriber discoverExtSubscriber;

    public BNanoDiscoverJobParam getParams() {
        return (BNanoDiscoverJobParam)this.get(params);
    }

    public void setParams(BNanoDiscoverJobParam v) {
        this.set(params, (BValue)v, null);
    }

    public boolean getColumnsLoaded() {
        return this.getBoolean(columnsLoaded);
    }

    public void setColumnsLoaded(boolean v) {
        this.setBoolean(columnsLoaded, v, null);
    }

    public int getDiscoveredObjectsCount() {
        return this.getInt(discoveredObjectsCount);
    }

    public void setDiscoveredObjectsCount(int v) {
        this.setInt(discoveredObjectsCount, v, null);
    }

    public BDiscoveredNanoObjects getDiscoveredObjects() {
        return (BDiscoveredNanoObjects)this.invoke(getDiscoveredObjects, null, null);
    }

    public BNanoRecipes getRecipes() {
        return (BNanoRecipes)this.invoke(getRecipes, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BNanoDiscoverJob() {
    }

    public BNanoDiscoverJob(BNanoDiscoverJobParam params) {
        this.setParams(params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(Context context) throws Exception {
        try {
            BOrd targetOrd = this.getParams().getTargetOrd();
            BNanoBaseComponent bNanoBaseComponent = this.target = targetOrd != BOrd.NULL ? (BNanoBaseComponent)targetOrd.get((BObject)Sys.getStation()) : null;
            if (this.target == null) {
                throw new LocalizableRuntimeException(MODULE, "NanoDiscover.undefinedViewTarget");
            }
            this.log().start(LEX.getText("NanoDiscover.start", new Object[]{this.target.getSlotPath()}));
            this.setColumnsLoaded(false);
            this.discoverExt = this.getDiscoverExt(this.target);
            if (this.discoverExt == null) {
                throw new LocalizableRuntimeException(MODULE, "NanoDiscover.invalidViewTarget");
            }
            if (this.target == null || ((BStatusEnum)this.target.getProperty("status").getDefaultValue()).getValue().getOrdinal() != OK_VALUE) {
                throw new LocalizableRuntimeException(MODULE, "NanoDiscover.error");
            }
            this.discoverFileProp = this.target.getProperty(this.target.getHostNameForExtensionSlot(this.discoverExt.getOriginNameFromLibrary(), "filePath"));
            this.discoverProgressProp = this.target.getProperty(this.target.getHostNameForExtensionSlot(this.discoverExt.getOriginNameFromLibrary(), "progress"));
            this.discoveryFilePath = this.getDiscoverFilePath();
            System.out.println("Discover file Path before start: " + this.discoveryFilePath);
            BNanoPermanentSubscriptionArg subscribeToNano = new BNanoPermanentSubscriptionArg(context);
            subscribeToNano.addComponent(this.target);
            this.target.getNe2DeviceExt().doRequestNanoPermanentSubscription(subscribeToNano);
            this.discoverExtSubscriber = new DiscoverExtSubscriber();
            this.discoverExtSubscriber.subscribe(this.target);
            if (!this.startDiscovery()) {
                throw new LocalizableRuntimeException(MODULE, "NanoDiscover.cannotStartDiscovery");
            }
            this.log().message(LEX.get("NanoDiscover.startedDiscovery", "Successfully started discovery"));
            boolean finished = false;
            BAbsTime startTime = BAbsTime.now();
            BAbsTime endTime = startTime.add(this.getParams().getDiscoveryFinishTimeout());
            while (!finished) {
                if (((BStatusEnum)this.target.getProperty("status").getDefaultValue()).getValue().getOrdinal() != OK_VALUE) {
                    throw new LocalizableRuntimeException(MODULE, "NanoDiscover.error");
                }
                if (BAbsTime.now().isAfter(endTime)) {
                    this.lastDiscoveryException = new LocalizableRuntimeException(MODULE, "NanoDiscover.discoverTimeout", new Object[]{this.getParams().getDiscoveryFinishTimeout().getSeconds()});
                }
                finished = this.isDiscoveryFinished || !this.isAlive() || this.lastDiscoveryException != null;
                Thread.sleep(500L);
            }
        }
        finally {
            if (this.fileProcessingExecutor != null) {
                this.fileProcessingExecutor.shutdown();
                this.fileProcessingExecutor.awaitTermination(15L, TimeUnit.SECONDS);
                if (!this.fileProcessingExecutor.isTerminated()) {
                    this.fileProcessingExecutor.shutdownNow();
                }
            }
            if (this.discoverExtSubscriber != null) {
                this.discoverExtSubscriber.unsubscribeAll();
            }
            if (this.target != null) {
                BNanoPermanentUnsubscriptionArg unsubscribeFromNano = new BNanoPermanentUnsubscriptionArg(context);
                unsubscribeFromNano.addComponent(this.target);
                this.target.getNe2DeviceExt().doRequestNanoPermanentUnsubscription(unsubscribeFromNano);
            }
            if (this.lastDiscoveryException != null) {
                throw this.lastDiscoveryException;
            }
        }
    }

    protected boolean startDiscovery() throws Exception {
        Property discoverActionProp = this.target.nanoActionsByName.get("Discover");
        if (discoverActionProp == null) {
            throw new LocalizableRuntimeException(MODULE, "NanoDiscover.noDiscoverAction");
        }
        BNanoAction discoverAction = (BNanoAction)this.target.get(discoverActionProp);
        discoverAction.invoke(this.target, null);
        BAbsTime startTime = BAbsTime.now();
        BAbsTime timeOut = startTime.add(this.getParams().getDiscoveryStartTimeout());
        while (!this.isDiscoveryRunning || BAbsTime.now().isAfter(timeOut)) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                break;
            }
        }
        return this.isDiscoveryRunning;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NiagaraRpc(permissions="unrestricted", transports={@Transport(type=TransportType.web), @Transport(type=TransportType.box), @Transport(type=TransportType.fox)})
    public Object getColumns(Context cx) throws Exception {
        BComponentSpace space = this.getComponentSpace();
        if (space != null && space.isProxyComponentSpace()) {
            Optional rpcResult = FoxRpcUtil.doRpc((BISpaceNode)this, (String)"getColumns", (Object[])new Object[0]);
            if (rpcResult.isPresent()) {
                Object rpcResultObj = rpcResult.get();
                return Serializer.fromJson(rpcResultObj);
            }
            return null;
        }
        Object object = this.jobUpdateLock;
        synchronized (object) {
            if (!this.getColumnsLoaded()) {
                throw new IllegalStateException("Attempted to access columns before loading has finished");
            }
            if (cx != null && cx.getFacets().get("transportType") != null) {
                List jsonCols = (List)Serializer.toJson(this.columns, false);
                return jsonCols;
            }
            return this.columns;
        }
    }

    public BNanoRecipes doGetRecipes(Context context) throws InterruptedException {
        for (int retry = 0; !this.getColumnsLoaded() && retry < 20; ++retry) {
            Thread.sleep(500L);
        }
        if (!this.getColumnsLoaded()) {
            throw new IllegalStateException("Attempted to access recipes before loading has finished");
        }
        return this.recipes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BDiscoveredNanoObjects doGetDiscoveredObjects(Context context) {
        if (this.getDiscoveredObjectsCount() == -1) {
            throw new IllegalStateException("Attempted to access columns before loading has finished");
        }
        Object object = this.jobUpdateLock;
        synchronized (object) {
            return this.discoveredNanoObjects;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doDiscoveryFileChanged(String previousFile, String newFile) throws Exception {
        Object object;
        String logMsg = LEX.getText("NanoDiscover.newDiscoveryFile", new Object[]{newFile});
        System.out.println(logMsg);
        byte[] jsonBytes = FileUtil.readNanoFile(this.target.getNe2DeviceExt(), newFile);
        ByteArrayInputStream is = new ByteArrayInputStream(jsonBytes);
        InputStreamReader reader = new InputStreamReader((InputStream)is, StandardCharsets.UTF_8);
        JSONTokener tokener = new JSONTokener((Reader)reader);
        JSONObject root = null;
        while (tokener.more() && root == null) {
            Object o = tokener.nextValue();
            if (!(o instanceof JSONObject)) continue;
            root = (JSONObject)o;
        }
        if (root == null) {
            throw new LocalizableRuntimeException(MODULE, "NanoDiscover.noJSONRoot");
        }
        int jsonFormatVersion = this.getFormatVersion(root);
        if (!this.getColumnsLoaded()) {
            object = this.jobUpdateLock;
            synchronized (object) {
                this.columns = this.parseColumns(root, jsonFormatVersion);
                this.recipes = this.parseRecipes(root, jsonFormatVersion);
            }
            this.setColumnsLoaded(true);
        }
        object = this.jobUpdateLock;
        synchronized (object) {
            this.discoveredNanoObjects = this.parseDiscoveredObjects(root, jsonFormatVersion);
            this.setDiscoveredObjectsCount(this.discoveredNanoObjects.getDynamicPropertiesArray().length);
        }
        this.log().message(LEX.getText("NanoDiscover.finishedDiscoveryFile", new Object[]{newFile}));
    }

    protected void doDiscoveryProgressChanged(double progressPercent) {
        System.out.println("Discover progress changed: " + progressPercent);
        this.progress((int)progressPercent);
    }

    protected BNanoExtension getDiscoverExt(BNanoBaseComponent target) {
        BNanoDiscoverExtension[] extensions = (BNanoDiscoverExtension[])target.getChildren(BNanoDiscoverExtension.class);
        return extensions.length > 0 ? extensions[0] : null;
    }

    protected String getDiscoverFilePath() {
        return ((BStatusString)this.target.get(this.discoverFileProp)).getValue();
    }

    protected double getDiscoverProgress() {
        return ((BNanoStatusNumeric)this.target.get(this.discoverProgressProp)).getValue();
    }

    protected int getFormatVersion(JSONObject jsonRoot) {
        return jsonRoot.getInt("FormatVersion");
    }

    protected ArrayList<ColumnInfo> parseColumns(JSONObject jsonRoot, int jsonFormatVersion) {
        ArrayList<ColumnInfo> columns = new ArrayList<ColumnInfo>();
        switch (jsonFormatVersion) {
            case 1: {
                JSONArray displayCols = jsonRoot.optJSONArray("DisplayedColumns");
                if (displayCols == null) {
                    throw new LocalizableRuntimeException(MODULE, "NanoDiscover.noColumns");
                }
                for (int i = 0; i < displayCols.length(); ++i) {
                    String colCaption = displayCols.getString(i);
                    String slotName = ScriptHelper.makeValidSlotNameForDiscoveredObject(colCaption, jsonFormatVersion);
                    columns.add(new ColumnInfo(colCaption, slotName, 4));
                }
                break;
            }
            default: {
                throw new LocalizableRuntimeException(MODULE, "NanoDiscover.unknownFormatVersion", new Object[]{jsonFormatVersion});
            }
        }
        return columns;
    }

    protected BNanoRecipes parseRecipes(JSONObject jsonRoot, int jsonFormatVersion) {
        BNanoRecipes recipes = new BNanoRecipes(this.target);
        switch (jsonFormatVersion) {
            case 1: {
                JSONArray jsonRecipes = jsonRoot.optJSONArray("Recipes");
                if (jsonRecipes == null) break;
                for (int i = 0; i < jsonRecipes.length(); ++i) {
                    JSONObject jsonRecipe = jsonRecipes.getJSONObject(i);
                    String discoveredType = jsonRecipe.optString("DiscoveredType", null);
                    if (discoveredType != null) {
                        BNanoRecipeActions actions = this.parseActions(jsonRecipe, jsonFormatVersion);
                        recipes.add(new BNanoRecipe(discoveredType, actions));
                        continue;
                    }
                    this.log().message(LEX.getText("NanoDiscover.noRecipeType", new Object[]{i, jsonRecipe.toString(2)}));
                }
                break;
            }
            default: {
                throw new LocalizableRuntimeException(MODULE, "NanoDiscover.unknownFormatVersion", new Object[]{jsonFormatVersion});
            }
        }
        return recipes;
    }

    protected BNanoRecipeActions parseActions(JSONObject jsonRecipe, int jsonFormatVersion) {
        BNanoRecipeActions recipeActions = new BNanoRecipeActions();
        switch (jsonFormatVersion) {
            case 1: {
                JSONArray jsonActions = jsonRecipe.optJSONArray("Actions");
                if (jsonActions == null) break;
                for (int i = 0; i < jsonActions.length(); ++i) {
                    JSONObject jsonAction = jsonActions.optJSONObject(i);
                    String actionName = jsonAction.optString("ActionName", null);
                    if (actionName == null || actionName.isEmpty()) {
                        throw new LocalizableRuntimeException(MODULE, "missingActionName", new Object[]{i});
                    }
                    BNanoRecipeAction recipeAction = new BNanoRecipeAction(actionName);
                    Iterator keys = jsonAction.keys();
                    while (keys.hasNext()) {
                        Object jsonKey = keys.next();
                        if (!(jsonKey instanceof String)) {
                            throw new LocalizableRuntimeException(MODULE, "NanoDiscover.invalidPropertyName", new Object[]{jsonKey == null ? "null" : jsonKey.getClass().getSimpleName(), jsonAction});
                        }
                        String jsonPropName = (String)jsonKey;
                        if (jsonPropName.equals("ActionName")) continue;
                        Object jsonPropValue = jsonAction.opt(jsonPropName);
                        if (!(jsonPropValue instanceof JSONObject) && !(jsonPropValue instanceof JSONArray)) {
                            BValue niagaraValue = ScriptHelper.niagaraValueFromObject(jsonPropValue = ScriptHelper.fixScriptReferences(jsonPropValue, jsonFormatVersion));
                            if (niagaraValue != null) {
                                recipeAction.add(jsonPropName, niagaraValue);
                                continue;
                            }
                            throw new LocalizableRuntimeException(MODULE, "NanoDiscover.invalidPropertyValue", new Object[]{jsonPropValue.getClass().getSimpleName(), jsonAction});
                        }
                        if (jsonPropValue instanceof JSONArray) {
                            if (jsonPropName.equals("IdentifyingValues")) {
                                JSONArray jsonIdentifyingValues = (JSONArray)jsonPropValue;
                                BIdentifyingValues identifyingValues = new BIdentifyingValues();
                                for (int identityCount = 0; identityCount < jsonIdentifyingValues.length(); ++identityCount) {
                                    JSONObject jsonIdentifyingValue = jsonIdentifyingValues.getJSONObject(identityCount);
                                    String c1PropName = jsonIdentifyingValue.optString("Name", null);
                                    Object c1PropValue = jsonIdentifyingValue.opt("Value");
                                    if (c1PropName == null || c1PropValue == null) {
                                        throw new LocalizableRuntimeException(MODULE, "NanoDiscover.invalidIdentifyingValue", new Object[]{identityCount, actionName});
                                    }
                                    if (ScriptHelper.isScript(c1PropName)) {
                                        c1PropName = (String)ScriptHelper.fixScriptReferences(c1PropName, jsonFormatVersion);
                                    }
                                    String c2PropName = ScriptHelper.isScript(c1PropValue) ? (String)ScriptHelper.fixScriptReferences(c1PropValue, jsonFormatVersion) : "";
                                    BValue comparisonValue = c2PropName.isEmpty() ? ScriptHelper.niagaraValueFromObject(c1PropValue) : null;
                                    identifyingValues.add(new BIdentifyingValue(c1PropName, c2PropName, comparisonValue));
                                }
                                recipeAction.add(jsonPropName, (BValue)identifyingValues);
                                continue;
                            }
                            throw new LocalizableRuntimeException(MODULE, "NanoDiscover.invalidPropertyValueArray", new Object[]{jsonKey, jsonAction});
                        }
                        throw new LocalizableRuntimeException(MODULE, "NanoDiscover.invalidPropertyValue", new Object[]{jsonPropValue.getClass().getSimpleName(), jsonAction});
                    }
                    recipeActions.add(recipeAction);
                }
                break;
            }
            default: {
                throw new LocalizableRuntimeException(MODULE, "NanoDiscover.unknownFormatVersion", new Object[]{jsonFormatVersion});
            }
        }
        return recipeActions;
    }

    protected BDiscoveredNanoObject parseDiscoveredObject(JSONObject jsonObject, int jsonFormatVersion) {
        BDiscoveredNanoObject discoveredNanoObject = new BDiscoveredNanoObject();
        switch (jsonFormatVersion) {
            case 1: {
                Iterator keys = jsonObject.keys();
                while (keys.hasNext()) {
                    Object jsonKey = keys.next();
                    if (jsonKey instanceof String) {
                        String propName = (String)jsonKey;
                        Object value = jsonObject.get(propName);
                        BValue niagaraValue = ScriptHelper.niagaraValueFromObject(value);
                        if (niagaraValue != null) {
                            discoveredNanoObject.add(ScriptHelper.makeValidSlotNameForDiscoveredObject(propName, jsonFormatVersion), niagaraValue);
                            continue;
                        }
                        this.log().message(LEX.getText("NanoDiscover.invalidPropertyValue", new Object[]{value.getClass().getSimpleName(), jsonObject}));
                        continue;
                    }
                    this.log().message(LEX.getText("NanoDiscover.invalidPropertyName", new Object[]{jsonKey == null ? "null" : jsonKey.getClass().getSimpleName(), jsonObject}));
                }
                break;
            }
            default: {
                throw new LocalizableRuntimeException(MODULE, "NanoDiscover.unknownFormatVersion", new Object[]{jsonFormatVersion});
            }
        }
        return discoveredNanoObject;
    }

    protected BDiscoveredNanoObjects parseDiscoveredObjects(JSONObject jsonRoot, int jsonFormatVersion) {
        BDiscoveredNanoObjects discoveredObjects = new BDiscoveredNanoObjects();
        switch (jsonFormatVersion) {
            case 1: {
                JSONArray discoveredJsonObjects = jsonRoot.optJSONArray("Discovered");
                if (discoveredJsonObjects == null) {
                    this.log().message(MODULE, "NanoDiscover.noObjects");
                    return discoveredObjects;
                }
                for (int i = 0; i < discoveredJsonObjects.length(); ++i) {
                    JSONObject discoveredJsonObject = discoveredJsonObjects.getJSONObject(i);
                    BDiscoveredNanoObject discoveredObject = this.parseDiscoveredObject(discoveredJsonObject, jsonFormatVersion);
                    if (discoveredObject == null) continue;
                    discoveredObjects.add(discoveredObject);
                }
                break;
            }
            default: {
                throw new LocalizableRuntimeException(MODULE, "NanoDiscover.unknownFormatVersion", new Object[]{jsonFormatVersion});
            }
        }
        return discoveredObjects;
    }

    class DiscoverExtSubscriber
    extends Subscriber {
        DiscoverExtSubscriber() {
        }

        public void event(BComponentEvent componentEvent) {
            if (componentEvent.getId() == 0) {
                if (componentEvent.getSlot().equals((Object)BNanoDiscoverJob.this.discoverProgressProp)) {
                    double percent = ((BNanoStatusNumeric)componentEvent.getValue()).getValue();
                    if (percent >= 100.0) {
                        BNanoDiscoverJob.this.isDiscoveryRunning = false;
                        BNanoDiscoverJob.this.isDiscoveryFinished = true;
                    }
                    if (!BNanoDiscoverJob.this.isDiscoveryRunning && percent < 100.0) {
                        BNanoDiscoverJob.this.isDiscoveryRunning = true;
                        BNanoDiscoverJob.this.isDiscoveryFinished = false;
                    }
                    BNanoDiscoverJob.this.doDiscoveryProgressChanged(percent);
                } else if (componentEvent.getSlot().equals((Object)BNanoDiscoverJob.this.discoverFileProp)) {
                    if (!BNanoDiscoverJob.this.isDiscoveryRunning) {
                        BNanoDiscoverJob.this.isDiscoveryRunning = true;
                    }
                    String oldFilePath = BNanoDiscoverJob.this.discoveryFilePath;
                    BNanoDiscoverJob.this.discoveryFilePath = ((BStatusString)componentEvent.getValue()).getValue();
                    if (BNanoDiscoverJob.this.discoveryFilePath.length() > 0) {
                        BNanoDiscoverJob.this.fileProcessingExecutor.execute(() -> {
                            try {
                                BNanoDiscoverJob.this.doDiscoveryFileChanged(oldFilePath, BNanoDiscoverJob.this.discoveryFilePath);
                            }
                            catch (Exception e) {
                                BNanoDiscoverJob.this.lastDiscoveryException = e;
                            }
                        });
                    }
                }
            }
        }
    }
}

