/*
 * Decompiled with CFR 0.152.
 */
package com.ismacontrolli.nE2Link.datatypes.choice.converter;

import com.ismacontrolli.nE2Link.datatypes.choice.BDynamicChoice;
import com.ismacontrolli.nE2Link.datatypes.choice.BDynamicChoiceRange;
import com.ismacontrolli.nE2Link.datatypes.choice.BStatusDynamicChoice;
import javax.baja.agent.BIAgent;
import javax.baja.nre.annotations.Adapter;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BEnum;
import javax.baja.sys.BNumber;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BConverter;

@NiagaraType(agent={@AgentOn(types={"baja:ConversionLink"})}, adapter=@Adapter(from="baja:StatusValue", to="nE2Link:StatusDynamicChoice"))
public class BStatusValueToStatusDynamicChoice
extends BConverter
implements BIAgent {
    public static final Type TYPE = Sys.loadType(BStatusValueToStatusDynamicChoice.class);

    public Type getType() {
        return TYPE;
    }

    public BObject convert(BObject from, BObject to, Context context) {
        BDynamicChoiceRange range = ((BStatusDynamicChoice)to).getValue().getRange();
        if (from == null) {
            BDynamicChoice nullChoice = BDynamicChoice.make(null, range);
            return new BStatusDynamicChoice(nullChoice);
        }
        BStatusValue fromValue = (BStatusValue)from;
        BValue fromValueValue = fromValue.getValueValue();
        BStatus status = fromValue.getStatus();
        BDynamicChoice toValue = null;
        if (fromValueValue.getType().is(BBoolean.TYPE) || fromValueValue.getType().is(BNumber.TYPE) || fromValueValue.getType().is(BString.TYPE)) {
            toValue = BDynamicChoice.make(fromValueValue, range);
        } else if (fromValueValue.getType().is(BEnum.TYPE)) {
            toValue = BDynamicChoice.make((double)((BEnum)fromValueValue).getOrdinal(), range);
        }
        if (toValue != null) {
            return new BStatusDynamicChoice(toValue, status);
        }
        throw new IllegalStateException(String.format("Cannot convert %s to %s", from, to));
    }
}

