/*
 * Decompiled with CFR 0.152.
 */
package com.ismacontrolli.nE2Link.datatypes.choice;

import com.ismacontrolli.nE2Link.datatypes.BBigInteger;
import com.ismacontrolli.nE2Link.datatypes.choice.BDynamicChoiceRange;
import com.ismacontrolli.nE2Link.parser.binary.SlotSchema;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Objects;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BDouble;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BLong;
import javax.baja.sys.BNumber;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BString;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public final class BDynamicChoice
extends BSimple {
    private BDynamicChoiceRange range;
    private BSimple key;
    private String encodedString;
    private int hashCode = -1;
    public static final BDynamicChoice DEFAULT = BDynamicChoice.make(null);
    public static final Type TYPE = Sys.loadType(BDynamicChoice.class);

    public Type getType() {
        return TYPE;
    }

    public static BDynamicChoice make(long key) {
        return BDynamicChoice.make(key, null);
    }

    public static BDynamicChoice make(long key, BDynamicChoiceRange range) {
        BLong keyObject = BLong.make((long)key);
        return BDynamicChoice.make((Object)keyObject, range);
    }

    public static BDynamicChoice make(BLong key, BDynamicChoiceRange range) {
        return (BDynamicChoice)new BDynamicChoice((BSimple)key, range).intern();
    }

    public static BDynamicChoice make(double key) {
        return BDynamicChoice.make(key, null);
    }

    public static BDynamicChoice make(double key, BDynamicChoiceRange range) {
        BDouble keyObject = BDouble.make((double)key);
        return BDynamicChoice.make((Object)keyObject, range);
    }

    public static BDynamicChoice make(BDouble key, BDynamicChoiceRange range) {
        return (BDynamicChoice)new BDynamicChoice((BSimple)key, range).intern();
    }

    public static BDynamicChoice make(boolean key) {
        return BDynamicChoice.make(key, null);
    }

    public static BDynamicChoice make(boolean key, BDynamicChoiceRange range) {
        BBoolean keyObject = BBoolean.make((boolean)key);
        return BDynamicChoice.make((Object)keyObject, range);
    }

    public static BDynamicChoice make(BBoolean key, BDynamicChoiceRange range) {
        return (BDynamicChoice)new BDynamicChoice((BSimple)key, range).intern();
    }

    public static BDynamicChoice make(String key) {
        BSimple keyObject = key == null ? (BSimple)null : BString.make((String)key);
        return BDynamicChoice.make(keyObject, null);
    }

    public static BDynamicChoice make(String key, BDynamicChoiceRange range) {
        BSimple keyObject = key == null ? (BSimple)null : BString.make((String)key);
        return BDynamicChoice.make(keyObject, range);
    }

    public static BDynamicChoice make(BString key, BDynamicChoiceRange range) {
        return (BDynamicChoice)new BDynamicChoice((BSimple)key, range).intern();
    }

    public static BDynamicChoice make(Object key) {
        return BDynamicChoice.make(key, null);
    }

    public static BDynamicChoice make(Object key, BDynamicChoiceRange range) {
        BDynamicChoice.validateKey(key);
        return (BDynamicChoice)new BDynamicChoice(BDynamicChoiceRange.makeKeyFromObject(key), range).intern();
    }

    private BDynamicChoice(BSimple key, BDynamicChoiceRange range) {
        this.key = key;
        if (range == null) {
            range = BDynamicChoiceRange.NULL;
        }
        this.range = range;
    }

    public BSimple getKey() {
        return this.key;
    }

    public BBoolean getKeyAsBoolean() {
        try {
            return BBoolean.make((boolean)BDynamicChoice.keyToBoolean(this.key));
        }
        catch (Exception e) {
            throw new IllegalStateException(String.format("Cannot convert %s to %s", this.key, BBoolean.TYPE.getTypeName()));
        }
    }

    public BNumber getKeyAsNumber() {
        try {
            Number num = BDynamicChoice.keyToNumber(this.key);
            if (num instanceof Long) {
                return BLong.make((long)((Long)num));
            }
            return BDouble.make((double)((Double)num));
        }
        catch (Exception e) {
            throw new IllegalStateException(String.format("Cannot convert %s to %s", this.key, BNumber.TYPE.getTypeName()));
        }
    }

    public BString getKeyAsString() {
        try {
            return BString.make((String)BDynamicChoice.keyToString(this.key));
        }
        catch (Exception e) {
            throw new IllegalStateException(String.format("Cannot convert %s to %s", this.key, BBoolean.TYPE.getTypeName()));
        }
    }

    public Object getKeyAsNanoObject(Slot nanoSlot) {
        try {
            return BDynamicChoice.keyToNanoObject(this.key, nanoSlot);
        }
        catch (Exception e) {
            throw new IllegalStateException(String.format("Cannot convert %s to %s", this.key, SlotSchema.getNanoValueType(nanoSlot)));
        }
    }

    public BEnum getKeyAsEnum(BEnumRange targetRange) {
        if (this.key == null) {
            return null;
        }
        BEnum toValue = null;
        try {
            if (this.key instanceof BBoolean) {
                toValue = ((BBoolean)this.key).getBoolean() ? targetRange.get(1) : targetRange.get(0);
            } else if (this.key instanceof BNumber) {
                toValue = targetRange.get(((BNumber)this.key).getInt());
            } else if (this.key instanceof BString) {
                toValue = targetRange.get(((BString)this.key).getString());
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(String.format("Cannot convert %s to enum with range %s", this.key, targetRange), e);
        }
        return toValue;
    }

    public static Boolean keyToBoolean(BSimple key) {
        if (key == null) {
            return null;
        }
        if (key instanceof BNumber) {
            return ((BNumber)key).getNumeric() == 0.0 ? Boolean.FALSE : Boolean.TRUE;
        }
        if (key instanceof BBoolean) {
            return ((BBoolean)key).getBoolean();
        }
        if (key instanceof BString) {
            return Boolean.parseBoolean(((BString)key).getString());
        }
        throw new IllegalArgumentException(String.format("Cannot convert %s to %s", key, Boolean.class));
    }

    public static Number keyToNumber(BSimple key) {
        if (key == null) {
            return null;
        }
        if (key instanceof BLong) {
            return ((BNumber)key).getLong();
        }
        if (key instanceof BNumber) {
            return ((BNumber)key).getNumeric();
        }
        if (key instanceof BBoolean) {
            return ((BBoolean)key).getBoolean() ? 1.0 : 0.0;
        }
        if (key instanceof BBigInteger) {
            return ((BBigInteger)key).getBigInteger();
        }
        if (key instanceof BString) {
            String keyString = key.toString();
            try {
                return Double.parseDouble(keyString);
            }
            catch (NumberFormatException e) {
                try {
                    return Long.parseLong(keyString);
                }
                catch (NumberFormatException ex) {
                    return Long.parseUnsignedLong(keyString);
                }
            }
        }
        throw new IllegalArgumentException(String.format("Cannot convert %s to %s", key, Double.class));
    }

    public static Object keyToNanoObject(BSimple key, Slot nanoSlot) {
        if (key == null) {
            return null;
        }
        if (SlotSchema.isNiagaraNumeric(nanoSlot)) {
            return BDynamicChoice.keyToNumber(key);
        }
        if (SlotSchema.isNiagaraBoolean(nanoSlot)) {
            return BDynamicChoice.keyToBoolean(key);
        }
        if (SlotSchema.isNiagaraString(nanoSlot)) {
            return BDynamicChoice.keyToString(key);
        }
        throw new IllegalArgumentException(String.format("Cannot convert %s to %s", key, SlotSchema.getNanoValueType(nanoSlot)));
    }

    public static String keyToString(BSimple key) {
        if (key == null) {
            return null;
        }
        return key.toString();
    }

    public static BigDecimal keyToBigDecimal(BSimple key) {
        if (key instanceof BDouble) {
            return BigDecimal.valueOf(((BDouble)key).getDouble());
        }
        if (key instanceof BLong) {
            return BigDecimal.valueOf(((BLong)key).getLong());
        }
        if (key instanceof BBoolean) {
            boolean booleanVal = ((BBoolean)key).getBoolean();
            Long longVal = booleanVal ? 1L : 0L;
            return BigDecimal.valueOf(longVal);
        }
        if (key instanceof BBigInteger) {
            return new BigDecimal(((BBigInteger)key).getBigInteger());
        }
        return null;
    }

    public String getTag() {
        return this.range.getTag(this.key);
    }

    public String getDisplayTag(Context cx) {
        return this.range.getDisplayTag(this.key, cx);
    }

    public BDynamicChoiceRange getRange() {
        return this.range;
    }

    public boolean isNull() {
        return this.key == null;
    }

    public String toString(Context context) {
        return this.getDisplayTag(context);
    }

    public int hashCode() {
        try {
            if (this.hashCode == -1) {
                this.hashCode = this.encodeToString().hashCode();
            }
            return this.hashCode;
        }
        catch (Exception e) {
            return System.identityHashCode((Object)this);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        BDynamicChoice that = (BDynamicChoice)((Object)o);
        return this.range.equals((Object)that.range) && Objects.equals(this.key, that.key);
    }

    public final void encode(DataOutput out) throws IOException {
        out.writeUTF(this.encodeToString());
    }

    public final BObject decode(DataInput in) throws IOException {
        return this.decodeFromString(in.readUTF());
    }

    public final String encodeToString() throws IOException {
        if (this.encodedString == null) {
            StringBuffer s = new StringBuffer();
            s.append(this.key == null ? "null" : this.key.encodeToString()).append("[").append(this.key == null ? BString.TYPE.getTypeSpec().encodeToString() : this.key.getType().getTypeSpec().encodeToString()).append("]");
            if (!this.range.isNull()) {
                s.append('@');
                s.append(this.range.encodeToString());
            }
            this.encodedString = s.toString();
        }
        return this.encodedString;
    }

    public final BObject decodeFromString(String s) throws IOException {
        try {
            BSimple key;
            String keyString = s;
            String rangeString = null;
            int at = s.indexOf(64);
            if (at > 0) {
                keyString = s.substring(0, at);
                rangeString = s.substring(at + 1);
            }
            BDynamicChoiceRange range = BDynamicChoiceRange.NULL;
            if (rangeString != null) {
                range = range.decodeFromString(rangeString);
            }
            if ((key = BDynamicChoiceRange.decodeKeyFromString(keyString)) == null) {
                throw new IOException("Invalid key format when decoding BDynamicChoice");
            }
            BDynamicChoice result = new BDynamicChoice(key, range);
            result.encodedString = s;
            return result;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IOException(s);
        }
    }

    public static boolean isKeyValid(Object key) {
        return key instanceof BString || key instanceof BDouble || key instanceof BBoolean || key instanceof BLong || key instanceof String || key instanceof Double || key instanceof Boolean || key instanceof Long || key == null;
    }

    public static void validateKey(Object key) {
        if (!BDynamicChoice.isKeyValid(key)) {
            throw new IllegalArgumentException("Invalid key type: key= " + key + " [" + key.getClass() + "]");
        }
    }
}

