/*
 * Decompiled with CFR 0.152.
 */
package com.ismacontrolli.nE2Link.datatypes;

import com.ismacontrolli.nE2Link.datatypes.BBigInteger;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.math.BigInteger;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BObject;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public final class BUInt64
extends BBigInteger {
    public static final BigInteger MAX_VALUE = new BigInteger("+FFFFFFFFFFFFFFFF", 16);
    public static final BigInteger MIN_VALUE = BigInteger.ZERO;
    public static final BUInt64 ZERO = BUInt64.make(BigInteger.ZERO);
    public static final BUInt64 ONE = BUInt64.make(BigInteger.ONE);
    public static final BUInt64 TEN = BUInt64.make(BigInteger.TEN);
    public static final BUInt64 DEFAULT = ZERO;
    public static final Type TYPE = Sys.loadType(BUInt64.class);

    @Override
    public Type getType() {
        return TYPE;
    }

    public static BUInt64 make(byte[] value) {
        return new BUInt64(value, true);
    }

    public static BUInt64 make(String value) {
        return new BUInt64(value);
    }

    public static BUInt64 make(String value, int radix) {
        return new BUInt64(value, radix);
    }

    public static BUInt64 makeFromLittleEndian(byte[] value) {
        return new BUInt64(value, false);
    }

    public static BUInt64 make(BigInteger value) {
        return new BUInt64(value);
    }

    protected BUInt64(byte[] value, boolean bigEndian) {
        super(false, value, bigEndian);
        if (value.length > 8) {
            throw new NumberFormatException("UInt64 cannot be longer than 8 bytes");
        }
    }

    protected BUInt64(String value) {
        super(value);
        if (value.contains("-")) {
            throw new NumberFormatException("UInt64 may not contain a minus sign");
        }
    }

    protected BUInt64(String value, int radix) {
        super(value, radix);
        if (value.contains("-")) {
            throw new NumberFormatException("UInt64 may not contain a minus sign");
        }
    }

    protected BUInt64(BigInteger value) {
        super(value);
    }

    @Override
    public byte[] toByteArray() {
        return super.toByteArray(8, true);
    }

    @Override
    public BigInteger getMinValue() {
        return MIN_VALUE;
    }

    @Override
    public BigInteger getMaxValue() {
        return MAX_VALUE;
    }

    public byte[] toByteArray(boolean bigEndian) {
        return super.toByteArray(8, bigEndian);
    }

    @Override
    public void encode(DataOutput dataOutput) throws IOException {
        dataOutput.writeUTF(this.encodeToString());
    }

    @Override
    public BObject decode(DataInput dataInput) throws IOException {
        String value = dataInput.readUTF();
        return this.decodeFromString(value);
    }

    @Override
    public String encodeToString() throws IOException {
        return this.toString(null);
    }

    @Override
    public BObject decodeFromString(String string) throws IOException {
        return new BUInt64(string);
    }
}

