/*
 * Decompiled with CFR 0.152.
 */
package com.ismacontrolli.nE2Link.datatypes;

import com.ismacontrolli.nE2Link.datatypes.BBigInteger;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.math.BigInteger;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BObject;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public final class BInt64
extends BBigInteger {
    public static final BigInteger MAX_VALUE = new BigInteger("7FFFFFFFFFFFFFFF", 16);
    public static final BigInteger MIN_VALUE = MAX_VALUE.negate().subtract(BigInteger.ONE);
    public static final BInt64 ZERO = BInt64.make(BigInteger.ZERO);
    public static final BInt64 ONE = BInt64.make(BigInteger.ONE);
    public static final BInt64 TEN = BInt64.make(BigInteger.TEN);
    public static final BInt64 DEFAULT = ZERO;
    public static final Type TYPE = Sys.loadType(BInt64.class);

    @Override
    public Type getType() {
        return TYPE;
    }

    public static BInt64 make(byte[] value) {
        return new BInt64(value, true);
    }

    public static BInt64 make(String value) {
        return new BInt64(value);
    }

    public static BInt64 make(String value, int radix) {
        return new BInt64(value, radix);
    }

    public static BInt64 make(BigInteger value) {
        return new BInt64(value);
    }

    public static BInt64 makeFromLittleEndian(byte[] value) {
        return new BInt64(value, false);
    }

    protected BInt64(byte[] value, boolean bigEndian) {
        super(true, value, bigEndian);
    }

    protected BInt64(String value) {
        super(value);
    }

    protected BInt64(String value, int radix) {
        super(value, radix);
    }

    protected BInt64(BigInteger value) {
        super(value);
    }

    @Override
    public byte[] toByteArray() {
        return super.toByteArray(8, true);
    }

    @Override
    public BigInteger getMinValue() {
        return MIN_VALUE;
    }

    @Override
    public BigInteger getMaxValue() {
        return MAX_VALUE;
    }

    public byte[] toByteArray(boolean bigEndian) {
        return super.toByteArray(8, bigEndian);
    }

    @Override
    public void encode(DataOutput dataOutput) throws IOException {
        dataOutput.writeUTF(this.encodeToString());
    }

    @Override
    public BObject decode(DataInput dataInput) throws IOException {
        String value = dataInput.readUTF();
        return this.decodeFromString(value);
    }

    @Override
    public String encodeToString() throws IOException {
        return this.toString(null);
    }

    @Override
    public BObject decodeFromString(String string) throws IOException {
        return new BInt64(string);
    }
}

