/*
 * Decompiled with CFR 0.152.
 */
package com.ismacontrolli.nE2Link.datatypes;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Arrays;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public abstract class BBigInteger
extends BSimple
implements Comparable<BBigInteger> {
    public static final Type TYPE = Sys.loadType(BBigInteger.class);
    private BigInteger bigInteger;

    public Type getType() {
        return TYPE;
    }

    protected BBigInteger(BigInteger value) {
        this.bigInteger = value == null ? BigInteger.ZERO : value;
        this.checkRange();
    }

    protected BBigInteger(String value) {
        this.bigInteger = value == null || value.isEmpty() ? BigInteger.ZERO : new BigInteger(value);
        this.checkRange();
    }

    protected BBigInteger(String value, int radix) {
        this.bigInteger = value == null || value.isEmpty() ? BigInteger.ZERO : new BigInteger(value, radix);
        this.checkRange();
    }

    protected BBigInteger(boolean signed, byte[] value, boolean bigEndian) {
        this.bigInteger = signed ? (bigEndian ? new BigInteger(value) : new BigInteger(this.reverseBytes(value))) : (bigEndian ? new BigInteger(1, value) : new BigInteger(this.reverseBytes(value)));
        this.checkRange();
    }

    public BigInteger getBigInteger() {
        return this.bigInteger;
    }

    protected byte[] toByteArray() {
        return this.bigInteger.toByteArray();
    }

    protected byte[] toByteArray(int targetLengthInBytes) {
        return this.toByteArray(targetLengthInBytes, true);
    }

    protected byte[] toByteArray(int targetLengthInBytes, boolean bigEndian) {
        byte[] srcAsBytes = this.bigInteger.toByteArray();
        int srcLength = srcAsBytes.length;
        boolean isNegative = this.bigInteger.signum() == -1;
        byte[] resultArray = new byte[targetLengthInBytes];
        if (isNegative) {
            Arrays.fill(resultArray, (byte)-1);
        }
        if (srcLength <= targetLengthInBytes) {
            System.arraycopy(srcAsBytes, 0, resultArray, targetLengthInBytes - srcLength, srcLength);
        } else {
            System.arraycopy(srcAsBytes, srcLength - targetLengthInBytes, resultArray, 0, targetLengthInBytes);
        }
        return bigEndian ? resultArray : this.reverseBytes(resultArray);
    }

    public static String toHexByteString(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        sb.append("[ ");
        for (byte b : bytes) {
            sb.append(String.format("0x%02X ", b));
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    public int compareTo(BBigInteger val) {
        return this.bigInteger.compareTo(val.bigInteger);
    }

    public String toString(Context cx) {
        return this.bigInteger.toString();
    }

    public String toString(Context cx, int radix) {
        return this.bigInteger.toString(radix);
    }

    private byte[] reverseBytes(byte[] original) {
        int length = original.length;
        byte[] reversed = new byte[length];
        for (int i = 0; i < length; ++i) {
            reversed[length - 1 - i] = original[i];
        }
        return reversed;
    }

    public boolean equals(Object other) {
        if (!(other instanceof BBigInteger)) {
            return false;
        }
        return this.bigInteger.equals(((BBigInteger)other).bigInteger);
    }

    protected void checkRange() {
        BigInteger minValue = this.getMinValue();
        BigInteger maxValue = this.getMaxValue();
        if (minValue == null || maxValue == null) {
            return;
        }
        if (this.getBigInteger().compareTo(minValue) < 0) {
            throw new NumberFormatException(String.format("Value is lower than allowed MIN_VALUE\n%s < %s", this.toString(null), minValue));
        }
        if (this.getBigInteger().compareTo(maxValue) > 0) {
            throw new NumberFormatException(String.format("Value is higher than allowed MAX_VALUE\n%s > %s", this.toString(null), maxValue));
        }
    }

    public abstract BigInteger getMinValue();

    public abstract BigInteger getMaxValue();

    public abstract void encode(DataOutput var1) throws IOException;

    public abstract BObject decode(DataInput var1) throws IOException;

    public abstract String encodeToString() throws IOException;

    public abstract BObject decodeFromString(String var1) throws IOException;

    public long longValue() {
        return this.bigInteger.longValue();
    }

    public long longValueExact() {
        return this.bigInteger.longValueExact();
    }

    public int hashCode() {
        return this.bigInteger.hashCode();
    }
}

