/*
 * Decompiled with CFR 0.152.
 */
package com.ismacontrolli.nE2Link;

import com.ismacontrolli.nE2Link.BNanoBaseComponent;
import com.ismacontrolli.nE2Link.BNe2DeviceExt;
import java.util.logging.Logger;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BLink;
import javax.baja.sys.BStruct;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="sourceComponentId", type="int", defaultValue="-1"), @NiagaraProperty(name="targetComponentId", type="int", defaultValue="-1"), @NiagaraProperty(name="sourceSlotName", type="String", defaultValue="\"\""), @NiagaraProperty(name="targetSlotName", type="String", defaultValue="\"\"")})
public class BNiagaraMoveLinkInfo
extends BStruct {
    public static final Property sourceComponentId = BNiagaraMoveLinkInfo.newProperty((int)0, (int)-1, null);
    public static final Property targetComponentId = BNiagaraMoveLinkInfo.newProperty((int)0, (int)-1, null);
    public static final Property sourceSlotName = BNiagaraMoveLinkInfo.newProperty((int)0, (String)"", null);
    public static final Property targetSlotName = BNiagaraMoveLinkInfo.newProperty((int)0, (String)"", null);
    public static final Type TYPE = Sys.loadType(BNiagaraMoveLinkInfo.class);
    public static Logger LOGGER = Logger.getLogger(TYPE.getTypeSpec().getModuleName());
    private BNanoBaseComponent sourceComponent;
    private BNanoBaseComponent targetComponent;

    public int getSourceComponentId() {
        return this.getInt(sourceComponentId);
    }

    public void setSourceComponentId(int v) {
        this.setInt(sourceComponentId, v, null);
    }

    public int getTargetComponentId() {
        return this.getInt(targetComponentId);
    }

    public void setTargetComponentId(int v) {
        this.setInt(targetComponentId, v, null);
    }

    public String getSourceSlotName() {
        return this.getString(sourceSlotName);
    }

    public void setSourceSlotName(String v) {
        this.setString(sourceSlotName, v, null);
    }

    public String getTargetSlotName() {
        return this.getString(targetSlotName);
    }

    public void setTargetSlotName(String v) {
        this.setString(targetSlotName, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BNiagaraMoveLinkInfo() {
    }

    public BNiagaraMoveLinkInfo(BLink link) {
        this((BNanoBaseComponent)link.getSourceComponent(), link.getSourceSlotName(), (BNanoBaseComponent)link.getTargetComponent(), link.getTargetSlotName());
    }

    public BNiagaraMoveLinkInfo(BNanoBaseComponent sourceComponent, String sourceSlotName, BNanoBaseComponent targetComponent, String targetSlotName) {
        if (sourceComponent != null) {
            this.setSourceComponentId(sourceComponent.getGlobalIndex());
        }
        if (targetComponent != null) {
            this.setTargetComponentId(targetComponent.getGlobalIndex());
        }
        if (sourceSlotName != null) {
            this.setSourceSlotName(sourceSlotName);
        }
        if (targetSlotName != null) {
            this.setTargetSlotName(targetSlotName);
        }
    }

    public BNanoBaseComponent getSourceComponent(BNe2DeviceExt controller) {
        return this.sourceComponent != null ? this.sourceComponent : (this.sourceComponent = controller.getComponentCache().get(this.getSourceComponentId()));
    }

    public BNanoBaseComponent getTargetComponent(BNe2DeviceExt controller) {
        return this.targetComponent != null ? this.targetComponent : (this.targetComponent = controller.getComponentCache().get(this.getTargetComponentId()));
    }

    public BLink createLinkInNiagara(BNe2DeviceExt controller) {
        Property targetSlot;
        BNanoBaseComponent targetComponent;
        Property sourceSlot;
        boolean dataComplete = true;
        BNanoBaseComponent sourceComponent = this.getSourceComponent(controller);
        if (sourceComponent == null) {
            dataComplete = false;
        }
        Property property = sourceSlot = sourceComponent != null ? sourceComponent.getProperty(this.getSourceSlotName()) : null;
        if (sourceSlot == null) {
            dataComplete = false;
        }
        if ((targetComponent = this.getTargetComponent(controller)) == null) {
            dataComplete = false;
        }
        Property property2 = targetSlot = targetComponent != null ? targetComponent.getProperty(this.getTargetSlotName()) : null;
        if (targetSlot == null) {
            dataComplete = false;
        }
        if (dataComplete) {
            return targetComponent.addLink(sourceComponent, (Slot)sourceSlot, (Slot)targetSlot);
        }
        LOGGER.severe(String.format("Failed to create link from component Id '%s', slot '%s' to componentId '%s', slot '%s'", this.getSourceComponentId(), this.getSourceSlotName(), this.getTargetComponentId(), this.getTargetSlotName()));
        return null;
    }
}

