/*
 * Decompiled with CFR 0.152.
 */
package com.ismacontrolli.nE2Link;

import com.ismacontrolli.nE2Link.BNanoBaseComponent;
import com.ismacontrolli.nE2Link.BNanoExtension;
import com.ismacontrolli.nE2Link.BNe2DeviceExt;
import com.ismacontrolli.nE2Link.BUnitMap;
import com.tridium.json.JSONArray;
import com.tridium.json.JSONException;
import com.tridium.json.JSONObject;
import com.tridium.json.JSONTokener;
import com.tridium.sys.Nre;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import javax.baja.data.BIDataValue;
import javax.baja.file.types.text.BJsonFile;
import javax.baja.naming.BOrd;
import javax.baja.naming.UnresolvedException;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.space.BComponentSpace;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusEnum;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.ModuleNotFoundException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;
import javax.baja.units.BUnitConversion;
import javax.baja.util.BFormat;

@NiagaraType
@NiagaraProperty(name="value", type="double", defaultValue="0.0d")
public class BNanoStatusNumeric
extends BStatusNumeric {
    public static final Property value = BNanoStatusNumeric.newProperty((int)0, (double)0.0, null);
    public static final Type TYPE = Sys.loadType(BNanoStatusNumeric.class);
    private static final BIcon icon = BIcon.std((String)"statusNumeric.png");
    public static final BFormat FORMAT_FOR_DISPLAY_UNIT = BFormat.make((String)"%getDisplayUnit%");
    public static final BFormat FORMAT_FOR_UNIT_ORDINAL = BFormat.make((String)"%parent.units.value.ordinal%");
    public static final String NANO_PROP_NAME_UNITS = "units";
    private static final String NANO_FORMAT_ATTRIB = "nano_attr_caption";
    private static final String FACET_NAME_DESIRED_UNITS = "desiredUnits";
    private static Map<String, DecimalFormat> valueFormatters = new HashMap<String, DecimalFormat>();
    private static Map<String, BFormat> outputFormatters = new HashMap<String, BFormat>();
    private static Map<BComponent, Map<Property, List<Property>>> dependentProperties = new HashMap<BComponent, Map<Property, List<Property>>>();

    public double getValue() {
        return this.getDouble(value);
    }

    public void setValue(double v) {
        this.setDouble(value, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BNanoStatusNumeric(double value, BStatus status) {
        super(value, status);
    }

    public BNanoStatusNumeric(double value) {
        super(value);
    }

    public BNanoStatusNumeric() {
    }

    private void leaseIfRequired(Context context) {
        BComponentSpace componentSpace;
        if (Sys.isStation()) {
            return;
        }
        BComponent parentComponent = this.getParentComponent();
        if (parentComponent instanceof BNanoBaseComponent && null != (componentSpace = parentComponent.getComponentSpace())) {
            boolean deepLease;
            boolean bl = deepLease = context != null && !context.getFacets().gets(NANO_FORMAT_ATTRIB, "").isEmpty();
            if (deepLease) {
                parentComponent.lease(2);
            } else {
                parentComponent.lease(1);
            }
        }
    }

    public String valueToString(Context context) {
        double value = this.getValue();
        if (this.getStatus() == BStatus.nullStatus) {
            return "null";
        }
        if (context == null || context.getFacet(NANO_FORMAT_ATTRIB) == null) {
            return BDouble.toString((double)value, (Context)context);
        }
        this.leaseIfRequired(context);
        String valueString = "";
        for (int retries = 0; retries < 2; ++retries) {
            BasicContext unitNoShowContext;
            BFormat outputFormat = this.getOutputFormatter(context);
            if (outputFormat == null) {
                return BDouble.toString((double)value, (Context)context);
            }
            BUnit unit = this.getUnit(context);
            BFacets facets = BFacets.make((String)"showUnits", (BIDataValue)BBoolean.FALSE);
            if (unit != null) {
                BUnitConversion unitConversion;
                BUnit desiredUnit;
                facets = BFacets.make((BFacets)facets, (BFacets)BFacets.make((String)NANO_PROP_NAME_UNITS, (BIDataValue)unit));
                int convert = Nre.unitConversion;
                convert = context.getFacets().geti("unitConversion", convert);
                if (convert != 0 && (desiredUnit = (unitConversion = BUnitConversion.make((int)convert)).getDesiredUnit(unit)) != unit) {
                    facets = BFacets.make((BFacets)facets, (BFacets)BFacets.make((String)FACET_NAME_DESIRED_UNITS, (BIDataValue)desiredUnit));
                }
            }
            if (!(valueString = outputFormat.format((Object)this, (Context)(unitNoShowContext = new BasicContext(context, facets)))).contains("%err:")) {
                return valueString;
            }
            this.removeOutputFormatter(context);
        }
        return valueString;
    }

    public String valueValueToString(Context context) throws Exception {
        double value = this.getValue();
        if (context == null) {
            return BDouble.toString((double)value, (Context)context);
        }
        if (this.getStatus() == BStatus.nullStatus) {
            return "null";
        }
        if (context.getFacet("fieldEditor").toString().equals("nE2Link:NanoStatusValueFE")) {
            BUnit unit = this.getUnit(context);
            BFacets facets = BFacets.make((String[])new String[]{NANO_PROP_NAME_UNITS, "showUnits"}, (BIDataValue[])new BIDataValue[]{unit, BBoolean.FALSE});
            context = new BasicContext(context, facets);
            String retVal = BDouble.toString((double)value, (Context)context);
            return retVal;
        }
        BOrd jsonFileOrd = null;
        if (this.getName().equals("objectType")) {
            switch (((BNanoBaseComponent)this.getParentComponent()).getOriginNameFromLibrary()) {
                case "Library.BACnet.AnalogCustomPoint": {
                    jsonFileOrd = BOrd.make((BOrd)BNe2DeviceExt.CUSTOM_POINTS_FILE_ORD, (String)"file:AnalogCustomPointsObjectTypes.json");
                    break;
                }
                case "Library.BACnet.BinaryCustomPoint": {
                    jsonFileOrd = BOrd.make((BOrd)BNe2DeviceExt.CUSTOM_POINTS_FILE_ORD, (String)"file:BinaryCustomPointsObjectTypes.json");
                    break;
                }
                case "Library.BACnet.StringCustomPoint": {
                    jsonFileOrd = BOrd.make((BOrd)BNe2DeviceExt.CUSTOM_POINTS_FILE_ORD, (String)"file:StringCustomPointsObjectTypes.json");
                }
            }
        } else if (this.getName().equals("property")) {
            switch (((BNanoBaseComponent)this.getParentComponent()).getOriginNameFromLibrary()) {
                case "Library.BACnet.AnalogCustomPoint": {
                    jsonFileOrd = BOrd.make((BOrd)BNe2DeviceExt.CUSTOM_POINTS_FILE_ORD, (String)"file:AnalogCustomPointProperties.json");
                    break;
                }
                case "Library.BACnet.BinaryCustomPoint": {
                    jsonFileOrd = BOrd.make((BOrd)BNe2DeviceExt.CUSTOM_POINTS_FILE_ORD, (String)"file:BinaryCustomPointProperties.json");
                    break;
                }
                case "Library.BACnet.StringCustomPoint": {
                    jsonFileOrd = BOrd.make((BOrd)BNe2DeviceExt.CUSTOM_POINTS_FILE_ORD, (String)"file:StringCustomPointProperties.json");
                }
            }
        }
        if (jsonFileOrd == null) {
            throw new Exception("Couldn't find file");
        }
        JSONObject rootObject = null;
        BComponent valueParent = this.getParentComponent();
        try {
            BJsonFile jsonFile = (BJsonFile)jsonFileOrd.get((BObject)valueParent);
            InputStream inputStream = jsonFile.getInputStream();
            InputStreamReader reader = new InputStreamReader(inputStream);
            JSONTokener tokener = new JSONTokener((Reader)reader);
            while (tokener.more() && rootObject == null) {
                Object o = tokener.nextValue();
                if (!(o instanceof JSONObject)) continue;
                rootObject = (JSONObject)o;
            }
            if (rootObject == null) {
                throw new Exception("Couldn't find file");
            }
            String modelName = rootObject.optString("name");
            JSONArray entities = rootObject.optJSONArray("entities");
            if (entities == null) {
                throw new Exception("Couldn't load file");
            }
            for (int i = 0; i < entities.length(); ++i) {
                JSONObject entity = entities.optJSONObject(i);
                if (entity == null) continue;
                int id = entity.getInt("id");
                String defaultDisplayName = entity.getString("displayName");
                if ((double)id != value) continue;
                return defaultDisplayName;
            }
        }
        catch (IOException | UnresolvedException | ModuleNotFoundException e) {
            BNe2DeviceExt.LOGGER.log(Level.SEVERE, "[BNumericJsonListFE]: Failed loading entities from " + jsonFileOrd, e);
        }
        catch (JSONException e) {
            BNe2DeviceExt.LOGGER.log(Level.SEVERE, "[BNumericJsonListFE]: Cannot parse JSON file. ", e);
        }
        return this.toString();
    }

    public String getDisplayUnit(Context context) {
        BUnit desiredUnit = (BUnit)context.getFacet(FACET_NAME_DESIRED_UNITS);
        BUnit unit = (BUnit)context.getFacet(NANO_PROP_NAME_UNITS);
        if (desiredUnit != null) {
            return !desiredUnit.isNull() ? desiredUnit.getSymbol(context) : "";
        }
        if (unit != null && !unit.isNull()) {
            return unit.getSymbol(context);
        }
        return "";
    }

    public BUnit getUnit(Context context) {
        BUnit niagaraUnit = null;
        BUnit nanoUnit = null;
        BUnit unit = null;
        if (context != null) {
            BFormat outputFormat;
            niagaraUnit = (BUnit)context.getFacet(NANO_PROP_NAME_UNITS);
            if (niagaraUnit != null && niagaraUnit.isNull()) {
                niagaraUnit = null;
            }
            if ((outputFormat = this.getOutputFormatter(context)) != null && outputFormat.getFormat().contains(FORMAT_FOR_DISPLAY_UNIT.getFormat())) {
                try {
                    BComponent parent = (BComponent)this.getParent();
                    Integer ordinal = ((BStatusEnum)parent.get(NANO_PROP_NAME_UNITS)).getValue().getOrdinal();
                    nanoUnit = BUnitMap.getNiagaraUnit(ordinal);
                }
                catch (Exception e) {
                    nanoUnit = null;
                }
            }
            unit = null != nanoUnit ? nanoUnit : niagaraUnit;
        }
        return unit != null ? unit : BUnit.NULL;
    }

    static String addForcedSign(boolean forceSign, double value) {
        return forceSign && value > 0.0 ? "+" : "";
    }

    static DecimalFormat getValueFormatter(int precision, boolean showSeparators, boolean useScientificNotation, Context cx) {
        String userLang = Context.getLanguageTag((Context)cx);
        String key = "" + precision + showSeparators + useScientificNotation + userLang;
        DecimalFormat formatter = valueFormatters.get(key);
        if (formatter == null) {
            StringBuilder pattern = new StringBuilder(16);
            if (useScientificNotation) {
                pattern.append("0.###############E0");
            } else {
                if (showSeparators) {
                    pattern.append("#,##0");
                } else {
                    pattern.append("#0");
                }
                if (precision > 0) {
                    pattern.append('.');
                    for (int i = 0; i < precision; ++i) {
                        pattern.append('0');
                    }
                }
            }
            formatter = !userLang.equals("") ? new DecimalFormat(pattern.toString(), DecimalFormatSymbols.getInstance(Locale.forLanguageTag(userLang))) : new DecimalFormat(pattern.toString());
            valueFormatters.put(key, formatter);
        }
        return formatter;
    }

    private void removeOutputFormatter(Context cx) {
        String nanoFormatString = cx != null ? cx.getFacets().gets(NANO_FORMAT_ATTRIB, null) : null;
        BComplex parent = this.getParent();
        if (nanoFormatString == null || nanoFormatString.isEmpty() || parent == null) {
            return;
        }
        String key = nanoFormatString + "@" + (parent instanceof BComponent ? ((BComponent)parent).getHandleOrd().toString() : parent.toDebugString());
        outputFormatters.remove(key);
    }

    public static void removeOutputFormatter(BComplex parent) {
        BNanoStatusNumeric.removeOutputFormatter(parent, null);
    }

    public static void removeOutputFormatter(BComplex parent, String nanoFormatString) {
        String parentKey = parent == null ? null : "@" + (parent instanceof BComponent ? ((BComponent)parent).getHandleOrd().toString() : parent.toDebugString());
        outputFormatters.entrySet().removeIf(entry -> !(parentKey != null && !((String)entry.getKey()).endsWith(parentKey) || nanoFormatString != null && !nanoFormatString.isEmpty() && !((String)entry.getKey()).startsWith(nanoFormatString + "@")));
    }

    private String makeOutputFormatKey(Context cx) {
        String nanoFormatString = cx != null ? cx.getFacets().gets(NANO_FORMAT_ATTRIB, null) : null;
        BComplex parent = this.getParent();
        if (nanoFormatString == null || nanoFormatString.isEmpty() || parent == null) {
            return null;
        }
        return nanoFormatString + "@" + (parent instanceof BComponent ? ((BComponent)parent).getHandleOrd().toString() : parent.toDebugString());
    }

    private BFormat getOutputFormatter(Context cx) {
        String key;
        BComplex parent = this.getParent();
        if (parent instanceof BNanoBaseComponent && ((BNanoBaseComponent)parent).getForceOutputFormatterInit()) {
            BNanoStatusNumeric.removeOutputFormatter(parent);
            ((BNanoBaseComponent)parent).setForceOutputFormatterInit(false);
        }
        if ((key = this.makeOutputFormatKey(cx)) == null) {
            return null;
        }
        String nanoFormatString = cx.getFacet(NANO_FORMAT_ATTRIB).toString();
        BFormat outputFormat = outputFormatters.get(key);
        if (outputFormat == null) {
            int processingIndex = 0;
            String outputFormatString = "";
            Property me = this.getPropertyInParent();
            while (processingIndex < nanoFormatString.length()) {
                int scriptStart = nanoFormatString.indexOf(123, processingIndex);
                if (scriptStart != -1) {
                    int scriptEnd = nanoFormatString.indexOf(125, processingIndex);
                    if (scriptEnd > -1) {
                        String niagaraScript;
                        String script = nanoFormatString.substring(scriptStart, scriptEnd + 1);
                        String regex = "\\{slot:(.*?)<(.*?)>(.*?)\\}";
                        String prefix = script.replaceAll(regex, "$1");
                        String slotName = script.replaceAll(regex, "$2");
                        String suffix = script.replaceAll(regex, "$3");
                        Property property = null;
                        switch (slotName) {
                            case "this": {
                                niagaraScript = prefix + "%valueValueToString%" + suffix;
                                break;
                            }
                            case "units": {
                                niagaraScript = prefix + "%getDisplayUnit%" + suffix;
                                property = null != parent ? parent.getProperty(slotName) : null;
                                break;
                            }
                            default: {
                                Property property2 = property = null != parent ? parent.getProperty(slotName) : null;
                                if (property == null && null != parent) {
                                    BNanoExtension[] extensions;
                                    for (BNanoExtension extension : extensions = (BNanoExtension[])((BComponent)parent).getChildren(BNanoExtension.class)) {
                                        Property extProperty = extension.getProperty(slotName);
                                        if (extProperty == null) continue;
                                        slotName = extension.getHostNameForExtensionSlot(extProperty);
                                        if (slotName != null) {
                                            property = parent.getProperty(slotName);
                                            break;
                                        }
                                        property = this.searchExtensionPropertyOnHost(parent, extProperty);
                                        if (property == null) break;
                                        slotName = property.getName();
                                        break;
                                    }
                                }
                                if (property != null && property.getTypeAccess() == 7) {
                                    niagaraScript = "parent." + slotName;
                                    if (property.getType().is(BStatusValue.TYPE)) {
                                        niagaraScript = niagaraScript + ".valueToString";
                                    }
                                } else {
                                    niagaraScript = "";
                                }
                                if (niagaraScript.isEmpty()) break;
                                niagaraScript = prefix + '%' + niagaraScript + '%' + suffix;
                            }
                        }
                        if (!niagaraScript.isEmpty() && !slotName.equals("this") && parent instanceof BNanoBaseComponent) {
                            ((BNanoBaseComponent)parent).addTriggerProperty(property.getName(), me.getName(), cx);
                        }
                        String literalsBeforeScript = nanoFormatString.substring(processingIndex, scriptStart);
                        outputFormatString = outputFormatString + literalsBeforeScript + niagaraScript;
                        processingIndex = scriptEnd + 1;
                        continue;
                    }
                    processingIndex = nanoFormatString.length();
                    continue;
                }
                outputFormatString = outputFormatString + nanoFormatString.substring(processingIndex);
                processingIndex = nanoFormatString.length();
            }
            outputFormat = BFormat.make((String)outputFormatString);
            outputFormatters.put(key, outputFormat);
        }
        return outputFormat;
    }

    public Property searchExtensionPropertyOnHost(BComplex parent, Property propInExtension) {
        Property[] properties;
        String propNameInExtension = propInExtension.getName();
        for (Property property : properties = parent.getDynamicPropertiesArray()) {
            if (!property.getName().matches("e\\d_" + propNameInExtension + ".*")) continue;
            return property;
        }
        return null;
    }
}

