/*
 * Decompiled with CFR 0.152.
 */
package com.ismacontrolli.nE2Link;

import com.ismacontrolli.nE2Link.BNanoBaseComponent;
import com.ismacontrolli.nE2Link.BNanoComponent;
import com.ismacontrolli.nE2Link.BNanoFolder;
import com.ismacontrolli.nE2Link.BNe2DeviceExt;
import com.tridium.file.types.bog.BBogSpace;
import javax.baja.agent.AgentList;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BNanoContainer
extends BNanoBaseComponent {
    public static final Type TYPE = Sys.loadType(BNanoContainer.class);
    private static final BIcon iconTree = BIcon.make((String)"module://nE2Link/rc/icons/x16/tree.svg");
    private static final String APPLICATION_MANAGER_VIEW = "nE2Link:ApplicationManager";
    private static final String DATA_POINT_MANAGER_VIEW = "nE2Link:DataPointManager";

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    public boolean isChildLegal(BComponent child) {
        return child.getType().is(TYPE) || child.getType().is(BNanoComponent.TYPE) || child.getType().is(BNanoFolder.TYPE);
    }

    @Override
    public boolean isParentLegal(BComponent parent) {
        if (!Sys.isStation() || parent != null && parent.getComponentSpace() instanceof BBogSpace) {
            return true;
        }
        boolean isRoot = !this.getIsLibraryComponent() && this.getOriginNameFromLibrary().equals("Framework.Core.Container") && this.getParentGlobalIndex() == -1;
        boolean isParentLegal = super.isParentLegal(parent) || isRoot && parent instanceof BNe2DeviceExt;
        return isParentLegal;
    }

    @Override
    public AgentList getAgents(Context cx) {
        AgentList agents = super.getAgents(cx);
        if (this.getIsLibraryComponent()) {
            agents.remove(APPLICATION_MANAGER_VIEW);
            agents.remove(DATA_POINT_MANAGER_VIEW);
        } else {
            String nanoName;
            switch (nanoName = this.getOriginNameFromLibrary()) {
                case "Framework.Core.ApplicationContainer": {
                    agents.toTop(APPLICATION_MANAGER_VIEW);
                    break;
                }
                case "Library.Core.Application": {
                    agents.remove(APPLICATION_MANAGER_VIEW);
                    break;
                }
                default: {
                    agents.remove(APPLICATION_MANAGER_VIEW);
                    agents.remove(DATA_POINT_MANAGER_VIEW);
                }
            }
        }
        return agents;
    }

    @Override
    public BIcon getIcon() {
        try {
            if (this.getName().equals("Root")) {
                return iconTree;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return super.getIcon();
    }
}

