/*
 * Decompiled with CFR 0.152.
 */
package com.ismacontrolli.nE2Link;

import com.ismacontrolli.nE2Link.BConfig;
import com.ismacontrolli.nE2Link.BNe2DeviceExt;
import com.ismacontrolli.nE2Link.notifications.BRefreshNotification;
import com.ismacontrolli.nE2Link.notifications.BRefreshTargets;
import com.ismacontrolli.nE2Link.utils.BConnectionStatus;
import com.ismacontrolli.nE2Link.utils.BSoftwareManager;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComplex;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="ipAddress", type="String", defaultValue="\"192.168.1.123\""), @NiagaraProperty(name="port", type="int", defaultValue="88"), @NiagaraProperty(name="status", type="BConnectionStatus", defaultValue="BConnectionStatus.DEFAULT", flags=3)})
public class BNanoConfigComms
extends BConfig {
    public static final Property ipAddress = BNanoConfigComms.newProperty((int)0, (String)"192.168.1.123", null);
    public static final Property port = BNanoConfigComms.newProperty((int)0, (int)88, null);
    public static final Property status = BNanoConfigComms.newProperty((int)3, (BValue)BConnectionStatus.DEFAULT, null);
    public static final Type TYPE = Sys.loadType(BNanoConfigComms.class);
    public static String USB_FIXED_IP = "169.254.1.123";
    BNe2DeviceExt ne2DeviceExt = null;

    public String getIpAddress() {
        return this.getString(ipAddress);
    }

    public void setIpAddress(String v) {
        this.setString(ipAddress, v, null);
    }

    public int getPort() {
        return this.getInt(port);
    }

    public void setPort(int v) {
        this.setInt(port, v, null);
    }

    public BConnectionStatus getStatus() {
        return (BConnectionStatus)this.get(status);
    }

    public void setStatus(BConnectionStatus v) {
        this.set(status, (BValue)v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        super.started();
        BSoftwareManager softwareManager = this.getNe2DeviceExt().getSoftwareManager();
        softwareManager.setIpAddress(this.getIpAddress());
        softwareManager.setIFnetPort(this.getPort());
    }

    public void changed(Property property, Context context) {
        if (!this.isRunning()) {
            return;
        }
        BSoftwareManager softwareManager = this.getNe2DeviceExt().getSoftwareManager();
        if (property.equals(ipAddress)) {
            softwareManager.setIpAddress(this.getIpAddress());
        }
        if (property.equals(port)) {
            softwareManager.setIFnetPort(this.getPort());
        }
        if (property.equals(status)) {
            BNe2DeviceExt ne2DeviceExt = this.getNe2DeviceExt();
            ne2DeviceExt.setIcon(ne2DeviceExt.getConnectionIcon());
            if (this.getStatus().getOrdinal() == 0 || this.getStatus().getOrdinal() == 1) {
                ne2DeviceExt.doStartAutoDisconnect(context);
            } else {
                ne2DeviceExt.doCancelAutoDisconnect(context);
            }
        }
        BRefreshNotification treeNodeRefresh = BRefreshNotification.make(BRefreshTargets.make(22), this.getNe2DeviceExt(), "from [BNanoConfigComms.changed]");
        treeNodeRefresh.raise(context);
        super.changed(property, context);
    }

    public String getAddress() {
        return this.getIpAddress() + ":" + this.getPort();
    }

    private BNe2DeviceExt getNe2DeviceExt() {
        if (this.ne2DeviceExt == null) {
            for (BComplex parent = this.getParent(); parent != null; parent = parent.getParent()) {
                if (!(parent instanceof BNe2DeviceExt)) continue;
                this.ne2DeviceExt = (BNe2DeviceExt)parent;
                break;
            }
        }
        return this.ne2DeviceExt;
    }
}

