/*
 * Decompiled with CFR 0.152.
 */
package com.ismacontrolli.nE2Link;

import com.ismacontrolli.nE2Link.BNanoBaseComponent;
import com.ismacontrolli.nE2Link.BNanoExtension;
import com.ismacontrolli.nE2Link.BNanoStatusNumeric;
import com.ismacontrolli.nE2Link.trends.BTrendObject;
import com.ismacontrolli.nE2Link.trends.BTrendObjectsList;
import com.ismacontrolli.nE2Link.trends.BTrendRemovingArgs;
import com.tridium.platform.BPlatformServiceContainer;
import com.tridium.platform.BSystemPlatformService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.baja.agent.AgentList;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.rpc.NiagaraRpc;
import javax.baja.rpc.Transport;
import javax.baja.rpc.TransportType;
import javax.baja.status.BStatusString;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperty(name="trendObjectsList", type="BTrendObjectsList", defaultValue="new BTrendObjectsList()", flags=4)
public class BNanoComponent
extends BNanoBaseComponent {
    public static final Property trendObjectsList = BNanoComponent.newProperty((int)4, (BValue)new BTrendObjectsList(), null);
    public static final Type TYPE = Sys.loadType(BNanoComponent.class);
    private static final String BACKUP_MANAGER_VIEW = "nE2Link:NanoBackupManager";
    private static final String SHARED_MANAGER_VIEW = "nE2Link:SharedManager";
    private static final String LOCAL_IO_MANAGER_VIEW = "nE2Link:LocalIoManager";
    private static final String BACNET_NETWORK_MANAGER_VIEW = "nE2Link:BacnetNetworkManager";
    private static final String MODBUS_NETWORK_MANAGER_VIEW = "nE2Link:ModbusNetworkManager";
    private static final String BACNET_POINT_MANAGER_VIEW = "nE2Link:BacnetPointManager";
    private static final String MODBUS_POINT_MANAGER_VIEW = "nE2Link:ModbusPointManager";
    private static final String MODBUS_DEVICE_MANAGER = "nE2Link:DeviceManager";
    private static final String CONFIG_DATA_SERVICE_MANAGER_VIEW = "nE2Link:ConfigurationDataServiceManager";
    private static final String ANALOG_BINARY_SCHEDULER_VIEW = "nE2Link:NanoScheduleView";
    private static final String CALENDAR_SCHEDULER_VIEW = "nE2Link:NanoCalendarView";
    private static final String SET_TIME_VIEW = "nE2Link:NanoSystemDateTimeEd";
    private static final String DATA_POINT_MANAGER = "nE2Link:DataPointManager";
    private static final String TREND_MANAGER_VIEW = "nE2Link:TrendsManager";
    private static final String BACNET_DEVICE_DISCOVER_VIEW = "nE2Link:DeviceDiscoverManager";
    private static final String TREND_MAINTENANCE_VIEW = "nE2Link:TrendsMaintenance";
    private static final String CUSTOM_TABLE_VIEW = "nE2Link:CustomTableView";
    private static final String PROP_NAME_MAC_ADDRESS = "mACAddress";
    private static final String PROP_NAME_IP_ADDRESS = "IPAddress";
    private static final String PROP_NAME_DHCP_ENABLED = "DHCPEnabled";
    private static final String PROP_NAME_DNS_SERVER_1 = "DNSServer1";
    private static final String PROP_NAME_DNS_SERVER_2 = "DNSServer2";
    private static final String PROP_NAME_SET_UTC_TIME = "SetUTCTime";

    public BTrendObjectsList getTrendObjectsList() {
        return (BTrendObjectsList)this.get(trendObjectsList);
    }

    public void setTrendObjectsList(BTrendObjectsList v) {
        this.set(trendObjectsList, (BValue)v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    public AgentList getAgents(Context cx) {
        AgentList agents = super.getAgents(cx);
        if (this.getIsLibraryComponent()) {
            agents.remove(BACKUP_MANAGER_VIEW);
            agents.remove(SHARED_MANAGER_VIEW);
            agents.remove(LOCAL_IO_MANAGER_VIEW);
            agents.remove(BACNET_NETWORK_MANAGER_VIEW);
            agents.remove(MODBUS_NETWORK_MANAGER_VIEW);
            agents.remove(BACNET_POINT_MANAGER_VIEW);
            agents.remove(MODBUS_POINT_MANAGER_VIEW);
            agents.remove(CONFIG_DATA_SERVICE_MANAGER_VIEW);
            agents.remove(ANALOG_BINARY_SCHEDULER_VIEW);
            agents.remove(CALENDAR_SCHEDULER_VIEW);
            agents.remove(SET_TIME_VIEW);
            agents.remove(MODBUS_DEVICE_MANAGER);
            agents.remove(DATA_POINT_MANAGER);
            agents.remove(TREND_MANAGER_VIEW);
            agents.remove(BACNET_DEVICE_DISCOVER_VIEW);
            agents.remove(CUSTOM_TABLE_VIEW);
            agents.remove(TREND_MAINTENANCE_VIEW);
        } else {
            String nanoName;
            switch (nanoName = this.getOriginNameFromLibrary()) {
                case "Framework.Core.SystemServices.BackupService": {
                    agents.toTop(BACKUP_MANAGER_VIEW);
                    agents.remove(SHARED_MANAGER_VIEW);
                    agents.remove(LOCAL_IO_MANAGER_VIEW);
                    agents.remove(BACNET_NETWORK_MANAGER_VIEW);
                    agents.remove(MODBUS_NETWORK_MANAGER_VIEW);
                    agents.remove(BACNET_POINT_MANAGER_VIEW);
                    agents.remove(MODBUS_POINT_MANAGER_VIEW);
                    agents.remove(CONFIG_DATA_SERVICE_MANAGER_VIEW);
                    agents.remove(ANALOG_BINARY_SCHEDULER_VIEW);
                    agents.remove(CALENDAR_SCHEDULER_VIEW);
                    agents.remove(SET_TIME_VIEW);
                    agents.remove(MODBUS_DEVICE_MANAGER);
                    agents.remove(DATA_POINT_MANAGER);
                    agents.remove(TREND_MANAGER_VIEW);
                    agents.remove(BACNET_DEVICE_DISCOVER_VIEW);
                    agents.remove(CUSTOM_TABLE_VIEW);
                    agents.remove(TREND_MAINTENANCE_VIEW);
                    break;
                }
                case "Library.Core.Equipment": {
                    agents.remove(SHARED_MANAGER_VIEW);
                    agents.remove(BACNET_NETWORK_MANAGER_VIEW);
                    agents.remove(MODBUS_NETWORK_MANAGER_VIEW);
                    agents.remove(CONFIG_DATA_SERVICE_MANAGER_VIEW);
                    agents.remove(BACNET_POINT_MANAGER_VIEW);
                    agents.remove(MODBUS_POINT_MANAGER_VIEW);
                    agents.remove(BACKUP_MANAGER_VIEW);
                    agents.remove(ANALOG_BINARY_SCHEDULER_VIEW);
                    agents.remove(CALENDAR_SCHEDULER_VIEW);
                    agents.remove(SET_TIME_VIEW);
                    agents.remove(MODBUS_DEVICE_MANAGER);
                    agents.remove(LOCAL_IO_MANAGER_VIEW);
                    agents.remove(TREND_MANAGER_VIEW);
                    agents.remove(BACNET_DEVICE_DISCOVER_VIEW);
                    agents.remove(CUSTOM_TABLE_VIEW);
                    agents.remove(TREND_MAINTENANCE_VIEW);
                    break;
                }
                case "Library.IO.Device": {
                    agents.toTop(LOCAL_IO_MANAGER_VIEW);
                    agents.remove(SHARED_MANAGER_VIEW);
                    agents.remove(BACNET_NETWORK_MANAGER_VIEW);
                    agents.remove(MODBUS_NETWORK_MANAGER_VIEW);
                    agents.remove(CONFIG_DATA_SERVICE_MANAGER_VIEW);
                    agents.remove(BACNET_POINT_MANAGER_VIEW);
                    agents.remove(MODBUS_POINT_MANAGER_VIEW);
                    agents.remove(BACKUP_MANAGER_VIEW);
                    agents.remove(ANALOG_BINARY_SCHEDULER_VIEW);
                    agents.remove(CALENDAR_SCHEDULER_VIEW);
                    agents.remove(SET_TIME_VIEW);
                    agents.remove(MODBUS_DEVICE_MANAGER);
                    agents.remove(DATA_POINT_MANAGER);
                    agents.remove(TREND_MANAGER_VIEW);
                    agents.remove(BACNET_DEVICE_DISCOVER_VIEW);
                    agents.remove(CUSTOM_TABLE_VIEW);
                    agents.remove(TREND_MAINTENANCE_VIEW);
                    break;
                }
                case "Library.Core.Network": {
                    agents.toTop(MODBUS_DEVICE_MANAGER);
                    agents.remove(SHARED_MANAGER_VIEW);
                    agents.remove(BACNET_NETWORK_MANAGER_VIEW);
                    agents.remove(MODBUS_NETWORK_MANAGER_VIEW);
                    agents.remove(CONFIG_DATA_SERVICE_MANAGER_VIEW);
                    agents.remove(BACNET_POINT_MANAGER_VIEW);
                    agents.remove(MODBUS_POINT_MANAGER_VIEW);
                    agents.remove(BACKUP_MANAGER_VIEW);
                    agents.remove(ANALOG_BINARY_SCHEDULER_VIEW);
                    agents.remove(CALENDAR_SCHEDULER_VIEW);
                    agents.remove(SET_TIME_VIEW);
                    agents.remove(LOCAL_IO_MANAGER_VIEW);
                    agents.remove(DATA_POINT_MANAGER);
                    agents.remove(TREND_MANAGER_VIEW);
                    agents.remove(CUSTOM_TABLE_VIEW);
                    agents.remove(TREND_MAINTENANCE_VIEW);
                    if (this.getParent() instanceof BNanoComponent) {
                        if (!((BNanoComponent)this.getParent()).getNanoName().equals("BACnet")) {
                            agents.remove(BACNET_DEVICE_DISCOVER_VIEW);
                        } else {
                            agents.toTop(BACNET_DEVICE_DISCOVER_VIEW);
                        }
                        if (((BNanoComponent)this.getParent()).getNanoName().equals("Modbus")) break;
                        agents.remove(MODBUS_DEVICE_MANAGER);
                        break;
                    }
                    agents.remove(BACNET_DEVICE_DISCOVER_VIEW);
                    agents.remove(MODBUS_DEVICE_MANAGER);
                    break;
                }
                case "Library.BACnet.Device": {
                    agents.toTop(BACNET_POINT_MANAGER_VIEW);
                    agents.remove(SHARED_MANAGER_VIEW);
                    agents.remove(BACNET_NETWORK_MANAGER_VIEW);
                    agents.remove(MODBUS_NETWORK_MANAGER_VIEW);
                    agents.remove(CONFIG_DATA_SERVICE_MANAGER_VIEW);
                    agents.remove(LOCAL_IO_MANAGER_VIEW);
                    agents.remove(BACKUP_MANAGER_VIEW);
                    agents.remove(MODBUS_POINT_MANAGER_VIEW);
                    agents.remove(ANALOG_BINARY_SCHEDULER_VIEW);
                    agents.remove(CALENDAR_SCHEDULER_VIEW);
                    agents.remove(SET_TIME_VIEW);
                    agents.remove(MODBUS_DEVICE_MANAGER);
                    agents.remove(DATA_POINT_MANAGER);
                    agents.remove(BACNET_DEVICE_DISCOVER_VIEW);
                    agents.remove(CUSTOM_TABLE_VIEW);
                    agents.remove(TREND_MAINTENANCE_VIEW);
                    break;
                }
                case "Library.BACnet.Bacnet": {
                    agents.toTop(BACNET_NETWORK_MANAGER_VIEW);
                    agents.remove(SHARED_MANAGER_VIEW);
                    agents.remove(LOCAL_IO_MANAGER_VIEW);
                    agents.remove(MODBUS_NETWORK_MANAGER_VIEW);
                    agents.remove(CONFIG_DATA_SERVICE_MANAGER_VIEW);
                    agents.remove(BACNET_POINT_MANAGER_VIEW);
                    agents.remove(MODBUS_POINT_MANAGER_VIEW);
                    agents.remove(BACKUP_MANAGER_VIEW);
                    agents.remove(ANALOG_BINARY_SCHEDULER_VIEW);
                    agents.remove(CALENDAR_SCHEDULER_VIEW);
                    agents.remove(SET_TIME_VIEW);
                    agents.remove(MODBUS_DEVICE_MANAGER);
                    agents.remove(DATA_POINT_MANAGER);
                    agents.remove(BACNET_DEVICE_DISCOVER_VIEW);
                    agents.remove(CUSTOM_TABLE_VIEW);
                    agents.remove(TREND_MAINTENANCE_VIEW);
                    break;
                }
                case "Library.Modbus.Device": {
                    agents.toTop(MODBUS_POINT_MANAGER_VIEW);
                    agents.remove(SHARED_MANAGER_VIEW);
                    agents.remove(BACNET_NETWORK_MANAGER_VIEW);
                    agents.remove(MODBUS_NETWORK_MANAGER_VIEW);
                    agents.remove(CONFIG_DATA_SERVICE_MANAGER_VIEW);
                    agents.remove(LOCAL_IO_MANAGER_VIEW);
                    agents.remove(BACKUP_MANAGER_VIEW);
                    agents.remove(BACNET_POINT_MANAGER_VIEW);
                    agents.remove(ANALOG_BINARY_SCHEDULER_VIEW);
                    agents.remove(CALENDAR_SCHEDULER_VIEW);
                    agents.remove(SET_TIME_VIEW);
                    agents.remove(MODBUS_DEVICE_MANAGER);
                    agents.remove(DATA_POINT_MANAGER);
                    agents.remove(TREND_MANAGER_VIEW);
                    agents.remove(BACNET_DEVICE_DISCOVER_VIEW);
                    agents.remove(CUSTOM_TABLE_VIEW);
                    agents.remove(TREND_MAINTENANCE_VIEW);
                    break;
                }
                case "Library.Modbus.Modbus": {
                    agents.toTop(MODBUS_NETWORK_MANAGER_VIEW);
                    agents.remove(SHARED_MANAGER_VIEW);
                    agents.remove(LOCAL_IO_MANAGER_VIEW);
                    agents.remove(BACNET_NETWORK_MANAGER_VIEW);
                    agents.remove(CONFIG_DATA_SERVICE_MANAGER_VIEW);
                    agents.remove(BACKUP_MANAGER_VIEW);
                    agents.remove(ANALOG_BINARY_SCHEDULER_VIEW);
                    agents.remove(CALENDAR_SCHEDULER_VIEW);
                    agents.remove(SET_TIME_VIEW);
                    agents.remove(BACNET_POINT_MANAGER_VIEW);
                    agents.remove(MODBUS_POINT_MANAGER_VIEW);
                    agents.remove(MODBUS_DEVICE_MANAGER);
                    agents.remove(DATA_POINT_MANAGER);
                    agents.remove(TREND_MANAGER_VIEW);
                    agents.remove(BACNET_DEVICE_DISCOVER_VIEW);
                    agents.remove(CUSTOM_TABLE_VIEW);
                    agents.remove(TREND_MAINTENANCE_VIEW);
                    break;
                }
                case "Library.Schedules.AnalogSchedule": 
                case "Library.Schedules.BinarySchedule": 
                case "Library.Schedules.MultistateSchedule": {
                    agents.toTop(ANALOG_BINARY_SCHEDULER_VIEW);
                    agents.remove(CONFIG_DATA_SERVICE_MANAGER_VIEW);
                    agents.remove(BACKUP_MANAGER_VIEW);
                    agents.remove(SHARED_MANAGER_VIEW);
                    agents.remove(LOCAL_IO_MANAGER_VIEW);
                    agents.remove(BACNET_NETWORK_MANAGER_VIEW);
                    agents.remove(MODBUS_NETWORK_MANAGER_VIEW);
                    agents.remove(BACNET_POINT_MANAGER_VIEW);
                    agents.remove(MODBUS_POINT_MANAGER_VIEW);
                    agents.remove(CALENDAR_SCHEDULER_VIEW);
                    agents.remove(SET_TIME_VIEW);
                    agents.remove(MODBUS_DEVICE_MANAGER);
                    agents.remove(DATA_POINT_MANAGER);
                    agents.remove(TREND_MANAGER_VIEW);
                    agents.remove(BACNET_DEVICE_DISCOVER_VIEW);
                    agents.remove(CUSTOM_TABLE_VIEW);
                    agents.remove(TREND_MAINTENANCE_VIEW);
                    break;
                }
                case "Library.Schedules.Calendar": {
                    agents.toTop(CALENDAR_SCHEDULER_VIEW);
                    agents.remove(CONFIG_DATA_SERVICE_MANAGER_VIEW);
                    agents.remove(BACKUP_MANAGER_VIEW);
                    agents.remove(SHARED_MANAGER_VIEW);
                    agents.remove(LOCAL_IO_MANAGER_VIEW);
                    agents.remove(BACNET_NETWORK_MANAGER_VIEW);
                    agents.remove(MODBUS_NETWORK_MANAGER_VIEW);
                    agents.remove(BACNET_POINT_MANAGER_VIEW);
                    agents.remove(MODBUS_POINT_MANAGER_VIEW);
                    agents.remove(ANALOG_BINARY_SCHEDULER_VIEW);
                    agents.remove(SET_TIME_VIEW);
                    agents.remove(MODBUS_DEVICE_MANAGER);
                    agents.remove(DATA_POINT_MANAGER);
                    agents.remove(TREND_MANAGER_VIEW);
                    agents.remove(BACNET_DEVICE_DISCOVER_VIEW);
                    agents.remove(CUSTOM_TABLE_VIEW);
                    agents.remove(TREND_MAINTENANCE_VIEW);
                    break;
                }
                case "Framework.Core.Schema.PlatformTime": {
                    agents.toTop(SET_TIME_VIEW);
                    agents.remove(CONFIG_DATA_SERVICE_MANAGER_VIEW);
                    agents.remove(CALENDAR_SCHEDULER_VIEW);
                    agents.remove(BACKUP_MANAGER_VIEW);
                    agents.remove(SHARED_MANAGER_VIEW);
                    agents.remove(LOCAL_IO_MANAGER_VIEW);
                    agents.remove(BACNET_NETWORK_MANAGER_VIEW);
                    agents.remove(MODBUS_NETWORK_MANAGER_VIEW);
                    agents.remove(MODBUS_POINT_MANAGER_VIEW);
                    agents.remove(BACNET_POINT_MANAGER_VIEW);
                    agents.remove(ANALOG_BINARY_SCHEDULER_VIEW);
                    agents.remove(MODBUS_DEVICE_MANAGER);
                    agents.remove(DATA_POINT_MANAGER);
                    agents.remove(TREND_MANAGER_VIEW);
                    agents.remove(BACNET_DEVICE_DISCOVER_VIEW);
                    agents.remove(CUSTOM_TABLE_VIEW);
                    agents.remove(TREND_MAINTENANCE_VIEW);
                    break;
                }
                case "Framework.ConfigurationData.ConfigurationDataService": {
                    agents.toTop(CONFIG_DATA_SERVICE_MANAGER_VIEW);
                    agents.remove(CALENDAR_SCHEDULER_VIEW);
                    agents.remove(BACKUP_MANAGER_VIEW);
                    agents.remove(SHARED_MANAGER_VIEW);
                    agents.remove(LOCAL_IO_MANAGER_VIEW);
                    agents.remove(BACNET_NETWORK_MANAGER_VIEW);
                    agents.remove(MODBUS_NETWORK_MANAGER_VIEW);
                    agents.remove(MODBUS_POINT_MANAGER_VIEW);
                    agents.remove(BACNET_POINT_MANAGER_VIEW);
                    agents.remove(MODBUS_DEVICE_MANAGER);
                    agents.remove(DATA_POINT_MANAGER);
                    agents.remove(ANALOG_BINARY_SCHEDULER_VIEW);
                    agents.remove(SET_TIME_VIEW);
                    agents.remove(TREND_MANAGER_VIEW);
                    agents.remove(BACNET_DEVICE_DISCOVER_VIEW);
                    agents.remove(CUSTOM_TABLE_VIEW);
                    agents.remove(TREND_MAINTENANCE_VIEW);
                    break;
                }
                case "Library.Trends.Trends": {
                    agents.toTop(f -> f.getDisplayName(null).contains("Trend"));
                    agents.remove(BACKUP_MANAGER_VIEW);
                    agents.remove(SHARED_MANAGER_VIEW);
                    agents.remove(LOCAL_IO_MANAGER_VIEW);
                    agents.remove(BACNET_NETWORK_MANAGER_VIEW);
                    agents.remove(MODBUS_NETWORK_MANAGER_VIEW);
                    agents.remove(BACNET_POINT_MANAGER_VIEW);
                    agents.remove(MODBUS_POINT_MANAGER_VIEW);
                    agents.remove(CONFIG_DATA_SERVICE_MANAGER_VIEW);
                    agents.remove(ANALOG_BINARY_SCHEDULER_VIEW);
                    agents.remove(CALENDAR_SCHEDULER_VIEW);
                    agents.remove(SET_TIME_VIEW);
                    agents.remove(MODBUS_DEVICE_MANAGER);
                    agents.remove(DATA_POINT_MANAGER);
                    agents.remove(BACNET_DEVICE_DISCOVER_VIEW);
                    agents.remove(CUSTOM_TABLE_VIEW);
                    break;
                }
                default: {
                    agents.remove(BACKUP_MANAGER_VIEW);
                    agents.remove(SHARED_MANAGER_VIEW);
                    agents.remove(LOCAL_IO_MANAGER_VIEW);
                    agents.remove(BACNET_NETWORK_MANAGER_VIEW);
                    agents.remove(MODBUS_NETWORK_MANAGER_VIEW);
                    agents.remove(BACNET_POINT_MANAGER_VIEW);
                    agents.remove(MODBUS_POINT_MANAGER_VIEW);
                    agents.remove(CONFIG_DATA_SERVICE_MANAGER_VIEW);
                    agents.remove(ANALOG_BINARY_SCHEDULER_VIEW);
                    agents.remove(CALENDAR_SCHEDULER_VIEW);
                    agents.remove(SET_TIME_VIEW);
                    agents.remove(MODBUS_DEVICE_MANAGER);
                    agents.remove(DATA_POINT_MANAGER);
                    agents.remove(TREND_MANAGER_VIEW);
                    agents.remove(BACNET_DEVICE_DISCOVER_VIEW);
                    agents.remove(CUSTOM_TABLE_VIEW);
                    agents.remove(TREND_MAINTENANCE_VIEW);
                }
            }
        }
        return agents;
    }

    @NiagaraRpc(permissions="unrestricted", transports={@Transport(type=TransportType.box), @Transport(type=TransportType.fox), @Transport(type=TransportType.web)})
    public boolean isStationOnMac(Context context) {
        BPlatformServiceContainer platformServiceContainer = (BPlatformServiceContainer)Sys.getService((Type)BPlatformServiceContainer.TYPE);
        if (platformServiceContainer != null) {
            BSystemPlatformService platformService = ((BSystemPlatformService[])platformServiceContainer.getChildren(BSystemPlatformService.class))[0];
            String product = platformService.getProduct();
            return product.contains("MAC");
        }
        return false;
    }

    @NiagaraRpc(permissions="unrestricted", transports={@Transport(type=TransportType.box), @Transport(type=TransportType.fox), @Transport(type=TransportType.web)})
    public BTrendObjectsList getAllRecords(Context context) {
        System.out.println("NanoTrendsService. getAllRecords");
        this.getTrendObjectsList().clearAll();
        ArrayList<BNanoExtension> trendExtensions = this.getNe2DeviceExt().doGetNanoComponentWithTrendsExtensions();
        for (BNanoExtension trendExtension : trendExtensions) {
            BNanoBaseComponent parent = (BNanoBaseComponent)trendExtension.getParent();
            BNanoExtension bacnetTrend = (BNanoExtension)((Object)Arrays.stream(parent.getChildren(BNanoExtension.class)).filter(child -> child.getNanoName().contains("BacnetTrend")).collect(Collectors.toList()).get(0));
            int extensionId = trendExtension.getExtensionId();
            int bacnetTrendExtensionId = bacnetTrend.getExtensionId();
            String trendDisplayName = ((BStatusString)parent.get("e" + extensionId + "_trendName")).getValue();
            int bacnetId = (int)((BNanoStatusNumeric)parent.get("e" + bacnetTrendExtensionId + "_objectId")).getValue();
            trendDisplayName = trendDisplayName + "_BacnetId:" + bacnetId;
            BTrendObject obj = new BTrendObject();
            obj.setTrendName(trendDisplayName);
            obj.setGuid(((BStatusString)parent.get("e" + extensionId + "_guid")).getValue());
            try {
                this.getTrendObjectsList().addTrendObject(obj);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.getTrendObjectsList();
    }

    @NiagaraRpc(permissions="unrestricted", transports={@Transport(type=TransportType.box), @Transport(type=TransportType.fox), @Transport(type=TransportType.web)})
    public Boolean clearOldRecords(List<?> jsListOfOrdsAndDate, Context context) throws Exception {
        System.out.println("NanoTrendsService. clearOldRecords");
        if (!this.isConnected()) {
            return false;
        }
        long beforeDateAsLong = (Long)((HashMap)jsListOfOrdsAndDate.get(1)).get("$millis");
        this.clearTrends((ArrayList)jsListOfOrdsAndDate.get(0), beforeDateAsLong);
        return true;
    }

    @NiagaraRpc(permissions="unrestricted", transports={@Transport(type=TransportType.box), @Transport(type=TransportType.fox), @Transport(type=TransportType.web)})
    public Boolean clearAllRecords(List<?> jsListOfOrds, Context context) throws Exception {
        System.out.println("NanoTrendsService. clearAllRecords");
        if (!this.isConnected()) {
            return false;
        }
        this.clearTrends((ArrayList)jsListOfOrds.get(0), -1L);
        return true;
    }

    @Override
    public String getDisplayName(Slot slot, Context cx) {
        switch (slot.getName()) {
            case "mACAddress": {
                return LEX.get("SlotName.MacAddress", "MAC Address");
            }
            case "IPAddress": {
                return LEX.get("SlotName.IPAddress", "IP Address");
            }
            case "DHCPEnabled": {
                return LEX.get("SlotName.DHCPEnabled", "DHCP Enabled");
            }
            case "DNSServer1": {
                return LEX.get("SlotName.DNSServer1", "DNS Server 1");
            }
            case "DNSServer2": {
                return LEX.get("SlotName.DNSServer2", "DNS Server 2");
            }
            case "SetUTCTime": {
                return LEX.get("SlotName.SetUTCTime", "Set UTC Time");
            }
        }
        String res = SlotPath.unescape((String)slot.getName()).replaceAll("(?<=[a-z])([A-Z])", " $1");
        res = res.replaceAll("e\\d+_", "");
        return res.substring(0, 1).toUpperCase() + res.substring(1);
    }

    private boolean isConnected() {
        return this._ne2DeviceExt.isConnected() == BBoolean.TRUE;
    }

    private void clearTrends(ArrayList<?> jsListOfOrds, long beforeDateAsLong) {
        jsListOfOrds.forEach(map -> {
            String value = (String)((HashMap)map).get("$ord");
            BTrendObject trendObject = (BTrendObject)BOrd.make((String)value).resolve((BObject)this).get();
            BTrendRemovingArgs trendRemovingArgs = new BTrendRemovingArgs();
            trendRemovingArgs.setGuid("" + trendObject.getGuid());
            trendRemovingArgs.setStartedStampRemoving(beforeDateAsLong);
            this.getNe2DeviceExt().handleNanoTrendRemoving(trendRemovingArgs);
        });
    }
}

