/*
 * Decompiled with CFR 0.152.
 */
package com.ismacontrolli.nE2Link;

import com.ismacontrolli.nE2Link.BLibraries;
import com.ismacontrolli.nE2Link.BMarkerEnum;
import com.ismacontrolli.nE2Link.BNanoBaseComponent;
import com.ismacontrolli.nE2Link.BNanoBaseNamed;
import java.util.ArrayList;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="marker", type="BMarkerEnum", defaultValue="BMarkerEnum.DEFAULT", flags=1), @NiagaraProperty(name="id", type="int", defaultValue="-1", flags=1), @NiagaraProperty(name="version", type="String", defaultValue="", flags=1)})
public class BLibrary
extends BNanoBaseNamed {
    public static final Property marker = BLibrary.newProperty((int)1, (BValue)BMarkerEnum.DEFAULT, null);
    public static final Property id = BLibrary.newProperty((int)1, (int)-1, null);
    public static final Property version = BLibrary.newProperty((int)1, (String)"", null);
    public static final Type TYPE = Sys.loadType(BLibrary.class);

    public BMarkerEnum getMarker() {
        return (BMarkerEnum)this.get(marker);
    }

    public void setMarker(BMarkerEnum v) {
        this.set(marker, (BValue)v, null);
    }

    public int getId() {
        return this.getInt(id);
    }

    public void setId(int v) {
        this.setInt(id, v, null);
    }

    public String getVersion() {
        return this.getString(version);
    }

    public void setVersion(String v) {
        this.setString(version, v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public BLibrary() {
    }

    public BLibrary(int id, String nanoName, String version) {
        this(BMarkerEnum.AssemblyInfoData, id, nanoName, version);
        this.setId(id);
        this.setNanoName(nanoName);
        this.setVersion(version);
    }

    public BLibrary(BMarkerEnum marker, int id, String nanoName, String version) {
        this();
        this.setMarker(marker);
        this.setId(id);
        this.setNanoName(nanoName);
        this.setVersion(version);
    }

    @Override
    public String toString(Context context) {
        return this.getId() + ": " + this.getNanoName() + " (" + this.getVersion() + ")";
    }

    public void added(Property property, Context context) {
        BComponent parent;
        if (property.getType().is(BNanoBaseComponent.TYPE) && this.isMounted() && (parent = (BComponent)this.getParent()) != null && parent.getType().is(BLibraries.TYPE)) {
            ((BLibraries)parent).getLibraryComponentsCache().put((BNanoBaseComponent)this.get(property));
        }
        super.added(property, context);
    }

    public Property[] addComponents(BNanoBaseComponent[] components, boolean replaceIfPresent) {
        ArrayList<Property> properties = new ArrayList<Property>();
        for (int i = 0; i < components.length; ++i) {
            Property property = this.addComponent(components[i], replaceIfPresent);
            if (property == null) continue;
            properties.add(property);
        }
        return properties.toArray(new Property[0]);
    }

    public Property addComponent(BNanoBaseComponent component, boolean replaceIfPresent) {
        component.setAssemblyInfo(this.getNanoName() + ", Version=" + this.getVersion());
        Property compProperty = this.getProperty(component.getDefaultPropertyName());
        if (compProperty != null && replaceIfPresent) {
            this.remove(compProperty);
            LOGGER.info("Reloaded component '" + (Object)((Object)component) + "'");
            return this.add(component.getDefaultPropertyName(), (BValue)component, component.isInvisibleInLibrary(this.getVersion()) ? 5 : 1);
        }
        if (compProperty != null) {
            LOGGER.info("Skipped adding component '" + (Object)((Object)component) + "'. Already present.");
            return null;
        }
        if (!component.isInvisibleInLibrary(this.getVersion())) {
            LOGGER.info("Added new component '" + (Object)((Object)component) + "'");
        }
        return this.add(component.getDefaultPropertyName(), (BValue)component, component.isInvisibleInLibrary(this.getVersion()) ? 5 : 1);
    }

    public boolean isInvisibleInTree() {
        return this.getNanoName().equals("Framework.Core") || this.getNanoName().equals("Framework.SDK");
    }

    @Override
    public boolean isChildLegal(BComponent child) {
        if (!this.isRunning()) {
            return true;
        }
        return child.getType().is(BNanoBaseComponent.TYPE) && ((BNanoBaseComponent)child).getIsLibraryComponent();
    }

    @Override
    public boolean isParentLegal(BComponent parent) {
        return parent instanceof BLibraries;
    }
}

