/*
 * Decompiled with CFR 0.152.
 */
package com.ismacontrolli.nE2Link;

import com.ismacontrolli.nE2Link.BLibrary;
import com.ismacontrolli.nE2Link.BNanoBase;
import com.ismacontrolli.nE2Link.BNanoBaseComponent;
import com.ismacontrolli.nE2Link.BNanoExtension;
import com.ismacontrolli.nE2Link.BNanoFolder;
import com.ismacontrolli.nE2Link.BNe2DeviceExt;
import com.tridium.file.types.bog.BBogSpace;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.space.BComponentSpace;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraActions(value={@NiagaraAction(name="getComponentByTypeId", parameterType="BInteger", defaultValue="BInteger.DEFAULT", returnType="BNanoBaseComponent", flags=4), @NiagaraAction(name="getComponentByTypeName", parameterType="BString", defaultValue="BString.DEFAULT", returnType="BNanoBaseComponent", flags=4), @NiagaraAction(name="getValidExtensions", parameterType="BNanoBaseComponent", defaultValue="new BNanoFolder()", returnType="BEnumRange", flags=4)})
public class BLibraries
extends BNanoBase {
    public static final Action getComponentByTypeId = BLibraries.newAction((int)4, (BValue)BInteger.DEFAULT, null);
    public static final Action getComponentByTypeName = BLibraries.newAction((int)4, (BValue)BString.DEFAULT, null);
    public static final Action getValidExtensions = BLibraries.newAction((int)4, (BValue)new BNanoFolder(), null);
    public static final Type TYPE = Sys.loadType(BLibraries.class);
    private LibraryComponentCache libraryComponentsCache = new LibraryComponentCache();
    private static final BIcon icon = BIcon.make((String)"module://nE2Link/rc/icons/x16/Libraries.svg");

    public BNanoBaseComponent getComponentByTypeId(BInteger parameter) {
        return (BNanoBaseComponent)this.invoke(getComponentByTypeId, (BValue)parameter, null);
    }

    public BNanoBaseComponent getComponentByTypeName(BString parameter) {
        return (BNanoBaseComponent)this.invoke(getComponentByTypeName, (BValue)parameter, null);
    }

    public BEnumRange getValidExtensions(BNanoBaseComponent parameter) {
        return (BEnumRange)this.invoke(getValidExtensions, (BValue)parameter, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public LibraryComponentCache getLibraryComponentsCache() {
        return this.libraryComponentsCache;
    }

    @Override
    public void started() throws Exception {
        this.getLibraryComponentsCache().init();
    }

    public void checkRemove(Property property, Context context) {
        if (this.checkContext(context)) {
            return;
        }
        BValue val = this.get(property);
        if (val.getType().is(BLibrary.TYPE)) {
            throw new LocalizableRuntimeException(BLibraries.LEX.module.getModuleName(), "DELETE_FORBIDDEN");
        }
        super.checkRemove(property, context);
    }

    public void added(Property property, Context context) {
        if (property.getType().is(BLibrary.TYPE)) {
            BNanoBaseComponent[] components;
            BLibrary lib = (BLibrary)this.get(property);
            for (BNanoBaseComponent component : components = (BNanoBaseComponent[])lib.getChildren(BNanoBaseComponent.class)) {
                this.libraryComponentsCache.put(component);
            }
        }
        super.added(property, context);
    }

    public Property[] addLibraries(BLibrary[] libraries, boolean replaceIfPresent) {
        ArrayList<Property> properties = new ArrayList<Property>();
        for (int i = 0; i < libraries.length; ++i) {
            Property property = this.addLibrary(libraries[i], replaceIfPresent);
            if (property == null) continue;
            properties.add(property);
        }
        return properties.toArray(new Property[0]);
    }

    public Property addLibrary(BLibrary library, boolean replaceIfPresent) {
        Property libProperty = this.getProperty(library.getDefaultPropertyName());
        if (libProperty != null && replaceIfPresent) {
            this.remove(libProperty);
            LOGGER.info("Reloaded library '" + (Object)((Object)library) + "'");
            return this.add(library.getDefaultPropertyName(), (BValue)library, !library.isInvisibleInTree() ? 1 : 5);
        }
        if (libProperty != null) {
            LOGGER.info("Skipped adding library '" + (Object)((Object)library) + "'. Already present.");
            return null;
        }
        LOGGER.info("Added new library '" + (Object)((Object)library) + "'");
        return this.add(library.getDefaultPropertyName(), (BValue)library, !library.isInvisibleInTree() ? 1 : 5);
    }

    public String getDisplayName(Slot slot, Context cx) {
        if (slot.isProperty() && this.get(slot.asProperty()).getType().is(BLibrary.TYPE)) {
            BLibrary lib = (BLibrary)this.get(slot.asProperty());
            if (!Sys.isStation()) {
                lib.lease();
            }
            return lib.toString(cx);
        }
        return super.getDisplayName(slot, cx);
    }

    @Override
    public boolean isChildLegal(BComponent child) {
        return child.getType().is(BLibrary.TYPE);
    }

    @Override
    public boolean isParentLegal(BComponent parent) {
        return parent instanceof BNe2DeviceExt || !parent.isMounted() || parent.getComponentSpace() instanceof BBogSpace;
    }

    public BNanoBaseComponent doGetComponentByTypeId(BInteger typeId) {
        return this.libraryComponentsCache.get(typeId.getInt());
    }

    public BNanoBaseComponent doGetComponentByTypeName(BString originNameFromLibrary) {
        return this.libraryComponentsCache.get(originNameFromLibrary.getString());
    }

    public BEnumRange doGetValidExtensions(BNanoBaseComponent target) {
        BNanoExtension[] validExt = this.libraryComponentsCache.getValidExtensions(target);
        String[] escapedExtensionNames = (String[])Arrays.stream(validExt).map(extension -> SlotPath.escape((String)extension.getOriginNameFromLibrary())).toArray(String[]::new);
        return BEnumRange.make((String[])escapedExtensionNames);
    }

    public BIcon getIcon() {
        return icon;
    }

    public class LibraryComponentCache {
        private HashMap<Integer, BNanoBaseComponent> componentsByTypeId = new HashMap();
        private HashMap<String, BNanoBaseComponent> componentsByTypeName = new HashMap();
        private List<BNanoExtension> extensions = new ArrayList<BNanoExtension>();

        private void init() {
            BLibraries thisLibraries = BLibraries.this;
            BComponentSpace componentSpace = thisLibraries.getComponentSpace();
            HashMap existingLibraryComponentsById = (HashMap)Arrays.stream(componentSpace.getAllComponents()).filter(component -> component instanceof BNanoBaseComponent && ((BNanoBaseComponent)((Object)component)).getIsLibraryComponent() && component.getParent().getParent().equals((Object)thisLibraries)).map(component -> (BNanoBaseComponent)((Object)component)).collect(Collectors.toMap(BNanoBaseComponent::getTypeId, Function.identity()));
            this.componentsByTypeId.putAll(existingLibraryComponentsById);
            HashMap existingLibraryComponentsByName = (HashMap)Arrays.stream(componentSpace.getAllComponents()).filter(component -> component instanceof BNanoBaseComponent && ((BNanoBaseComponent)((Object)component)).getIsLibraryComponent() && component.getParent().getParent().equals((Object)thisLibraries)).map(component -> (BNanoBaseComponent)((Object)component)).collect(Collectors.toMap(BNanoBaseComponent::getOriginNameFromLibrary, Function.identity()));
            this.componentsByTypeName.putAll(existingLibraryComponentsByName);
            this.extensions = Arrays.stream(componentSpace.getAllComponents()).filter(component -> component instanceof BNanoExtension && ((BNanoExtension)((Object)component)).getIsLibraryComponent() && component.getParent().getParent().equals((Object)thisLibraries)).map(component -> (BNanoExtension)((Object)component)).collect(Collectors.toList());
        }

        public void clear() {
            this.componentsByTypeId.clear();
            this.componentsByTypeName.clear();
            this.extensions.clear();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean put(BNanoBaseComponent componentToCache) {
            if (componentToCache == null) {
                return false;
            }
            int typeId = componentToCache.getTypeId();
            if (typeId != -1) {
                this.componentsByTypeId.put(typeId, componentToCache);
                this.componentsByTypeName.put(componentToCache.getOriginNameFromLibrary(), componentToCache);
                List<BNanoExtension> list = this.extensions;
                synchronized (list) {
                    if (componentToCache instanceof BNanoExtension) {
                        this.extensions.add((BNanoExtension)componentToCache);
                    }
                }
                return true;
            }
            return false;
        }

        public BNanoBaseComponent get(int typeId) {
            return this.componentsByTypeId.get(typeId);
        }

        public BNanoBaseComponent get(String originNameFromLibrary) {
            return this.componentsByTypeName.get(originNameFromLibrary);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public BNanoExtension[] getValidExtensions(BNanoBaseComponent target) {
            List<BNanoExtension> list = this.extensions;
            synchronized (list) {
                if (target == null) {
                    return this.extensions.toArray(new BNanoExtension[0]);
                }
                ArrayList existingExtensionTypes = (ArrayList)Arrays.stream(target.getChildren(BNanoExtension.class)).map(BNanoBaseComponent::getOriginNameFromLibrary).collect(Collectors.toList());
                BNanoExtension[] validExt = (BNanoExtension[])this.extensions.stream().filter(extension -> !extension.getIsManaged() && extension.isValidForTarget(target) && (extension.getIsMultipleAllowed() || !existingExtensionTypes.contains(extension.getOriginNameFromLibrary()))).toArray(BNanoExtension[]::new);
                return validExt;
            }
        }
    }
}

