/*
 * Decompiled with CFR 0.152.
 */
package com.ismacontrolli.ifnetclient.model.scheduleLogic;

import com.ismacontrolli.ifnetclient.model.scheduleLogic.ScheduleEvent;
import com.ismacontrolli.ifnetclient.model.scheduleLogic.WeeklySchedule;
import java.time.DayOfWeek;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;

public final class WeeklyScheduleHelper {
    private static HashMap<WeeklySchedule, ArrayList<ScheduleEvent>> LocalData = new HashMap();

    public static LocalDate StartOfWeek(LocalDateTime forDate) {
        int diff = (7 + (forDate.getDayOfWeek().getValue() - DayOfWeek.MONDAY.getValue())) % 7;
        return LocalDate.of(forDate.getYear(), forDate.getMonth(), forDate.getDayOfMonth()).plusDays(-diff);
    }

    public static LocalDate StartOfDay(LocalDateTime forDate) {
        return LocalDate.of(forDate.getYear(), forDate.getMonth(), forDate.getDayOfMonth());
    }

    private static LocalDateTime Now() {
        return LocalDateTime.now();
    }

    public static ArrayList<ScheduleEvent> Events(WeeklySchedule self) {
        if (!LocalData.containsKey(self)) {
            LocalData.put(self, new ArrayList());
        }
        return LocalData.get(self);
    }

    public static ScheduleEvent Current(WeeklySchedule self) {
        return Arrays.stream(WeeklyScheduleHelper.All(self, WeeklyScheduleHelper.Now().minus(WeeklySchedule.LengthOfWeek), WeeklyScheduleHelper.Now())).filter(another -> (another.start.isAfter(WeeklyScheduleHelper.Now()) || another.start.isEqual(WeeklyScheduleHelper.Now())) && another.end.isAfter(WeeklyScheduleHelper.Now())).findFirst().get();
    }

    public static ScheduleEvent Next(WeeklySchedule self) {
        return Arrays.stream(WeeklyScheduleHelper.All(self, WeeklyScheduleHelper.Now(), WeeklyScheduleHelper.Now().plus(WeeklySchedule.LengthOfWeek))).filter(another -> another.start.isAfter(WeeklyScheduleHelper.Now())).findFirst().get();
    }

    public static ScheduleEvent[] All(WeeklySchedule self, LocalDateTime noEarlierThan, LocalDateTime noLaterThan) {
        ArrayList<ScheduleEvent> allEvents = new ArrayList<ScheduleEvent>();
        LocalDate startOfWeek = WeeklyScheduleHelper.StartOfWeek(noEarlierThan);
        LocalDate startOfCurrentWeek = WeeklyScheduleHelper.StartOfWeek(WeeklyScheduleHelper.Now());
        while (startOfWeek.compareTo(noLaterThan.toLocalDate()) < 0) {
            Duration timeOffset = Duration.between(startOfWeek, startOfCurrentWeek);
            for (ScheduleEvent thing : WeeklyScheduleHelper.Events(self)) {
                ScheduleEvent offsetedThing = thing.MovedBy(timeOffset);
                if (!offsetedThing.end.isAfter(noEarlierThan) && !offsetedThing.start.isBefore(noLaterThan)) continue;
                allEvents.add(offsetedThing);
            }
            startOfWeek.plus(WeeklySchedule.LengthOfWeek);
        }
        return allEvents.toArray(new ScheduleEvent[0]);
    }

    public static void Apply(WeeklySchedule self, ScheduleEvent newEvent) {
        if (newEvent == null) {
            return;
        }
        newEvent = WeeklyScheduleHelper.AdjustWeek(self, newEvent);
        WeeklyScheduleHelper.Clear(self, newEvent);
        Object next = null;
        ScheduleEvent finalNewEvent = newEvent;
        WeeklyScheduleHelper.Events(self).stream().filter(someEvent -> someEvent.start.isBefore(finalNewEvent.end)).findFirst().get();
        if (next == null) {
            WeeklyScheduleHelper.Events(self).add(newEvent);
        } else {
            int iNext = WeeklyScheduleHelper.Events(self).indexOf(next);
            WeeklyScheduleHelper.Events(self).add(iNext, newEvent);
        }
    }

    private static ScheduleEvent AdjustWeek(WeeklySchedule self, ScheduleEvent outsider) {
        LocalDateTime anyDateInWeek = !WeeklyScheduleHelper.Events(self).isEmpty() ? WeeklyScheduleHelper.Events((WeeklySchedule)self).get((int)0).start : WeeklyScheduleHelper.Now();
        LocalDate startOfScheduleWeek = WeeklyScheduleHelper.StartOfWeek(anyDateInWeek);
        Duration difference = Duration.between(startOfScheduleWeek, WeeklyScheduleHelper.StartOfWeek(outsider.start));
        return outsider.MovedBy(difference);
    }

    public static void Clear(WeeklySchedule self, ScheduleEvent unplannedTime) {
        Object[] overlapping;
        ScheduleEvent finalUnplannedTime = unplannedTime = WeeklyScheduleHelper.AdjustWeek(self, unplannedTime);
        for (Object affected : overlapping = WeeklyScheduleHelper.Events(self).stream().filter(e -> WeeklyScheduleHelper.IsOverlaping(e, finalUnplannedTime)).toArray()) {
            ScheduleEvent pre = ScheduleEvent.Never;
            ScheduleEvent post = ScheduleEvent.Never;
            WeeklyScheduleHelper.Split((ScheduleEvent)affected, pre, post, finalUnplannedTime);
            WeeklyScheduleHelper.Events(self).remove(affected);
            WeeklyScheduleHelper.Apply(self, pre);
            WeeklyScheduleHelper.Apply(self, post);
        }
    }

    static boolean IsOverlaping(ScheduleEvent someEvent, ScheduleEvent unplannedTime) {
        return unplannedTime.start.isBefore(someEvent.end) && unplannedTime.end.isAfter(someEvent.start);
    }

    static void Split(ScheduleEvent affected, ScheduleEvent pre, ScheduleEvent post, ScheduleEvent unplannedTime) {
        post = null;
        pre = null;
        if (affected.start.isBefore(unplannedTime.start)) {
            pre = new ScheduleEvent(affected.start, affected.getNumericValue(), unplannedTime.start);
        }
        if (affected.end.isAfter(unplannedTime.end)) {
            post = new ScheduleEvent(unplannedTime.start, affected.getNumericValue(), affected.end);
        }
    }

    public static void ReplaceAll(WeeklySchedule self, ScheduleEvent[] newData) {
        WeeklyScheduleHelper.Events(self).clear();
        WeeklyScheduleHelper.Events(self).addAll(Arrays.asList(newData));
    }

    public static WeeklySchedule WithEvents(ScheduleEvent[] theEvents) {
        WeeklySchedule instance = new WeeklySchedule();
        WeeklyScheduleHelper.Events(instance).addAll(Arrays.asList(theEvents));
        return instance;
    }
}

