/*
 * Decompiled with CFR 0.152.
 */
package com.ismacontrolli.ifnetclient.model.scheduleLogic;

import com.ismacontrolli.ifnetclient.model.scheduleLogic.ISchedule;

public final class Sorting {
    public static void SortChangeTimes(long[] changeTimes, double[] values) {
        int i;
        if (changeTimes == null || values == null) {
            return;
        }
        int[][] indexedChangeTimes = new int[changeTimes.length][];
        double[] tempValues = values;
        for (i = 0; i < changeTimes.length; ++i) {
            indexedChangeTimes[i] = new int[]{i, (int)changeTimes[i]};
        }
        Sorting.MergeSort((Object[])indexedChangeTimes);
        for (i = 0; i < changeTimes.length; ++i) {
            changeTimes[i] = indexedChangeTimes[i][1];
            values[i] = tempValues[indexedChangeTimes[i][0]];
        }
    }

    public static void SortByPriority(ISchedule[] exceptionalDays) {
        if (exceptionalDays == null) {
            return;
        }
        Sorting.MergeSort(exceptionalDays);
    }

    private static void MergeSort(Object[] array) {
        int length = array.length;
        if (length <= 1) {
            return;
        }
        int middle = length / 2;
        Object[] leftPart = new Object[middle];
        Object[] rightPart = new Object[length - middle];
        int j = 0;
        for (int i = 0; i < length; ++i) {
            if (i < middle) {
                leftPart[i] = array[i];
                continue;
            }
            rightPart[j] = array[i];
            ++j;
        }
        Sorting.MergeSort(leftPart);
        Sorting.MergeSort(rightPart);
        Sorting.Merge(leftPart, rightPart, array);
    }

    private static void Merge(Object[] leftPart, Object[] rightPart, Object[] initialArray) {
        int leftSize = initialArray.length / 2;
        int rightSize = initialArray.length - leftSize;
        int leftIndex = 0;
        int rightIndex = 0;
        int arrayIndex = 0;
        Sorting.AddInOrder(leftPart, rightPart, initialArray, leftSize, rightSize, leftIndex, rightIndex, arrayIndex);
        Sorting.AppendSurplus(leftPart, rightPart, initialArray, leftSize, rightSize, leftIndex, rightIndex, arrayIndex);
    }

    static void AddInOrder(Object[] leftPart, Object[] rightPart, Object[] initialArray, int leftSize, int rightSize, int leftIndex, int rightIndex, int arrayIndex) {
        while (leftIndex < leftSize && rightIndex < rightSize) {
            if (Sorting.Compare(leftPart[leftIndex], rightPart[rightIndex])) {
                initialArray[arrayIndex] = rightPart[rightIndex];
                ++rightIndex;
            } else {
                initialArray[arrayIndex] = leftPart[leftIndex];
                ++leftIndex;
            }
            ++arrayIndex;
        }
    }

    static void AppendSurplus(Object[] leftPart, Object[] rightPart, Object[] initialArray, int leftSize, int rightSize, int leftIndex, int rightIndex, int arrayIndex) {
        while (leftIndex < leftSize) {
            initialArray[arrayIndex] = leftPart[leftIndex];
            ++leftIndex;
            ++arrayIndex;
        }
        while (rightIndex < rightSize) {
            initialArray[arrayIndex] = rightPart[rightIndex];
            ++rightIndex;
            ++arrayIndex;
        }
    }

    private static boolean Compare(Object someObject, Object toCompareWith) {
        boolean cmp = false;
        if (someObject instanceof ISchedule) {
            ISchedule schedule = (ISchedule)someObject;
            if (toCompareWith instanceof ISchedule) {
                cmp = schedule.getPriority() > ((ISchedule)toCompareWith).getPriority();
            }
        } else if (someObject.getClass().isArray()) {
            cmp = ((int[])someObject)[1] > ((int[])toCompareWith)[1];
        } else {
            throw new UnsupportedOperationException("Can't compare these objects");
        }
        return cmp;
    }
}

