/*
 * Decompiled with CFR 0.152.
 */
package com.ismacontrolli.ifnetclient.model.scheduleLogic;

import java.time.Duration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;

public class ScheduleEvent {
    public static ScheduleEvent Never = new ScheduleEvent(LocalDateTime.MIN, Double.NaN, LocalDateTime.MIN);
    public LocalDateTime start = LocalDateTime.MIN;
    public LocalDateTime end = LocalDateTime.MIN;
    private double NumericValue;

    public ScheduleEvent(LocalDateTime from, double value, LocalDateTime until) {
        this.start = from;
        this.end = until;
        this.setNumericValue(value);
    }

    public ScheduleEvent(LocalDateTime from, boolean value, LocalDateTime until) {
        this(from, value ? 1.0 : 0.0, until);
    }

    public final double getNumericValue() {
        return this.NumericValue;
    }

    private void setNumericValue(double value) {
        this.NumericValue = value;
    }

    public final boolean getBinaryValue() {
        return this.getNumericValue() != 0.0;
    }

    private void setBinaryValue(boolean value) {
        this.setNumericValue(value ? 1.0 : 0.0);
    }

    public final ScheduleEvent MovedBy(Duration offset) {
        return new ScheduleEvent(this.start.plus(offset), this.getNumericValue(), this.end.plus(offset));
    }

    public LocalDateTime convertToLocalDateTimeViaInstant(Date dateToConvert) {
        return dateToConvert.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
    }

    public LocalDateTime convertToLocalDateTimeViaMilisecond(Date dateToConvert) {
        return Instant.ofEpochMilli(dateToConvert.getTime()).atZone(ZoneId.systemDefault()).toLocalDateTime();
    }

    public boolean equals(Object obj) {
        boolean tempVar = obj instanceof ScheduleEvent;
        ScheduleEvent other = tempVar ? (ScheduleEvent)obj : null;
        return tempVar && other.start.equals(this.start) && other.end.equals(this.end) && other.getNumericValue() == this.getNumericValue();
    }

    public int hashCode() {
        return this.start.hashCode() + this.end.hashCode() + new Double(this.getNumericValue()).hashCode();
    }
}

