/*
 * Decompiled with CFR 0.152.
 */
package com.ismacontrolli.ifnetclient.model.scheduleLogic;

import com.ismacontrolli.ifnetclient.model.scheduleLogic.DayOfMonth;
import com.ismacontrolli.ifnetclient.model.scheduleLogic.DaysFromCalendar;
import com.ismacontrolli.ifnetclient.model.scheduleLogic.ExceptionalDays;
import com.ismacontrolli.ifnetclient.model.scheduleLogic.ISchedule;
import com.ismacontrolli.ifnetclient.model.scheduleLogic.Month;
import com.ismacontrolli.ifnetclient.model.scheduleLogic.ScheduleEvent;
import com.ismacontrolli.ifnetclient.model.scheduleLogic.ScheduleStaticMethods;
import com.ismacontrolli.ifnetclient.model.scheduleLogic.WeekOfMonth;
import java.time.DayOfWeek;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

public class ScheduleDailyExtension {
    static HashMap<ISchedule, List<ScheduleEvent>> AllEvents = new HashMap();

    public static LocalDateTime[] ActiveDays(DaysFromCalendar self, LocalDateTime since, LocalDateTime until) {
        ArrayList<LocalDateTime> allActiveDays = new ArrayList<LocalDateTime>();
        while (since.isBefore(until)) {
            LocalDateTime nearestOccurence = LocalDateTime.MIN;
            self.NearestRelevantDay(since, nearestOccurence);
            if (nearestOccurence != null) {
                allActiveDays.add(nearestOccurence);
            }
            since.plus(Duration.ofDays(1L));
        }
        return (LocalDateTime[])allActiveDays.stream().toArray();
    }

    public static List<ScheduleEvent> Events(ISchedule self) {
        if (!AllEvents.keySet().contains(self)) {
            AllEvents.put(self, new ArrayList());
        }
        return AllEvents.get(self);
    }

    public static ISchedule Adjust(String withName, byte withPriority, ISchedule original) {
        return ScheduleDailyExtension.Adjust(withName, withPriority, original, null);
    }

    public static ISchedule Adjust(String withName, byte withPriority, ISchedule original, ScheduleEvent[] withEvents) {
        ScheduleStaticMethods.Modify(original, withName, withPriority);
        if (AllEvents.keySet().contains(original)) {
            AllEvents.replace(original, Arrays.asList(withEvents));
        } else {
            AllEvents.put(original, Arrays.asList(withEvents));
        }
        return original;
    }

    public static boolean NearestMatchingDay(ExceptionalDays relevance, LocalDateTime noEarlierThan) {
        LocalDateTime nearestOccurence = LocalDateTime.MIN;
        return relevance.NearestRelevantDay(noEarlierThan, nearestOccurence);
    }

    public static boolean DoesMatchFuture(LocalDateTime deviceTime, DayOfWeek dayOfWeek, WeekOfMonth week, Month month) {
        return ScheduleDailyExtension.IsToHappenInTheFuture(deviceTime, ExceptionalDays.DayAndWeek(dayOfWeek, week, month));
    }

    public static boolean DoesMatchFuture(LocalDateTime deviceTime, DayOfWeek dayOfWeek, DayOfMonth dayOfMonth, Month month, short year) {
        return ScheduleDailyExtension.IsToHappenInTheFuture(deviceTime, ExceptionalDays.DatePattern(dayOfWeek, dayOfMonth, month, year));
    }

    public static boolean DoesMatchFuture(LocalDateTime deviceTime, DayOfMonth startDayOfMonth, Month startMonth, short startYear, DayOfMonth endDayOfMonth, Month endMonth, short endYear) {
        return ScheduleDailyExtension.IsToHappenInTheFuture(deviceTime, ExceptionalDays.DateRange(startDayOfMonth, startMonth, startYear, endDayOfMonth, endMonth, endYear));
    }

    public static boolean DoesMatchFutureUntil(LocalDateTime deviceTime, DayOfMonth endDayOfMonth, Month endMonth, short endYear) {
        return ScheduleDailyExtension.IsToHappenInTheFuture(deviceTime, ExceptionalDays.DateRange(DayOfMonth.Any, Month.Any, 65535, endDayOfMonth, endMonth, endYear));
    }

    public static boolean DoesMatchFutureSince(LocalDateTime deviceTime, DayOfMonth startDayOfMonth, Month startMonth, short startYear) {
        return ScheduleDailyExtension.IsToHappenInTheFuture(deviceTime, ExceptionalDays.DateRange(startDayOfMonth, startMonth, startYear, DayOfMonth.Any, Month.Any, 65535));
    }

    static boolean IsToHappenInTheFuture(LocalDateTime deviceTime, ExceptionalDays irregularDay) {
        return ScheduleDailyExtension.NearestMatchingDay(irregularDay, deviceTime);
    }
}

