/*
 * Decompiled with CFR 0.152.
 */
package com.ismacontrolli.ifnetclient.model.scheduleLogic;

import com.ismacontrolli.ifnetclient.model.scheduleLogic.DayOfMonth;
import com.ismacontrolli.ifnetclient.model.scheduleLogic.DaysFromCalendar;
import com.ismacontrolli.ifnetclient.model.scheduleLogic.ExceptionalDays;
import com.ismacontrolli.ifnetclient.model.scheduleLogic.ISchedule;
import com.ismacontrolli.ifnetclient.model.scheduleLogic.IrregularDays;
import com.ismacontrolli.ifnetclient.model.scheduleLogic.Month;
import com.ismacontrolli.ifnetclient.model.scheduleLogic.ScheduleDailyExtension;
import com.ismacontrolli.ifnetclient.model.scheduleLogic.ScheduleData;
import com.ismacontrolli.ifnetclient.model.scheduleLogic.ScheduleEvent;
import com.ismacontrolli.ifnetclient.model.scheduleLogic.WeekOfMonth;
import com.ismacontrolli.ifnetclient.model.scheduleLogic.WeeklySchedule;
import com.ismacontrolli.ifnetclient.model.scheduleLogic.WeeklyScheduleHelper;
import com.ismacontrolli.nE2Link.BNanoComponent;
import com.ismacontrolli.nE2Link.datatypes.BUInt64;
import com.ismacontrolli.nE2Link.datatypes.choice.BDynamicChoiceRange;
import com.ismacontrolli.nE2Link.datatypes.choice.BStatusDynamicChoice;
import com.ismacontrolli.nE2Link.datatypes.choice.converter.BStatusDynamicChoiceToStatusValue;
import com.ismacontrolli.nE2Link.schedules.BNanoCalendar;
import com.ismacontrolli.nE2Link.schedules.BNanoDateRangeSchedule;
import com.ismacontrolli.nE2Link.schedules.BNanoDateSchedule;
import com.ismacontrolli.nE2Link.schedules.BNanoSchedule;
import com.ismacontrolli.nE2Link.schedules.BNanoWeekAndDaySchedule;
import com.ismacontrolli.nE2Link.schedules.BNanoWeekSchedule;
import com.ismacontrolli.nE2Link.schedules.utils.BNanoBacnetPriorityEnum;
import com.ismacontrolli.nE2Link.schedules.utils.ScheduleUtils;
import com.ismacontrolli.serialization.DataMarker;
import com.ismacontrolli.serialization.SerializableCollection;
import com.ismacontrolli.serialization.SerializableForm;
import java.time.DayOfWeek;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Period;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.TreeMap;
import javax.baja.naming.SlotPath;
import javax.baja.nre.util.Array;
import javax.baja.schedule.BAbstractSchedule;
import javax.baja.schedule.BDailySchedule;
import javax.baja.schedule.BScheduleReference;
import javax.baja.schedule.BTimeSchedule;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusEnum;
import javax.baja.status.BStatusNumeric;
import javax.baja.sys.BObject;
import javax.baja.sys.BTime;
import javax.baja.sys.Sys;

public final class NotationOfSchedule {
    private static StardDateFunction WeekStart = someTime -> WeeklyScheduleHelper.StartOfWeek(someTime);
    private static StardDateFunction DayStart = someTime -> WeeklyScheduleHelper.StartOfDay(someTime);

    public static SerializableForm WithSchedule(BUInt64 persistentId, BAbstractSchedule schedule) {
        SerializableForm dataForm = new SerializableForm(DataMarker.ScheduleMarker, new Object[4]);
        dataForm.data[0] = persistentId;
        if (schedule instanceof BNanoSchedule) {
            BNanoWeekSchedule weekSchedule = ((BNanoSchedule)schedule).getWeekSchedule();
            for (int weekDay = 1; weekDay <= 7; ++weekDay) {
                BTimeSchedule[] bTimeScheduleArray = weekSchedule.schedule(weekDay).getDay().getTimesInOrder();
                int n = bTimeScheduleArray.length;
                block17: for (int i = 0; i < n; ++i) {
                    BTimeSchedule timeSchedule = bTimeScheduleArray[i];
                    LocalDate localDate = WeekStart.invoke(LocalDateTime.now()).plusDays(weekDay - 1);
                    BTime start = timeSchedule.getStart();
                    BTime finish = timeSchedule.getFinish();
                    BTimeSchedule[] startDateTime = LocalDateTime.of(localDate, LocalTime.of(start.getHour(), start.getMinute()));
                    LocalDateTime finishDateTime = LocalDateTime.of(localDate, LocalTime.of(finish.getHour(), finish.getMinute()));
                    switch (((BNanoSchedule)schedule).getScheduleType().getOrdinal()) {
                        case 0: {
                            double value2 = ((BStatusNumeric)timeSchedule.getEffectiveValue()).getValue();
                            ((BNanoSchedule)schedule).getScheduleEventsList().add(new ScheduleEvent((LocalDateTime)startDateTime, value2, finishDateTime));
                            continue block17;
                        }
                        case 1: {
                            boolean value3 = false;
                            if (timeSchedule.getEffectiveValue() instanceof BStatusDynamicChoice) {
                                BStatusDynamicChoiceToStatusValue converter = new BStatusDynamicChoiceToStatusValue();
                                BStatusBoolean sv = (BStatusBoolean)converter.convert((BObject)((BStatusDynamicChoice)timeSchedule.getEffectiveValue()), (BObject)new BStatusBoolean());
                                value3 = sv.getValue();
                            } else {
                                value3 = ((BStatusBoolean)timeSchedule.getEffectiveValue()).getValue();
                            }
                            ((BNanoSchedule)schedule).getScheduleEventsList().add(new ScheduleEvent((LocalDateTime)startDateTime, value3, finishDateTime));
                            continue block17;
                        }
                        case 2: {
                            double value2 = 0.0;
                            if (timeSchedule.getEffectiveValue() instanceof BStatusDynamicChoice) {
                                BStatusDynamicChoiceToStatusValue converter = new BStatusDynamicChoiceToStatusValue();
                                BStatusEnum sv = (BStatusEnum)converter.convert((BObject)((BStatusDynamicChoice)timeSchedule.getEffectiveValue()), (BObject)new BStatusEnum());
                                value2 = sv.getValue().getOrdinal();
                            } else {
                                value2 = ((BStatusEnum)timeSchedule.getEffectiveValue()).getValue().getOrdinal();
                            }
                            ((BNanoSchedule)schedule).getScheduleEventsList().add(new ScheduleEvent((LocalDateTime)startDateTime, value2, finishDateTime));
                            continue block17;
                        }
                    }
                }
            }
        }
        BNanoCalendar specialEventsSchedule = schedule instanceof BNanoSchedule ? ((BNanoSchedule)schedule).getSpecialEvents() : (BNanoCalendar)schedule;
        for (BAbstractSchedule abstractSchedule : (BAbstractSchedule[])specialEventsSchedule.getChildren(BAbstractSchedule.class)) {
            Month startMonthOfYear;
            DayOfWeek dayOfWeek;
            BAbstractSchedule scheduleEvent;
            long[] secondsOfChange = new long[]{};
            double[] scheduledValues = new double[]{};
            if (schedule instanceof BNanoSchedule) {
                if (abstractSchedule instanceof BDailySchedule) {
                    BDailySchedule dailySchedule = (BDailySchedule)abstractSchedule;
                    secondsOfChange = new long[2 * dailySchedule.getDay().getTimesInOrder().length];
                    scheduledValues = new double[2 * dailySchedule.getDay().getTimesInOrder().length];
                    int index = 0;
                    for (BTimeSchedule timeSchedule : dailySchedule.getDay().getTimesInOrder()) {
                        BTime start = timeSchedule.getStart();
                        BTime finish = timeSchedule.getFinish();
                        secondsOfChange[index] = start.getHour() * 3600 + start.getMinute() * 60 + start.getSecond();
                        switch (((BNanoSchedule)schedule).getScheduleType().getOrdinal()) {
                            case 0: {
                                double value4;
                                scheduledValues[index] = value4 = ((BStatusNumeric)timeSchedule.getEffectiveValue()).getValue();
                                break;
                            }
                            case 1: {
                                boolean value5 = false;
                                value5 = timeSchedule.getEffectiveValue() instanceof BStatusDynamicChoice ? ((BStatusDynamicChoice)timeSchedule.getEffectiveValue()).getValue().getKeyAsBoolean().getBoolean() : ((BStatusBoolean)timeSchedule.getEffectiveValue()).getValue();
                                scheduledValues[index] = value5 ? 1.0 : 0.0;
                                break;
                            }
                            case 2: {
                                double value6 = timeSchedule.getEffectiveValue() instanceof BStatusDynamicChoice ? ((BStatusDynamicChoice)timeSchedule.getEffectiveValue()).getValue().getKeyAsNumber().getNumeric() : (double)((BStatusEnum)timeSchedule.getEffectiveValue()).getValue().getOrdinal();
                                scheduledValues[index] = value6;
                                break;
                            }
                        }
                        LocalTime localTime = LocalTime.of(finish.getHour(), finish.getMinute(), finish.getSecond());
                        secondsOfChange[++index] = localTime.equals(LocalTime.MIDNIGHT) ? 86400L : (long)(finish.getHour() * 3600 + finish.getMinute() * 60 + finish.getSecond());
                        scheduledValues[index] = Double.NaN;
                        ++index;
                    }
                } else if (abstractSchedule instanceof BScheduleReference) {
                    // empty if block
                }
            }
            String eventName = SlotPath.unescape((String)abstractSchedule.getName());
            byte priority = 16;
            try {
                if (abstractSchedule instanceof BDailySchedule) {
                    BAbstractSchedule days = ((BDailySchedule)abstractSchedule).getDays();
                    priority = (byte)((BNanoBacnetPriorityEnum)days.get(ScheduleUtils.BACNET_PRIORITY)).getOrdinal();
                } else {
                    priority = (byte)((BNanoBacnetPriorityEnum)abstractSchedule.get(ScheduleUtils.BACNET_PRIORITY)).getOrdinal();
                }
            }
            catch (Exception days) {
                // empty catch block
            }
            IrregularDays specialEvent = null;
            IrregularDays daysFromCalendar = null;
            BAbstractSchedule bAbstractSchedule = scheduleEvent = abstractSchedule instanceof BDailySchedule ? ((BDailySchedule)abstractSchedule).getDays() : abstractSchedule;
            if (scheduleEvent instanceof BNanoDateSchedule) {
                BNanoDateSchedule dateSchedule = (BNanoDateSchedule)scheduleEvent;
                dayOfWeek = dateSchedule.getWeekday() == 0 ? DayOfWeek.of(7) : (dateSchedule.getWeekday() > 0 ? DayOfWeek.of(dateSchedule.getWeekday()) : null);
                DayOfMonth startDayOfMonth = dateSchedule.getDay() >= 0 ? DayOfMonth.forValue(dateSchedule.getDay()) : DayOfMonth.Any;
                startMonthOfYear = dateSchedule.getMonth() >= 0 ? Month.forValue(dateSchedule.getMonth() + 1) : Month.Any;
                int startYear = dateSchedule.getYear();
                specialEvent = ExceptionalDays.DatePattern(dayOfWeek, startDayOfMonth, startMonthOfYear, startYear);
            } else if (scheduleEvent instanceof BNanoDateRangeSchedule) {
                BNanoDateRangeSchedule dateRangeSchedule = (BNanoDateRangeSchedule)scheduleEvent;
                DayOfMonth startDayOfMonth = dateRangeSchedule.getStart().getDay() >= 0 ? DayOfMonth.forValue(dateRangeSchedule.getStart().getDay()) : DayOfMonth.Any;
                startMonthOfYear = dateRangeSchedule.getStart().getMonth() >= 0 ? Month.forValue(dateRangeSchedule.getStart().getMonth() + 1) : Month.Any;
                int startYear = dateRangeSchedule.getStart().getYear();
                DayOfMonth endDayOfMonth = dateRangeSchedule.getEnd().getDay() >= 0 ? DayOfMonth.forValue(dateRangeSchedule.getEnd().getDay()) : DayOfMonth.Any;
                Month endMonthOfYear = dateRangeSchedule.getEnd().getMonth() >= 0 ? Month.forValue(dateRangeSchedule.getEnd().getMonth() + 1) : Month.Any;
                int endYear = dateRangeSchedule.getEnd().getYear();
                specialEvent = ExceptionalDays.DateRange(startDayOfMonth, startMonthOfYear, startYear, endDayOfMonth, endMonthOfYear, endYear);
            } else if (scheduleEvent instanceof BNanoWeekAndDaySchedule) {
                BNanoWeekAndDaySchedule weekAndDaySchedule = (BNanoWeekAndDaySchedule)scheduleEvent;
                dayOfWeek = weekAndDaySchedule.getWeekday() == 0 ? DayOfWeek.of(7) : (weekAndDaySchedule.getWeekday() > 0 ? DayOfWeek.of(weekAndDaySchedule.getWeekday()) : null);
                WeekOfMonth weekOfMonth = weekAndDaySchedule.getWeek() >= 0 ? WeekOfMonth.forValue(weekAndDaySchedule.getWeek()) : WeekOfMonth.Any;
                startMonthOfYear = weekAndDaySchedule.getMonth() >= 0 ? Month.forValue(weekAndDaySchedule.getMonth() + 1) : Month.Any;
                specialEvent = ExceptionalDays.DayAndWeek(dayOfWeek, weekOfMonth, startMonthOfYear);
            } else if (scheduleEvent instanceof BScheduleReference) {
                BScheduleReference scheduleReference = (BScheduleReference)scheduleEvent;
                try {
                    BNanoCalendar refComponent = (BNanoCalendar)scheduleReference.getRef().resolve((BObject)Sys.getStation()).getComponent();
                    daysFromCalendar = new DaysFromCalendar(((BNanoComponent)refComponent.getParent()).getPersistentId());
                }
                catch (Exception e) {
                    daysFromCalendar = new DaysFromCalendar();
                }
            }
            if (specialEvent != null) {
                specialEvent.setName(eventName);
                specialEvent.setPriority(priority);
                specialEvent.getValues().Set(secondsOfChange, scheduledValues);
            }
            if (daysFromCalendar != null) {
                daysFromCalendar.setName(eventName);
                daysFromCalendar.setPriority(priority);
                daysFromCalendar.getValues().Set(secondsOfChange, scheduledValues);
            }
            if (schedule instanceof BNanoSchedule) {
                if (specialEvent != null) {
                    ((BNanoSchedule)schedule).getSpecialEventsList().add(specialEvent);
                }
                if (daysFromCalendar == null) continue;
                ((BNanoSchedule)schedule).getSpecialEventsList().add(daysFromCalendar);
                continue;
            }
            if (specialEvent == null) continue;
            ((BNanoCalendar)schedule).getSpecialEventsList().add(specialEvent);
        }
        if (schedule instanceof BNanoSchedule) {
            TreeMap<Duration, Double> changes = NotationOfSchedule.SerializeEvents(((BNanoSchedule)schedule).getScheduleEventsList(), WeekStart);
            Array secondsOfChange = new Array(Long.class, changes.size());
            changes.keySet().forEach(change -> secondsOfChange.add((Object)change.getSeconds()));
            Array scheduledValues = new Array(Double.class, changes.size());
            changes.values().forEach(value -> scheduledValues.add(value));
            dataForm.data[1] = secondsOfChange;
            dataForm.data[2] = scheduledValues;
        } else {
            dataForm.data[1] = new Array(Long.class, 0);
            dataForm.data[2] = new Array(Double.class, 0);
        }
        dataForm.data[3] = null;
        dataForm.elements = new SerializableCollection();
        List<ISchedule> specialEvents = schedule instanceof BNanoSchedule ? ((BNanoSchedule)schedule).getSpecialEventsList() : ((BNanoCalendar)schedule).getSpecialEventsList();
        for (ISchedule specialEvent : specialEvents) {
            dataForm.elements.Add(NotationOfSchedule.SpecialEventForm(schedule, specialEvent));
        }
        try {
            BDynamicChoiceRange labels;
            BDynamicChoiceRange bDynamicChoiceRange = labels = schedule instanceof BNanoSchedule ? ((BNanoSchedule)schedule).getLabels() : ((BNanoCalendar)schedule).getLabels();
            if (labels != null) {
                SerializableForm dynamicChoiceElement = labels.getSerializableForm();
                dataForm.elements.Add(dynamicChoiceElement);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dataForm;
    }

    private static TreeMap<Duration, Double> SerializeEvents(List<ScheduleEvent> events, StardDateFunction periodStart) {
        TreeMap<Duration, Double> changes = new TreeMap<Duration, Double>();
        events.sort((some, other) -> some.start.compareTo(other.start));
        for (int i = 0; i < events.size(); ++i) {
            ScheduleEvent next = events.get(i);
            LocalDateTime startOfPeriod = LocalDateTime.of(periodStart.invoke(next.start), LocalTime.MIN);
            changes.put(Duration.between(startOfPeriod, next.start), next.getNumericValue());
            int plusDays = next.end.toLocalTime().equals(LocalTime.MIDNIGHT) ? 1 : 0;
            changes.put(Duration.between(startOfPeriod, next.end).plusDays(plusDays), Double.NaN);
        }
        return changes;
    }

    static SerializableForm SpecialEventForm(BAbstractSchedule schedule, ISchedule specialEvent) {
        double[] dArray;
        long[] lArray;
        List<ISchedule> specialEvents;
        SerializableForm specialEventForm = new SerializableForm(DataMarker.ScheduleMarker, ScheduleData.IrregularDaysNotation(specialEvent));
        if (specialEvent instanceof ExceptionalDays) {
            byte[] daysDefinition = (byte[])((ExceptionalDays)specialEvent).RawData();
            Array rawDataArray = new Array(Byte.class, daysDefinition.length);
            for (int i = 0; i < daysDefinition.length; ++i) {
                rawDataArray.add((Object)daysDefinition[i]);
            }
            specialEventForm.data[2] = rawDataArray;
        } else {
            DaysFromCalendar daysFromCalendar = (DaysFromCalendar)specialEvent;
            BUInt64 calendarPersistentId = daysFromCalendar.getCalendarPersistentId();
            specialEventForm.data[2] = null != calendarPersistentId ? calendarPersistentId : BUInt64.ZERO;
        }
        List<ISchedule> list = specialEvents = schedule instanceof BNanoSchedule ? ((BNanoSchedule)schedule).getSpecialEventsList() : ((BNanoCalendar)schedule).getSpecialEventsList();
        if (schedule instanceof BNanoSchedule) {
            lArray = specialEvent.getValues().GetChangeTimes();
        } else {
            long[] lArray2 = new long[2];
            lArray2[0] = 0L;
            lArray = lArray2;
            lArray2[1] = 172799L;
        }
        long[] changeTimes = lArray;
        if (schedule instanceof BNanoSchedule) {
            dArray = specialEvent.getValues().GetValues();
        } else {
            double[] dArray2 = new double[2];
            dArray2[0] = 1.0;
            dArray = dArray2;
            dArray2[1] = Double.NaN;
        }
        double[] values = dArray;
        Array timesArray = new Array(Object.class, changeTimes.length);
        for (int i = 0; i < changeTimes.length; ++i) {
            timesArray.add((Object)changeTimes[i]);
        }
        Array valuesArray = new Array(Object.class, values.length);
        for (int i = 0; i < values.length; ++i) {
            valuesArray.add((Object)values[i]);
        }
        specialEventForm.data[3] = timesArray;
        specialEventForm.data[4] = valuesArray;
        specialEventForm.data[5] = specialEvent.getPriority();
        return specialEventForm;
    }

    public static BNanoSchedule ExtractSchedule(SerializableForm dataForm, String originNameFromLibrary) {
        if (dataForm.marker != DataMarker.ScheduleMarker) {
            return null;
        }
        try {
            Class outputType;
            switch ((String)dataForm.data[3]) {
                case "Bool": {
                    outputType = Boolean.class;
                    break;
                }
                case "Double": {
                    outputType = Double.class;
                    break;
                }
                default: {
                    throw new IllegalArgumentException(String.format("Not supported output type for schedule: %1$s", dataForm.data[3]));
                }
            }
            ScheduleEvent[] weeklyEvents = NotationOfSchedule.TranslateToWeeklyEvents(dataForm.data[1], dataForm.data[2]);
            ISchedule[] specialEvents = NotationOfSchedule.ExtractSpecialEvents(dataForm);
            BDynamicChoiceRange valueRestrictions = NotationOfSchedule.SearchChildElementForChoice(dataForm, "labels");
            BDynamicChoiceRange availableCalendars = NotationOfSchedule.SearchChildElementForChoice(dataForm, "calendars");
            BNanoSchedule schedule = new BNanoSchedule(outputType, weeklyEvents, specialEvents, valueRestrictions, availableCalendars, originNameFromLibrary);
            return schedule;
        }
        catch (RuntimeException error) {
            System.out.println("failed to deserialize schedule data: " + error);
            error.printStackTrace();
            return null;
        }
    }

    public static BNanoCalendar ExtractCalendar(SerializableForm dataForm) {
        if (dataForm.marker != DataMarker.ScheduleMarker) {
            return null;
        }
        try {
            Class outputType;
            switch ((String)dataForm.data[3]) {
                case "Bool": {
                    outputType = Boolean.class;
                    break;
                }
                case "Double": {
                    outputType = Double.class;
                    break;
                }
                default: {
                    throw new IllegalArgumentException(String.format("Not supported output type for schedule: %1$s", dataForm.data[3]));
                }
            }
            ISchedule[] specialEvents = NotationOfSchedule.ExtractSpecialEvents(dataForm);
            BDynamicChoiceRange valueRestrictions = NotationOfSchedule.SearchChildElementForChoice(dataForm, "labels");
            BNanoCalendar calendar = new BNanoCalendar(outputType, specialEvents, valueRestrictions);
            return calendar;
        }
        catch (RuntimeException error) {
            System.out.println("failed to deserialize schedule data: " + error);
            error.printStackTrace();
            return null;
        }
    }

    static ScheduleEvent[] TranslateToWeeklyEvents(Object times, Object values) {
        return NotationOfSchedule.ParseEvents(times, values, WeeklyScheduleHelper.StartOfWeek(LocalDateTime.now()), WeeklySchedule.LengthOfWeek);
    }

    private static BDynamicChoiceRange SearchChildElementForChoice(SerializableForm dataForm, String withId) {
        if (dataForm.elements != null) {
            BUInt64 persistentId = (BUInt64)dataForm.data[0];
            for (SerializableForm subform : dataForm.elements.toSerializableForms()) {
                BDynamicChoiceRange found = BDynamicChoiceRange.parse(subform, persistentId, false);
                if (null == found || !found.getId().equals(withId)) continue;
                return found;
            }
        }
        return null;
    }

    private static ISchedule[] ExtractSpecialEvents(SerializableForm dataForm) {
        if (dataForm.elements == null) {
            return new ISchedule[0];
        }
        ArrayList<ISchedule> extracted = new ArrayList<ISchedule>();
        try {
            for (SerializableForm subform : dataForm.elements.toSerializableForms()) {
                ISchedule specialEvent = NotationOfSchedule.TryParseToSpecialEvent(subform);
                if (null == specialEvent) continue;
                extracted.add(specialEvent);
            }
            return extracted.toArray(new ISchedule[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ISchedule[0];
        }
    }

    private static ISchedule TryParseToSpecialEvent(SerializableForm someData) {
        ISchedule schedule = null;
        if (someData == null || someData.data == null) {
            return null;
        }
        schedule = ScheduleData.ExtractIrregularSchedule(someData.data);
        if (null == schedule) {
            return null;
        }
        try {
            schedule = ScheduleDailyExtension.Adjust(schedule.getScheduleName(), schedule.getPriority(), schedule, NotationOfSchedule.ParseEvents(schedule, someData.data[3], someData.data[4], LocalDateTime.now().toLocalDate(), Period.ofDays(1)));
        }
        catch (Exception e) {
            e.printStackTrace();
            schedule = null;
        }
        return schedule;
    }

    private static ScheduleEvent[] ParseEvents(Object timesContainer, Object valuesContainer, LocalDate periodStart, Period periodLength) {
        return NotationOfSchedule.ParseEvents(null, timesContainer, valuesContainer, periodStart, periodLength);
    }

    private static ScheduleEvent[] ParseEvents(ISchedule schedule, Object timesContainer, Object valuesContainer, LocalDate periodStart, Period periodLength) {
        Object[] asObjects = ((Array)timesContainer).array();
        Integer[] changeTimes = new Integer[asObjects.length];
        for (int i = 0; i < asObjects.length; ++i) {
            changeTimes[i] = ((Long)asObjects[i]).intValue();
        }
        asObjects = ((Array)valuesContainer).array();
        Double[] values = new Double[asObjects.length];
        for (int i = 0; i < asObjects.length; ++i) {
            values[i] = (Double)asObjects[i];
        }
        ArrayList<ScheduleEvent> allEvents = new ArrayList<ScheduleEvent>();
        for (int i = 0; i < changeTimes.length; ++i) {
            if (Double.isNaN(values[i])) continue;
            LocalDateTime start = LocalDateTime.of(periodStart, LocalTime.MIN).plus(Duration.ofSeconds(changeTimes[i].intValue()));
            boolean isMore = changeTimes.length > i + 1;
            LocalDateTime end = LocalDateTime.of(periodStart, LocalTime.MIN).plus(isMore ? Duration.ofSeconds(changeTimes[i + 1].intValue()) : periodLength);
            allEvents.add(new ScheduleEvent(start, values[i], end));
        }
        if (null != schedule) {
            schedule.getValues().Set(Arrays.stream(changeTimes).mapToLong(Integer::intValue).toArray(), Arrays.stream(values).mapToDouble(Double::doubleValue).toArray());
        }
        return allEvents.toArray(new ScheduleEvent[0]);
    }

    private static <T> T[] MapSerializedArray(Object container) {
        Object[] asObjects = ((Array)container).array();
        Object[] mapped = new Integer[asObjects.length];
        for (int i = 0; i < asObjects.length; ++i) {
            mapped[i] = asObjects[i];
        }
        return mapped;
    }

    @FunctionalInterface
    private static interface StardDateFunction {
        public LocalDate invoke(LocalDateTime var1);
    }
}

