/*
 * Decompiled with CFR 0.152.
 */
package com.ismacontrolli.ifnetclient.model.scheduleLogic;

import com.ismacontrolli.ifnetclient.model.scheduleLogic.EventsTable;
import com.ismacontrolli.ifnetclient.model.scheduleLogic.ISchedule;
import com.ismacontrolli.ifnetclient.model.scheduleLogic.RawIScheduleData;
import com.ismacontrolli.ifnetclient.model.scheduleLogic.ScheduleValue;
import java.time.Duration;
import java.time.LocalDateTime;
import javax.baja.schedule.BCompositeSchedule;
import javax.baja.sys.BLong;

public abstract class IrregularDays
implements ISchedule {
    private String Name;
    private byte Priority = (byte)16;
    private EventsTable Values = new EventsTable(ScheduleValue.dayLength);

    @Override
    public final String getScheduleName() {
        return this.Name;
    }

    public final void setName(String value) {
        this.Name = value;
    }

    @Override
    public final byte getPriority() {
        return this.Priority;
    }

    public final void setPriority(byte value) {
        this.Priority = value;
    }

    @Override
    public final EventsTable getValues() {
        return this.Values;
    }

    @Override
    public final ScheduleValue Calculate(LocalDateTime forMoment) {
        boolean isActuallyRelevant;
        LocalDateTime startOfNearestDay = LocalDateTime.now();
        if (this.getValues().isEmpty() || !(this instanceof ISchedule ? this : null).NearestRelevantDay(forMoment, startOfNearestDay)) {
            return ScheduleValue.getEmpty();
        }
        Duration timeInThisDay = Duration.ofSeconds(forMoment.toLocalTime().toSecondOfDay());
        Double actualValue = null;
        Duration time2next = null;
        Double next = null;
        if (!this.getValues().ValuesForTime(timeInThisDay, actualValue, time2next, next)) {
            return ScheduleValue.getEmpty();
        }
        if (!this.IsRelevantDayNow(startOfNearestDay, forMoment)) {
            Duration tempTime2next = null;
            Double tempNext = null;
            this.getValues().ValuesForTime(Duration.ZERO, next, tempTime2next, tempNext);
            time2next = Duration.ZERO;
        }
        if ((isActuallyRelevant = this.IsActuallyRelevant(actualValue, startOfNearestDay, forMoment)) && this.IsNextOnTheSameDay(time2next, forMoment)) {
            LocalDateTime timeOfNext = forMoment.plus(time2next);
            return new ScheduleValue(actualValue, timeOfNext, next);
        }
        Duration lengthInNextDay = Duration.ZERO;
        if (isActuallyRelevant && this.IsContinuedInNextDay(forMoment, lengthInNextDay)) {
            if (lengthInNextDay.equals(Duration.ofMillis(BLong.MAX.getLong()))) {
                return new ScheduleValue(actualValue, LocalDateTime.MAX, actualValue);
            }
            return new ScheduleValue(actualValue, startOfNearestDay.plus(lengthInNextDay), Double.NaN);
        }
        if (isActuallyRelevant) {
            return new ScheduleValue(actualValue, startOfNearestDay.plus(ScheduleValue.dayLength), Double.NaN);
        }
        if (this.IsNextOnTheSameDay(time2next, forMoment)) {
            LocalDateTime timeOfNext = startOfNearestDay.plus(Duration.ofSeconds(forMoment.toLocalTime().toSecondOfDay())).plus(time2next);
            return new ScheduleValue(Double.NaN, timeOfNext, next);
        }
        LocalDateTime nextRelevantDay = LocalDateTime.MIN;
        if (!this.NearestRelevantDay(forMoment.plus(ScheduleValue.dayLength), nextRelevantDay)) {
            return ScheduleValue.getEmpty();
        }
        Double otherDayFirst = null;
        Duration otherDayTime2next = Duration.ZERO;
        Double otherDayNext = null;
        this.getValues().ValuesForTime(Duration.ZERO, otherDayFirst, otherDayTime2next, otherDayNext);
        if (this.IsRelevant(otherDayFirst)) {
            return new ScheduleValue(Double.NaN, nextRelevantDay, otherDayFirst);
        }
        if (this.IsRelevant(otherDayNext)) {
            return new ScheduleValue(Double.NaN, nextRelevantDay.plus(otherDayTime2next), otherDayNext);
        }
        return ScheduleValue.getEmpty();
    }

    boolean IsRelevantDayNow(LocalDateTime startOfNearestDay, LocalDateTime forMoment) {
        return startOfNearestDay.isEqual(forMoment) || startOfNearestDay.isBefore(forMoment);
    }

    boolean IsRelevant(double value) {
        return false == Double.isNaN(value);
    }

    boolean IsActuallyRelevant(double value, LocalDateTime startOfNearestDay, LocalDateTime forMoment) {
        return this.IsRelevant(value) && startOfNearestDay.isEqual(forMoment);
    }

    boolean IsNextOnTheSameDay(Duration time2next, LocalDateTime forMoment) {
        return time2next.compareTo(Duration.ZERO) > 0 && time2next.compareTo(ScheduleValue.dayLength.minus(Duration.ofSeconds(forMoment.toLocalTime().toSecondOfDay()))) > 0;
    }

    boolean IsContinuedInNextDay(LocalDateTime afterMoment, Duration lengthOfValuePeriodAfterDayEnd) {
        Double valueForMoment = null;
        Duration valueLength = Duration.ZERO;
        Double next = null;
        Duration timeInThisDay = Duration.ofSeconds(afterMoment.toLocalTime().toSecondOfDay());
        this.Values.ValuesForTime(timeInThisDay, valueForMoment, valueLength, next);
        if (valueLength.compareTo(Duration.ofMillis(BLong.MAX.getLong())) < 0) {
            lengthOfValuePeriodAfterDayEnd = Duration.ZERO;
            return false;
        }
        LocalDateTime nextRelevantDay = LocalDateTime.MIN;
        if (!this.NearestRelevantDay(afterMoment.plus(ScheduleValue.dayLength), nextRelevantDay) || !nextRelevantDay.isEqual(afterMoment.plus(ScheduleValue.dayLength))) {
            lengthOfValuePeriodAfterDayEnd = Duration.ZERO;
            return false;
        }
        int nrOfDays = 1;
        LocalDateTime nextDay = afterMoment.plus(ScheduleValue.dayLength);
        LocalDateTime nextDayWithValue = LocalDateTime.MIN;
        while (this.NearestRelevantDay(nextDay, nextDayWithValue) && nextDayWithValue.toLocalDate().equals(nextDay.toLocalDate())) {
            try {
                nextDay = nextDay.plus(ScheduleValue.dayLength);
                ++nrOfDays;
            }
            catch (Exception outOfRange) {
                System.out.println("wild cards in date range not supported");
                break;
            }
        }
        Double firstValue = null;
        Duration time2next = Duration.ZERO;
        Double nextValue = null;
        this.Values.ValuesForTime(Duration.ZERO, firstValue, time2next, nextValue);
        lengthOfValuePeriodAfterDayEnd = Duration.ofDays(nrOfDays);
        return firstValue.equals(valueForMoment);
    }

    @Override
    public abstract boolean NearestRelevantDay(LocalDateTime var1, LocalDateTime var2);

    protected abstract boolean ValidateRawData(Object var1);

    protected abstract void SetRawData(Object var1);

    protected abstract Object RawData();

    @Override
    public final boolean ApplyRawData(RawIScheduleData compressed) {
        if (!this.ValidateRawData(compressed.daysDefinition) || !this.getValues().Set(compressed.eventsTimes, compressed.eventsValues)) {
            return false;
        }
        this.setName(compressed.name);
        this.setPriority(compressed.bacnetPriority);
        this.SetRawData(compressed.daysDefinition);
        return true;
    }

    @Override
    public final RawIScheduleData ExtractRawData() {
        long[] times = this.getValues().GetChangeTimes();
        double[] values = this.getValues().GetValues();
        return new RawIScheduleData(BCompositeSchedule.class.toString(), times, values, this.RawData(), this.getScheduleName(), this.getPriority());
    }
}

