/*
 * Decompiled with CFR 0.152.
 */
package com.ismacontrolli.ifnetclient.comm;

import com.ismacontrolli.ifnetclient.Internal.Notation;
import com.ismacontrolli.ifnetclient.comm.ConnectionResult;
import com.ismacontrolli.ifnetclient.comm.Endpoint;
import com.ismacontrolli.ifnetclient.comm.IFNetClientException;
import com.ismacontrolli.ifnetclient.comm.Response;
import com.ismacontrolli.ifnetclient.comm.Session;
import com.ismacontrolli.ifnetclient.model.RemoteDevice;
import com.ismacontrolli.ifnetclient.utils.Action1Param;
import com.ismacontrolli.ifnetclient.utils.Event;
import com.ismacontrolli.ifnetclient.utils.IfnetClientLogger;
import com.ismacontrolli.serialization.DataMarker;
import com.ismacontrolli.serialization.SerializableCollection;
import com.ismacontrolli.serialization.SerializableForm;
import com.tridium.nre.util.tuple.Pair;
import java.net.MalformedURLException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Level;
import javax.baja.util.BUuid;

public class Server {
    public final String ip;
    public final int port;
    public final Event<Action1Param<Server>> OnConnectionChange = new Event();
    String[] endpoints = Endpoint.LegacyEndpoints;
    private Session session;
    private String ifnetVersion = RemoteDevice.defaultIfnetVersion;

    public Server(String atIP, int atPort) {
        this.ip = atIP;
        this.port = atPort;
    }

    public final Pair<ArrayList<SerializableForm>, ConnectionResult> Connect(String username, String password) {
        IfnetClientLogger.log(Level.INFO, String.format("[Server.Connect] Connect to device: %s at port %d; username %s password %s\"", this.ip, this.port, username, "***"));
        this.session = new Session(this);
        String salt = "";
        BUuid nonce = null;
        ArrayList<SerializableForm> result = new ArrayList<SerializableForm>();
        this.ifnetVersion = RemoteDevice.defaultIfnetVersion;
        this.endpoints = Endpoint.LegacyEndpoints;
        if (this.isConnected()) {
            IfnetClientLogger.log(Level.INFO, String.format("%1$s - already connected.", this.ip));
            return new Pair(result, (Object)ConnectionResult.CONNECTED);
        }
        ConnectionResult isReachable = this.DoConnect(salt, nonce, username, password, result);
        if (ConnectionResult.CONNECTED != isReachable) {
            if (null != this.session) {
                this.Disconnect(true);
            }
            IfnetClientLogger.log(Level.SEVERE, String.format("Could not reach to: %1$s:%2$s.", this.ip, this.port));
            return new Pair(result, (Object)isReachable);
        }
        if (this.OnConnectionChange != null) {
            for (Action1Param<Server> listener : this.OnConnectionChange.listeners()) {
                listener.invoke(this);
            }
        }
        result.add(new SerializableForm(DataMarker.IFNetInfoData, new Object[]{this.ifnetVersion, this.endpoints}));
        return new Pair(result, (Object)isReachable);
    }

    ConnectionResult DoConnect(String salt, BUuid nonce, String username, String password, ArrayList<SerializableForm> errors) {
        IfnetClientLogger.log(Level.INFO, String.format("[Server.DoConnect] Connecting to device: %s at port %d", this.ip, this.port));
        SerializableForm identificationData = Notation.Identification(username);
        boolean ok = false;
        Response response = this.session.Execute(Endpoint.Connect, identificationData);
        try {
            boolean bl = ok = response != null && response.isValid() && response.status == 200 && response.content.length == 1;
            if (ok) {
                SerializableCollection responseData = response.content[0].elements;
                String signatureData = responseData.First().data[0].toString();
                nonce = BUuid.make((String)signatureData);
                salt = responseData.First().data[1].toString();
                this.ifnetVersion = responseData.Last().data[0].toString();
                ConnectionResult authorized = this.DoAuthorize(salt, nonce, password, errors);
                return authorized;
            }
            return ConnectionResult.FAILED;
        }
        catch (Exception e) {
            e.printStackTrace();
            return ConnectionResult.FAILED;
        }
    }

    ConnectionResult DoAuthorize(String salt, BUuid nonce, String password, ArrayList<SerializableForm> errors) {
        IfnetClientLogger.log(Level.INFO, String.format("[Server.DoAuthorize] Authorizing connection with device: %s at port %d", this.ip, this.port));
        try {
            MessageDigest sha256 = MessageDigest.getInstance("SHA-256");
            byte[] hashedPassword = sha256.digest((salt + password).getBytes(StandardCharsets.UTF_8));
            byte[] passwordData = sha256.digest((nonce.toString() + this.HashToString(hashedPassword)).getBytes(StandardCharsets.UTF_8));
            SerializableForm authorizationData = Notation.Authorization(nonce, this.HashToString(passwordData));
            Response response = this.session.Execute(Endpoint.Authorize, authorizationData);
            try {
                if (response == null || response.status == 401) {
                    throw IFNetClientException.Unauthenticated;
                }
                this.AppendErrors(response, errors);
                SerializableForm content = response.content[0].elements.First();
                this.endpoints = this.Endpoints(content.elements);
                String sessionId = content.data[0].toString();
                this.session.SetId(BUuid.make((String)sessionId));
                if (this.session.getID() != BUuid.DEFAULT) {
                    return ConnectionResult.CONNECTED;
                }
            }
            catch (Exception error) {
                IfnetClientLogger.log(Level.SEVERE, MessageFormat.format("Wrong authorization data in response {0}", error.getMessage()));
                return ConnectionResult.NOT_AUTHENTICATED;
            }
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        return ConnectionResult.NOT_AUTHENTICATED;
    }

    void AppendErrors(Response fromResponse, ArrayList<SerializableForm> errors) {
        try {
            SerializableForm[] errorsInResponse;
            SerializableForm[] serializableFormArray = fromResponse == null ? null : (errorsInResponse = fromResponse.Errors() != null ? fromResponse.Errors() : new SerializableForm[]{});
            if (errorsInResponse.length > 0) {
                errors.addAll(Arrays.asList(errorsInResponse));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    String HashToString(byte[] hash) {
        StringBuilder hexString = new StringBuilder(2 * hash.length);
        for (int i = 0; i < hash.length; ++i) {
            String hex = Integer.toHexString(0xFF & hash[i]);
            if (hex.length() == 1) {
                hexString.append('0');
            }
            hexString.append(hex);
        }
        return hexString.toString();
    }

    public final void Disconnect(boolean raiseConnectionChange) {
        if (this.session != null) {
            this.session.Kill();
            this.session = null;
        }
        if (raiseConnectionChange) {
            for (Action1Param<Server> listener : this.OnConnectionChange.listeners()) {
                listener.invoke(this);
            }
        }
    }

    public void ProcessConnectionError(Session problematicSession, int responseStatus) {
        boolean raiseConnectionChange = true;
        switch (responseStatus) {
            case 401: {
                IfnetClientLogger.log(Level.SEVERE, "Unauthorized request.");
                raiseConnectionChange = false;
                break;
            }
            case 408: 
            case 504: {
                IfnetClientLogger.log(Level.SEVERE, "Connection timed out.");
                break;
            }
            case 400: {
                IfnetClientLogger.log(Level.SEVERE, "Bad Request.");
                break;
            }
            case 500: {
                IfnetClientLogger.log(Level.SEVERE, "Internal server error.");
                break;
            }
            default: {
                String log = responseStatus == 200 ? "no body" : String.format("wrong response status %1$s", responseStatus);
                IfnetClientLogger.log(Level.SEVERE, String.format("Bad response: %1$s", log));
            }
        }
        if (responseStatus != 200 && responseStatus != 400 && responseStatus != 500) {
            this.Disconnect(raiseConnectionChange);
        }
    }

    public final String getAddress() throws MalformedURLException {
        return String.format("http://%1$s:%2$s/", this.ip, this.port);
    }

    public final boolean isConnected() {
        return this.session != null && this.session.isConnected();
    }

    public final String getVersion() {
        return this.ifnetVersion;
    }

    public final void setVersion(String value) {
        this.ifnetVersion = value;
    }

    String[] Endpoints(SerializableCollection fromData) {
        if (fromData == null || fromData.Count == 0) {
            return Endpoint.LegacyEndpoints;
        }
        String[] processedEndpoints = new String[fromData.Count];
        for (int i = 0; i < fromData.Count; ++i) {
            processedEndpoints[i] = fromData.ToArray()[i].data[0].toString();
        }
        return processedEndpoints;
    }

    public final ArrayList<SerializableForm> Logs() {
        return this.Perform(Endpoint.Logs, new SerializableForm[]{null});
    }

    public final ArrayList<SerializableForm> Schema() {
        return this.Perform(Endpoint.Schema, new SerializableForm[]{null});
    }

    public final ArrayList<SerializableForm> Tree() {
        return this.Perform(Endpoint.Tree, new SerializableForm[]{null});
    }

    public final ArrayList<SerializableForm> Subscribe(SerializableForm subscriptions) {
        return this.Perform(Endpoint.Subscribe, subscriptions);
    }

    public final ArrayList<SerializableForm> Poll() {
        return this.Perform(Endpoint.Poll, new SerializableForm[0]);
    }

    public final ArrayList<SerializableForm> Unsubscribe(SerializableForm subscriptions) {
        return this.Perform(Endpoint.Unsubscribe, subscriptions);
    }

    public final ArrayList<SerializableForm> Invoke(SerializableForm actionsData) {
        return this.Perform(Endpoint.Invoke, actionsData);
    }

    public final ArrayList<SerializableForm> Add(SerializableForm ... newComponentsData) {
        return this.Perform(Endpoint.Add, newComponentsData);
    }

    public final ArrayList<SerializableForm> Link(SerializableForm ... linksData) {
        return this.Perform(Endpoint.Link, linksData);
    }

    public final ArrayList<SerializableForm> Remove(SerializableForm identifiersData) {
        return this.Perform(Endpoint.Remove, identifiersData);
    }

    public final ArrayList<SerializableForm> Rename(SerializableForm ... parameters) {
        return this.Perform(Endpoint.Rename, parameters);
    }

    public final ArrayList<SerializableForm> Reorder(SerializableForm newOrderData) {
        return this.Perform(Endpoint.Reorder, newOrderData);
    }

    public final ArrayList<SerializableForm> Move(SerializableForm moveData) {
        return this.Perform(Endpoint.Move, moveData);
    }

    public final ArrayList<SerializableForm> Unlink(SerializableForm ... linksData) {
        return this.Perform(Endpoint.Unlink, linksData);
    }

    public final ArrayList<SerializableForm> Write(SerializableForm ... slotsData) {
        return this.Perform(Endpoint.Write, slotsData);
    }

    public final ArrayList<SerializableForm> AddExtension(SerializableForm ... extensionData) {
        return this.Perform(Endpoint.Extend, extensionData);
    }

    public final ArrayList<SerializableForm> RemoveExtension(SerializableForm ... extensionData) {
        return this.Perform(Endpoint.Shrink, extensionData);
    }

    public final ArrayList<SerializableForm> Transform(SerializableForm ... newExtensionsOrder) {
        return this.Perform(Endpoint.Extend, newExtensionsOrder);
    }

    public final ArrayList<SerializableForm> Libraries() {
        return this.Perform(Endpoint.Libraries, new SerializableForm[]{null});
    }

    public final ArrayList<SerializableForm> UpdateAttributes(SerializableForm ... attrData) {
        return this.Perform(Endpoint.UpdateAttr, attrData);
    }

    public final ArrayList<SerializableForm> FileDelete(SerializableForm pathData) {
        return this.Perform(Endpoint.FileDelete, pathData);
    }

    public final ArrayList<SerializableForm> FileGet(SerializableForm pathData) {
        return this.Perform(Endpoint.FileGet, pathData);
    }

    public final ArrayList<SerializableForm> FilePut(SerializableForm fileData) {
        return this.Perform(Endpoint.FilePut, fileData);
    }

    public final ArrayList<SerializableForm> Folder(SerializableForm ... pathsData) {
        return this.Perform(Endpoint.Folder, pathsData);
    }

    public final ArrayList<SerializableForm> FolderDelete(SerializableForm ... pathsData) {
        return this.Perform(Endpoint.FolderDelete, pathsData);
    }

    public final ArrayList<SerializableForm> Tag(SerializableForm ... setsOfNewTags) {
        return this.Perform(Endpoint.Tag, setsOfNewTags);
    }

    public final ArrayList<SerializableForm> Untag(SerializableForm ... setsOfRemovedTags) {
        return this.Perform(Endpoint.Untag, setsOfRemovedTags);
    }

    public final ArrayList<SerializableForm> Schedule(SerializableForm ... schedulesForms) {
        return this.Perform(Endpoint.Schedule, schedulesForms);
    }

    public final ArrayList<SerializableForm> Labels(SerializableForm ... labelsForm) {
        return this.Perform(Endpoint.Labels, labelsForm);
    }

    public final ArrayList<SerializableForm> GetTrend(SerializableForm ... trend) {
        return this.Perform(Endpoint.GetTrend, trend);
    }

    public final ArrayList<SerializableForm> ClearTrend(SerializableForm ... trend) {
        return this.Perform(Endpoint.ClearTrend, trend);
    }

    private ArrayList<SerializableForm> Perform(Endpoint target, SerializableForm ... parameters) {
        if (!this.isConnected()) {
            IfnetClientLogger.log(Level.SEVERE, "Can't perform request. Not connected.");
            return null;
        }
        ArrayList<SerializableForm> errors = new ArrayList<SerializableForm>();
        try {
            Response response = this.session.Execute(target, parameters);
            if (response == null || response.status == 401) {
                IfnetClientLogger.log(Level.SEVERE, String.format("Null answer for %s. Connection timed out.", target));
                this.Disconnect(true);
                throw IFNetClientException.Unauthenticated;
            }
            this.AppendErrors(response, errors);
            ArrayList<SerializableForm> details = response.content == null ? null : new ArrayList<SerializableForm>(Arrays.asList(response.content));
            return details != null && details.size() > 0 ? details : new ArrayList<SerializableForm>();
        }
        catch (Exception e) {
            IfnetClientLogger.log(Level.SEVERE, String.format("Failed to parse response for: %s error: %s", target, e.getMessage()));
            return null;
        }
    }

    public String toString() {
        return String.format("%1$s:%2$s", this.ip, this.port);
    }
}

