/*
 * Decompiled with CFR 0.152.
 */
package com.ismacontrolli.ifnetclient.comm;

import com.ismacontrolli.ifnetclient.Internal.Helper;
import com.ismacontrolli.ifnetclient.Internal.IRequestComplete;
import com.ismacontrolli.ifnetclient.Internal.Notation;
import com.ismacontrolli.ifnetclient.comm.Endpoint;
import com.ismacontrolli.ifnetclient.comm.Request;
import com.ismacontrolli.ifnetclient.comm.RequestExecutionImplementation;
import com.ismacontrolli.ifnetclient.comm.Response;
import com.ismacontrolli.ifnetclient.utils.IfnetClientLogger;
import com.ismacontrolli.serialization.SerializableForm;
import com.ismacontrolli.serialization.internal.EndOfStreamException;
import com.ismacontrolli.serialization.internal.InvalidCastException;
import java.text.MessageFormat;
import java.util.logging.Level;
import javax.baja.util.Queue;

public class RequestsQueue {
    private Queue pending = new Queue();
    private RequestExecutionImplementation requestHandling;
    private boolean terminated;

    public RequestsQueue(RequestExecutionImplementation implementation) {
        this.requestHandling = implementation;
        Thread communicationLoop = new Thread(){

            @Override
            public void run() {
                RequestsQueue.this.CommunicationLoop();
            }
        };
        communicationLoop.setName("communication");
        communicationLoop.start();
    }

    public final int getCount() {
        return this.pending.size();
    }

    public final void Kill() {
        this.terminated = true;
    }

    public final boolean Append(Endpoint request, IRequestComplete callback, SerializableForm ... parameters) throws Exception {
        if (this.terminated) {
            return false;
        }
        Request tempVar = new Request();
        tempVar.endpoint = request;
        tempVar.callback = callback;
        tempVar.body = null != parameters && parameters.length > 0 ? Notation.RequestData(request.marker, parameters) : null;
        this.pending.enqueue((Object)tempVar);
        return true;
    }

    private void CommunicationLoop() {
        Request next;
        while (!this.terminated && this.pending != null) {
            if (this.pending.size() == 0) {
                try {
                    Thread.sleep(25L);
                }
                catch (InterruptedException e) {
                    IfnetClientLogger.log(Level.SEVERE, MessageFormat.format("Thread.sleep caught an InterruptedException: {0}", e.getMessage()));
                }
                continue;
            }
            next = null;
            try {
                next = (Request)this.pending.dequeue();
                this.requestHandling.invoke(next);
            }
            catch (Exception e) {
                IfnetClientLogger.log(Level.SEVERE, MessageFormat.format(Helper.IsTimeout(e) ? "Timed out: {0}" : "Failed to execute {0}:  {1}", next.endpoint.toString(), e.getMessage()));
                try {
                    if (next.callback == null) continue;
                    next.callback.invoke(Response.Failed(next.endpoint, 400));
                }
                catch (EndOfStreamException | InvalidCastException | Exception ex) {
                    IfnetClientLogger.log(Level.SEVERE, MessageFormat.format("caught an exception: {0}", ex.getMessage()));
                }
            }
        }
        while (this.pending != null && !this.pending.isEmpty()) {
            try {
                next = (Request)this.pending.dequeue();
                this.requestHandling.invoke(next);
                if (next.callback == null) continue;
                next.callback.invoke(null);
            }
            catch (Exception e) {
                IfnetClientLogger.log(Level.SEVERE, MessageFormat.format("caught an exception: {0}", e.getMessage()));
            }
        }
    }
}

