/*
 * Decompiled with CFR 0.152.
 */
package com.ismacontrolli.ifnetclient.comm;

import com.ismacontrolli.ifnetclient.comm.Endpoint;
import com.ismacontrolli.ifnetclient.comm.Request;
import com.ismacontrolli.ifnetclient.comm.Response;
import com.ismacontrolli.ifnetclient.comm.Session;
import com.ismacontrolli.ifnetclient.utils.Action2Param;
import com.ismacontrolli.ifnetclient.utils.Event;
import com.ismacontrolli.ifnetclient.utils.IfnetClientLogger;
import com.ismacontrolli.serialization.internal.EndOfStreamException;
import com.ismacontrolli.serialization.internal.InvalidCastException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.MessageFormat;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.concurrent.FutureTask;
import java.util.logging.Level;
import javax.baja.net.Http;
import javax.baja.net.HttpConnection;
import javax.baja.net.HttpConnectionFactory;

public final class HttpImplementation {
    public final Event<Action2Param<Session, Http>> OnBadResponse = new Event();
    private int BUFFER_LENGTH = 1024;
    private HttpConnection connection = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FutureTask<?> Execute(Session session, Request next) {
        try {
            this.prepareRequest(session, next);
            int status = this.connection.getStatusCode();
            byte[] readBytes = this.connection.readContent();
            this.ProcessResponse(next, readBytes, status, session);
        }
        catch (Exception e) {
            e.printStackTrace();
            int status = 408;
            byte[] readBytes = new byte[]{};
            this.ProcessResponse(next, readBytes, status, session);
        }
        finally {
            if (this.connection != null) {
                this.connection.close();
            }
        }
        return null;
    }

    private void prepareRequest(Session session, Request next) throws IOException {
        URL url = new URL(session.target.getAddress() + next.endpoint.address);
        this.connection = HttpConnectionFactory.make((String)url.toString());
        this.connection.setRequestMethod(Endpoint.Method.Post.toString().toUpperCase());
        this.connection.setRequestHeader("Session-Id", session.getID().toString());
        int length = next.body != null ? next.body.length : 0;
        this.connection.setRequestHeader("ContentLength", Integer.toString(length));
        this.connection.setRequestHeader("Content-Length", Integer.toString(length));
        LocalDateTime start = LocalDateTime.now();
        if (next.body != null) {
            ByteArrayInputStream requestContent = new ByteArrayInputStream(next.body);
            this.connection.connect((long)next.body.length, (InputStream)requestContent);
        } else {
            this.connection.connect();
        }
        Duration duration = Duration.between(start, LocalDateTime.now());
        IfnetClientLogger.log(Level.FINEST, MessageFormat.format("Processed {0} in {1}ms", next.endpoint.address, duration.toMillis()));
    }

    private void ProcessResponse(Request next, byte[] readBytes, int status, Session session) {
        Response answer = new Response(next.endpoint);
        try {
            answer = new Response(next.endpoint, status, readBytes);
            if (answer.status != 200 && this.OnBadResponse != null) {
                for (Action2Param<Session, Http> listener : this.OnBadResponse.listeners()) {
                    listener.invoke(session, answer.status);
                }
            }
        }
        catch (EndOfStreamException | InvalidCastException | Exception e) {
            e.printStackTrace();
        }
        if (next.callback != null) {
            next.callback.invoke(answer);
        }
    }
}

