/**
 * @file Custom enclosingPoint jQuery selector.
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

define(['jquery'], function ($) {

  "use strict";

  /**
   * jQuery custom selector that returns all elements whose boundaries
   * (calculated using `.offset()`, not `.position()`) enclose the given
   * coordinates. Installed using the standard
   * `$.expr[':'].enclosingPoint = enclosingPoint`
   * 
   * @memberOf niagara.util.customSelectors
   */

  function enclosingPoint(obj, index, meta, stack) {
    var elem = $(obj),
        pos = elem.offset(),
        params = meta[3].split(','),
        x = parseInt(params[0], 10),
        y = parseInt(params[1], 10);
    return y >= pos.top && y < pos.top + elem.height() && x >= pos.left && x < pos.left + elem.width();
  }

  $.extend($.expr[':'], {
    enclosingPoint: enclosingPoint
  });

  return $;
});
