/**
 * @file
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/*global niagara: false, baja: false */

(function testScheduleFieldEditors() {
  "use strict";

  var fe = niagara.fieldEditors,
      testFe = niagara.test.fieldEditors,
      buildHtml = testFe.buildHtml,
      verifyLoadValue = testFe.verifyLoadValue,
      verifySaveValue = testFe.verifySaveValue,
      mock = niagara.test.mock.mock;

  describe("timeSchedule editor", function timeScheduleEditor() {
    var editor,
        start = baja.Time.make(0),
        finish = baja.Time.make(3600000),
        value = mock('baja:StatusBoolean').addProp('status', baja.Status.ok).addProp('value', true),
        timeSchedule = mock('schedule:TimeSchedule').addProp('start', start).addProp('finish', finish).addProp('effectiveValue', value),
        newSchedule = mock('schedule:TimeSchedule').addProp('start', baja.Time.make(3600000 * 2)).addProp('finish', baja.Time.make(3600000 * 4)).addProp('effectiveValue', mock('baja:StatusBoolean').addProp('status', baja.Status.nullStatus).addProp('value', false));

    beforeEach(function () {
      editor = fe.getFieldEditor(timeSchedule);
      buildHtml(editor);
    });

    it("exists", function exists() {
      expect(editor).toBeDefined();
    });

    function verifyDiv(div, startInputVal, finishInputVal, selectVal, checked) {
      expect(div.find('input#start').val()).toEqual(startInputVal);
      expect(div.find('input#finish').val()).toEqual(finishInputVal);
      expect(div.find('select#effectiveValue').val()).toEqual(selectVal);
      expect(div.find('#effectiveValue_nulldefault').is(':checked')).toEqual(checked);
    }

    it("gives me a div", function givesMeADiv() {
      expect(editor.div).toBeDefined();

      verifyDiv(editor.div, '00:00', '01:00', 'true', false);
    });

    function verifyLoad(value, startInputVal, finishInputVal, selectVal, checked) {
      verifyLoadValue(editor, value, function (div) {
        verifyDiv(div, startInputVal, finishInputVal, selectVal, checked);
      });
    }

    it("sets my value", function setsMyValue() {
      verifyLoad(newSchedule, '02:00', '04:00', 'false', true);
    });

    it("doesn't die when i pass in null", function setNull() {
      verifyLoad(newSchedule, '02:00', '04:00', 'false', true);
      verifyLoad(undefined, '02:00', '04:00', 'false', true);
    });

    it("saves my value", function savesMyValue() {
      verifySaveValue(editor, function (value) {
        return value.getStart().getTimeOfDayMillis() === 3600000 * 5 && value.getFinish().getTimeOfDayMillis() === 3600000 * 6.5 && value.getEffectiveValue().getValue() === false && value.getEffectiveValue().getStatus() === baja.Status.nullStatus;
      }, function (div) {
        div.find('input#start').val('05:00').trigger('change');
        div.find('input#finish').val('06:30').trigger('change');
        div.find('select#effectiveValue').val('false');
        div.find('input#effectiveValue_nulldefault').attr('checked', 'checked');
      });
    });
  });
})();
