/**
 * @file Time-related utilities.
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * @file AOP utilities.
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * @file Slot-related utilities.
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * @file Mobile-related utilities.
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * @file Niagara Mobile Utils - Pages
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Gareth Johnson
 */

/**
 * @file Functions related to the management and display of JQM
 * dialog boxes.
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * @file Niagara Mobile Utils - functions relating to the
 * "available commands" button and associated dialog in our JQM page headers
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Gareth Johnson
 */

/**
 * @file A base class for views used in JQM apps.
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * @file A component view showing a list of radio buttons.
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * @file Functions relating to the BaseFieldEditor object that all
 * field editors in Niagara mobile apps extend from. Also, functions relating
 * to registering field editors on Types.
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * @file Base field editor from which all others inherit.
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * @file Composite field editors.
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * @file Dialogs relating to field editors, including action invocation.
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * @file Field editors for use in a JQM app.
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * @copyright 2017 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * @file ORD-related utilities.
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * @file The built-in field editors available to all Niagara Mobile
 * apps. These field editors make use of jQuery Mobile with the Datebox plugin.
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * @file Utility functions for the mobile scheduler app.
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * @file Color utilities.
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * @file Gradient utilities.
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * @file Utilities for managing color gradients in the schedule app.
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * @file Functions relating to the ScheduleBlock object that contains a
 * BTimeSchedule component within a Day.
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * @file Custom enclosingPoint jQuery selector.
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * @file Functions relating to day editing (block resizing, dragging,
 * etc.) within the mobile scheduler app.
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * @file Functions relating to the DayEditor field editor for a
 * `schedule:DaySchedule` object.
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * @file Functions relating to the Schedule object that represents
 * a BWeeklySchedule component.
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * @file Datebox utilities for the schedule app.
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * @file Functions relating to displaying and updating calendar
 * widgets within the mobile scheduler app.
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * @file
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * @file Functions relating to the field editor for trigger times on
 * a `BTriggerSchedule`'s `times` slot (a `BDaySchedule`).
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * @file Functions relating to page navigation and interaction within
 * the mobile scheduler app.
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * @file Start the mobile schedule app.
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

define("mobile/util/time",["baja!"],function(e){"use strict";function t(t){return t=(t+l)%l,e.Time.make(t)}function n(n){return n instanceof Date?n.getTime()%l:n instanceof e.Time?n.getTimeOfDayMillis():"number"==typeof n?t(n).getTimeOfDayMillis():void 0}function i(n){return n instanceof Date?n.getTime()%u:n instanceof e.Time?n.getTimeOfDayMillis()%u:"number"==typeof n?t(n).getTimeOfDayMillis()%u:void 0}function r(t){var i=n(t),r=Math.round(i/s)*s;return t instanceof Date?new Date(r):t instanceof e.Time?e.Time.make({relTime:e.RelTime.make(r)}):"number"==typeof t?r:void 0}function a(e){return(e<10?"0":"")+e}function o(e,t,n){return[a(e),a(t),a(n||0)].join(":")}var l=864e5,u=36e5,s=18e5;return{MILLIS_IN_DAY:l,MILLIS_IN_HOUR:u,MILLIS_IN_HALF_HOUR:s,MILLIS_IN_MINUTE:6e4,MILLIS_IN_SECOND:1e3,makeTime:t,millisOfDay:n,millisOfHour:i,roundToHalfHour:r,toTimeString:o,zeroPad:a}});var _typeof="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e};define("mobile/util/aop",["baja!"],function(e){"use strict";function t(t,n){return e.iterate(t,function(e){return e[n]},function(e){return e.prototype})}function n(e,i,r,a){if("function"!=typeof a)throw"missing AOP function wrapper";var o,l;if("function"==typeof e&&"function"==typeof i)return r=e,o=i,l=a(r,o),l.prototype=o.prototype,l;if("object"!==(void 0===e?"undefined":_typeof(e))&&"function"!=typeof e||"string"!=typeof i||"function"!=typeof r)throw"AOP functions must be called with argument signature [Function, Function] or [Object, String, Function]";o=t(e,i),e[i]=n(r,o,null,a)}function i(e,t,i){return n(e,t,i,function(e,t){return function(){var n=Array.prototype.slice.call(arguments),i=e.call(this,n);if(!1!==i)return t.apply(this,i||n)}})}function r(e,t,i){return n(e,t,i,function(e,t){return function(){var n=Array.prototype.slice.call(arguments),i=t.apply(this,n),r=e.call(this,n,i);return void 0===r?i:r}})}function a(t,n){e.strictArg(t,Object),n=e.objectify(n);var a=n.before||{},o=n.after||{};return e.iterate(a,function(e,n){i(t,n,e)}),e.iterate(o,function(e,n){r(t,n,e)}),t}function o(t,n){return e.strictArg(t,Function),a(t.prototype,n),t}return{advise:a,advisePrototype:o,after:r,before:i}}),define("mobile/util/slot",["baja!","jquery","Promise","underscore","baja!baja:Link,baja:Password,control:IWritablePoint"],function(e,t,n,i){"use strict";function r(e,t,n){if(t===n||t<0||n<0||t>=e.length||n>=e.length)return!1;var i=e.splice(t,1);return e.splice(n,0,i[0]),!0}function a(e,r,a,o){var l=e.getSlots().dynamic().toArray();return o(l,i.indexOf(l,e.getSlot(r)))?e.reorder(t.extend(a,{dynamicProperties:l})):n.resolve()}function o(e,t,n){return a(e,t,n,function(e,t){return r(e,t,t-1)})}function l(e,t,n){return a(e,t,n,function(e,t){return r(e,t,t+1)})}function u(e,t,n){return a(e,t,n,function(e,t){return r(e,t,0)})}function s(e,t,n){return a(e,t,n,function(e,t){return r(e,t,e.length-1)})}function c(t){var n=t.getFlags();return!!(e.Flags.CONFIRM_REQUIRED&n)}function d(t){return!!t.getType().is("baja:Password")||e.Flags.READONLY&t.getFlags()}function f(t){var n=t.getFlags();return!!(e.Flags.HIDDEN&n)||(!(!t.isProperty()||!t.getType().is("baja:Link"))||("wsAnnotation"===t.getName()||"displayNames"===t.getName()))}function p(e){return!e.getType().is("baja:Password")&&(!d(e)&&!f(e))}function h(e){return e.isAction()&&!f(e)}function m(t){var n,i,r=e.Facets.DEFAULT;return t&&t.getType().isComplex()&&(i=t.getSlots().properties().frozen().is("baja:Facets").firstValue(),"function"==typeof t.getFacets&&(n=t.getFacets())&&(r=e.Facets.make(r,n)),i&&(r=e.Facets.make(r,i))),r}function g(e){var t=e&&e.getType();if(t)return t.isComponent()?e:t.isComplex()?g(e.getParent()):void 0}function v(t,n){var i,r,a,o,l=e.Facets.DEFAULT,u=t&&t.getType();if(n&&t.getType().isComplex()&&(n=t.getSlot(n),n.isProperty()&&n.getType().isComplex()&&(t=t.get(n))),u&&u.isComplex()&&(i=g(t))&&(a=i.getType(),(r=m(i))&&(l=e.Facets.make(l,r))),n instanceof e.Slot){if(o=String(n),a&&a.is("control:IWritablePoint")&&(n.isFrozen()&&0===o.indexOf("in")||"set"===o||"fallback"===o||"override"===o||"emergencyOverride"===o))return l;l=e.Facets.make(l,n.getFacets())}return l}return{getFacets:v,isConfirmRequired:c,isEditable:p,isFireable:h,isHidden:f,isReadonly:d,moveDown:l,moveUp:o,moveToTop:u,moveToBottom:s}}),define("mobile/util/mobile/mobile",["baja!","jquery","jquerymobile","Promise"],function(e,t,n,i){"use strict";function r(e){return String(e).replace(/[&<>"'\/]/g,function(e){return x[e]})}function a(){n.loading("show")}function o(){n.loading("hide")}function l(e){var n=e.find(':jqmData(role="header")'),i=e.find(':jqmData(role="footer")'),r=window.innerHeight||t(window).height();return n.length&&(r-=n.outerHeight()),i.length&&(r-=i.outerHeight()),r}function u(e,t){var n=t||e.children(':jqmData(role="content")'),i=l(e),r=n.outerHeight()-n.height();n.height(i-r),n.parent().height(Math.max(n.parent().height(),i)),setTimeout(function(){n.trigger("updatelayout")},100)}function s(e,n,i){e.on(n,i);var r=t._data(e[0]),a=r.events,o=a[n];o.length>1&&o.splice(0,0,o.pop())}function c(t,n,i){var r=this;r.$ticket=setTimeout(function(){r.$ticket&&a()},t),n&&(r.$timeoutTicket=setTimeout(function(){if(r.$ticket){var t="timeout "+n+"ms reached";"function"==typeof i?i(t):e.error(t)}r.hide()},n))}function d(e,t,n){return new c(e||1e3,t,n)}function f(e,t){e.toggleClass("ui-listview-inset ui-corner-all ui-shadow",t);var n=e.children("li"),i=n.first(),r=n.last();i.toggleClass("ui-corner-top",t),r.toggleClass("ui-corner-bottom",t),i.children("a").last().toggleClass("ui-corner-tr",t),r.children("a").last().toggleClass("ui-corner-br",t)}function p(e){f(e,!0)}function h(e){f(e,!1)}function m(e){e.on("click","a",function(){var e=t(this);setTimeout(function(){e.removeClass(function(e,t){return"ui-btn-active "+(t.match(/\bui-btn-hover-\w/g)||[]).join(" ")})},100)})}function g(e){return e=String(e),"#"===e.charAt(0)&&(e=e.substring(1)),e.replace(w,function(e){return"_"+e.charCodeAt(0).toString(16).toUpperCase()})}function v(e){if(!e)return e;e=e instanceof t?e.attr("id"):String(e);var n=/\_([A-Z0-9][A-Z0-9])/g;return e=e.replace(n,function(e){return String.fromCharCode(parseInt(e.substring(1,e.length),16))}),unescape(e)}function y(t){var n=t&&t.viewQuery;return n||(t=e.objectify(t,"viewQuery"),n=t.viewQuery),"string"==typeof n||n&&n.id?n=new e.ViewQuery(n):!n&&t.id&&(n=new e.ViewQuery(t)),t.viewQuery=n,t}function b(t,n){n=y(n);var i;i=n.viewQuery?e.Ord.make({base:t,child:n.viewQuery}):e.Ord.make(t),window.location.assign(i.toUri())}function k(n,i){i=y(i);var r;r=i.viewQuery?e.Ord.make({base:n,child:i.viewQuery}):e.Ord.make(n),t.mobile.changePage(r.toUri(),i)}function S(n,r){var a=d(1e3);return i.resolve(t.ajax({url:e.Ord.make(n).toUri(),type:"POST",headers:{"niagara-mobile-rpc":"typeSpec"}})).then(function(e){return a.hide(),e.typeSpec===niagara.view.typeSpec?k(n,r):b(n,r)},function(e){return a.hide(),b(n,r)})}function T(e,t){E().pagecontainer("change",e,t)}function E(){return t(":mobile-pagecontainer")}function j(){return E().pagecontainer("getActivePage")}function D(e){E().length?e():t(window).one("pagecontainercreate",e)}var w=/[^\w-_]/g,x={"&":"&amp;","<":"&lt;",">":"&gt;",'"':"&quot;","'":"&#39;","/":"&#x2F;"};return c.prototype.hide=function(){o();var e=this;clearTimeout(e.$ticket),delete e.$ticket,clearTimeout(e.$timeoutTicket),delete e.$timeoutTicket},{applyListviewInset:p,changePage:T,decodePageId:v,encodePageId:g,escapeHtml:r,getActivePage:j,getPageContainer:E,getVisibleHeight:l,hidePageLoadingMsg:o,linkToOrd:S,linkToOrdExternal:b,linkToOrdInternal:k,onPageContainerCreate:D,prependEventHandler:s,preventNavbarHighlight:m,removeListviewInset:h,setContentHeight:u,showPageLoadingMsg:a,spinnerTicket:d}}),define("mobile/util/mobile/pages",["baja!","jquery","jquerymobile","mobile/util/mobile/mobile"],function(e,t,n,i){"use strict";function r(e,t){1===arguments.length&&(t=e,e=N);var n=e;return"string"==typeof n&&(n=function(t){return e===t}),M.push({isMatch:n,handler:t}),t}function a(e){if(!e)return null;var t;for(t=0;t<M.length;++t)if(M[t].isMatch(e))return M[t].handler;return null}function o(e){var t=e.page.attr("id")||N,n=a(t);n&&"function"==typeof n[e.eventName]&&n[e.eventName](e)}function l(t){t=e.objectify(t,"eventName");var n;for(n=0;n<M.length;++n)"function"==typeof M[n].handler[t.eventName]&&M[n].handler[t.eventName](t)}function u(){return x.attr("id")||""}function s(){return a(u())}function c(){return x}function d(){return C.attr("id")||""}function f(){return C}function p(){return a(d())}function h(){return w}function m(e,n){var i,r=n.toPage;n&&n.prevPage&&(i=t(n.prevPage)),x||(i=r),o({page:r,prevPage:i,event:e,eventName:"pageshow"}),"dialog"!==r.jqmData("role")&&(x=C,C=r)}function g(e,n){var i,r=t(e.target);r&&(n&&n.prevPage&&(i=t(n.prevPage)),x||(i=r),o({page:r,prevPage:i,event:e,eventName:e.type}))}function v(e,n){var i;n&&n.nextPage&&(i=t(n.nextPage)),o({page:C,nextPage:i,event:e,eventName:"pagehide"})}function y(e,n){w=!1;var i;n&&n.nextPage&&(i=t(n.nextPage)),o({page:C,nextPage:i,event:e,eventName:e.type})}function b(e,n){o({page:t(e.target),event:e,eventName:e.type})}function k(e){return e=decodeURI(e),"/"!==e.charAt(0)&&"#"!==e.charAt(0)||(e=e.substring(1)),e.match(/^ord[\?\/]/)?"ord?"+encodeURI(e.substring(4)):encodeURI(e)}function S(e){return A(k(e))}function T(e,t,n){if(!e||"function"!=typeof e.createPage)throw new Error("No page handler (or no createPage function) found for id "+t);e.createPage(n)}function E(n,i){if(!I){var r,o=a(n),l=O();I=!0,i.pageData&&o&&"function"==typeof o.encodeUrl&&(n=o.encodeUrl(i.pageData)),r=S(n),l.children("#"+r).length||T(o,r,t.extend(i,{ok:function(e){e.attr("id",r),l.append(e),e.jqmData("pageData",i.pageData),e.page(),I=!1,t.mobile.changePage(e,i)},fail:function(t){I=!1,e.fail(t)}}))}}function j(n,i){if("string"==typeof i.toPage){var r,l,u,s=t.mobile.path.parseUrl(i.toPage),c=k(s.pathname+s.search),d=k(s.hash||""),f=k(s.pathname||""),p=d,h=O();if(!(d.indexOf("&ui-state=dialog")>-1)&&(r=a(p),r||(p=f,r=a(p)),r||(p=c,r=a(p)),r)){if(l=h.children("#"+S(p)),!l.length&&d&&(l=h.children("#"+S(d))),l.length||(l=h.children("#"+S(c))),d&&l.length||(i.options.dataUrl="/"+c),!l.length){if("function"!=typeof r.createPage)return;u=r.decodeUrl&&r.decodeUrl(s),i.options.pageData=u,i.options.url=s,e.started(function(){E(p,i.options)})}i.options.role&&"dialog"===i.options.role||l.is(".ui-dialog")||(l.length&&t.mobile.changePage(l,i.options),n.preventDefault())}}else if(i.toPage instanceof t){if(i.consumed)return;i.consumed=!0,"dialog"!==i.toPage.jqmData("role")&&(i.options.fromPage&&"dialog"!==i.options.fromPage.jqmData("role")&&o({page:i.options.fromPage,nextPage:i.toPage,event:n,eventName:"pagebeforechange",options:i.options}),n.isDefaultPrevented()||setTimeout(function(){i.toPage.trigger("pagelayout")},0))}}function D(){var e=O();e.on("pagebeforecreate pagecreate pageinit pagelayout","div",b).on("pagecontainershow",m).on("pagebeforeshow","div",g).on("pagecontainerhide",v).on("pagebeforehide","div",y),e.on("pagecontainerbeforechange",j)}var w=!0,x=null,C=null,M=[],I=!1,A=i.encodePageId,O=i.getPageContainer,L=i.onPageContainerCreate,N="____DEFAULT_PAGE_$_$";return L(D),{register:r,getPrevName:u,getPrev:c,getPrevHandler:s,getCurrentName:d,getCurrent:f,getCurrentHandler:p,getHandler:a,fire:o,fireAll:l,isFirst:h}});var _typeof="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e},_slicedToArray=function(){function e(e,t){var n=[],i=!0,r=!1,a=void 0;try{for(var o,l=e[Symbol.iterator]();!(i=(o=l.next()).done)&&(n.push(o.value),!t||n.length!==t);i=!0);}catch(e){r=!0,a=e}finally{try{!i&&l.return&&l.return()}finally{if(r)throw a}}return n}return function(t,n){if(Array.isArray(t))return t;if(Symbol.iterator in Object(t))return e(t,n);throw new TypeError("Invalid attempt to destructure non-iterable instance")}}();define("mobile/util/mobile/dialogs",["baja!","lex!mobile","jquery","jquerymobile","Promise","mobile/util/mobile/pages","mobile/util/mobile/mobile","css!mobile/util/mobile/dialogs"],function(e,t,n,i,r,a,o){"use strict";function l(t,i){return t instanceof n?(i.html(t),r.resolve()):"object"===(void 0===t?"undefined":_typeof(t))||"string"==typeof t?(t instanceof Error&&e.error(t),i.text(String(t)),r.resolve()):"function"==typeof t?r.try(function(){return t(i.empty())}):void 0}function u(e){var t=a.getCurrent();return"string"==typeof e&&(e=f(e),e=n("#"===e.charAt(0)?e:"#"+e)),!t||!e||t[0]!==e[0]}function s(t,i){var r=n(k.patternReplace({theme:"a"})),a=r.children(":jqmData(role=content)").children(".dialogButtons");return e.iterate(i,function(e,t){var i=n(S.patternReplace({value:e}));i.text(v.get({key:e,def:e})),i.appendTo(a)}),r.attr("id",t),0===t.indexOf("error")&&r.addClass("error"),r.appendTo(h()),r}var c=e.callbackify,d=o.decodePageId,f=o.encodePageId,p=o.getActivePage,h=o.getPageContainer,m=o.hidePageLoadingMsg,g=_slicedToArray(t,1),v=g[0],y={},b=void 0,k=void 0,S=void 0,T=!1;k='<div data-role="dialog" class="dynamicDialog" data-overlay-theme="b">\n<div class="dynamicDialogHeader" data-role="header" data-theme="a">\n<h1 class="title" />\n</div>\n<div class="dynamicDialogContent" data-role="content" data-theme="c">\n<div class="dialogDisplay"></div>\n<div class="dialogButtons" data-role="controlgroup" data-type="horizontal"></div>\n</div>\n</div>',S='<a data-value="{value}" data-role="button" data-theme="a"></a>';var E=function(t,n){this.$params=e.objectify(t,"content"),this.$returnPage=t.returnPage,this.$page=n,T=!0};y.DialogInvocation=E,E.prototype.close=function(e){e=e||"cancel";var t=this,r=t.$options,a=t.$returnPage;"string"==typeof a&&0!==a.indexOf("ord?")&&"#"!==a.charAt(0)&&(a="#"+a),a instanceof n||"string"==typeof a?i.changePage(a,n.extend({transition:"none",changeHash:u(a)},r)):"function"==typeof a?a.call(this,e):i.changePage(location.href,{transition:"none",changeHash:!1}),b=void 0},E.prototype.invoke=function(t,n){function i(e){T=!1,u.fail(e),n.fail(e),T||o.close(t)}var r=e.ok,a=y.error;n=c(n,r,a);var o=this,l=o.$params,u=c(l.callbacks,r,a),s="function"==typeof t?t:l[t];"function"!=typeof s&&(s=function(e){e.ok()});try{T=!1,s.call(o,{ok:function(){T||o.close(t),u.ok(),n.ok()},fail:i})}catch(e){i(e)}},E.prototype.redirect=function(e,t){this.$returnPage=e,this.$options=t||{}},E.prototype.load=function(){var e=this,t=e.$page,i=e.$params,r=t.find(":jqmData(role=header)"),a=t.find(":jqmData(role=content)"),o=a.children(".dialogDisplay"),u=r.find("a:jqmData(icon=delete)"),s=a.find(".dialogButtons a");return r.find("h1.title").text(i.title||""),s.off("click").addClass("ui-disabled"),u.off().on("click",function(){return e.invoke("cancel"),!1}),l(i.content||"",o).then(function(){s.on("click",function(){var t=n(this).jqmData("value");e.invoke(t)}),s.removeClass("ui-disabled"),y.repositionDialog(t)},function(e){y.error("Failed to load dynamic dialog content: "+e)})},y.repositionDialog=function(e){var t=e.children(".ui-dialog-contain"),i=e.find(":jqmData(role=header)"),r=t.outerHeight(),a=n(window).height(),o=(a-r)/2,l=Math.max(o,15);t.css("margin-top",l),i.css("margin-top",l)},y.closeCurrent=function(){b&&b.close()},y.registerDialog=function(e,t){function r(e){b?b.load():e.page.find(".dialogDisplay").empty()}function o(r){var a=n("#"+e);return a.length||(a=s(e,t)),r.returnPage=b&&b.$returnPage||r.returnPage,b=new E(r,a),i.changePage(a,{changeHash:!1,allowSamePageTransition:!0,transition:"none"}),b}var l;l={load:o,pagebeforeshow:r},a.register(e,l)},function(){var e=y.registerDialog;e("yesNoCancelDialog",["yes","no","cancel"]),e("yesNoDialog",["yes","no"]),e("okCancelDialog",["ok","cancel"]),e("okDialog",["ok"]),e("errorDialog",["ok"]),e("cancelDialog",["cancel"])}();var j=function(e,t){return a.getHandler(e).load(t)};return y.yesNoCancel=function(e){return j("yesNoCancelDialog",e)},y.ok=function(e){return j("okDialog",e)},y.okCancel=function(e){return j("okCancelDialog",e)},y.cancel=function(e){return j("cancelDialog",e)},y.yesNo=function(e){return j("yesNoDialog",e)},y.error=function(t,n){return n=n||function(e){e.ok()},"function"!=typeof t&&e.error(t),m(),j("errorDialog",{title:v.get("appError"),content:t,ok:n})},y.unrecoverableError=function(t){var i,r=function(){location.reload()};return"function"==typeof t?i=t:(i=function(e){var i=n("<div/>").css({"margin-bottom":"1em"}).text(String(t)),r=n("<div/>").text(v.get("message.clickOKToReload"));e.append(i),e.append(r)},e.error(t)),m(),j("errorDialog",{title:v.get("unrecoverableError"),content:i,ok:r})},y.confirmAbandonChanges=function(t){t=e.objectify(t);var n=function(e){e.ok()},i=t.yes||n,r=t.no||n,o=t.redirect;return t.title=v.get("abandonChanges"),t.content=v.get({key:"message.confirmUnsavedChanges",args:[t.viewName]}),t.returnPage||(t.returnPage=d(a.getCurrent())),t.yes=function(e){o&&this.redirect(o),i.call(this,e)},t.no=function(e){o&&this.redirect(o),r.call(this,e)},y.yesNoCancel(t)},y.showDialog=function(e,t){var n=a.getHandler(e);return n?n.load(t):y.error(v.get({key:"dialogs.noPageRegistered",args:[e]}))},function(){n(window).on("resize",e.throttle(function(){var e=p();"dialog"===e.jqmData("role")&&y.repositionDialog(e)},500))}(),function(){var t=window.location.hash;t.indexOf("&ui-state=dialog")>0&&e.started(function(){i.changePage(t.replace("&ui-state=dialog",""),{changeHash:!0,transition:"none"})})}(),y}),define("mobile/util/mobile/commands",["require","css!mobile/util/mobile/commands","jquerymobile","baja!","jquery","Promise","underscore","bajaux/commands/Command","mobile/util/mobile/dialogs","mobile/util/mobile/pages","mobile/util/mobile/mobile","lex!mobile"],function(e){"use strict";function t(){return h(j.patternReplace({title:S.get("menu")}))}function n(e,t,n){if(e=g.filter(e,function(e){return e.isEnabled()}),h("a.commandsButton").trigger("onShowCommands",e),n=T(n),t=t||S.get("commands.title"),0===e.length)y.ok({title:t,content:S.get("commands.noneAvailable")});else var i=y.cancel({title:t,content:function(t){var n=g.map(e,function(e){var t=h("<li/>"),n=h("<a/>").appendTo(t);return e.toDisplayName().then(function(r){return n.text(r),n.click(function(){i.invoke(function(t){e.invoke().then(t.ok,t.fail)})}),t})});return m.all(n).then(function(e){var n=h('<ul data-role="listview" data-theme="c" />').html(e);t.html(n),n.listview()})},callbacks:n})}function i(){var e=Array.prototype.slice.call(arguments);p.iterate(e,function(e){E.contains(e)||E.push(e)})}function r(){var e=Array.prototype.slice.call(arguments);p.iterate(e,function(e){E.contains(e)||(E.length?E.splice(0,0,e):E.push(e))})}function a(e){var t=Array.prototype.slice.call(arguments);t.length>1?p.iterate(t,function(e){a(e)}):p.iterate(E,function(t,n){if(t===e)return E.splice(n,1),!0})}function o(){return E.slice(0)}function l(e){E=e}function u(){var e=o(),t=b.getCurrentHandler();return t&&"function"==typeof t.getCommands&&(e=t.getCommands({commands:e,page:b.getCurrent()})),n(e),!1}function s(){return d}function c(){return f}e("css!mobile/util/mobile/commands"),e("jquerymobile");var d,f,p=e("baja!"),h=e("jquery"),m=e("Promise"),g=e("underscore"),v=e("bajaux/commands/Command"),y=e("mobile/util/mobile/dialogs"),b=e("mobile/util/mobile/pages"),k=e("mobile/util/mobile/mobile"),S=e("lex!mobile")[0],T=p.callbackify,E=[],j="<a class='commandsButton profileHeader' title='{title}' data-icon='bars' data-role='button' data-iconpos='notext'></a>";return f=new v("%lexicon(mobile:commands.logout)%",function(e){var t=location.protocol+"//"+location.host+"/logout";window.location.assign(t+"?csrfToken="+encodeURIComponent(h("#csrfToken").val()))}),"undefined"!=typeof niagara&&niagara.view.profile.showLogoutCmd&&r(f),d=new v("%lexicon(mobile:commands.home)%",function(e){k.linkToOrd(p.getUserHome())}),"undefined"!=typeof niagara&&niagara.view.profile.showHome&&r(d),{getCommandsButton:t,getHomeCmd:s,getLogoutCmd:c,showCommandsDialog:n,addDefaultCommand:i,prependDefaultCommand:r,removeDefaultCommand:a,getDefaultCommands:o,setDefaultCommands:l,showCommandsHandler:u}}),define("mobile/util/mobile/views/MobileView",["baja!","jquery","Promise","bajaux/Widget"],function(e,t,n,i){"use strict";var r=function(){i.apply(this,arguments)};return r.prototype=Object.create(i.prototype),r.prototype.constructor=r,r.prototype.doInitialize=function(e){return n.resolve(i.prototype.doInitialize.call(this,e)).then(function(){e.enhanceWithin()})},r}),define("mobile/util/mobile/views/RadioButtonView",["baja!","jquery","jquerymobile","Promise","mobile/util/mobile/mobile","mobile/util/mobile/views/MobileView"],function(e,t,n,i,r,a){"use strict";var o=r.encodePageId,l=e.subclass(function(){e.callSuper(l,this,arguments)},a);return l.prototype.doLoad=function(n){e.strictArg(n,e.Complex);var r=this,a=t('<fieldset data-role="controlgroup" />'),o=n.getSlots(function(e){return r.shouldIncludeSlot(e)});return e.iterate(o,function(e){a.append(r.makeInput(n,e)).append(r.makeLabel(n,e))}),this.jq().empty().append(a).trigger("create"),i.resolve()},l.prototype.doInitialize=function(e){var n=this;return a.prototype.doInitialize.call(this,e).then(function(){e.on("change","input[type=radio]",function(){n.selectionChanged(t(this).jqmData("slot"))})})},l.prototype.selectionChanged=function(e){this.$selectedSlot=e},l.prototype.setSelectedSlot=function(e){e=String(e);var t=o(e),n=this.jq().find("input#"+t);e=this.value().getSlot(e),e&&n.length?(this.$selectedSlot=e,n.prop("checked",!0).checkboxradio("refresh")):(delete this.$selectedSlot,this.jq().find("input[type=radio]").prop("checked",!1)),this.selectionChanged(e)},l.prototype.getSelectedSlot=function(){return this.$selectedSlot||this.jq().find("input:checked").jqmData("slot")},l.prototype.getSelectedValue=function(){var e=this.getSelectedSlot();if(e)return this.value().get(e)},l.prototype.makeInput=function(e,n){n=String(n);var i=o(n),r=o(e.getName()),a=t('<input type="radio" />').attr("name",r).attr("id",i).attr("value",i);return n===String(this.$selectedSlot)&&a.prop("checked",!0),a.jqmData("slot",n),a},l.prototype.makeLabel=function(n,i){var r=o(String(i)),a=n.getDisplay(i),l=e.SlotPath.unescape(String(i)),u=t('<label data-theme="c"/>').attr("for",r);return u.append(t("<span/>").text(l)).append(t("<br/>")).append(t("<span/>").text(a)),u},l.prototype.shouldIncludeSlot=function(e){return e.isProperty()&&!e.isAction()&&!e.isTopic()},l}),define("mobile/fieldeditors/fieldeditors",["baja!mobile:MobileFieldEditor","baja!","jquery","Promise","underscore","mobile/util/aop","mobile/util/slot","nmodule/js/rc/asyncUtils/asyncUtils"],function(e,t,n,i,r,a,o,l){"use strict";function u(e,t){var i=n('<div class="labeledEditor"/>').appendTo(t),r=n('<label class="editorLabel" />'),a=n('<div class="editorContainer"/>');return void 0!==e&&r.text(e),i.append(r).append(a),a}function s(e){var t=e.newCopy(!0);return t.editedSlots={},t.getSlots().properties().isComplex().each(function(e){var n=t.get(e);t.set({slot:e,value:s(n)})}),a.after(t,"set",function(e,t){var n=e[0];return this.editedSlots[String(n.slot)]=n.value,t}),t}function c(e,n){n=t.objectify(n);var r,o=n.doInitialize,l=n.doLoad,u=n.doRead,s=n.doSave;return t.strictAllArgs([o,l],[Function,Function]),r=t.subclass(function(){t.callSuper(r,this,arguments)},e),r.prototype.doInitialize=function(t){var n=this;return i.resolve(e.prototype.doInitialize.call(n,t)).then(function(){return o.call(n,t)})},r.prototype.doLoad=function(t){var n=this;return i.resolve(e.prototype.doLoad.call(n,t)).then(function(){return l.call(n,t)})},"function"==typeof u&&(r.prototype.doRead=u),"function"==typeof s&&(r.prototype.doSave=s),n.validate&&a.after(r.prototype,"postCreate",function(e){this.validators().add(n.validate)}),n.postCreate&&a.after(r.prototype,"postCreate",function(e){n.postCreate.call(this)}),n.doEnabled&&a.after(r.prototype,"doEnabled",function(e){n.doEnabled.apply(this,e)}),r}function d(e){return e?t.importTypes({typeSpecs:[e]}).then(function(e){var n=e[0];return!!n.is(M)||(!!n.is(I)||(t.error("fieldEditor facet "+n+" does not reference a sub-Type of MobileFieldEditor."),!1))},function(n){return t.error("fieldEditor facet "+e+" does not reference a known Type."),!1}):i.resolve(!1)}function f(e){function n(e){for(var t=E();e;){if(w[String(e)])return!0;if(t[String(e)])return!0;e=e.getSuperType()}}return null!==e&&void 0!==e?function(){return"string"==typeof e?t.importTypes({typeSpecs:[e]}).then(function(e){return e[0]}):e.getType?i.resolve(e.getType()):i.resolve(e)}().then(function(t){if(n(t))return!0;var i=e.getFacets&&e.getFacets();return d(i&&i.get(A))}):i.resolve(!1)}function p(e){return d(e).then(function(t){return!!t&&f(e)})}function h(e,t,n){var i="/ord/"+e;return i+="|view:mobile:MobileFieldEditorView%3FfeTypeSpec="+t+";typeSpecs="+n.join(",")}function m(e){e=String(e);var t=j(),n=E(),a=t&&t[e],o=[];return a?(r.each(a.js,function(t){o.push(h(t,e,a.agentOn))}),r.each(a.css,function(e){e.indexOf(".css")===e.length-4&&(e=e.substring(0,e.length-4)),o.push("css!"+e)}),C(o).then(function(){delete t[e],delete n[e]})):i.resolve()}function g(e){e=String(e);var t=E(),n=t&&t[e];if(!n)return i.resolve();var a=r.map(n,function(e){return m(e)});return i.all(a).then(function(){delete t[e]})}function v(e){return e.is(M)?m(e):g(e)}function y(e){return e?v(e).then(function(){return y(e.getSuperType())}):i.resolve()}function b(e,n){var r;return e?("string"==typeof e&&(e=t.lt(e)),n=n||"default",y(e).then(function(){for(;!r&&e;){if((r=w[String(e)])&&r[n])return r[n];e=e.getSuperType()}return b("baja:String","default")})):i.reject("cannot get field editor for null type")}function k(e,t,n){if(!e)throw new Error("cannot register field editor for null type");if("function"!=typeof t)throw new Error("editor is required");e=String(e),n=n||"default";var i=w[e]||{};return i[n]=t,w[e]=i,t}function S(e,n,i,r){var a,l=x;return a=n&&i?o.getFacets(n,i):o.getFacets(e),a&&(l=t.Facets.make(l,a)),r&&(l=t.Facets.make(l,r)),l}function T(){return"undefined"!=typeof niagara&&niagara.view||{}}function E(){return T().customFieldEditors||{}}function j(){return T().fieldEditorResources||{}}function D(e,n){arguments.length<2&&(n=e,e=null);try{t.strictArg(n),!1!==n.autoInitialize&&t.strictArg(n.element)}catch(e){return i.reject("element is required to initialize - did you mean to set autoInitialize = false?")}if(void 0===n.value){try{t.strictArg(n.container,t.Complex)}catch(e){return i.reject("container is required when value is undefined")}n.value=n.container.get(n.slot)}var r,a,o,l=n.value,u=!1!==n.autoInitialize,s=n.element,c=n.type||l.getType(),d=n.key;return a=n.container||l.getParent&&l.getParent(),o=n.slot||l.getPropertyInParent&&l.getPropertyInParent(),n.facets=S(l,a,o,n.facets),r=n.facets.get(A),p(r).then(function(i){function f(e){var t=new e(l,a,o,n);return u?t.initialize(s).then(function(){return t.load(l)}).then(function(){return t}):t}return i&&(c=t.lt(r)),e?f(e):b(c,d).then(f)})}var w={},x=t.Facets.make({timeFormat:t.getTimeFormatPattern(),unitConversion:t.getUnitConversion()}),C=l.doRequire,M="mobile:MobileFieldEditor",I="workbench:WbFieldEditor",A="fieldEditor";return{composite:{},defineEditor:c,isRegistered:f,makeFor:D,register:k,toLabeledEditorContainer:u,toSaveDataComponent:s}}),define("mobile/fieldeditors/BaseFieldEditor",["baja!","bajaux/Widget","jquery","Promise","underscore","bajaux/events","bajaux/mixin/batchSaveMixin","nmodule/js/rc/asyncUtils/asyncUtils"],function(e,t,n,i,r,a,o,l){"use strict";function u(e){return e.is('input[type="checkbox"]')||e.is('input[type="radio"]')}function s(t,n){e.iterate(n,function(e){t.addClass(String(e.getTypeSpec()).replace(":","-"))},function(e){return e.getSuperType()})}function c(t,n){var i=e.$(n).decodeFromString(t),r=h[n.toString()];return i.getDataTypeSymbol=function(){return r},i}function d(e,t){var n=e.getType&&e.getType();return!(!n||!n.isComponent())&&(!e.editedSlots&&e!==t)}var f=l.doRequire,p=o.COMMIT_READY,h={"baja.Boolean":"b","baja:Integer":"i","baja:Long":"l","baja:Float":"f","baja:Double":"d","baja:String":"s","baja:DynamicEnum":"e","baja:EnumRange":"E","baja:AbsTime":"a","baja:RelTime":"r","baja:TimeZone":"z","baja:Unit":"u"},m=r.once(function(){return f("mobile/fieldeditors/fieldeditors")}),g=function(n,i,r,a){if(t.call(this,"mobile","BaseFieldEditor"),void 0===n||null===n)return this;a=e.objectify(a),n.getType().isComplex()&&!n.getType().isComponent()&&(n=n.newCopy()),this.$value=n,this.container=i||n.getParent&&n.getParent(),this.slot=r||n.getName&&n.getName(),this.name=String(this.slot),this.params=a,this.facets=a.facets||e.Facets.DEFAULT,this.label=a.label||i&&i.getDisplayName&&r&&i.getDisplayName(r)||n.getName&&n.getName()||r&&String(r),this.parent=a.parent,this.$enabled=!a.readonly,this.$kids=[],this.postCreate(),o(this)};return g.prototype=Object.create(t.prototype),g.prototype.constructor=g,g.prototype.setModified=function(i,r){if(!this.isLoading()){t.prototype.setModified.apply(this,[i]),r=e.objectify(r);var a=this,o=a.parent,l=a.jq();i&&(o&&o.setModified(!0,n.extend({silent:!0},r)),l&&!r.silent&&l.trigger("modified.view",[a,r]))}},g.prototype.postCreate=function(){},g.prototype.doEnabled=function(e){var t=this.jq(),n=t&&t.find("select,input,textarea");n&&(e?n.removeAttr("disabled"):n.attr("disabled","disabled"))},g.$detectChangeEvent=function(){var e,t=n(this),i=t.closest("div.editor"),r=i.data("editor"),a=t.data("oldValue");e=u(t)?t.is(":checked"):t.val(),r.isLoading()||void 0===a||a===e||r.setModified(!0,{oldValue:a,newValue:e,element:t}),t.data("oldValue",e)},g.prototype.buildAndLoad=function(e){var t=this;return t.initialize(e).then(function(){return t.load(t.value())})},g.prototype.load=function(e){var i=this;return t.prototype.load.apply(i,arguments).then(function(e){var t=i.jq();return null!==e&&void 0!==e&&s(t,e.getType()),t.find("input,select,textarea").each(function(){var e=n(this);u(e)?e.data("oldValue",e.is(":checked")):e.data("oldValue",e.val())}),e})},g.prototype.initialize=function(e){return e=n('<div class="editor ui-field-contain"/>').data("editor",this).appendTo(e),e.on("change keyup","input,select,textarea",g.$detectChangeEvent),t.prototype.initialize.apply(this,[e])},g.prototype.read=function(){var n=this,i=n.value(),r=e.hasType(i)&&i.getType();return t.prototype.read.apply(n,arguments).then(function(e){return r&&r.is("baja:Simple")&&!r.is("baja:String")&&e.getType().is("baja:String")?c(e,r):e})},g.prototype.save=function(e){var t,n,i=this;return i.validate().then(function(r){if(t=r,n=r.getType&&r.getType(),d(t,i.value()))throw new Error("Component editors must support edit-by-ref semantics");return i.doSave(t,e)}).then(function(){var r=i.container,a=i.slot,o=e&&e.batch,l=e&&e.progressCallback;if(n&&!n.isComponent()&&r&&a){var u=r.set({slot:a,value:t,batch:o});return l&&l(p),u}return t}).then(function(){i.trigger(a.SAVE_EVENT),i.setModified(!1),i.$value=t})},g.prototype.doSave=function(t,n){var r=[],a=this.value();if(a.getType().isSimple())return t;if(t instanceof e.Component&&!t.editedSlots)throw new Error("provided raw instance of Component (type "+t.getType()+") to defaultDoSave - does your field editor use niagara.fieldEditors.toSaveDataComponent()?");var o=new e.comm.Batch;return e.iterate(t.editedSlots||t,function(e,t){r.push(a.set({slot:t,value:e.newCopy(!0),batch:o}))}),o.commit(),i.all(r).then(function(){return a})},g.prototype.makeChildFor=function(e){var t=this,n=t.$kids;return e.element=e.element||t.jq(),void 0===e.readonly&&(e.readonly=!t.isEnabled()),m().then(function(t){return t.makeFor(e)}).then(function(e){return n.push(e),e.parent=t,e})},g}),define("mobile/fieldeditors/fieldeditors.composite",["baja!","jquery","Promise","underscore","mobile/util/slot","mobile/fieldeditors/BaseFieldEditor","mobile/fieldeditors/fieldeditors"],function(e,t,n,i,r,a,o){"use strict";function l(e){var t={}
;return e.getSlots().properties().each(function(e){r.isEditable(e)&&(t[String(e)]="default")}),t}function u(i){return function(r,a){var u=this,s=u.value(),c=[],d=[];return e.iterate(i||l(s),function(e,n){var i=t('<div class="subEditor"/>').appendTo(r),l=s.getSlot(n),f=s.getDisplayName(l);c.push(u.makeChildFor({key:e.key,value:e.defaultValue||s.get(n),slot:l,container:s,facets:u.facets,autoInitialize:!1}).then(function(e){var t=o.toLabeledEditorContainer(f,i);return u.subEditorMap[l]=e,d.push(e.initialize(t,a)),e}))}),n.all(c).then(function(){return n.all(d)})}}function s(t){return function(i,r){var a=this,o=[],u=a.subEditorMap;return null===i||void 0===i?n.resolve(i):(e.iterate(t||l(i),function(e,t){var n=u[t],a=e.defaultValue||i.get(t);o.push(n.load(a,r))}),n.all(o))}}function c(t){return function(){var i=this.subEditorMap,r=[],a=this.value(),u=o.toSaveDataComponent(a);return e.iterate(t||l(a),function(e,t){var n=i[t];r.push(n.read().then(function(e){return u.set({slot:t,value:e})}))}),n.all(r).then(function(){return u})}}function d(t){return function(n){var i=this.subEditorMap,r=this.value();e.iterate(t||l(r),function(e,t){i[t].setEnabled(n)})}}function f(t){return function(){var i=[],r=this.subEditorMap,a=this.value();return e.iterate(t||l(a),function(e,t){var n=r[t];i.push(n.validate())}),n.all(i)}}var p={};return p.makeComposite=function(t,n,i){t=t||[],e.strictArg(t,Array);var r;return t.length&&(r={},e.iterate(t,function(e){"string"==typeof e?r[e]={key:"default"}:r[e.slot]={key:e.key||"default",defaultValue:e.defaultValue}})),o.defineEditor(n||a,{doInitialize:u(r),doLoad:s(r),doRead:c(r),doEnabled:d(r),validate:f(r),postCreate:function(){this.subEditorMap={},i&&i.validate&&this.validators().add(i.validate)}})},p.allSlots=function(){var e=p.makeComposite(),t=e.prototype.doInitialize;return e.prototype.doInitialize=function(e){e.addClass("allSlots"),t.call(this,e)},e},p}),define("mobile/fieldeditors/fieldeditors.dialogs",["baja!","lex!mobile","jquery","Promise","mobile/fieldeditors/fieldeditors","mobile/fieldeditors/fieldeditors.composite","bajaux/commands/Command","mobile/util/mobile/dialogs","mobile/util/mobile/commands","mobile/util/slot"],function(e,t,n,i,r,a,o,l,u,s){"use strict";function c(t){function n(n){return new i(function(i,u){l.okCancel({title:t.title||String(o.getType()),content:function(e){return t.element=e,r.makeFor(n,t).then(function(e){a=e})},ok:function(t){var n=new e.comm.Batch;a.save({batch:n}).then(function(){return a.read()}).then(function(e){i(e),t.ok()},function(e){u(e),t.fail(e)}),n.commit()},cancel:function(e){i(null),e.ok()}})})}var a,o=t.value;return r.isRegistered(o.getType()).then(function(e){return n(e?null:p)})}function d(t){function r(){return e.clock.schedule(function(){e.station.sync()},500),g.invoke({slot:o,value:f})}function a(){return d?g.getActionParameterDefault({slot:o}).then(function(e){return f=e,t&&!t.facets&&(t.facets=s.getFacets(g)),c(n.extend(t,{title:g.getDisplayName(o),value:f})).then(function(e){return null!==e?(f=e,r()):null})}):r()}t=e.objectify(t);var o,u,d,f=null,p=t.slot,m=e.def(t.parameter,""),g=t.component;if(e.strictArg(g,e.Component),o=g.getSlot(p),!o.isAction())throw new Error("slot '"+p+"' is not an action");if(u=o.getParamType(),m.equals("")||null===u||(m.getType().is(u)?f=m:"string"==typeof m&&u.isSimple()&&(f=u.getInstance().decodeFromString(m))),d=null===f&&null!==u,(g.getFlags(o)&e.Flags.CONFIRM_REQUIRED)===e.Flags.CONFIRM_REQUIRED)return new i(function(e,t){l.yesNo({content:h.get({key:"invoke.confirm",args:[g.getDisplayName(o)]}),yes:function(){a().then(e,t)},no:function(){e(null)}})});var v=a();return d||l.closeCurrent(),v}function f(e){var t=[];e.getSlots(function(e){return s.isFireable(e)}).each(function(n){t.push(new o(e.getDisplayName(n),function(){return d({component:e,slot:n,facets:e.get("facets")||{}})}))}),u.showCommandsDialog(t,h.get("actions"))}var p=a.allSlots(),h=t[0];return{action:d,fieldEditor:c,showAvailableActions:f}}),define("mobile/fieldeditors/MobileFieldEditor",["baja!","jquery","jquerymobile","mobile/fieldeditors/BaseFieldEditor"],function(e,t,n,i){"use strict";var r=e.subclass(function(e,t,n,r){i.call(this,e,t,n,r)},i);return r.prototype.refreshWidgets=function(){var e=this.jq(),t=e.find("select"),n=e.find("input"),i=t.filter(".ui-slider-switch"),r=t.filter(".ui-select select"),a=n.filter(".ui-checkbox input"),o=n.filter(".ui-input-datebox input");i.length&&i.slider("refresh"),r.length&&r.selectmenu("refresh"),a.length&&a.checkboxradio("refresh"),o.length&&o.datebox("refresh"),e.removeClass("ui-br")},r.prototype.doEnabled=function(e){var t=this,n=this.jq();n&&t.updateReadonlyStatus(n)},r.prototype.updateReadonlyStatus=function(e){var t=this.isEnabled(),n=e.find("select"),i=e.find("input"),r=t?"enable":"disable",a=e.find("textarea"),o=n.filter(":jqmData(role=slider)"),l=n.filter(":jqmData(role!=slider)"),u=i.filter('[type="checkbox"]'),s=i.filter(':jqmData(role="datebox")'),c=i.filter('[type="text"]');o.length&&o.slider(r),l.length&&l.selectmenu(r),u.length&&u.checkboxradio(r),s.length&&s.datebox(r),c.length&&c.textinput(r),a.length&&a.textinput(r)},r.prototype.initialize=function(e){var t=this;return i.prototype.initialize.call(this,e).then(function(){e.enhanceWithin(),t.updateReadonlyStatus(e)})},r.prototype.load=function(e){var t=this;return i.prototype.load.call(t,e).then(function(){t.refreshWidgets()})},r});var _slicedToArray=function(){function e(e,t){var n=[],i=!0,r=!1,a=void 0;try{for(var o,l=e[Symbol.iterator]();!(i=(o=l.next()).done)&&(n.push(o.value),!t||n.length!==t);i=!0);}catch(e){r=!0,a=e}finally{try{!i&&l.return&&l.return()}finally{if(r)throw a}}return n}return function(t,n){if(Array.isArray(t))return t;if(Symbol.iterator in Object(t))return e(t,n);throw new TypeError("Invalid attempt to destructure non-iterable instance")}}();define("mobile/fieldeditors/mobile/AbsTimeEditor",["baja!","bajaux/events","jquery","Promise","mobile/fieldeditors/MobileFieldEditor"],function(e,t,n,i,r){"use strict";var a=t.MODIFY_EVENT,o=function(){r.apply(this,arguments)};return o.prototype=Object.create(r.prototype),o.prototype.constructor=o,o.prototype.doLoad=function(e){var t=this,n=t.jq(),r=e.getDate(),o=e.getTime();return n.empty(),t.$offset=e.$offset||0,i.join(t.makeChildFor({value:r,element:n}),t.makeChildFor({value:o,element:n})).spread(function(e,n){function i(){return t.setModified(!0),!1}t.$dateEditor=e,t.$timeEditor=n,e.jq().on(a,i),n.jq().on(a,i)})},o.prototype.doRead=function(){var t=this.$offset;return i.all([this.$dateEditor.read(),this.$timeEditor.read()]).then(function(n){var i=_slicedToArray(n,2),r=i[0],a=i[1];return e.AbsTime.make({date:r,time:a,offset:t})})},o.prototype.doEnabled=function(e){var t=this;t.$dateEditor&&t.$dateEditor.doEnabled(e),t.$timeEditor&&t.$timeEditor.doEnabled(e)},o});var _slicedToArray=function(){function e(e,t){var n=[],i=!0,r=!1,a=void 0;try{for(var o,l=e[Symbol.iterator]();!(i=(o=l.next()).done)&&(n.push(o.value),!t||n.length!==t);i=!0);}catch(e){r=!0,a=e}finally{try{!i&&l.return&&l.return()}finally{if(r)throw a}}return n}return function(t,n){if(Array.isArray(t))return t;if(Symbol.iterator in Object(t))return e(t,n);throw new TypeError("Invalid attempt to destructure non-iterable instance")}}();define("mobile/fieldeditors/mobile/feUtils",["baja!","lex!mobile","jquery","Promise","mobile/util/slot","nmodule/js/rc/asyncUtils/asyncUtils"],function(e,t,n,i,r,a){"use strict";function o(e){var t,n,i="",r="",a=0;for(n=0;n<e.length;n++)switch(t=e.charAt(n)){case"Y":case"M":case"D":case"W":case"w":case"z":case"s":i="";break;case"h":case"H":case"m":case"a":i.length&&(r+=i,i=""),r+=t,a++;break;default:a>0&&(i+=t)}return r}function l(){var e,t,n,i=p.getBajaTimeFormat(),r=[],a="",o=[],l=12;for(e=0;e<i.length;e++)n=i.charAt(e),r.length>0&&r[r.length-1].ch===n?r[r.length-1].count++:r.push({ch:n,count:1});for(e=0;e<r.length;e++)switch(r[e].ch){case"Y":a+=r[e].count<=2?"%y":"%Y";break;case"M":switch(r[e].count){case 1:a+="%-m";break;case 2:a+="%m";break;case 3:a+="%b";break;case 4:default:a+="%B"}break;case"D":a+=1===r[e].count?"%-d":"%d";break;case"h":a+=1===r[e].count?"%-l":"%l",o.push("h"),l=12;break;case"H":a+=1===r[e].count?"%-k":"%k",o.push("h"),l=24;break;case"m":a+=1===r[e].count?"%-M":"%M",o.push("i");break;case"s":a+="ss";break;case"a":a+="%p",o.push("a");break;case"z":case"Z":break;case"W":a+=1===r[e].count?"%a":"%A";break;case"w":a+="%W";break;case"%":for(t=0;t<r[e].count;t++)a+="%%";break;default:for(t=0;t<r[e].count;t++)a+=r[e].ch}return{timeOutput:a,timeFieldOrder:o,timeFormat:l}}var u=a.doRequire,s=_slicedToArray(t,1),c=s[0],d=void 0,f=void 0,p={};return p.dateboxArmHandlers=function(e){e.find("input:jqmData(role=datebox)").on("keyup",function(){var e=n(this),t=e.val();e.trigger("datebox",{method:"set",value:t})})},p.getBajaTimeFormat=function(){return d||(d=e.getTimeFormatPattern()||"HH:mm",d=o(d),d.match(/a\S+/g)&&(d=d.replace("a","a "))),d},p.getDateboxDefaultOptions=function(){var e={centerHoriz:!0,centerVert:!0,daysOfWeek:c.get({key:"propsheet.datebox.daysOfWeek",def:"Sunday Monday Tuesday Wednesday Thursday Friday Saturday"}).split(" "),daysOfWeekShort:c.get({key:"propsheet.datebox.daysOfWeekShort",def:"Su Mo Tu We Th Fr Sa"}).split(" "),monthsOfYear:c.get({key:"propsheet.datebox.monthsOfYear",def:"January February March April May June July August September October November December"}).split(" "),monthsOfYearShort:c.get({key:"propsheet.datebox.monthsOfYearShort",def:"Jan Feb Mar Apr May Jun Jul Aug Sep Oct Nov Dec"}).split(" "),setDateButtonLabel:c.get({key:"propsheet.datebox.setDateButtonLabel",def:"Set Date"})};return f=f||l(),e.overrideTimeOutput=f.timeOutput,e.overrideTimeFieldOrder=f.timeFieldOrder,e.overrideTimeFormat=f.timeFormat,e},p.getEnumRangeDisplay=function(t,n){return i.try(function(){var i=n.getOptions().get("lexicon"),r=n.get(t),a=r.getTag();return i?u(["lex!"+i]).spread(function(e){return e.get({key:a,def:a})}):e.SlotPath.unescape(r.toString())}).catch(function(){return String(t)})},p.getFacets=function(t){var n=t.facets,i=t.container;return n&&n!==e.Facets.NULL?n:i?r.getFacets(i,t.slot):e.Facets.DEFAULT},p.minMaxCheck=function(e,t,n,r){return new i(function(i,a){var o;void 0!==t&&null!==t&&r<t||void 0!==n&&null!==n&&r>n?(o='Cannot save property "'+e.slot+'". ',o+=r<t?r+" < "+t:r+" > "+n,o+=" ["+t+" - "+n+"]",a(new Error(o))):i()})},p});var _slicedToArray=function(){function e(e,t){var n=[],i=!0,r=!1,a=void 0;try{for(var o,l=e[Symbol.iterator]();!(i=(o=l.next()).done)&&(n.push(o.value),!t||n.length!==t);i=!0);}catch(e){r=!0,a=e}finally{try{!i&&l.return&&l.return()}finally{if(r)throw a}}return n}return function(t,n){if(Array.isArray(t))return t;if(Symbol.iterator in Object(t))return e(t,n);throw new TypeError("Invalid attempt to destructure non-iterable instance")}}();define("mobile/fieldeditors/mobile/BooleanEditor",["baja!","lex!baja","jquery","Promise","mobile/fieldeditors/MobileFieldEditor","mobile/fieldeditors/mobile/feUtils"],function(e,t,n,i,r,a){"use strict";function o(t){var n,r,a=t.facets;return a&&a.get("trueText")&&a.get("falseText")||(a=l(t)),a&&(n=a.get("trueText"),r=a.get("falseText")),n&&r||(n=s.get("true"),r=s.get("false")),i.join(e.Format.format({pattern:n}),e.Format.format({pattern:r}))}var l=a.getFacets,u=_slicedToArray(t,1),s=u[0],c=function(){r.apply(this,arguments)};return c.prototype=Object.create(r.prototype),c.prototype.constructor=c,c.prototype.doInitialize=function(e){var t=this;return o(t).spread(function(i,r){var a=t.name,o=n('<select data-role="slider" />').attr("name",a),l=n("<option/>").val("true").text(i),u=n("<option/>").val("false").text(r);o.append(u).append(l).appendTo(e)})},c.prototype.doLoad=function(e){this.jq().find("select").val(e?"true":"false")},c.prototype.doRead=function(){return"true"===this.jq().find("select").val()},c}),define("mobile/fieldeditors/mobile/BooleanCheckboxEditor",["baja!","jquery","mobile/fieldeditors/MobileFieldEditor","mobile/util/mobile/mobile"],function(e,t,n,i){"use strict";var r=i.encodePageId,a=function(){n.apply(this,arguments)};return a.prototype=Object.create(n.prototype),a.prototype.constructor=a,a.prototype.doInitialize=function(e){var n=this.label,i=r(n),a=t('<fieldset data-role="controlgroup"/>'),o=t("<label/>").attr("for",i).text(n),l=t('<input type="checkbox" data-theme="b"/>').attr("name",i).attr("id",i);a.append(l).append(o),e.append(a)},a.prototype.doLoad=function(e){this.jq().find("input").attr("checked",e).checkboxradio("refresh")},a.prototype.doRead=function(){return this.jq().find("input").is(":checked")},a}),define("mobile/fieldeditors/mobile/DateEditor",["baja!","jquery","mobile/fieldeditors/MobileFieldEditor","mobile/fieldeditors/mobile/feUtils"],function(e,t,n,i){"use strict";function r(t){var n=t.jq().find("input[name$=date]"),i=n.datebox("getTheDate");return e.Date.make({year:i.getFullYear(),month:i.getMonth(),day:i.getDate()})}function a(e){var n=t('<input type="date" data-role="datebox" name="'+e+'_date" />'),i=l();return i.mode="calbox",i.useDialogForceFalse=!0,i.calHighToday=!1,n.attr("data-options",JSON.stringify(i)),n}var o=i.dateboxArmHandlers,l=i.getDateboxDefaultOptions,u=function(){n.apply(this,arguments)};return u.prototype=Object.create(n.prototype),u.prototype.constructor=u,u.prototype.doInitialize=function(e){e.append(a(this.name)),o(e)},u.prototype.doLoad=function(e){var t=this.jq().find("input:jqmData(role=datebox)");return e.toDateString({textPattern:"YYYY-MM-DD"}).then(function(e){t.trigger("datebox",{method:"set",value:e})})},u.prototype.doRead=function(){return r(this)},u});var _slicedToArray=function(){function e(e,t){var n=[],i=!0,r=!1,a=void 0;try{for(var o,l=e[Symbol.iterator]();!(i=(o=l.next()).done)&&(n.push(o.value),!t||n.length!==t);i=!0);}catch(e){r=!0,a=e}finally{try{!i&&l.return&&l.return()}finally{if(r)throw a}}return n}return function(t,n){if(Array.isArray(t))return t;if(Symbol.iterator in Object(t))return e(t,n);throw new TypeError("Invalid attempt to destructure non-iterable instance")}}();define("mobile/fieldeditors/mobile/EnumEditor",["baja!","lex!mobile","jquery","Promise","underscore","mobile/fieldeditors/MobileFieldEditor","mobile/fieldeditors/mobile/feUtils"],function(e,t,n,i,r,a,o){"use strict";var l=o.getEnumRangeDisplay,u=_slicedToArray(t,1),s=u[0],c=function(){a.apply(this,arguments)};return c.prototype=Object.create(a.prototype),c.prototype.constructor=c,c.prototype.doInitialize=function(e){var t=n('<select data-theme="a" />').attr("name",this.name);n("<option/>").attr("value","n/a").val(s.get("loading")).appendTo(t),t.appendTo(e)},c.prototype.doLoad=function(t){var a=this.jq().find("select").empty(),o=this.facets.get("range")||t.getRange(),u=o.getOrdinals();this.range=o;var s=r.map(u,function(e){return l(e,o)});return i.all(s).then(function(i){var o=r.map(i,function(t,i){return n("<option/>").val(u[i]).text(e.SlotPath.unescape(t))});a.html(o),a.val(String(t.getOrdinal())).selectmenu("refresh")})},c}),define("mobile/fieldeditors/mobile/DynamicEnumEditor",["baja!","mobile/fieldeditors/mobile/EnumEditor"],function(e,t){"use strict";var n=function(){t.apply(this,arguments)};return n.prototype=Object.create(t.prototype),n.prototype.constructor=n,n.prototype.doRead=function(){var t=this.jq().find("select"),n=this.range;return e.DynamicEnum.make({ordinal:Number(t.val()),range:n})},n}),define("mobile/fieldeditors/mobile/FacetsEditor",["baja!","jquery","Promise","mobile/fieldeditors/MobileFieldEditor","mobile/util/mobile/dialogs"],function(e,t,n,i,r){"use strict";function a(e,t,n){var i=e.jq(),r=e.facetValues[n];void 0!==r&&e.makeChildFor({value:r,element:t.empty()}).then(function(t){delete e.currentEditor,delete e.currentKey,i.trigger("create"),i.trigger("updatelayout"),e.currentEditor=t,e.currentKey=n})}function o(e,t){return t&&t.isModified()?t.read().then(function(t){e.facetValues[e.currentKey]=t}):n.resolve()}var l=function(){i.apply(this,arguments),this.currentEditor=null,this.currentKey=null};return l.prototype=Object.create(i.prototype),l.prototype.constructor=l,l.prototype.doInitialize=function(e){var n=this,i=t('<select data-role="selectmenu" data-theme="a"><option value="-1">loading</option></select>'),l=t('<div class="subEditor"/>');i.appendTo(e),l.appendTo(e),e.undelegate(),i.on("change",function(){var e=t(this).val();o(n,n.currentEditor).then(function(){a(n,l,e),n.$lastKey=e},function(e){r.error(e),i.val(n.$lastKey)})})},l.prototype.doLoad=function(n){var i=this,r=i.jq().find("select"),a=i.facetValues={},o=n,l=null;r.empty(),e.iterate(o.getKeys(),function(e){var n=t("<option/>").attr("value",e).text(e);r.append(n),a[e]=o.get(e),l=l||e}),r.val(l).trigger("change"),i.$lastKey=l},l.prototype.doRead=function(){var t=this;return o(t,t.currentEditor).then(function(){var n=[],i=[];return e.iterate(t.facetValues,function(e,t){n.push(t),i.push(e)}),e.Facets.make(n,i)})},l}),define("mobile/fieldeditors/mobile/FrozenEnumEditor",["mobile/fieldeditors/mobile/EnumEditor"],function(e){"use strict";var t=function(){e.apply(this,arguments)};return t.prototype=Object.create(e.prototype),t.prototype.constructor=t,t.prototype.doRead=function(){var e=this.jq().find("select");return this.value().get(Number(e.val()))},t});var _slicedToArray=function(){function e(e,t){var n=[],i=!0,r=!1,a=void 0;try{for(var o,l=e[Symbol.iterator]();!(i=(o=l.next()).done)&&(n.push(o.value),!t||n.length!==t);i=!0);}catch(e){r=!0,a=e}finally{try{!i&&l.return&&l.return()}finally{if(r)throw a}}return n}return function(t,n){if(Array.isArray(t))return t;if(Symbol.iterator in Object(t))return e(t,n);throw new TypeError("Invalid attempt to destructure non-iterable instance")}}();define("mobile/fieldeditors/mobile/NonEditableEditor",["lex!mobile","jquery","mobile/fieldeditors/MobileFieldEditor"],function(e,t,n){"use strict";var i=_slicedToArray(e,1),r=i[0],a=function(){n.apply(this,arguments)};return a.prototype=Object.create(n.prototype),a.prototype.constructor=a,a.prototype.doInitialize=function(e){e.append('<span class="nonEditable" />')},a.prototype.doLoad=function(e){var t=this.jq().find("span"),n=r.get({key:"propsheet.message.nonEditable",def:"Not Editable In Mobile Property Sheet"});t.text(e.getType()+" "+n)},a}),define("mobile/fieldeditors/mobile/StringEditor",["baja!","jquery","Promise","mobile/fieldeditors/MobileFieldEditor","mobile/fieldeditors/mobile/feUtils"],function(e,t,n,i,r){"use strict";var a=r.getFacets,o=r.minMaxCheck,l=function(){var e=this;i.apply(this,arguments),this.validators().add(function(t){var n=a(e);if(n)return o(e,n.get("min"),n.get("max"),t.length)})};return l.prototype=Object.create(i.prototype),l.prototype.constructor=l,l.prototype.doInitialize=function(e){var n,i,r=a(this);r&&r.get("multiLine")?(i=r.get("fieldWidth"),n=t('<textarea cols="40" rows="10"></textarea>'),i&&n.attr("cols",i)):n=t('<input type="text"/>'),n.attr("name",this.name).appendTo(e).textinput()},l.prototype.doLoad=function(t){if(null!==t&&void 0!==t){var n;"function"==typeof t.encodeToString?n=t.encodeToString():(n=JSON.stringify(e.bson.encodeValue(t)),this.setEnabled(!1)),this.jq().find("input,textarea").val(n)}},l.prototype.doRead=function(){return this.jq().find("input,textarea").val()},l}),define("mobile/fieldeditors/mobile/NumericEditor",["baja!","jquery","Promise","mobile/fieldeditors/MobileFieldEditor","mobile/fieldeditors/mobile/StringEditor","mobile/fieldeditors/mobile/feUtils"],function(e,t,n,i,r,a){"use strict";function o(t){var i=d(t),r=i.get("units"),a=i.get("unitConversion");return!r||r.equals(e.Unit.NULL)?n.resolve(null):a?e.UnitDatabase.get().then(function(t){var n=l(a),i=e.$("baja:UnitConversion",n).getTag();return t.convertUnit(i,r)}):n.resolve(r)}function l(t){return e.hasType(t,"baja:Enum")?t.getOrdinal():e.hasType(t,"baja:Number")?t.valueOf():null}function u(t){var n=d(t).get("units");return n&&!n.equals(e.Unit.NULL)?n:null}function s(e){var t=Number(r.prototype.doRead.call(e));return o(e).then(function(n){return n&&!isNaN(t)&&(t=n.convertTo(u(e),t)),t})}function c(t){return e.hasType(t,"baja:Number")}var d=a.getFacets,f=a.minMaxCheck,p=function(){var e=this;i.apply(this,arguments),this.validators().add(function(t){var n=d(e);if(n)return f(e,n.get("min"),n.get("max"),t)})};return p.prototype=Object.create(i.prototype),p.prototype.constructor=p,p.prototype.doInitialize=function(e){var n=t('<div class="numericWrapper"/>'),i=t('<label class="unitsDisplay"/>').appendTo(n),r=t('<span class="inputWrapper"/>').appendTo(n),a=t('<input type="text" data-theme="c"/>').attr("name",this.name).appendTo(r);return o(this).then(function(t){t?(t.getIsPrefix()&&(i.css("order","0"),a.css("text-align","left")),i.text(t.getSymbol()),i.show()):i.hide(),n.appendTo(e)})},p.prototype.doLoad=function(e){var t=this,n=e.valueOf(),i=d(t),a=i&&i.get("precision");return o(t).then(function(e){if(e){var i=u(t);n=i.convertTo(e,n)}return c(n)&&c(a)&&(n=n.toFixed(Math.min(a,20))),r.prototype.doLoad.call(t,n)})},p.prototype.doRead=function(){var t=this.value().getType(),n=r.prototype.doRead.call(this);return s(this).then(function(i){if(t.is("baja:Integer"))switch(n.toLowerCase()){case"min":return e.Integer.MIN_VALUE;case"max":return e.Integer.MAX_VALUE;default:if(isNaN(i))throw new Error(n+" is not a valid Integer value");return e.Integer.make(i)}else if(t.is("baja:Long"))switch(n.toLowerCase()){case"min":return e.Long.MIN_VALUE;case"max":return e.Long.MAX_VALUE;default:if(isNaN(i))throw new Error(n+" is not a valid Long value");return e.Long.make(i)}else if(t.is("baja:Float"))switch(n.toLowerCase()){case"nan":return e.Float.NAN;case"-inf":return e.Float.NEGATIVE_INFINITY;case"+inf":return e.Float.POSITIVE_INFINITY;default:if(isNaN(i))throw new Error(n+" is not a valid Float value");return e.Float.make(i)}else{if(!t.is("baja:Double")){if(isNaN(i))throw new Error(n+" is not a valid numeric value");return i}switch(n.toLowerCase()){case"nan":return e.Double.NaN;case"-inf":return e.Double.NEGATIVE_INFINITY;case"+inf":return e.Double.POSITIVE_INFINITY;default:if(isNaN(i))throw new Error(n+" is not a valid Double value");return e.Double.make(i)}}})},p}),define("mobile/util/ord",["baja!"],function(e){"use strict";function t(e){if(!e)return"";e=String(e);var t=e.length,n=e.substring(t-1,t),i=e.substring(t-2,t-1);return"/"===n&&":"!==i?e=e.substring(0,t-1):":"===n&&(e+="/"),e}function n(t,n){return t=e.Ord.make(t),void 0===n&&(n=!0),t.get({lease:n})}function i(e){e=unescape(String(e)),e.match(/\/$/)&&(e=e.substring(0,e.length-1));var n=e.split("/"),i=0,r=[];for(i=0;i<n.length;i++)r.push(t(n.slice(0,i+1).join("/")));return r}function r(t,n){return!(!t||!n)&&e.Ord.make(t).relativizeToSession().equals(e.Ord.make(n).relativizeToSession())}function a(t){if(t){if(t instanceof e.Ord||"string"==typeof t)return t.toString();if(t.getType().isComponent()&&t.isMounted())return t.getNavOrd().relativizeToSession().toString();if(t.getType().isComplex()){var n=a(t.getParent());if(n)return n+"/"+t.getPropertyInParent()}}}return{chopLastSlash:t,deriveOrd:a,equivalent:r,get:n,makeOrdHistory:i}});var _slicedToArray=function(){function e(e,t){var n=[],i=!0,r=!1,a=void 0;try{for(var o,l=e[Symbol.iterator]();!(i=(o=l.next()).done)&&(n.push(o.value),!t||n.length!==t);i=!0);}catch(e){r=!0,a=e}finally{try{!i&&l.return&&l.return()}finally{if(r)throw a}}return n}return function(t,n){if(Array.isArray(t))return t;if(Symbol.iterator in Object(t))return e(t,n);throw new TypeError("Invalid attempt to destructure non-iterable instance")}}();define("mobile/fieldeditors/mobile/OrdComponentSelector",["baja!","lex!mobile","jquery","mobile/fieldeditors/MobileFieldEditor","mobile/util/ord"],function(e,t,n,i,r){"use strict";function a(e){if(e=String(e),e.indexOf("slotPathOrd")<0||e.indexOf("displayName")<0)throw"Must select slotPathOrd and displayName"}var o=r.equivalent,l=_slicedToArray(t,1),u=l[0],s=function(){i.apply(this,arguments)};return s.prototype=Object.create(i.prototype),s.prototype.constructor=s,s.prototype.doInitialize=function(e){n('<select data-role="selectmenu" data-theme="a" />').attr("name",this.name).appendTo(e).append(n("<option/>").text(u.get("loading")))},s.prototype.doLoad=function(t){var i=this.jq(),r=i.find("select");r.html(n("<option/>").text(u.get("loading")));try{a(t)}catch(e){i.text(e)}return e.Ord.make(String(t)).get({cursor:{before:function(){r.empty()},each:function(){var e=this.get("slotPathOrd"),i=this.get("displayName"),a=n("<option/>").val(e).text(i);o(t,e)&&a.attr("selected","selected"),a.appendTo(r)},after:function(){r.selectmenu("refresh")},limit:100}})},s.prototype.doRead=function(){return e.Ord.make(this.jq().find("select").val())},s});var _slicedToArray=function(){function e(e,t){var n=[],i=!0,r=!1,a=void 0;try{for(var o,l=e[Symbol.iterator]();!(i=(o=l.next()).done)&&(n.push(o.value),!t||n.length!==t);i=!0);}catch(e){r=!0,a=e}finally{try{!i&&l.return&&l.return()}finally{if(r)throw a}}return n}return function(t,n){if(Array.isArray(t))return t;if(Symbol.iterator in Object(t))return e(t,n);throw new TypeError("Invalid attempt to destructure non-iterable instance")}}();define("mobile/fieldeditors/mobile/RelTimeEditor",["baja!","lex!mobile","jquery","mobile/fieldeditors/MobileFieldEditor","mobile/fieldeditors/mobile/feUtils","mobile/util/time"],function(e,t,n,i,r,a){"use strict";function o(t){var n,i=l(t),r=i.get("max"),a=i.get("min"),o=null,u=null;return r&&r.getType().is("baja:RelTime")&&(o=r.getMillis()),a&&a.getType().is("baja:RelTime")&&(u=a.getMillis()),null!==u&&null!==o&&u>o&&(u=null,o=null),null===o&&null===u||(n="["+(u===e.Long.MIN_VALUE?"-inf":e.RelTime.make(u).encodeToString()+"ms")+" - "+(o===e.Long.MAX_VALUE?"+inf":e.RelTime.make(o).encodeToString()+"ms")+"]"),{min:u,max:o,str:n,normalize:function(e){return null!==o&&e>o?o:null!==u&&e<u?u:e}}}var l=r.getFacets,u=r.minMaxCheck,s=a.toTimeString,c=_slicedToArray(t,1),d=c[0],f=function(){i.apply(this,arguments),this.validators().add(function(e){var t=o(this);return u.call(this,t.min,t.max,e.getMillis())})};return f.prototype=Object.create(i.prototype),f.prototype.constructor=f,f.prototype.doInitialize=function(e){var t,i,r=this,a=r.name,l=r.params,u=n('<input type="text" data-role="datebox" />').attr("name",a),s=o(r);t={mode:"durationbox",useDialogForceFalse:!0,lockInput:!1,defaultValue:new Date,durationLabel:d.get({key:"propsheet.datebox.durationLabel",def:"Days Hours Minutes Seconds"}).split(" "),setDurationButtonLabel:d.get({key:"propsheet.datebox.setDurationButtonLabel",def:"Set Duration"}),durationFormat:l.durationFormat,durationOrder:l.durationOrder},u.attr("data-options",JSON.stringify(t)),u.appendTo(e),e.on("datebox",'input:jqmData(role="datebox")',function(e,t){function r(){var e=n(".ui-datebox-container .ui-datebox-controls"),t=e.prev();t.hasClass("relTimeRange")||(t=n('<div class="relTimeRange"></div>').insertBefore(e)),t.text(s.str)}var a=n(this);"open"===t.method&&r(),"open"===t.method||"offset"===t.method?i=function(){var e,t=a.datebox("getTheDate"),n=new Date(a.datebox("getOption","defaultValue")),i=t-n,r=i%1e3,o=i-r+(r?1e3:0);(e=s.normalize(o))!==o&&(a.datebox("setTheDate",new Date(n.getTime()+e)),a.datebox("refresh"))}:"postrefresh"===t.method&&i&&(i(),i=void 0,r())})},f.prototype.doLoad=function(e){if(e){var t=this,n=t.jq(),i=n.find('input:jqmData(role="datebox")'),r=e.getDaysPart(),a=e.getHoursPart(),o=e.getMinutesPart(),l=e.getSecondsPart(),u="";u+=r+" Day"+(r>1?"s":"")+", ",u+=s(a,o,l),i.trigger("datebox",{method:"set",value:u})}},f.prototype.doRead=function(){var t=this.jq().find('input:jqmData(role="datebox")'),n=new Date(t.datebox("getOption","defaultValue")),i=t.datebox("getTheDate"),r=i.getTime()-n.getTime();return r=1e3*Math.ceil(r/1e3),e.RelTime.make(r)},f}),define("mobile/fieldeditors/mobile/DurationSelectRelTimeEditor",["baja!","jquery","underscore","mobile/fieldeditors/mobile/RelTimeEditor","nmodule/js/rc/asyncUtils/asyncUtils"],function(e,t,n,i,r){"use strict";var a=r.doRequire,o=[["override.perm",0],["override.min1",6e4],["override.min15",9e5],["override.min30",18e5],["override.hour1",36e5],["override.hour2",72e5],["override.hour3",108e5],["override.custom",-1]],l=function(){i.apply(this,arguments)};return l.prototype=Object.create(i.prototype),l.prototype.constructor=l,l.prototype.doInitialize=function(e){var i=t('<select class="durationChoice" data-theme="a" />'),r=this;return a("lex!control").spread(function(a){function l(e,n){var r=t('<option value="'+n+'"/>');r.text(a.get(e)),r.appendTo(i)}var u=r.facets.get("max");null===u||u.getType().is("baja:RelTime")||(u=null),n.each(o,function(e){var t=e[0],n=e[1];(null===u||-1===n||n>0&&n<=u.getMillis())&&l(t,n)}),e.append(i)})},l.prototype.doLoad=function(e){var t=e?e.getMillis():"-1",n=this.jq().find("select");n.find('option[value="'+t+'"]').length?n.val(String(t)):n.val("-1"),n.trigger("change"),n.selectmenu("refresh")},l.prototype.doRead=function(){var t=this.jq().find("select"),n=Number(t.val());return-1===n?-1:e.RelTime.make(Number(n))},l}),define("mobile/fieldeditors/mobile/OverrideRelTimeEditor",["baja!","jquery","Promise","mobile/fieldeditors/MobileFieldEditor","mobile/fieldeditors/mobile/DurationSelectRelTimeEditor","mobile/fieldeditors/mobile/RelTimeEditor"],function(e,t,n,i,r,a){"use strict";var o=function(){i.apply(this,arguments)};return o.prototype=Object.create(i.prototype),o.prototype.constructor=o,o.prototype.doInitialize=function(n){function i(i){return null!==i&&(s.facets=e.Facets.make(s.facets,{max:i,min:e.RelTime.make(1e3)}),s.maxOverride=i,u.facets=e.Facets.make(u.facets,{max:i,min:e.RelTime.make(1e3)})),u.initialize(n).then(function(){return s.initialize(n).then(function(){return i&&s.load(i)})}).then(function(){o.$durationSelectEditor=u,o.$relTimeEditor=s,n.on("change","select",function(){var n=t(this).val();"-1"===n?(s.setEnabled(!0),s.load(e.RelTime.make(0))):(s.setEnabled(!1),s.load(e.RelTime.make(Number(n)))),o.setModified(!0)})})}var o=this,l=o.value(),u=new r(e.RelTime.make(0),l,"duration",{parent:o}),s=new a(e.RelTime.make(0),l,"duration",{parent:o}),c=o.facets.get("maxOverrideDuration");return null!==c?i(c):e.Ord.make("station:|slot:/").get({lease:100}).then(function(e){return i(e.get("sysInfo").get("maxOverrideDuration"))})},o.prototype.doLoad=function(e){var t=this,i=t.$durationSelectEditor,r=t.$relTimeEditor,a=r.maxOverride;return delete r.maxOverride,i.load(a||e).then(function(){return i.read()}).then(function(i){return n.join(r.load(a||e),r.setEnabled(!t.isEnabled()||-1===i))})},o.prototype.doRead=function(){return this.$relTimeEditor.read()},o});var _slicedToArray=function(){function e(e,t){var n=[],i=!0,r=!1,a=void 0;try{for(var o,l=e[Symbol.iterator]();!(i=(o=l.next()).done)&&(n.push(o.value),!t||n.length!==t);i=!0);}catch(e){r=!0,a=e}finally{try{!i&&l.return&&l.return()}finally{if(r)throw a}}return n}return function(t,n){if(Array.isArray(t))return t;if(Symbol.iterator in Object(t))return e(t,n);throw new TypeError("Invalid attempt to destructure non-iterable instance")}}();define("mobile/fieldeditors/mobile/TimeEditor",["baja!","lex!mobile","jquery","jqmDatebox","underscore","mobile/fieldeditors/MobileFieldEditor","mobile/fieldeditors/mobile/feUtils","mobile/util/time"],function(e,t,n,i,r,a,o,l){"use strict";function u(t,n){var i=t.jq().find("input[name$=time]"),a=i.datebox("getTheDate"),o=0,l=r.indexOf(["hour","minute","second","millisecond"],n||"millisecond");if(l<0)throw new Error("invalid accuracy argument "+n);return l>=0&&(o+=a.getHours()*p),l>=1&&(o+=a.getMinutes()*h),l>=2&&(o+=a.getSeconds()*m),l>=3&&(o+=a.getMilliseconds()),e.Time.make(o)}function s(e){var t=n('<input type="text" data-role="datebox" id="'+e+'_time" name="'+e+'_time"/>'),i=f();return i.mode="timebox",i.useDialogForceFalse=!0,i.lockInput=!1,i.centerHoriz=!0,i.centerVert=!0,i.setTimeButtonLabel=v.get({key:"propsheet.datebox.setTimeButtonLabel",def:"Set Time"}),t.attr("data-options",JSON.stringify(i)),t}
var c=o.dateboxArmHandlers,d=o.getBajaTimeFormat,f=o.getDateboxDefaultOptions,p=l.MILLIS_IN_HOUR,h=l.MILLIS_IN_MINUTE,m=l.MILLIS_IN_SECOND,g=_slicedToArray(t,1),v=g[0],y=function(){a.apply(this,arguments)};return y.prototype=Object.create(a.prototype),y.prototype.constructor=y,y.prototype.doInitialize=function(e){e.append(s(this.name)),c(e)},y.prototype.doLoad=function(e){if(null!==e&&void 0!==e){var t=this.jq().find('input:jqmData(role="datebox")');return e.toTimeString({textPattern:d()||"HH:mm"}).then(function(e){t.trigger("datebox",{method:"set",value:e})})}},y.prototype.doRead=function(){return u(this,"minute")},y}),define("mobile/fieldeditors/mobile/UnitEditor",["baja!","jquery","underscore","mobile/fieldeditors/MobileFieldEditor"],function(e,t,n,i){"use strict";function r(){return e.UnitDatabase.get().then(function(e){function t(){return s}function i(e){return n.filter(s,function(e){var t=e.getName(),n=t.match(a);return n&&n[0]})}function r(e){return n.find(s,function(t){return t.getName()===e})}function o(e){var t=i(String(e.getDimension()));return n.find(t,function(t){return n.find(t.getUnits(),function(t){return e.equivalent(t)})})}function l(e){var t=r(e);return t&&t.getUnits()}function u(e,t){function r(t){return t.getSymbol()===e}for(var a=i(t),o=0;o<a.length;o++){var l=n.find(a[o].getUnits(),r);if(l)return l}}var s=e.getQuantities();return{getQuantities:t,getQuantityFromUnit:o,getUnits:l,getUnitFromSymbolAndDimension:u}})}var a=/\(\S*\)/,o=n.once(r),l=function(){i.apply(this,arguments)};return l.prototype=Object.create(i.prototype),l.prototype.constructor=l,l.prototype.doInitialize=function(e){var i=t('<select data-role="selectmenu" data-theme="a" name="quantity" />').append("<option>loading</option>"),r=t('<select data-role="selectmenu" data-theme="a" name="units" />').append("<option>loading</option>");return e.append(i),e.append(r),o().then(function(a){i.html(n.map(a.getQuantities(),function(e){var n=e.getName();return t("<option/>").attr("value",n||"").text(n)})),i.on("change",function(){var e=t(this).find("option:selected").text(),i=a.getUnits(e);r.html(n.map(i,function(e){return t("<option/>").val(e.getUnitName()).text(e.getUnitName()+" ("+e.getSymbol()+")").jqmData("unit",e)})),r.selectmenu("refresh").trigger("updatelayout")}),i.appendTo(e),r.appendTo(e)})},l.prototype.doLoad=function(e){var t=this.jq(),n=t.find("select[name=quantity]"),i=t.find("select[name=units]");return o().then(function(t){var r=t.getQuantityFromUnit(e);r&&(n.val(r.getName()).trigger("change"),i.val(e.getUnitName()).trigger("change"))})},l.prototype.doRead=function(){return this.jq().find("select[name=units]").find("option:selected").jqmData("unit")},l});var _slicedToArray=function(){function e(e,t){var n=[],i=!0,r=!1,a=void 0;try{for(var o,l=e[Symbol.iterator]();!(i=(o=l.next()).done)&&(n.push(o.value),!t||n.length!==t);i=!0);}catch(e){r=!0,a=e}finally{try{!i&&l.return&&l.return()}finally{if(r)throw a}}return n}return function(t,n){if(Array.isArray(t))return t;if(Symbol.iterator in Object(t))return e(t,n);throw new TypeError("Invalid attempt to destructure non-iterable instance")}}();define("mobile/fieldeditors/fieldeditors.mobile",["baja!baja:Month,baja:UnitConversion","jqmDatebox","css!mobile/fieldeditors/fieldeditors","baja!","lex!mobile","jquery","jquerymobile","Promise","underscore","mobile/fieldeditors/fieldeditors","mobile/fieldeditors/fieldeditors.composite","mobile/fieldeditors/MobileFieldEditor","mobile/fieldeditors/mobile/AbsTimeEditor","mobile/fieldeditors/mobile/BooleanEditor","mobile/fieldeditors/mobile/BooleanCheckboxEditor","mobile/fieldeditors/mobile/DateEditor","mobile/fieldeditors/mobile/DynamicEnumEditor","mobile/fieldeditors/mobile/FacetsEditor","mobile/fieldeditors/mobile/FrozenEnumEditor","mobile/fieldeditors/mobile/NonEditableEditor","mobile/fieldeditors/mobile/NumericEditor","mobile/fieldeditors/mobile/OrdComponentSelector","mobile/fieldeditors/mobile/OverrideRelTimeEditor","mobile/fieldeditors/mobile/RelTimeEditor","mobile/fieldeditors/mobile/StringEditor","mobile/fieldeditors/mobile/TimeEditor","mobile/fieldeditors/mobile/UnitEditor"],function(e,t,n,i,r,a,o,l,u,s,c,d,f,p,h,m,g,v,y,b,k,S,T,E,j,D,w){var x=s.register,C=s.toSaveDataComponent,M=_slicedToArray(r,1),I=M[0],A={};return A=function(){function e(e){var t="nulldefault"+o++,n=a('<fieldset data-role="controlgroup" class="nulldefault"/>'),i=a('<input type="checkbox" data-theme="a" name="nulldefault"/>').attr("id",t).addClass("hidden"),r=a("<label/>").attr("for",t).text(I.get("propsheet.nullDefault"));n.append(i).append(r),e.append(n)}function t(e){return e.find("input[name=nulldefault]").is(":checked")?i.Status.nullStatus:i.Status.ok}function n(e){var t=e.find("input[type=text], textarea"),n=e.find("select");e.find("input[type=checkbox]").is(":checked")?(t.attr("disabled","disabled"),n.filter(':jqmData(role="slider")').slider("disable"),n.filter(':jqmData(role!="slider")').selectmenu("disable")):(t.removeAttr("disabled"),n.filter(':jqmData(role="slider")').slider("enable"),n.filter(':jqmData(role!="slider")').selectmenu("enable"))}function r(r){return function(a,o,u,s){var c=new r(a,o,u,s),d=c.$validators.$validators;return c.doInitialize=function(t){var i=this;return l.resolve(r.prototype.doInitialize.call(i,t)).then(function(){e(t),t.find('input[type="checkbox"]').change(function(){i.isEnabled()&&n(t)})})},i.iterate(d,function(e,t){d[t]=function(t){return e.call(this,t.getValue())}}),c.doEnabled=function(){var e=this;r.prototype.doEnabled.apply(e,arguments),e.isEnabled()&&n(e.jq())},c.doLoad=function(e){var t=e;if(t)return l.resolve(r.prototype.doLoad.call(this,t.getValue())).then(function(){var e=t.getStatus();c.jq().find('input[type="checkbox"]').prop("checked",e.isNull())})},c.doRead=function(){return l.resolve(r.prototype.doRead.call(this)).then(function(e){var n=t(c.jq()),i=c.value(),r=C(i);return r.set({slot:"value",value:e}),r.set({slot:"status",value:n}),r})},c.refreshWidgets=function(){var e=this;r.prototype.refreshWidgets.apply(e,arguments),e.isEnabled()&&n(e.jq())},c}}var o=0;return{wrapWithStatus:r}}(),function(){function e(e){i.iterate(e,function(e,t){x(t,e)})}var t,n,r,a;t={"baja:AbsTime":f,"baja:Boolean":p,"baja:Date":m,"baja:DynamicEnum":g,"baja:FrozenEnum":y,"baja:Number":k,"baja:RelTime":E,"baja:String":j,"baja:Time":D,"baja:Facets":v,"baja:Unit":w},n={"baja:StatusBoolean":A.wrapWithStatus(t["baja:Boolean"]),"baja:StatusEnum":A.wrapWithStatus(t["baja:DynamicEnum"]),"baja:StatusNumeric":A.wrapWithStatus(t["baja:Number"]),"baja:StatusString":A.wrapWithStatus(t["baja:String"])},r={"control:BooleanOverride":c.makeComposite([{slot:"duration",key:"override"},"value"]),"control:EnumOverride":c.makeComposite([{slot:"duration",key:"override"},"value"]),"control:NumericOverride":c.makeComposite([{slot:"duration",key:"override"},"value"]),"control:Override":c.makeComposite([{slot:"duration",key:"override"}]),"control:StringOverride":c.makeComposite([{slot:"duration",key:"override"},"value"]),"baja:AbsTimeRange":c.makeComposite(["startTime","endTime"]),"baja:TimeRange":c.makeComposite(["startTime","endTime"])},a={"baja:EnumRange":b,"baja:Password":b,"baja:TimeZone":b},e(t),e(n),e(r),e(a),x("baja:Boolean",h,"checkbox")}(),function(){x("baja:RelTime",T,"override"),x("baja:Ord",S,"componentSelector")}(),{status:A}});var _slicedToArray=function(){function e(e,t){var n=[],i=!0,r=!1,a=void 0;try{for(var o,l=e[Symbol.iterator]();!(i=(o=l.next()).done)&&(n.push(o.value),!t||n.length!==t);i=!0);}catch(e){r=!0,a=e}finally{try{!i&&l.return&&l.return()}finally{if(r)throw a}}return n}return function(t,n){if(Array.isArray(t))return t;if(Symbol.iterator in Object(t))return e(t,n);throw new TypeError("Invalid attempt to destructure non-iterable instance")}}();define("mobile/schedule/util.schedule",["baja!","jquery","underscore","mobile/util/time","mobile/fieldeditors/mobile/feUtils","lex!baja"],function(e,t,n,i,r,a){"use strict";var o=r.getBajaTimeFormat,l=i.MILLIS_IN_DAY,u=_slicedToArray(a,1),s=u[0],c=void 0,d=void 0,f={},p=n.once(function(){return n.map([3,6,9,12,15,18,21],function(t){return e.Time.make({hour:t}).toTimeStringSync({textPattern:"HH:mm"|o(),lex:s})})});return f.pixelsToMillis=function(e,t){return t/e.children(".blocksDisplay").outerHeight()*l},f.millisToPixels=function(e,t){return t/l*e.children(".blocksDisplay").outerHeight()},f.percentageOfDay=function(e){return e/l},f.addMonths=function(t,n){var i=t.getDate(),r=i.getYear(),a=i.getMonth().getOrdinal()+n;return-1===a?(r--,a=11):12===a&&(r++,a=0),i=e.Date.DEFAULT.make({year:r,month:a,day:2}),e.AbsTime.make({date:i,time:e.Time.make(0)})},f.appendTimeLabels=function(e){var n=t('<div class="scheduleLabels" />').appendTo(e);return p().forEach(function(e,i){var r=t("<div/>").append(t('<div class="labelDiv"/>').append(t("<label/>").text(e)));r.addClass("scheduleLabel scheduleLabel"+i),n.append(r)}),n},f.getCurrentSchedule=function(){return c},f.setCurrentSchedule=function(e){c=e},f.getLastEnteredValue=function(){return d},f.setLastEnteredValue=function(e){d=e},f.updateScheduleBlockDiv=function(e){var t,n=e.data("scheduleBlock"),r=n.start,a=n.finish,o=n.value,l=e.find("div.display"),u=e.parent(),s=e.children(".scheduleBlock"),d=i.millisOfDay(r),p=i.millisOfDay(a),h=f.percentageOfDay(d),m=f.percentageOfDay(p),g=Math.floor(h*u.height()),v=Math.floor(m*u.height()),y=e.outerHeight()-e.height()-2;0===p&&(v=u.height()+1),c.stringify(o).then(function(e){l.children("span.valueDisplay").text(e)}),l.children("span.timeDisplay").text("("+n+")"),t=v-g-y,e.css({top:g,height:t}),n.$colors.apply(s)},f.relayoutLabelsDiv=function(e,t){var i=t/8;e.height(t),n.range(0,7).forEach(function(t){var n=e.children("div.scheduleLabel"+t);n.height(i),n.css("bottom",i*(6-t))})},f.relayoutDayDiv=function(e){var i=e.find("div.blocksDisplay").height(),r=i/8,a=e.siblings("div.scheduleLabels");n.range(0,8).forEach(function(t){e.find("div.block.block"+t).css("top",r*t)}),a.length&&f.relayoutLabelsDiv(a,i),t(".scheduleBlockContainer",e).each(function(){f.updateScheduleBlockDiv(t(this))})},f}),define("mobile/util/color",["jquery"],function(e){"use strict";function t(e,t){return Math.max(0,Math.min(e,t))}function n(e){var t=Math.round(e).toString(16);return 1===t.length?"0"+t:t}function i(e,t,n,i){return e=Math.round(e),t=Math.round(t),n=Math.round(n),"number"==typeof i?"rgba("+e+","+t+","+n+","+i+")":"rgb("+e+","+t+","+n+")"}function r(e){return parseInt(e,16)}function a(e){if("%"===e.charAt(e.length-1)){var t=parseInt(e.substring(0,e.length-1),10);return Math.round(2.55*t)}return parseInt(e,10)}function o(e,t,n){return.2126*e+.7152*t+.0722*n}function l(e,n,i){e=t(e,255)/255,n=t(n,255)/255,i=t(i,255)/255;var r,a=Math.max(e,n,i),o=Math.min(e,n,i),l=a,u=a-o,s=0===a?0:u/a;if(a===o)r=0;else{switch(a){case e:r=(n-i)/u+(n<i?6:0);break;case n:r=(i-e)/u+2;break;case i:r=(e-n)/u+4}r/=6}return[r,s,l]}function u(e,t,i){return"#"+n(e)+n(t)+n(i)}function s(e,t,n,r,a){var o=l(e,t,n),s=this;"number"!=typeof r&&(r=255),s.red=e,s.green=t,s.blue=n,s.alpha=r,s.css="string"==typeof a?a:i(e,t,n,r/255),s.hexString=u(e,t,n),s.h=o[0],s.s=o[1],s.v=o[2]}function c(e,n,i){e=t(e,1),n=t(n,1),i=t(i,1);var r,a,o,l=Math.floor(6*e),u=6*e-l,c=i*(1-n),d=i*(1-u*n),f=i*(1-(1-u)*n);switch(l%6){case 0:r=i,a=f,o=c;break;case 1:r=d,a=i,o=c;break;case 2:r=c,a=i,o=f;break;case 3:r=c,a=d,o=i;break;case 4:r=f,a=c,o=i;break;case 5:r=i,a=c,o=d}return new s(255*r,255*a,255*o)}function d(n){if(n instanceof s)return n;var i,o,l,u,c,d,f,b=v[n],k=0,S=0,T=0,E=255;if(e.isArray(n))return k=t(n[0],255),S=t(n[1],255),T=t(n[2],255),"number"==typeof n[3]?(E=t(n[3],255),new s(k,S,T,E)):new s(k,S,T);if("string"!=typeof n)throw new Error("invalid input to parseRgba: "+n);if(y[n])return y[n];if("string"==typeof b&&(n=b),i=p.exec(n),i&&(o=i[1],l=i[2],u=i[3],c=i[4],c?(E=r(o)/255,k=r(l),S=r(u),T=r(c),d="rgba("+k+","+S+","+T+","+E+")"):(k=r(o),S=r(l),T=r(u),d=n)),i||(i=h.exec(n))&&(o=i[1],l=i[2],u=i[3],k=r(o+o),S=r(l+l),T=r(u+u),d=n),i||(i=m.exec(n))&&(k=a(i[1]),S=a(i[2]),T=a(i[3]),d="rgb("+k+","+S+","+T+")"),i||(i=g.exec(n))&&(k=a(i[1]),S=a(i[2]),T=a(i[3]),E=255*parseFloat(i[4]),d="rgba("+k+","+S+","+T+","+E/255+")"),!i)throw new Error("could not parse string: "+n);return y[n]=f=new s(k,S,T,E,d),f}function f(e,t){var n=e.red,i=e.green,r=e.blue,a=e.alpha/255,o=t.red,l=t.green,u=t.blue;return n=Math.round(a*(n-o)+o),i=Math.round(a*(i-l)+l),r=Math.round(a*(r-u)+u),new s(n,i,r)}var p=/^\#([0-9a-fA-F]{2})([0-9a-fA-F]{2})([0-9a-fA-F]{2})([0-9a-fA-F]{2})?$/,h=/^\#([0-9a-fA-F])([0-9a-fA-F])([0-9a-fA-F])$/,m=/^rgb\([\s]*?([0-9]+[%]?)[\s]*?,[\s]*?([0-9]+[%]?)[\s]*?,[\s]*?([0-9]+[%]?)[\s]*?\)$/,g=/^rgba\([\s]*?([0-9]+[%]?)[\s]*?,[\s]*?([0-9]+[%]?)[\s]*?,[\s]*?([0-9]+[%]?)[\s]*?,[\s]*?([0-9\.]+)[\s]*?\)$/,v={transparent:"rgba(0, 0, 0, 0)",aliceBlue:"#f0f8ff",antiqueWhite:"#faebd7",aqua:"#00ffff",aquamarine:"#7fffd4",azure:"#f0ffff",beige:"#f5f5dc",bisque:"#ffe4c4",black:"#000000",blanchedAlmond:"#ffebcd",blue:"#0000ff",blueViolet:"#8a2be2",brown:"#a52a2a",burlyWood:"#deb887",cadetBlue:"#5f9ea0",chartreuse:"#7fff00",chocolate:"#d2691e",coral:"#ff7f50",cornflowerBlue:"#6495ed",cornsilk:"#fff8dc",crimson:"#dc143c",cyan:"#00ffff",darkBlue:"#00008b",darkCyan:"#008b8b",darkGoldenrod:"#b8860b",darkGray:"#a9a9a9",darkGreen:"#006400",darkGrey:"#a9a9a9",darkKhaki:"#bdb76b",darkMagenta:"#8b008b",darkOliveGreen:"#556b2f",darkOrange:"#ff8c00",darkOrchid:"#9932cc",darkRed:"#8b0000",darkSalmon:"#e9967a",darkSeaGreen:"#8fbc8f",darkSlateBlue:"#483d8b",darkSlateGray:"#2f4f4f",darkSlateGrey:"#2f4f4f",darkTurquoise:"#00ced1",darkViolet:"#9400d3",deepPink:"#ff1493",deepSkyBlue:"#00bfff",dimGray:"#696969",dimGrey:"#696969",dodgerBlue:"#1e90ff",firebrick:"#b22222",floralWhite:"#fffaf0",forestGreen:"#228b22",fuchsia:"#ff00ff",gainsboro:"#dcdcdc",ghostWhite:"#f8f8ff",gold:"#ffd700",goldenrod:"#daa520",gray:"#808080",green:"#008000",greenYellow:"#adff2f",grey:"#808080",honeydew:"#f0fff0",hotPink:"#ff69b4",indianRed:"#cd5c5c",indigo:"#4b0082",ivory:"#fffff0",khaki:"#f0e68c",lavender:"#e6e6fa",lavenderBlush:"#fff0f5",lawnGreen:"#7cfc00",lemonChiffon:"#fffacd",lightBlue:"#add8e6",lightCoral:"#f08080",lightCyan:"#e0ffff",lightGoldenrodYellow:"#fafad2",lightGray:"#d3d3d3",lightGreen:"#90ee90",lightGrey:"#d3d3d3",lightPink:"#ffb6c1",lightSalmon:"#ffa07a",lightSeaGreen:"#20b2aa",lightSkyBlue:"#87cefa",lightSlateGray:"#778899",lightSlateGrey:"#778899",lightSteelBlue:"#b0c4de",lightYellow:"#ffffe0",lime:"#00ff00",limeGreen:"#32cd32",linen:"#faf0e6",magenta:"#ff00ff",maroon:"#800000",mediumAquamarine:"#66cdaa",mediumBlue:"#0000cd",mediumOrchid:"#ba55d3",mediumPurple:"#9370db",mediumSeaGreen:"#3cb371",mediumSlateBlue:"#7b68ee",mediumSpringGreen:"#00fa9a",mediumTurquoise:"#48d1cc",mediumVioletRed:"#c71585",midnightBlue:"#191970",mintCream:"#f5fffa",mistyRose:"#ffe4e1",moccasin:"#ffe4b5",navajoWhite:"#ffdead",navy:"#000080",oldLace:"#fdf5e6",olive:"#808000",oliveDrab:"#6b8e23",orange:"#ffa500",orangeRed:"#ff4500",orchid:"#da70d6",paleGoldenrod:"#eee8aa",paleGreen:"#98fb98",paleTurquoise:"#afeeee",paleVioletRed:"#db7093",papayaWhip:"#ffefd5",peachPuff:"#ffdab9",peru:"#cd853f",pink:"#ffc0cb",plum:"#dda0dd",powderBlue:"#b0e0e6",purple:"#800080",red:"#ff0000",rosyBrown:"#bc8f8f",royalBlue:"#4169e1",saddleBrown:"#8b4513",salmon:"#fa8072",sandyBrown:"#f4a460",seaGreen:"#2e8b57",seaShell:"#fff5ee",sienna:"#a0522d",silver:"#c0c0c0",skyBlue:"#87ceeb",slateBlue:"#6a5acd",slateGray:"#708090",slateGrey:"#708090",snow:"#fffafa",springGreen:"#00ff7f",steelBlue:"#4682b4",tan:"#d2b48c",teal:"#008080",thistle:"#d8bfd8",tomato:"#ff6347",turquoise:"#40e0d0",violet:"#ee82ee",wheat:"#f5deb3",white:"#ffffff",whiteSmoke:"#f5f5f5",yellow:"#ffff00",yellowGreen:"#9acd32"},y={};return{COLOR_CONSTANTS:v,Color:s,alphaBlend:f,hsvToRgb:c,luma:o,parseRgba:d,rgbToHsv:l,toHexCssString:u,toRgbCssString:i}}),define("mobile/util/gradient",["mobile/util/color"],function(e){"use strict";function t(e){var t=e*Math.PI/180,n=Math.cos(t),i=Math.sin(t),r=1/Math.max(Math.abs(i),Math.abs(n)),a=n*r,o=-i*r,l=-a,u=-o;return l=Math.round(50*(l+1)),u=Math.round(50*(u+1)),a=Math.round(50*(a+1)),o=Math.round(50*(o+1)),l+"% "+u+"%, "+a+"% "+o+"%"}function n(e,n){var i,r,a,o=t(e);for(r="(linear, "+o,a=0;a<n.length;++a)i=n[a],r+=", color-stop("+i[0]+", "+i[1].css+")";return r+=")"}function i(e,t){var n,i,r=t.length,a=0;for(n="("+e+"deg, ";a<r;)i=t[a],n+=i[1].css+" "+i[0],++a<r&&(n+=", ");return n+=")"}function r(e,t,n){return u.patternReplace({gradientType:e?"0":"1",startColor:t.hexString,endColor:n.hexString})}function a(e){var t,n,i=[];for(n=0;n<e.length;n++)t=e[n],i[n]=[t[0],o(t[1])];return i}var o=e.parseRgba,l=["-webkit-","-moz-","-ms-","-o-"],u="progid:DXImageTransform.Microsoft.gradient(GradientType={gradientType},startColorstr='{startColor}', endColorstr='{endColor}')",s={};return s.createLinearGradientCss=function(e,t){if(!t||!t.length)return null;t=a(t);var o={},l=t[0],u=l[1],s=t[t.length-1],c=s[1];return o.background=u.hexString,o.filter=r(e,u,c),o.webkitGradient=n(e,t),o.linearGradientNonStandard=i(e,t),o.linearGradient=i(90-e,t),o},s.applyLinearGradientBackground=function(e,t,n){var i,r=s.createLinearGradientCss(t,n);if(null!==r){for(e.css("background",r.background),e.css("filter",r.filter),e.css("background","-webkit-gradient"+r.webkitGradient),i=0;i<l.length;i++)e.css("background",l[i]+"linear-gradient"+r.linearGradientNonStandard);e.css("background","linear-gradient"+r.linearGradient)}},s});var _slicedToArray=function(){function e(e,t){var n=[],i=!0,r=!1,a=void 0;try{for(var o,l=e[Symbol.iterator]();!(i=(o=l.next()).done)&&(n.push(o.value),!t||n.length!==t);i=!0);}catch(e){r=!0,a=e}finally{try{!i&&l.return&&l.return()}finally{if(r)throw a}}return n}return function(t,n){if(Array.isArray(t))return t;if(Symbol.iterator in Object(t))return e(t,n);throw new TypeError("Invalid attempt to destructure non-iterable instance")}}();define("mobile/schedule/ScheduleColors",["baja!","jquery","underscore","mobile/util/color","mobile/util/gradient","mobile/schedule/util.schedule","lex!schedule"],function(e,t,n,i,r,a,o){"use strict";function l(){return M(t("#main").css("background-color"))}function u(e){if(O[e.css])return O[e.css];var t,n,i,r,a=e.h,o=e.s,l=e.v,u=255*e.alpha;return t=C(a,.5*o,1.35*l),n=C(a,.6*o,1.25*l),i=C(a,.9*o,1.05*l),r=C(a,o,l),"number"==typeof u&&(t=M([t.red,t.green,t.blue,u]),n=M([n.red,n.green,n.blue,u]),i=M([i.red,i.green,i.blue,u]),r=M([r.red,r.green,r.blue,u])),O[e.css]=[["0%",t],["30%",n],["90%",i],["97%",r],["100%",i]]}function s(e){return e.alpha<255&&(e=i.alphaBlend(e,l())),i.luma(e.red,e.green,e.blue)}function c(e){return s(e)>N?{color:"black","text-shadow":"0 1px 1px rgba(255, 255, 255, 0.7)"}:{color:"white","text-shadow":"0 1px 1px rgba(0, 0, 0, 0.7)"}}function d(e,t){var n=u(t),i=c(n[0][1]);e.css(i),e.parents(".schedule").length?w(e,L,n):e.css("background-color",x(L,n).background)}function f(e){if(e.parents(".schedule").length){var t,n,i=e.height(),r=i/2,a="0 2px 6px rgba(0,0,0,0.3), inset 0 0px 0px 1px rgba(255,255,255,0.1)",o=F;for(r<160&&(t=Math.min(160-r,80)/80*.07,a+=", inset 0 "+r+"px rgba(255,255,255,"+t+")"),n=0;n<o.length;n++)e.css(o[n]+"box-shadow",a)}}function p(){return a.getCurrentSchedule().value()}function h(t){var n=A.get(t);if(n)try{return M(n)}catch(i){e.error("Invalid color in lexicon: "+t+" = "+n)}}function m(t,n){var i;try{if(t&&(i=t.get("facets").get("colors")),i&&i.getType().is("baja:EnumRange")){var r=i.get(n).getTag();return M(e.SlotPath.unescape(r))}}catch(e){return null}}function g(e){return h("BooleanSchedule.colors."+(e?1:0))}function v(e){return e?P:q}function y(e){var t=p(),n=e.get("value");return m(t,n?1:0)||g(n)||v(n)}function b(t){if(t===e.DynamicEnum.DEFAULT)return 0;var i=t.getOrdinal(),r=t.getRange().getOrdinals(),a=n.indexOf(r,i);return-1===a?i:a}function k(e){var t=B,n=t.length,i=b(e),r=i%(2*n),a=t[r%n];return M(a)}function S(e){var t=b(e);if(t>=0)return h("EnumSchedule.colors."+t)}function T(t){var n=p(),i=t.getValue(),r=i.getRange();return r===e.EnumRange.DEFAULT&&(r=n.get("facets").get("range"))&&r!==e.EnumRange.DEFAULT&&(i=e.DynamicEnum.make({ordinal:i.getOrdinal(),range:r})),m(n,i.getOrdinal())||S(i)||k(i)}function E(e){var t,n=e.getType();return n.is("baja:StatusEnum")?t=h("EnumSchedule.colors.null"):n.is("baja:StatusBoolean")&&(t=h("BooleanSchedule.colors.null")),t||(t=_),t}function j(e){d(e,R),e.css(c(R)),f(e)}function D(e){var t,n,i,r=this,a=e&&e.getType();a&&a.is("baja:StatusValue")?e.get("status").isNull()?(t=E(e),n=c(t),i=function(e){e.css({"background-color":t.css}),e.css(n)}):a.is("baja:StatusEnum")?(t=T(e),i=function(e){d(e,t),f(e)}):a.is("baja:StatusBoolean")?(t=y(e),i=function(e){d(e,t),f(e)}):i=j:i=j,r.apply=i}var w=r.applyLinearGradientBackground,x=r.createLinearGradientCss,C=i.hsvToRgb,M=i.parseRgba,I=_slicedToArray(o,1),A=I[0],O={},L=270,N=150,F=["-webkit-","-moz-","-ms-","-o-",""],P=M("#f065cb65"),q=M("#f0e17171"),_=M("#f8cccccc"),R=M("#f88fbc8f"),B=["#f08c0000","#f0387038","#f0703870","#f025255a","#f01f6f70","#f0704308","#f0606060","#f0e17171","#f065cb65","#f0cb7fcb","#f06c6ccb","#f054b7b8","#f0c88435","#f0e1e171"];return D});var _slicedToArray=function(){function e(e,t){var n=[],i=!0,r=!1,a=void 0;try{for(var o,l=e[Symbol.iterator]();!(i=(o=l.next()).done)&&(n.push(o.value),!t||n.length!==t);i=!0);}catch(e){r=!0,a=e}finally{try{!i&&l.return&&l.return()}finally{if(r)throw a}}return n}return function(t,n){if(Array.isArray(t))return t;if(Symbol.iterator in Object(t))return e(t,n);throw new TypeError("Invalid attempt to destructure non-iterable instance")}}();define("mobile/schedule/ScheduleBlock",["baja!","jquery","Promise","mobile/util/time","mobile/schedule/ScheduleColors","mobile/fieldeditors/mobile/feUtils","lex!baja,schedule","css!mobile/schedule/ScheduleBlock"],function(e,t,n,i,r,a,o){"use strict";function l(e,t,n){var i,a=this;e.getType().is("schedule:TimeSchedule")?(i=e,a.start=i.get("start"),a.finish=i.get("finish"),a.value=i.get("effectiveValue")):(a.start=e,a.finish=t,a.value=n),a.$colors=new r(a.value)}var u=a.getBajaTimeFormat,s=_slicedToArray(o,2),c=s[0],d=s[1];return l.prototype.generateDiv=function(e){var n=t('<div class="scheduleBlockContainer" />').append(t('<div class="grab top" />')).append(t('<div class="grab bottom" />')).appendTo(e),i=t('<div class="scheduleBlock" />').appendTo(n);return t('<div class="display" />').appendTo(i).append('<span class="valueDisplay"/>&nbsp;<span class="timeDisplay"/>'),n.data("scheduleBlock",this),n},l.prototype.createTimeSchedule=function(){var t="effectiveValue",n=e.$("schedule:TimeSchedule",{start:this.start,finish:this.finish});return n.add({slot:t,value:this.value.newCopy(),cx:{displayName:d.get(t)||t}}),n},l.prototype.overlaps=function(e,t){var n=this.start.getTimeOfDayMillis(),r=this.finish.getTimeOfDayMillis(),a=e,o=t;return 0===r&&(r=i.MILLIS_IN_DAY),0===o&&(o=i.MILLIS_IN_DAY),r<n&&(r+=i.MILLIS_IN_DAY),o<a&&(o+=i.MILLIS_IN_DAY),r>a&&o>n},l.prototype.toString=function(){function e(e){return e&&e.toTimeStringSync({textPattern:u()||"HH:mm",lex:c})}var t=e(this.start),n=e(this.finish),i="";return t&&(i+=t+" - "),n&&(i+=n),i},l}),define("mobile/util/jquery/enclosingPoint",["jquery"],function(e){"use strict";function t(t,n,i,r){var a=e(t),o=a.offset(),l=i[3].split(","),u=parseInt(l[0],10),s=parseInt(l[1],10);return s>=o.top&&s<o.top+a.height()&&u>=o.left&&u<o.left+a.width()}return e.extend(e.expr[":"],{enclosingPoint:t}),e}),define("mobile/schedule/schedule.ui.day",["baja!","jquery","mobile/util/time","mobile/schedule/util.schedule","mobile/util/jquery/enclosingPoint"],function(e,t,n,i){"use strict";function r(t,r,a,o,l){var u,s,c=a.data("scheduleBlock");c?(a.addClass("selected"),r.trigger("selectionchange"),u=c.start,s=c.finish):(u=n.makeTime(i.pixelsToMillis(r,l-r.offset().top)),s=n.makeTime(u.getTimeOfDayMillis()+y)),t.dragStart={pageY:l,timeStamp:e.clock.ticks(),scheduleBlock:c,start:u,finish:s,operation:o},m=a}function a(e,t){return e.find(":not(.overlay)").filter(":enclosingPoint("+t.pageX+","+t.pageY+")")}function o(e,t,i,r){var a=n.millisOfDay(i),o=n.millisOfDay(r),l=t.start,u=t.finish;if(!(i&&i.equals(l)&&r&&r.equals(u))){if(o>0&&a>=o)throw"finish time ("+r+") was before start time ("+i+")";if(!e.canMoveBlockTo(t,a,o))throw"("+i+"), ("+r+") overlaps with another block";t.start=i,t.finish=r}}function l(e,t,r){if(m&&m.data("scheduleBlock")){for(var a=e.dragStart,l=a.operation,u=i.pixelsToMillis(t,r),s=u>0?"down":"up",c=a.scheduleBlock,d=a.start.getTimeOfDayMillis(),f=a.finish.getTimeOfDayMillis()||v,p=d,h=f,g=!1,b=!1;!g&&!b;)try{switch(l){case"resizeTop":p=Math.max(d+u,0),p=Math.min(p,(h||v)-y);break;case"resizeBottom":h=Math.min(f+u,v),h=Math.max(h,p+y);break;case"move":p=d+u,h=f+u}p=n.roundToHalfHour(p),h=n.roundToHalfHour(h),o(e,c,n.makeTime(p),n.makeTime(h)),g=!0}catch(e){switch(s){case"down":u-=y,b=u<=0;break;case"up":u+=y,b=u>=0}}g&&(a.changed=!0,i.updateScheduleBlockDiv(m),e.setModified(!0))}}function u(e,t,a){var o=e.dragStart,u=o.pageY-t.children(".blocksDisplay").offset().top,s=n.roundToHalfHour(i.pixelsToMillis(t,u)),c=i.getCurrentSchedule().getNewBlockValue(),d=e.addBlock(n.makeTime(s),n.makeTime(s+6e4),c),f=d.generateDiv(t.children(".blocksDisplay"));o.changed=!0,r(e,t,f,"resizeBottom",o.pageY),l(e,t,a)}function s(e){var t;return t=e.filter(".grab"),t.length?t:(t=e.filter(".scheduleBlockContainer"),t.length?t:e.filter(".block"))}function c(e,n){if(1===e.length)return t(e[0]);var i=Number.MAX_VALUE,r=Number.MIN_VALUE,a=Number.MAX_VALUE,o=Number.MIN_VALUE,l=null,u=null;return e.each(function(){var e=t(this),n=e.offset().top,s=n+e.outerHeight(),c=e.parent(),d=c.offset().top,f=d+c.outerHeight();(n<i||n===i&&d<a)&&(l=e),(s>r||s===r&&f>o)&&(u=e),i=Math.min(n,i),r=Math.max(s,r),a=Math.min(d,a),o=Math.max(f,o)}),n.pageY<(r+i)/2?l:u}function d(e,n,i){var o,l,u=a(n,i),d=s(u);t(".scheduleBlockContainer.selected",n).removeClass("selected"),d.length&&(d.hasClass("scheduleBlockContainer")?(o=d,l="move"):d.hasClass("grab")?(d=c(d,i),o=d.parent(),l=d.hasClass("top")?"resizeTop":"resizeBottom"):(o=d,l="create"),n.trigger("selectionchange"),r(e,n,o,l,i.pageY))}function f(e,t,n){var r,o=a(t,n),s=t.find(".overlay"),c=e.dragStart;o.filter(".grab").length?s.css("cursor","n-resize"):s.css("cursor","default"),c&&(r=n.pageY-c.pageY,Math.abs(r)>20&&(c.moved=!0),"resizeTop"===c.operation||"resizeBottom"===c.operation||"move"===c.operation?l(e,t,r):"create"===c.operation&&r>=i.millisToPixels(t,y)&&u(e,t,r))}function p(t,n,i){var r,o,l=t.dragStart;l&&(r=i.pageY-l.pageY,o=e.clock.ticks()-l.timeStamp,Math.abs(r)<3&&o<750&&a(n,i).filter(".scheduleBlockContainer").click(),l.changed&&t.setModified(!0),delete t.dragStart)}function h(t,n){var i=e.throttle(f,50);return"ontouchend"in document?{document:{touchend:function(e){p(t,n,e)}},overlay:{touchend:function(e){var i=e.originalEvent.touches[0]||e.originalEvent.changedTouches[0];p(t,n,i)},touchmove:function(e){var r=e.originalEvent.touches[0]||e.originalEvent.changedTouches[0];i(t,n,r)},touchstart:function(e){e.preventDefault();var i=e.originalEvent.touches[0]||e.originalEvent.changedTouches[0];d(t,n,i)}}}:{document:{mouseup:function(e){p(t,n,e)}},overlay:{mousedown:function(e){d(t,n,e)},mousemove:function(e){i(t,n,e)},mouseup:function(e){p(t,n,e)}}}}var m,g={},v=n.MILLIS_IN_DAY,y=n.MILLIS_IN_HALF_HOUR;return g.armHandlers=function(n,i){var r=t('<div class="overlay"/>').appendTo(i.children(".blocksDisplay")),a=h(n,i);e.iterate(a.overlay,function(e,t){r.on(t,e)}),i.on("mousedown",a.overlay.mousedown),i.on("touchstart",a.overlay.touchstart),e.iterate(a.document,function(e,n){t(document).on(n,e)}),n.unbindAll=function(){e.iterate(a.overlay,function(e,t){r.off(t,e)}),i.off("mousedown",a.overlay.mousedown),i.off("touchstart",a.overlay.touchstart),e.iterate(a.document,function(e,n){t(document).off(n,e)})}},g}),define("mobile/schedule/DayEditor",["baja!schedule:TimeSchedule","css!mobile/schedule/DayEditor","baja!","jquery","underscore","mobile/schedule/util.schedule","mobile/schedule/ScheduleBlock","mobile/schedule/schedule.ui.day","mobile/fieldeditors/fieldeditors","mobile/fieldeditors/BaseFieldEditor"],function(e,t,n,i,r,a,o,l,u,s){"use strict";var c=function(){s.apply(this,arguments),this.scheduleBlocks=[],this.$dayDisplay=this.params.label||this.container.getDisplayName(),this.dragStart=null};return c.prototype=Object.create(s.prototype),c.prototype.constructor=c,c.prototype.doInitialize=function(e){var t,n,a=this.container,o=a.getName(),u=this.$dayDisplay;t=i('<div class="day" />').addClass(o).append(i('<div class="dayTitle"/>').text(u)),n=i('<div class="blocksDisplay"/>').appendTo(t),n.append(r.range(0,8).map(function(e){return'<div class="block block'+e+' {name}"/>'}).join("")),t.data("daySchedule",this.value()),t.appendTo(e),this.isEnabled()&&l.armHandlers(this,t)},c.prototype.doLoad=function(e){var t=this,n=i(".blocksDisplay",t.jq());t.empty(),e.getSlots().is("schedule:TimeSchedule").eachValue(function(e){t.addBlock(e.get("start"),e.get("finish"),e.get("effectiveValue"))}),t.setModified(!1),i(".scheduleBlockContainer",n).remove(),this.getBlocks().forEach(function(e){return e.generateDiv(n)})},c.prototype.doRead=function(){return this.scheduleBlocks},c.prototype.doSave=function(e){var t=this.value();t.getSlots().is("schedule:TimeSchedule").each(function(e){t.remove({slot:e})}),e.forEach(function(e){t.add({slot:"time?",value:e.createTimeSchedule()})})},c.prototype.refreshWidgets=function(){var e=i(".blocksDisplay",this.jq());i(".scheduleBlockContainer",e).remove(),this.getBlocks().forEach(function(t){return t.generateDiv(e)})},c.prototype.addBlock=function(e,t,n){var i=new o(e,t,n);return this.scheduleBlocks.push(i),this.setModified(!0),i},c.prototype.allDayEvent=function(e){this.empty(),this.addBlock(n.Time.make(0),n.Time.make(0),e)},c.prototype.canMoveBlockTo=function(e,t,i){return!n.iterate(this.scheduleBlocks,function(n){if(n&&n!==e&&n.overlaps(t,i))return!0})},c.prototype.copyTo=function(e){var t=this;e.empty(),n.iterate(t.getBlocks(),function(t){e.addBlock(t.start,t.finish,t.value)})},c.prototype.empty=function(){this.scheduleBlocks=[],this.setModified(!0)},c.prototype.getBlocks=function(){return this.scheduleBlocks},c.prototype.removeBlock=function(e){var t=this.scheduleBlocks,n=r.indexOf(t,e);if(n>=0)return t.splice(n,1),this.setModified(!0),e},c.prototype.getSelectedBlock=function(){return this.jq().find(".scheduleBlockContainer.selected").data("scheduleBlock")},c.prototype.layout=function(){a.relayoutDayDiv(this.jq().children(".day"))},u.register("schedule:DaySchedule",c),c});var _slicedToArray=function(){function e(e,t){var n=[],i=!0,r=!1,a=void 0;try{for(var o,l=e[Symbol.iterator]();!(i=(o=l.next()).done)&&(n.push(o.value),!t||n.length!==t);i=!0);}catch(e){r=!0,a=e}finally{try{!i&&l.return&&l.return()}finally{if(r)throw a}}return n}return function(t,n){if(Array.isArray(t))return t;if(Symbol.iterator in Object(t))return e(t,n);throw new TypeError("Invalid attempt to destructure non-iterable instance")}}();define("mobile/schedule/schedule",["baja!baja:StatusString,baja:StatusNumeric,baja:StatusEnum,baja:StatusBoolean,baja:Weekday","css!mobile/schedule/schedule","baja!","lex!baja","jquery","Promise","underscore","mobile/util/slot","mobile/fieldeditors/fieldeditors","mobile/fieldeditors/fieldeditors.mobile","mobile/fieldeditors/mobile/feUtils","mobile/fieldeditors/MobileFieldEditor","mobile/schedule/util.schedule","mobile/schedule/DayEditor"],function(e,t,n,i,r,a,o,l,u,s,c,d,f){"use strict";function p(e,t){var i,r=b(e),o=t.get("value");return r&&(i=r.get(o?"trueText":"falseText")),i?n.Format.format({pattern:i}):a.resolve(S.get(o?"true":"false"))}function h(e,t){var i=b(e),r=i&&i.get("units"),o=i&&i.get("precision")||0,l=t.getValue(),u=l.toFixed(o);if(r&&r!==n.Unit.NULL){var s=r.getSymbol();r.getIsPrefix()?u=s+" "+u:u+=" "+s}return a.resolve(u)}
var m=c.getEnumRangeDisplay,g=f.appendTimeLabels,v=f.getLastEnteredValue,y=f.relayoutLabelsDiv,b=l.getFacets,k=_slicedToArray(i,1),S=k[0],T=o.once(function(){var e,t,i,r=0,a=[];for(t=S.get("weekday.firstDayOfWeek"),t||(t="sunday"),e=n.$("baja:Weekday").get(t),a[r++]=t,i=e.getOrdinal()+1;i<=6;i++)a[r++]=n.$("baja:Weekday").get(i).getTag();for(i=0;i<e.getOrdinal();i++)a[r++]=n.$("baja:Weekday").get(i).getTag();return a}),E=function(){d.apply(this,arguments),this.dayEditors={}};return E.prototype=Object.create(d.prototype),E.prototype.constructor=E,E.prototype.doInitialize=function(e){var t=r('<div class="schedule" />');g(t),r('<div class="weekdays" />').appendTo(t),t.appendTo(e)},E.prototype.doLoad=function(e){if(e.getType().is("schedule:WeeklySchedule")){var t,n=this,i=!n.isEnabled(),l=n.jq(),s=l.parent(),c=e.get("schedule").get("week");l.detach(),t=l.find("div.weekdays").empty();var d=o.map(T(),function(e){var a=c.get(e),o=r('<div class="dayContainer"/>').appendTo(t);return u.makeFor({container:a,slot:"day",element:o,readonly:i,label:S.get(e+".short")}).then(function(t){n.dayEditors[e]=t})});return n.defaultValue=e.get("defaultOutput"),a.all(d).then(function(){l.appendTo(s)})}},E.prototype.doRead=function(){return this.value()},E.prototype.doSave=function(){var e=this,t=e.value();return n.Ord.make(niagara.view.ord).get().then(function(e){return e.serverSideCall({typeSpec:"mobile:ScheduleServerSideCallHandler",methodName:"save",value:t})}).then(function(i){if(n.hasType(i,"baja:String"))throw new Error(i.toString());return e.snapshot=i,t})},E.prototype.layout=function(){var e=this.jq(),t=e.find(".blocksDisplay").height();o.each(this.dayEditors,function(e){e.layout()}),y(e.find(".scheduleLabels"),t)},E.prototype.applyMF=function(e){var t,i=this;n.iterate(T(),function(n){"saturday"!==n&&"sunday"!==n&&(t=i.dayEditors[n],t.value()!==e.value()&&(e.copyTo(t),t.save()))}),this.setModified(!0)},E.prototype.overwrite=function(e,t){e.copyTo(this.dayEditors[t]),this.setModified(!0)},E.prototype.empty=function(){n.iterate(this.dayEditors,function(e){e.empty(),e.save()}),this.setModified(!0)},E.prototype.stringify=function(e){if(e.get("status").isNull())return a.resolve(S.get("Status.null"));var t=e.getType(),n=this.value(),i=e.get("value");return t.is("baja:StatusBoolean")?p(n,e):t.is("baja:StatusString")?a.resolve(i):t.is("baja:StatusNumeric")?h(n,e):t.is("baja:StatusEnum")?m(i.getOrdinal(),n.get("facets").get("range")):a.resolve("N/A")},E.prototype.getNewBlockValue=function(){if(v())return v().newCopy();var e,t,i,r=this.value(),a=r.get("defaultOutput").newCopy(),o=a.getValue(),l=b(r);return a.setStatus(n.Status.ok),a.getType().is("baja:StatusBoolean")?a.setValue(!o):a.getType().is("baja:StatusNumeric")?(o=0,l&&(e=l.get("min"),t=l.get("max"),o<e?o=e:o>t&&(o=t),a.setValue(o))):a.getType().is("baja:StatusEnum")&&o.getType().is("baja:DynamicEnum")&&(i=l&&l.get("range"))&&a.setValue(n.DynamicEnum.make({range:i})),a},u.register("schedule:WeeklySchedule",E),E});var _slicedToArray=function(){function e(e,t){var n=[],i=!0,r=!1,a=void 0;try{for(var o,l=e[Symbol.iterator]();!(i=(o=l.next()).done)&&(n.push(o.value),!t||n.length!==t);i=!0);}catch(e){r=!0,a=e}finally{try{!i&&l.return&&l.return()}finally{if(r)throw a}}return n}return function(t,n){if(Array.isArray(t))return t;if(Symbol.iterator in Object(t))return e(t,n);throw new TypeError("Invalid attempt to destructure non-iterable instance")}}();define("mobile/schedule/util.schedule.datebox",["baja!","lex!mobile","jquery","jqmDatebox","Promise","underscore","mobile/util/time","mobile/fieldeditors/mobile/feUtils"],function(e,t,n,i,r,a,o,l){"use strict";function u(e){var t=e.getSelectedBlock(),n=0,i=t.start.getTimeOfDayMillis();return e.getBlocks().forEach(function(e){if(e!==t){var r=e.finish.getTimeOfDayMillis();r>0&&r<=i&&(!n||n<r)&&(n=r)}}),n}function s(e){var t=e.getSelectedBlock(),n=p,i=t.finish.getTimeOfDayMillis();return e.getBlocks().forEach(function(e){if(e!==t){var r=e.start.getTimeOfDayMillis();r>=i&&(!n||n>r)&&(n=r)}}),n%p}function c(e,t,n,i,r){var a=r>0?"down":"up",o=t+("start"===i?r:0),l=n+("finish"===i?r:0);switch(o=(o+p)%p,l=(l+p)%p,i+" "+a){case"start down":return(l||p)-h;case"start up":return u(e);case"finish down":return n+r>p?0:s(e);case"finish up":return o+h;default:throw"slot must be one of 'start' or 'finish'"}}var d=l.getBajaTimeFormat,f=l.getDateboxDefaultOptions,p=o.MILLIS_IN_DAY,h=o.MILLIS_IN_MINUTE,m=_slicedToArray(t,1),g=m[0],v={};return v.validateTimeChange=function(e){var t,n=e.dayEditor,i=e.startTime,a=e.finishTime,o=e.slot,l=e.mschange,u=n.getSelectedBlock(),s=i.getTimeOfDayMillis(),c=a.getTimeOfDayMillis();return"start"===o?((s+=l)<0||s>=p)&&(t="schedule.message.crossesMidnight"):(c=c||p,((c+=l)<=0||c>p)&&(t="schedule.message.crossesMidnight")),n.canMoveBlockTo(u,s,c)||(t="schedule.message.blockOverlap"),(c||p)<=s&&(t="schedule.message.finishBeforeStart"),t?r.join(i.toTimeString({textPattern:d()||"HH:mm"}),a.toTimeString({textPattern:d()||"HH:mm"})).spread(function(e,n){throw g.get({key:t,args:[e,n]})}):r.resolve()},v.validateTimeScheduleEditor=function(t,n,i,r){return i.read().then(function(i){function a(){e.Time.make(o).toTimeString({textPattern:d()||"HH:mm",ok:function(e){setTimeout(function(){t.trigger("datebox",{method:"set",value:e})},0)}})}var o,l=t.attr("name").replace("_time",""),u=i.get("start"),s=i.get("finish"),f=u.getTimeOfDayMillis(),h=s.getTimeOfDayMillis();return v.validateTimeChange({dayEditor:n,startTime:u,finishTime:s,slot:l,mschange:r}).then(function(){o="start"===l?f:h,o=(o+r+p)%p,a()},function(){o=c(n,f,h,l,r),a()})})},v.getDateboxInput=function(e){if(e.is(":jqmData(role=datebox)"))return e;var t=e.find(":jqmData(role=datebox)");if(!t.length){var i=n('<div class="calendarContainer"/>'),r=n('<div class="calendarContainerInner"/>').appendTo(i),o=a.extend(f(),{mode:"calbox",hideInput:!0,useInline:!0,calHighToday:!1,calHighPick:!1,themeDateHigh:"e",calNextMonthIcon:"arrow-r",calPrevMonthIcon:"arrow-l"});t=n('<input class="hidden" type="date" data-role="datebox" />').attr("data-options",JSON.stringify(o)).appendTo(r),e.html(i),t.datebox()}return t},v.getAbsTime=function(t){var n=v.getDateboxInput(t),i=n.datebox("getTheDate");return e.AbsTime.make({jsDate:i,offset:-6e4*i.getTimezoneOffset()})},v}),define("mobile/schedule/schedule.ui.calendar",["baja!baja:Month","baja!","jquery","jquerymobile","jqmDatebox","underscore","mobile/util/mobile/dialogs","mobile/util/mobile/mobile","mobile/util/time","mobile/fieldeditors/fieldeditors","bajaux/events","mobile/schedule/util.schedule.datebox"],function(e,t,n,i,r,a,o,l,u,s,c,d){"use strict";function f(e,n){return t.$("baja:Vector",{time:n,schedule:e})}function p(e){var n={slot:"refBase",value:t.Ord.make(niagara.view.ord),flags:t.Flags.HIDDEN|t.Flags.TRANSIENT};e.has("refBase")?e.set(n):e.add(n)}function h(e){var t=e.getDate(),n=t.getYear(),i=t.getMonth().getOrdinal()+1;return n+"-"+(i<10?"0":"")+i+"-01"}function m(e,n,i){e=e.newCopy(),p(e);var r=f(e,n);return t.Ord.make(niagara.view.ord).get().then(function(e){return e.serverSideCall({typeSpec:"mobile:ScheduleServerSideCallHandler",methodName:i,value:r})}).then(function(e){return JSON.parse(e)})}function g(e,t){return m(e,t,"getHighlightedDates")}function v(e,t){return m(e,t,"getDaySummary")}function y(e){var i=n('<ul class="daySummary" data-role="listview"/>');return t.iterate(e,function(e){var t=n("<li/>"),r=n('<label class="daySummaryTitle"/>').appendTo(t),a=n('<label class="daySummarySubtitle"/>').appendTo(t);r.text(e.timestamp),a.text(e.output+" ("+e.source+")"),t.appendTo(i)}),i}var b={};return b.showEffectiveRangeCalendar=function(e,t,n){var i=l.spinnerTicket(2e3);return g(t,n).then(function(t){var r=d.getDateboxInput(e);r.datebox({highDates:t}),r.datebox("setTheDate",h(n)),r.trigger("datebox",{method:"close"}),r.datebox("getTheDate"),i.hide()})},b.showDaySummary=function(e,t,i){var r=l.spinnerTicket(2e3);return v(t,i).then(function(t){var i=y(t);e.html(i),i.listview(),n.mobile.silentScroll(e.offset().top),r.hide()})},b.loadScheduleEditor=function(e,t,n){var i=e.children(':jqmData(role="content")'),r=i.find('div:jqmData(role="calendareditor")');return s.makeFor({value:t,element:r.empty(),readonly:n})},b.bindEditorToCalendar=function(e,n){var i=e.jq();i.off(c.MODIFY_EVENT),i.on(c.MODIFY_EVENT,a.debounce(function(){var i=d.getDateboxInput(n),r=i.datebox("getTheDate");r=new Date(r.getTime()+u.MILLIS_IN_DAY),e.read().then(function(e){return b.showEffectiveRangeCalendar(n,e,t.AbsTime.make({jsDate:r}))}).catch(o.error)},500))},b});var _slicedToArray=function(){function e(e,t){var n=[],i=!0,r=!1,a=void 0;try{for(var o,l=e[Symbol.iterator]();!(i=(o=l.next()).done)&&(n.push(o.value),!t||n.length!==t);i=!0);}catch(e){r=!0,a=e}finally{try{!i&&l.return&&l.return()}finally{if(r)throw a}}return n}return function(t,n){if(Array.isArray(t))return t;if(Symbol.iterator in Object(t))return e(t,n);throw new TypeError("Invalid attempt to destructure non-iterable instance")}}();define("mobile/schedule/schedule.fieldeditors",["baja!","jquery","Promise","underscore","mobile/util/aop","mobile/fieldeditors/fieldeditors","mobile/fieldeditors/fieldeditors.mobile","mobile/fieldeditors/MobileFieldEditor","mobile/fieldeditors/fieldeditors.composite","mobile/fieldeditors/mobile/feUtils","mobile/util/mobile/dialogs","lex!schedule,mobile,baja","baja!baja:EnumSet,baja:Month,baja:Weekday,schedule:YearSchedule,schedule:MonthSchedule,schedule:DayOfMonthSchedule,schedule:WeekOfMonthSchedule,schedule:WeekdaySchedule,schedule:DateSchedule,schedule:DateRangeSchedule,schedule:WeekAndDaySchedule,schedule:TimeSchedule,schedule:CustomSchedule,schedule:ScheduleReference"],function(e,t,n,i,r,a,o,l,u,s,c,d){function f(e,t){if(e&&t&&e.has(t))return e.getSlot(t).getFacets()}function p(n,i,r){var a,o=n.jq().find("select").empty(),l=i.ordinals,u=i.displays;e.iterate(l,function(e,n){var i=t("<option/>").val(e).text(u[n]);o.append(i)}),a=r===e.EnumSet.NULL?l[0]:r.encodeToString(),o.val(a).trigger("change")}function h(e,t,r){var a=f(e.container,e.slot),o=a&&a.get("range"),l=o.getOrdinals();r=r||H;var u=i.map(l,function(e){return n.resolve(r(e,o)||H(e,o)).then(function(t){return[e,t]})});return n.all(u).then(function(e){var n=i.map(e,function(e){return e[0]}),r=i.map(e,function(e){return e[1]});return t&&(n.splice(0,0,"any"),r.splice(0,0,t)),{ordinals:n,displays:r}})}function m(t,n){return t===n?e.EnumSet.NULL:e.EnumSet.make([t])}function g(n,r,a){var o=r.ordinals,l=r.displays,u=n.value(),s=u.getOrdinals(),d=t('<div data-role="fieldcontain"/>'),f=t('<fieldset data-role="controlgroup"/>').appendTo(d);e.iterate(o,function(e,n){var r=l[n],o="checkbox"+e,u=t('<input type="checkbox"/>').attr("id",o).attr("value",e),c=t("<label/>").attr("for",o).text(r);(i.indexOf(s,e)>=0||String(e)===a&&0===s.length)&&u.prop("checked","checked"),f.append(u).append(c)}),f.on("change","input",function(){t(this).val()===a?f.find("input[value!="+a+"]").prop("checked",!1):f.find("input[value="+a+"]").prop("checked",!1),0===f.find("input:checked").length&&f.find("input[value="+a+"]").prop("checked",!0),f.find("input").checkboxradio("refresh"),n.setModified(!0)}),c.okCancel({content:function(e){e.append(f).trigger("create")},title:n.label,ok:function(i){var r,o=[];f.find("input:checked").each(function(){var e=t(this).val();e!==a&&o.push(Number(e))}),r=e.EnumSet.make(o),n.load(r).then(i.ok,i.fail)}})}function v(e){e.append(le.patternReplace({id:this.name}))}function y(e,n,i,r){var a=t('<a data-role="button" data-theme="a"/>');e.label=e.container.getDisplayName(),a.text(e.label),a.click(function(){g(e,i,r)}),a.appendTo(n)}function b(e){var t=this;return h(t,G,w).then(function(n){n.ordinals.pop(),n.ordinals.pop(),y(t,e,n,"any")})}function k(e,t){return 0===e?Q:6===e?ee:e<6?oe+" "+e:X+" "+(e-6)}function S(e){var t=this;return h(t,null,k).then(function(n){p(t,n,e)})}function T(){}function E(e,t){if(0===e)return Y}function j(e){var t=this;return h(t,null,E).then(function(n){p(t,n,e)})}function D(e){var t=this;return h(t,null,E).then(function(n){n.ordinals.push(32,33,34,35),n.displays.push(Z,ee,te,ne),y(t,e,n,"0")})}function w(t,n){if(12===t)return re;if(13===t)return ie;var i=e.$("baja:Month").get(t).getTag()+".short";return W.get(i)}function x(e){var t=this;return h(t,G,w).then(function(n){n.ordinals.pop(),n.ordinals.pop(),p(t,n,e)})}function C(e){var t=this;return h(t,G,w).then(function(n){p(t,n,e)})}function M(t,n){if(t>=7)return null;var i=e.$("baja:Weekday").get(t).getTag()+".short";return W.get(i)}function I(e){var t=this;return h(t,J,M).then(function(n){p(t,n,e)})}function A(e){var t=this;return h(t,J,M).then(function(n){y(t,e,n,"any")})}function O(e){var t=this;return h(t,null,k).then(function(n){y(t,e,n,"0")})}function L(){return this.value()}function N(e){return e.jq().find("select").val()}function F(){return m(N(this),"any")}function P(){return m(N(this),"0")}function q(){return m(N(this),"any")}function _(){return m(N(this),"0")}function R(n){var i=(new Date).getFullYear(),r=t('<select data-theme="a" name="year" />');t("<option />").val("any").text(K).appendTo(r),e.iterate(i,i+10,function(e){t("<option />").val(String(e)).text(String(e)).appendTo(r)}),r.appendTo(n)}function B(e){var t=e,n=this.jq().find("select");t.getAlwaysEffective()?n.val("any"):n.val(String(t.getYear()))}function U(){var e=a.toSaveDataComponent(this.value()),t=this.jq().find("select").val();return"any"===t?e.setAlwaysEffective(!0):(e.setAlwaysEffective(!1),e.setYear(Number(t))),e}var H=s.getEnumRangeDisplay,z=_slicedToArray(d,3),V=z[0],$=z[1],W=z[2],Y=V.get({key:"dayofmonth.anyDay",def:"Any Day"}),G=V.get({key:"month.anyMonth",def:"Any Month"}),Q=V.get({key:"week.anyWeek",def:"Any Week"}),J=V.get({key:"weekday.anyWeekday",def:"Any Weekday"}),K=V.get({key:"year.anyYear",def:"Any Year"}),X=V.get({key:"week.calendarWeek",def:"Calendar Week"}),Z=V.get({key:"dayofmonth.last_day",def:"Last Day"}),ee=V.get({key:"dayofmonth.last7days",def:"Last 7 Days"}),te=V.get({key:"dayofmonth.oddDays",def:"Odd Days"}),ne=V.get({key:"dayofmonth.evenDays",def:"Even Days"}),ie=V.get({key:"month.feb_apr_jun_aug_oct_dec",def:"Feb-Apr-Jun-Aug-Oct-Dec"}),re=V.get({key:"month.jan_mar_may_jul_sep_nov",def:"Jan-Mar-May-Jul-Sep-Nov"}),ae=V.get({key:"daterange.through",def:"Through"}),oe=V.get({key:"week.week",def:"week"}),le='<select data-theme="a" name="enumset_{id}" id="enumset_{id}"><option value="-1">'+$.get("loading")+"</option></select>";return function(){var n=a.defineEditor(l,{doInitialize:v,doLoad:x,doRead:F});a.register("baja:EnumSet",n,"enumset-month");var i=a.defineEditor(l,{doInitialize:b,doLoad:T,doRead:L});a.register("baja:EnumSet",i,"enumset-month-multi");var o=a.defineEditor(l,{doInitialize:v,doLoad:C,doRead:F});a.register("baja:EnumSet",o,"enumset-month-groups");var s=a.defineEditor(l,{doInitialize:v,doLoad:j,doRead:P});a.register("baja:EnumSet",s,"enumset-day");var c=a.defineEditor(l,{doInitialize:D,doLoad:T,doRead:L});a.register("baja:EnumSet",c,"enumset-day-custom");var d=a.defineEditor(l,{doInitialize:v,doLoad:S,doRead:_});a.register("baja:EnumSet",d,"enumset-weekofmonth");var f=a.defineEditor(l,{doInitialize:O,doLoad:T,doRead:L});a.register("baja:EnumSet",f,"enumset-weekofmonth-multi");var p=a.defineEditor(l,{doInitialize:v,doLoad:I,doRead:q});a.register("baja:EnumSet",p,"enumset-weekday");var h=a.defineEditor(l,{doInitialize:A,doLoad:T,doRead:L});a.register("baja:EnumSet",h,"enumset-weekday-multi");var m=a.defineEditor(l,{doInitialize:R,doLoad:B,doRead:U});a.register("schedule:YearSchedule",m);var g=u.makeComposite([{slot:"set",key:"enumset-month"}]);a.register("schedule:MonthSchedule",g);var y=u.makeComposite([{slot:"set",key:"enumset-month-multi"}]);a.register("schedule:MonthSchedule",y,"month-multi");var k=u.makeComposite([{slot:"set",key:"enumset-month-groups"}]);a.register("schedule:MonthSchedule",k,"month-groups");var E=u.makeComposite([{slot:"set",key:"enumset-day"}]);a.register("schedule:DayOfMonthSchedule",E);var w=u.makeComposite([{slot:"set",key:"enumset-day-custom"}]);a.register("schedule:DayOfMonthSchedule",w,"day-custom");var M=u.makeComposite([{slot:"set",key:"enumset-weekofmonth"}]);a.register("schedule:WeekOfMonthSchedule",M);var N=u.makeComposite([{slot:"set",key:"enumset-weekofmonth-multi"}]);a.register("schedule:WeekOfMonthSchedule",N,"week-multi");var H=u.makeComposite([{slot:"set",key:"enumset-weekday"}]);a.register("schedule:WeekdaySchedule",H);var z=u.makeComposite([{slot:"set",key:"enumset-weekday-multi"}]);a.register("schedule:WeekdaySchedule",z,"weekday-multi");var V=u.makeComposite(["weekdaySchedule","daySchedule","monthSchedule","yearSchedule"]),$=u.makeComposite(["daySchedule","monthSchedule","yearSchedule"]),W=u.makeComposite([{slot:"start",key:"noweekdays"},{slot:"end",key:"noweekdays"}],l),Y=u.makeComposite(["weekdays","weeksOfMonth",{slot:"months",key:"month-groups"}]),G=u.makeComposite(["start","finish","effectiveValue"]),Q=u.makeComposite([{slot:"daysOfMonth",key:"day-custom"},{slot:"months",key:"month-multi"},{slot:"weekdays",key:"weekday-multi"},{slot:"weeksOfMonth",key:"week-multi"},"year"]),J=u.makeComposite([{slot:"ref",key:"componentSelector",defaultValue:e.Ord.make("station:|slot:/|bql: select displayName, slotPathOrd from schedule:CalendarSchedule where parent.type != schedule:AbstractSchedule")}]);r.after($.prototype,"doInitialize",function(e,t){var n=e[0];return t.then(function(){n.wrapInner('<fieldset data-role="controlgroup"/>')})}),r.after(W.prototype,"doInitialize",function(e,n){var i=e[0];return n.then(function(){i.children("div.subEditor").eq(0).after(t('<div class="through"/>').text(ae))})}),a.register("schedule:DateSchedule",V),a.register("schedule:DateSchedule",$,"noweekdays"),a.register("schedule:DateRangeSchedule",W),a.register("schedule:WeekAndDaySchedule",Y),a.register("schedule:TimeSchedule",G),a.register("schedule:CustomSchedule",Q),a.register("schedule:ScheduleReference",J)}(),{schedulerDayLoad:j,schedulerEnumSetInitialize:v,schedulerMonthLoad:x,schedulerGroupsMonthLoad:C,schedulerWeekdayLoad:I,schedulerWeekLoad:S,schedulerMonthRead:F,schedulerDayRead:P,schedulerWeekdayRead:q,schedulerWeekOfMonthRead:_,schedulerYearInitialize:R,schedulerYearLoad:B,schedulerYearRead:U}});var _slicedToArray=function(){function e(e,t){var n=[],i=!0,r=!1,a=void 0;try{for(var o,l=e[Symbol.iterator]();!(i=(o=l.next()).done)&&(n.push(o.value),!t||n.length!==t);i=!0);}catch(e){r=!0,a=e}finally{try{!i&&l.return&&l.return()}finally{if(r)throw a}}return n}return function(t,n){if(Array.isArray(t))return t;if(Symbol.iterator in Object(t))return e(t,n);throw new TypeError("Invalid attempt to destructure non-iterable instance")}}();define("mobile/schedule/schedule.fieldeditors.triggers",["baja!schedule:TimeSchedule,schedule:DaySchedule","baja!","lex!mobile,schedule","jquery","jquerymobile","Promise","underscore","mobile/util/mobile/dialogs","mobile/util/mobile/mobile","mobile/fieldeditors/fieldeditors","mobile/fieldeditors/fieldeditors.mobile","mobile/fieldeditors/MobileFieldEditor","mobile/fieldeditors/mobile/feUtils","bajaux/events"],function(e,t,n,i,r,a,o,l,u,s,c,d,f,p){"use strict";function h(e,t){var n=t?"show":"hide",i=S();e.find(".triggerRangeEditors").animate({height:n,opacity:n},{step:function(e,t){l.repositionDialog(i)}})}function m(e,t){return e.getSlots().properties().is(E).eachValue(function(e){return e.getStart().equals(t)})}function g(e,n,i){var r=e,a=e.getTimeOfDayMillis(),o=[],l=i.getMillis();if(l<t.RelTime.MILLIS_IN_MINUTE)throw new Error(b.get("schedule.message.intervalRequired"));do{o.push(t.$(E,{start:r,finish:t.Time.make(a+2e4)})),a+=l,r=t.Time.make(a)}while(function(){return a<t.RelTime.MILLIS_IN_DAY&&n&&!r.isAfter(n)}());return o}function v(e){var n=e.startEditor,i=e.rangeEditor,r=e.endEditor,o=e.intervalEditor;return a.join(n.read(),i.read(),r.read(),o.read()).spread(function(e,n,i,r){var a=r.getMillis();return{start:e,isRange:n,end:i,interval:t.RelTime.make(a%t.RelTime.MILLIS_IN_DAY)}})}var y=_slicedToArray(n,2),b=y[0],k=y[1],S=u.getActivePage,T=f.getBajaTimeFormat,E="schedule:TimeSchedule",j='\n    <div class="checkboxContainer" data-role="fieldcontain">\n      <fieldset data-role="controlgroup" data-type="vertical">\n        <input type="checkbox" id="{checkboxId}"/>\n        <label for="{checkboxId}"><span>Selected</span></label>\n      </fieldset>\n    </div>',D='\n    <div>\n      <label class="rangeStartLabel">{triggerTime}:</label>\n      <div class="triggerStartTime"></div>\n    </div>\n    <div>\n      <div class="triggerRange"></div>\n    </div>\n    <div class="triggerRangeEditors hidden">\n      <div>\n        <label class="rangeEndLabel">{rangeEnd}:</label>\n        <div class="triggerEndTime"></div>\n      </div>\n      <div>\n        <label class="rangeIntervalLabel">{rangeInterval}:</label>\n        <div class="triggerInterval"></div>\n      </div>\n      <div>\n        <label class="triggersToCreate"/>\n      </div>\n    </div>',w=s.defineEditor(d,{doInitialize:function(e){e.on("click","li",function(){var e=i(this).find("input[type=checkbox]"),t=e.is(":checked");e.prop("checked",!t).trigger("change").checkboxradio("refresh")})},doLoad:function(e){var n,r=this,a=r.jq(),o=i('<ul data-role="listview" data-inset="true" data-theme="c" />'),l=i('<li data-role="list-divider"/>');l.append(j.patternReplace({checkboxId:"selectAll"})).append(i('<div class="detailsContainer"/>').text(b.get("selectAll"))),o.append(l),n=e.getSlots().properties().is(E).toValueArray(),n.sort(function(e,t){return e.getStart().getTimeOfDayMillis()-t.getStart().getTimeOfDayMillis()}),t.iterate(n,function(e){var t=i("<li/>").appendTo(o),n=i(j.patternReplace({checkboxId:e.getName()})),r=i('<div class="detailsContainer"/>');e.getStart().toTimeString({textPattern:T()||"HH:mm",ok:function(e){r.append(e)}}),t.append(n).append(r)}),a.html(o).trigger("create")},doRead:function(){return this.value()}});w.prototype.getSelectedSlots=function(){var e=[];return this.jq().find(".ui-li-static input[type=checkbox]").each(function(){var t=i(this);t.is(":checked")&&e.push(t.attr("id"))}),e},w.prototype.removeSelected=function(){var e=this,t=e.value(),n=e.getSelectedSlots(),i=o.map(n,function(e){return t.remove({slot:e})});return a.all(i).then(function(){return e.load(t)})},s.register("schedule:DaySchedule",w,"triggers-list");var x=s.defineEditor(d,{doInitialize:function(e){var n=this,r=n.jq();return e.html(D.patternReplace({triggerTime:b.get("schedule.triggerTime"),rangeEnd:k.get("trigger.rangeEnd"),rangeInterval:k.get("trigger.rangeInterval"),triggersToCreate:b.get("schedule.triggersToCreate")})),e.on(p.MODIFY_EVENT,".triggerRange",function(){n.rangeEditor.read().then(function(t){var n=b.get(t?"schedule.rangeStart":"schedule.triggerTime")+":";e.find(".rangeStartLabel").text(n),h(e,t)}).catch(t.error)}),e.on(p.MODIFY_EVENT,function(){n.updateTriggerCountDisplay()}),a.join(s.makeFor({value:t.Time.DEFAULT,element:i(".triggerStartTime",r)}),s.makeFor({value:!1,element:i(".triggerRange",r),label:k.get("trigger.range")+"?",key:"checkbox"}),s.makeFor({value:t.Time.make(t.RelTime.MILLIS_IN_DAY-1),element:i(".triggerEndTime",r)}),s.makeFor({value:t.RelTime.make(t.RelTime.MILLIS_IN_HOUR),element:i(".triggerInterval",r),durationOrder:["h","i"]})).spread(function(e,t,i,r){n.startEditor=e,n.rangeEditor=t,n.endEditor=i,n.intervalEditor=r})},doLoad:function(e){return this.updateTriggerCountDisplay()},doRead:function(){return v(this).then(function(e){var n=e.start,i=e.isRange,r=e.end,a=e.interval;return i?g(n,r,a):[t.$(E,{start:n,finish:t.Time.make(n.getTimeOfDayMillis()+2e4)})]})},doSave:function(e){var t=this.value(),n=o.map(e,function(e){if(!m(t,e.getStart()))return t.add({slot:"time?",value:e})});return a.all(n).then(function(){return t})}});return x.prototype.updateTriggerCountDisplay=function(){var e=this.jq();return v(this).then(function(n){var i=n.start,r=n.end,a=n.interval,o=r.getTimeOfDayMillis()-i.getTimeOfDayMillis()+t.RelTime.MILLIS_IN_MINUTE,l=a.getMillis(),u=l>=t.RelTime.MILLIS_IN_MINUTE,s=Math.max(Math.ceil(o/l),1),c=e.find(".triggersToCreate"),d=u?b.get("schedule.triggersToCreate")+": "+s:b.get("schedule.message.intervalRequired");c.text(d),c.toggleClass("error",!u)})},s.register("schedule:DaySchedule",x,"triggers-add"),{TriggersAddEditor:x,TriggersListEditor:w}});var _slicedToArray=function(){function e(e,t){var n=[],i=!0,r=!1,a=void 0;try{for(var o,l=e[Symbol.iterator]();!(i=(o=l.next()).done)&&(n.push(o.value),!t||n.length!==t);i=!0);}catch(e){r=!0,a=e}finally{try{!i&&l.return&&l.return()}finally{if(r)throw a}}return n}return function(t,n){if(Array.isArray(t))return t;if(Symbol.iterator in Object(t))return e(t,n);throw new TypeError("Invalid attempt to destructure non-iterable instance")}}();define("mobile/schedule/schedule.ui",["baja!schedule:WeeklySchedule,schedule:CalendarSchedule,schedule:TriggerSchedule,schedule:AbstractSchedule,schedule:DailySchedule,mobile:ScheduleServerSideCallHandler,schedule:WeekSchedule","css!mobile/schedule/schedule.ui","baja!","lex!baja,mobile,schedule","jquery","jquerymobile","Promise","underscore","mobile/util/time","mobile/util/aop","mobile/util/slot","bajaux/commands/Command","bajaux/events","mobile/util/mobile/mobile","mobile/util/mobile/pages","mobile/util/mobile/commands","mobile/util/mobile/dialogs","mobile/util/mobile/views/RadioButtonView","mobile/fieldeditors/fieldeditors","mobile/fieldeditors/fieldeditors.dialogs","mobile/schedule/schedule","mobile/schedule/ScheduleBlock","mobile/schedule/schedule.ui.calendar","mobile/schedule/util.schedule","mobile/schedule/util.schedule.datebox","mobile/schedule/schedule.fieldeditors","mobile/schedule/schedule.fieldeditors.triggers"],function(e,t,n,i,r,a,o,l,u,s,c,d,f,p,h,m,g,v,y,b,k,S,T,E,j){"use strict";function D(e){n.error(e)}function w(){var e,t=r("#schedule"),n=r("#main"),i=t.find("div.scheduleLabels");return ne(n),Le.load(Le.value()).then(function(){Le.layout(),e=t.find("div.blocksDisplay").height(),re(i,e)})}function x(e,t){Ue=t,r(".edit .ui-icon",e).toggleClass("ui-icon-grid",!t).toggleClass("ui-icon-plus",t),r(".edit .ui-btn-text",e).text(ve.get(t?"create":"edit")),r(".delete",e).toggleClass(we,t)}function C(e){return n.strictArg(e,n.Component),e.isMounted()?e.serverSideCall({typeSpec:De,methodName:"getSnapshot"}):o.reject("Cannot call 'getSnapshot' on an unmounted Component")}function M(){Le.setModified(!1),g.ok({title:ve.get("schedule.scheduleUnmounted"),content:ve.get({key:"schedule.message.scheduleUnmounted",args:Ne.getDisplayName()}),ok:function(){X(n.getUserHome())}})}function I(e){var t,i,a=e.getType(),o=e.getPermissions();a.is(be)?t=e.get("schedule").get("specialEvents"):a.is(ke)?t=e:a.is(Se)&&(t=e.get("dates")),i=t&&t.getPermissions(),Ne=e,r("#main-title").text(Ne.getDisplayName()),Pe=t,Ie=!o.hasOperatorWrite()||e.getFlags()&n.Flags.READONLY||e.has("ext"),Ae=i&&i.hasOperatorRead(),Oe=i&&!i.hasOperatorWrite()||t&&t.getFlags()&n.Flags.READONLY||e.has("ext"),r("#main-save, #editDay-edit, #editDay-delete, #editDay-actions, #specialEvents-add, #editSpecialEvent-edit, #editSpecialEvent-delete, #editSpecialEvent-actions").toggleClass(we,Ie)}function A(e){Le=new k(e),ae(Le),Fe=e;var t=e.getType();return t.is(be)?qe=e.get("schedule").get("specialEvents"):t.is(ke)?qe=e:t.is(Se)&&(qe=e.get("dates")),s.after(Le,"setModified",function(e){var t=e[0];r(".commandsButton").toggleClass("red",t),r("#main-save").toggleClass(we,!t)}),Le.setModified(!1),Le.setEnabled(!1),Le.initialize(r("#schedule").empty())}function O(){var e,t=new n.Subscriber;return t.attach("unmount",M),n.Ord.make(niagara.view.ord).get({subscriber:t}).then(function(t){if(e=t,e.has("schedule"))return e.get("schedule").loadSlots()}).then(function(){return I(e),C(e)}).then(function(e){return A(e)})}function L(){return new o(function(e){g.ok({title:ve.get("schedule.saved"),content:ve.get("schedule.message.savedSuccessfully"),ok:function(t){t.ok(),e()}})})}function N(){return Re&&Re.isModified()?(Le.setModified(!0),Re.save()):o.resolve()}function F(){return N().then(function(){return Le.save()}).then(function(){var e=Le.snapshot;return delete Le.snapshot,A(e)}).then(function(){return L()}).then(w).catch(g.error)}function P(){return new o(function(e,t){Le.isModified()?g.confirmAbandonChanges({viewName:G(ye.get("scheduler.weeklySchedule")),yes:function(t){F().then(function(){t.ok(),e()})},no:function(t){O().then(function(){t.ok(),e()})},cancel:function(){g.closeCurrent()}}):e()})}function q(){K()}function _(e){var t=e.attr("id"),n=e.children(Ce),i=r('<div data-role="navbar"/>').appendTo(n),a=r("<ul/>").appendTo(i),o=Ne.getType(),l=o.is(be),u=o.is(Se);l&&a.append(Me({pageId:t,tabId:"main",text:ye.get("scheduler.weeklySchedule")})),a.append(Me({pageId:t,tabId:"specialEvents",text:ye.get("scheduler.specialEvents")})),u&&a.append(Me({pageId:t,tabId:"triggers",text:ve.get("schedule.triggers")})),l&&a.append(Me({pageId:t,tabId:"properties",text:ye.get("scheduler.properties")})),a.append(Me({pageId:t,tabId:"summary",text:ye.get("summary")})),Ae||n.find(".to-specialEvents").addClass(we)}function R(e){return new o(function(t,n){g.okCancel({title:ve.get("schedule."+(Ue?"createBlock":"editBlock")),content:function(t){return e.buildAndLoad(t).then(function(){Ue||e.jq().on("datebox",'input:jqmData(role="datebox")',function(t,n){if("offset"===n.method){var i;switch(n.type){case"h":i=ce*n.amount;break;case"i":i=de*n.amount}he(r(this),Re,e,i)}return!1})})},ok:function(i){e.save().then(function(){var n=e.value();oe(n.get("effectiveValue")),Re.setModified(!0),i.ok(),t(n)}).catch(function(e){i.fail(e),n(e)})},callbacks:{ok:function(){r("#okCancelDialog").find(".ui-datebox-screen, .ui-datebox-container").remove(),J().children(".ui-dialog-datebox").remove()},fail:g.error}})})}function B(e){return e?y.makeFor({value:e.createTimeSchedule(),facets:Le.value().get("facets"),autoInitialize:!1}).then(function(e){return e.validators().add(function(e){var t={startTime:e.get("start"),finishTime:e.get("finish"),dayEditor:Re,mschange:0};return o.all([pe(r.extend(t,{slot:"start"})),pe(r.extend(t,{slot:"finish"}))])}),R(e)}).then(function(t){return S.call(e,t),e}):o.resolve()}function U(){if(Ue){return B(new S(n.Time.DEFAULT,n.Time.DEFAULT,Le.getNewBlockValue())).then(function(e){Re.addBlock(e.start,e.finish,e.value)})}return B(Re.getSelectedBlock())}function H(e){return e=n.objectify(e,"value"),e.value?(Re&&Re.unbindAll&&(Re.unbindAll(),Re.jq().remove()),y.makeFor(l.extend({},e,{container:e.value.getParent(),slot:e.value.getPropertyInParent(),element:e.element||Re&&Re.jq().parent()})).then(function(t){return Re=t,t.load(e.value)})):o.resolve()}function z(e){var t=Re.getSelectedBlock(),n=[],i=Re.$dayDisplay+(t?" ("+t.toString()+")":"");l.each(He,function(t,i){e[i]&&n.push(t)}),m.showCommandsDialog(n,i)}function V(){function e(){return P().then(function(){return O()})}function t(){return Le.isModified()||Re&&Re.isModified()?new o(function(e,t){g.confirmAbandonChanges({viewName:ye.get("scheduler.weeklySchedule"),yes:function(){F().then(function(){return p.invoke()}).then(e,t)},no:function(){Le.setModified(!1),p.invoke().then(e,t)}})}):p.invoke()}function i(e){return(Le.isModified()?[u,c]:[c]).concat(e.commands)}var u,c,p=m.getHomeCmd(),k=m.getDefaultCommands(),S=l.indexOf(k,p);u=new d("%lexicon(mobile:save)%",function(){return F()}),c=new d("%lexicon(mobile:refresh)%",function(){return e()}),p.toDisplayName().then(function(e){k[S]=new d(e,t),m.setDefaultCommands(k)}),h.register("main",function(){function e(e){_(e.page),te(r("#main-footer")),r("#main-save").click(function(){var e=r(this);e.hasClass(we)||(e.addClass(we),F().catch(D))}),r("#main-refresh").click(function(){P().then(function(){return O()}).then(w).catch(D)}),r("#schedule").on("click","div.day",function(){h.getHandler("editDay").load(r(this).data("daySchedule"))})}function t(){ne(r("#main")),Le&&w()}function n(){r("#main-main").addClass(xe),t()}function o(e){Ne&&!Ne.getType().is(be)&&(a.changePage("#specialEvents",{changeHash:!1,
transition:"none"}),e.event.preventDefault())}return{pagebeforeshow:o,pagebeforecreate:e,pagelayout:n,redraw:t,getCommands:i}}()),h.register("editDay",function(){function e(e){return function(){if(Re.isModified())return g.confirmAbandonChanges({yes:N,redirect:e,viewName:ve.get("schedule.dayEditor")}),!1}}function t(){var e=Re.getSelectedBlock(),t=!!Re.scheduleBlocks.length;z({delete:!!e,paste_day:!!Be,all_day:!0,apply_weekdays:t,copy_day:t,clear_day:t,clear_week:!0})}function n(t){t.page.children(Ce).find("a.profileHeaderBack").on("click",e("#main"))}function i(){var e=r("#editDay-day");ne(r("#editDay")),Re&&Re.layout(),re(e.find(".scheduleLabels"),e.find(".blocksDisplay").height())}function o(){var e=r("#editDay-day").empty(),t=_e.getParent(),n=t&&t.getName(),a=n&&ge.get(n),o={value:_e,element:e,readonly:Ie,label:a};return ie(e),H(o).then(function(){x(r("#editDay-footer"),!0),i()})}function l(){Re.refreshWidgets(),x(r("#editDay-footer"),!0),i()}function u(){r("#editDay-day").on("selectionchange",function(){var e=!!Re.getSelectedBlock();x(r("#editDay-footer"),!e)}).on("dblclick",function(){B(Re.getSelectedBlock()).catch(D)}),r("#editDay-footer").on("click","a",function(){switch(r(this).attr("id")){case"editDay-save":N().catch(D);break;case"editDay-refresh":Re.isModified()?g.confirmAbandonChanges({yes:function(e){N().then(e.ok,e.fail)},no:function(e){o().then(e.ok,e.fail)},viewName:ve.get("schedule.dayEditor")}):o().catch(D);break;case"editDay-actions":t();break;case"editDay-edit":U().then(l);break;case"editDay-delete":Re.removeBlock(Re.getSelectedBlock()),l()}})}function s(){l(),x(r("#editDay-footer"),!0)}function c(e){_e=e,o().then(function(){a.changePage("#editDay")}).catch(D)}function d(){i()}function f(e){Re.isModified()&&(g.confirmAbandonChanges({yes:function(e){N().then(e.ok,e.fail)},no:function(e){H(_e).then(e.ok,e.fail)},redirect:e.nextPage,viewName:ve.get("schedule.dayEditor")}),e.event.preventDefault())}return{load:c,rebuild:o,relayout:i,pagebeforechange:f,pagebeforecreate:u,pagebeforeshow:s,pagecreate:n,pagelayout:d}}()),h.register("properties",function(){function e(e,t){return f.read().then(function(n){return T.showEffectiveRangeCalendar(e,n,t)})}function t(){var e=d.slice();e.push(f);var t=l.map(e,function(e){return e.isModified()&&e.validate()});return o.all(t).then(function(){var t=l.map(e,function(e){return e.save()});return o.all(t)}).then(function(){Le.setModified(!0)})}function a(i){var a=l.debounce(function(t,n){e(t,n).catch(D)},600);_(i.page),r("#properties-save").click(function(){t().catch(D)}),r("#properties-calendars").on("datebox",'input:jqmData(role="datebox")',function(e,t){if("offset"===t.method){var i=n.AbsTime.make({jsDate:t.newDate});a(r("#properties-calendars"),i)}}),te(r("#properties-footer"))}function u(e){e.empty(),d=[];var t=["defaultOutput","facets","cleanupExpiredEvents"],n=Le.value(),i=l.map(t,function(t){var i=r("<div></div>").addClass(t).appendTo(e),a=y.toLabeledEditorContainer(String(t),i);return y.makeFor({element:a,container:n,slot:t,facets:n.get("facets"),readonly:Ie}).then(function(e){d.push(e)})});return o.all(i)}function s(){var e=Le.value();u(r("#properties-editors")).catch(D),T.loadScheduleEditor(r("#properties"),e.get("effective"),Ie).then(function(e){T.bindEditorToCalendar(e,r("#properties-calendars")),f=e}).catch(function(e){n.error("properties: could not load schedule editor: "+e)}),T.showEffectiveRangeCalendar(r("#properties-calendars"),e.get("effective"),n.AbsTime.now()).catch(D),r("#properties-properties").addClass(xe),r("#properties-title").text(Ne.getDisplayName())}function c(){q()}var d,f;return{pagebeforecreate:a,pagebeforeshow:s,pageshow:c,getCommands:i}}()),h.register("specialEvents",function(){function e(){return o.initialize(r("#specialEvents-eventList").empty()).then(function(){return o.load(u)}).then(function(){o.setSelectedSlot(o.$selectedSlot)})}function t(t){_(t.page),o=new l;var i=r("#specialEvents-navbar");te(i),i.on("click","a",function(){var t=r(this),i=String(o.getSelectedSlot());if(!t.hasClass(we))switch(r(this).attr("id")){case"specialEvents-add":h.getHandler("addSpecialEvent").load(u);break;case"specialEvents-edit":h.getHandler("editSpecialEvent").load(o.getSelectedValue());break;case"specialEvents-priorityUp":se(u,i).catch(D),e().catch(D),Le.setModified(!0);break;case"specialEvents-priorityDown":le(u,i).catch(D),e().catch(D),Le.setModified(!0);break;case"specialEvents-delete":g.yesNo({content:ve.get({key:"schedule.message.confirmDeleteSpecialEvent",def:"{0}",args:[n.SlotPath.unescape(String(i))]}),yes:function(t){u.remove(i).then(function(){return o.setSelectedSlot(null),e()}).then(function(){Le.setModified(!0),t.ok()})}});break;case"specialEvents-rename":b.fieldEditor({title:ye.get("composite.rename"),value:n.SlotPath.unescape(i)}).then(function(t){if(null!==t)return t=n.SlotPath.escape(t),t!==i?u.rename({slot:i,newName:t}).then(function(){return Le.setModified(!0),e()}):void 0}).catch(g.error)}})}function a(){u=qe,e().then(function(){o.getSelectedSlot()||r("#specialEvents-footer").find("a").addClass(we),Oe||r("#specialEvents-add").removeClass(we),r("#specialEvents-specialEvents").addClass(xe),r("#specialEvents-title").text(Ne.getDisplayName()),r("#specialEvents-edit").find(".ui-btn-text").text(ve.get(Oe?"view":"edit"))})}var o,l,u;return l=n.subclass(function(){n.callSuper(l,this,arguments)},v),l.prototype.shouldIncludeSlot=function(e){return e.isProperty()&&e.getType().is(Te)},l.prototype.doLoad=function(e){if(e.getSlots().properties().dynamic().toArray().length)return v.prototype.doLoad.call(this,e);this.jq().text(ve.get("schedule.message.noSpecialEvents"))},l.prototype.makeLabel=function(e,t){var i=Y(String(t)),a=e.getDisplay(t),o=n.SlotPath.unescape(String(t)),l=r('<label data-theme="c"/>').attr("for",i);return l.append(r("<span/>").text(o)).append(r("<br/>")).append(r("<span/>").text(a)),l},s.after(l.prototype,"selectionChanged",function(e){if(Oe)r("#specialEvents-edit").removeClass(we);else{r("#specialEvents-footer").find("a").removeClass(we);var t=String(e[0]),n=this.value(),i=n.getSlots().is(Te).toArray(),a=i[0],o=i[i.length-1];a&&t===String(a)&&r("#specialEvents-priorityUp").addClass(we),o&&t===String(o)&&r("#specialEvents-priorityDown").addClass(we)}}),{pagebeforecreate:t,pagebeforeshow:a,getCommands:i}}()),h.register("triggers",function(){function e(){r("#triggers-triggers").addClass(xe),r("#triggers-remove").addClass(we),y.makeFor({value:Fe.get("times"),key:"triggers-list",element:r("#triggers-triggerList").empty()}).then(function(e){a=e})}function t(e){_(e.page),r("#triggers-triggerList").on(f.MODIFY_EVENT,n.throttle(function(){r("#triggers-remove").toggleClass(we,!a.getSelectedSlots().length)},100)).on("change","#selectAll",function(){var e=r(this).is(":checked");r("#triggers-triggerList").find(".ui-li-static input[type=checkbox]").prop("checked",e).checkboxradio("refresh")}),r("#triggers-add").click(function(){b.fieldEditor({title:ve.get("schedule.addTrigger"),value:Fe.get("times"),key:"triggers-add"}).then(function(e){null!==e&&Le.setModified(!0)}).catch(g.error)}),r("#triggers-remove").click(function(){a.removeSelected().then(function(){Le.setModified(!0),r("#triggers-triggerList").trigger("updatelayout"),r("#triggers-remove").addClass(we)}).catch(D)}),te(r("#triggers-navbar"))}var a;return{pagebeforeshow:e,pagebeforecreate:t,getCommands:i}}()),h.register("addSpecialEvent",function(){function e(e){var t,i=n.SlotPath.escape(e);return s.save().then(function(){var e=s.value();return t=Ne.getType().is(be)?n.$(Ee,{days:e}):e,u.add({slot:i,value:t})}).then(function(){return Ne.serverSideCall({typeSpec:De,methodName:"getDailyScheduleDisplayString",value:t})}).then(function(e){u.getSlot(i).$display=e,ue(u,i),Le.setModified(!0),history.back()})}function t(e){var t=new Date;e.find(".schedule-DayOfMonthSchedule").find("select").val(String(t.getDate())).selectmenu("refresh"),e.find(".schedule-MonthSchedule").find("select").val(String(t.getMonth())).selectmenu("refresh"),e.find(".schedule-YearSchedule").find("select").val(String(t.getFullYear())).selectmenu("refresh")}function i(){for(var e=0,t="Event";u.has(t);)e++,t="Event"+e;return t}function o(){var i=r("#addSpecialEvent-typesList");Ne.getType().is(be)||i.find('option[value="schedule:ScheduleReference"]').remove(),i.change(function(){var e=r(this).val(),i=n.$(e);y.makeFor({value:i,element:r("#addSpecialEvent-editors").empty()}).then(function(e){var n=e.jq();i.getType().is(je)&&t(n),n.trigger("updatelayout"),s=e}).catch(g.error)}),r("#addSpecialEvent-editors").on(f.MODIFY_EVENT,function(){r("#addSpecialEvent-save").removeClass(we)}),te(r("#addSpecialEvent-footer")),r("#addSpecialEvent-save").click(function(){var t=r("#addSpecialEvent-name").val();u.has(t)?g.ok({content:ve.get({key:"schedule.message.nameInUse",args:[t]})}):e(t).catch(g.error)})}function l(e){u=e,a.changePage(r("#addSpecialEvent")),r("#addSpecialEvent-typesList").trigger("change"),r("#addSpecialEvent-name").val(i())}var u,s;return{load:l,pagebeforecreate:o}}()),h.register("editSpecialEvent",function(){function e(e){return e.save().then(function(){return Ne.serverSideCall({typeSpec:De,methodName:"getDailyScheduleDisplayString",value:w})}).then(function(e){w.getPropertyInParent().$display=e,Le.setModified(!0)})}function t(e,t){return j.read().then(function(n){return C=!1,T.showEffectiveRangeCalendar(e,n,t)})}function i(){return N().then(function(){return j.isModified()&&e(j)})}function u(e){return function(){if(Re&&Re.isModified()||j.isModified())return g.confirmAbandonChanges({yes:function(e){i().then(e.ok,e.fail)},redirect:e,viewName:w.getDisplayName()}),!1}}function s(){2===I?Oe?r("#editSpecialEvent-refresh").removeClass(we):(r("#editSpecialEvent-actions, #editSpecialEvent-refresh").removeClass(we),r("#editSpecialEvent-edit").removeClass(we),r("#editSpecialEvent-delete").toggleClass(we,!Re.getSelectedBlock())):r("#editSpecialEvent-footer").find('a[id!="editSpecialEvent-save"]').addClass(we)}function c(){var e=r("#editSpecialEvent-dayWrapper"),t=r("#editSpecialEvent-day");ne(r("#editSpecialEvent"),e);var n=Math.max(e.height(),r("#editSpecialEvent-editors").children(".editor").height());r("#editSpecialEvent-content").height(n),Re&&Re.layout(),re(t.children(".scheduleLabels"),t.find(".blocksDisplay").height()),s()}function d(){var e=r("#editSpecialEvent-day").empty();return ie(e),H({value:_e,label:n.SlotPath.unescape(w.getName()),readonly:Oe,element:e}).then(function(){r("#editSpecialEvent-edit").addClass(we),r("#editSpecialEvent-delete").addClass(we),c()})}function p(){Re&&Re.refreshWidgets(),x(r("#editSpecialEvent-footer"),!0),c()}function h(){z({delete:!!Re.getSelectedBlock(),paste_day:!1,all_day:!0,apply_weekdays:!1,copy_day:!1,clear_day:!!Re.scheduleBlocks.length,clear_week:!1})}function m(e){var i,a,o=r("#editSpecialEvent-content"),l=r(document.documentElement).outerWidth();0===e&&C&&(i=r("#editSpecialEvent-calendars"),a=fe(i),t(i,a).catch(n.error)),o.children().each(function(){var t=r(this),n=t.index();t.animate({left:l*(n-e),right:l*(e-n)},"fast")}),I=e,s()}function v(e){e.page.children(Ce).find("a.profileHeaderBack").on("click",u("#specialEvents"))}function y(){Ne.getType().is(be)||(r("#editSpecialEvent-dayEditorLink").parent().remove(),r("#editSpecialEvent-edit").parent().remove(),r("#editSpecialEvent-delete").parent().remove(),r("#editSpecialEvent-actions").parent().remove(),r("#editSpecialEvent-refresh").parent().remove()),r("#editSpecialEvent-day").on("selectionchange",function(){var e=!!Re.getSelectedBlock();x(r("#editSpecialEvent-footer"),!e)}).on("dblclick",function(){B(Re.getSelectedBlock()).catch(D)}),r("#editSpecialEvent-navbar").on("click","a",function(){switch(r(this).attr("id")){case"editSpecialEvent-calendarLink":m(0);break;case"editSpecialEvent-activeDatesLink":m(1);break;case"editSpecialEvent-dayEditorLink":m(2)}});var e=r("#editSpecialEvent-footer");te(e),e.on("click","a",function(){switch(r(this).attr("id")){case"editSpecialEvent-save":i().then(function(){history.back()},g.error);break;case"editSpecialEvent-refresh":Re.isModified()?g.confirmAbandonChanges({yes:N,callbacks:function(){var e=r("#editSpecialEvent-calendars"),n=fe(e);d().catch(D),t(e,n).catch(D)},viewName:ve.get("schedule.dayEditor")}):d().catch(D);break;case"editSpecialEvent-actions":h();break;case"editSpecialEvent-edit":U().then(p);break;case"editSpecialEvent-delete":Re.removeBlock(Re.getSelectedBlock()),p()}}),r("#editSpecialEvent-content").on(f.MODIFY_EVENT,function(){C=!0}),r("#editSpecialEvent-calendars").on("datebox",'input:jqmData(role="datebox")',function(e,t){if("offset"===t.method){var i=r("#editSpecialEvent-calendars"),a=n.AbsTime.make({jsDate:t.newDate});o.resolve(M(i,a)).catch(D)}})}function b(e){w=e,_e=w.get("day"),r("#editSpecialEvent-eventName").text(n.SlotPath.unescape(e.getName())),d().then(function(){return a.changePage("#editSpecialEvent"),T.loadScheduleEditor(r("#editSpecialEvent"),w.get("days")||w,Oe)}).then(function(e){var n=r("#editSpecialEvent-calendars"),i=fe(n);return j=e,t(n,i)}).catch(function(e){D("editSpecialEvent.pagebeforeshow: failed to load schedule editor: "+e)})}function k(){if(!w)return void a.changePage("#specialEvents");p(),x(r("#editSpecialEvent-footer"),!0)}function S(){Re&&(document.title=r("#editSpecialEvent-header").children("h1").text(),c(),m(I||0))}function E(e){(Re&&Re.isModified()||j.isModified())&&(g.confirmAbandonChanges({yes:function(e){i().then(e.ok,e.fail)},no:function(e){H(_e).then(e.ok,e.fail)},redirect:e.nextPage,viewName:ye.get("summary.specialEvent")}),e.event.preventDefault())}var j,w,C,M,I=0;return M=l.debounce(t,600),r(window).resize(n.throttle(function(){m(I||0)})),{pagebeforechange:E,pagebeforecreate:y,pagebeforeshow:k,pagecreate:v,pagelayout:S,load:b,rebuild:d,relayout:c}}()),h.register("summary",function(){function e(e){var t=e.substring(0,4),i=e.substring(5,7),r=e.substring(8,10),a=n.Date.make({year:Number(t),month:Number(i)-1,day:Number(r)}),o=n.Time.make(9*ce);return n.AbsTime.make({date:a,time:o})}function t(e,t){return T.showEffectiveRangeCalendar(e,Le.value(),t).catch(D)}function a(t){_(t.page),r("#summary-calendars").on("datebox",'input:jqmData(role="datebox")',function(t,i){if("offset"===i.method){var a=r("#summary-calendars"),o=n.AbsTime.make({jsDate:i.newDate});u(a,o)}else"set"===i.method&&Ne.getType().is(be)&&T.showDaySummary(r("#summary-summaryList"),Le.value(),e(i.value)).catch(D)})}function o(){T.showEffectiveRangeCalendar(r("#summary-calendars"),Le.value(),n.AbsTime.now()).catch(D),r("#summary-summary").addClass(xe),r("#summary-title").text(Ne.getDisplayName())}var u;return u=l.debounce(t,600),{pagebeforecreate:a,pagebeforeshow:o,getCommands:i}}())}function $(e,t){if(!Le){var n;n="string"==typeof t.toPage?a.path.parseUrl(t.toPage).hash.replace("#","")||"main":t.toPage.attr("id"),e.preventDefault(),e.stopImmediatePropagation(),O().then(function(){t.options.changeHash=!0,"editDay"===n?a.changePage("#main",t.options):"addSpecialEvent"===n||"editSpecialEvent"===n?a.changePage("#specialEvents",t.options):(t.options.changeHash=!1,a.changePage("#"+n,t.options))})}}function W(){V(),r(window).on("resize",n.throttle(function(){Q().trigger("pagelayout")},500)),window.onbeforeunload=function(){if(Le.isModified())return ve.get({key:"message.viewModified",args:[ye.get("scheduler.weeklySchedule")]})},r(function(){r(".commandsButton").click(m.showCommandsHandler)}),Z(function(){ee(J(),"pagebeforechange",$)})}var Y=p.encodePageId,G=p.escapeHtml,Q=p.getActivePage,J=p.getPageContainer,K=p.hidePageLoadingMsg,X=p.linkToOrd,Z=p.onPageContainerCreate,ee=p.prependEventHandler,te=p.preventNavbarHighlight,ne=p.setContentHeight,ie=E.appendTimeLabels,re=E.relayoutLabelsDiv,ae=E.setCurrentSchedule,oe=E.setLastEnteredValue,le=c.moveDown,ue=c.moveToTop,se=c.moveUp,ce=u.MILLIS_IN_HOUR,de=u.MILLIS_IN_MINUTE,fe=j.getAbsTime,pe=j.validateTimeChange,he=j.validateTimeScheduleEditor,me=_slicedToArray(i,3),ge=me[0],ve=me[1],ye=me[2],be="schedule:WeeklySchedule",ke="schedule:CalendarSchedule",Se="schedule:TriggerSchedule",Te="schedule:AbstractSchedule",Ee="schedule:DailySchedule",je="schedule:DateSchedule",De="mobile:ScheduleServerSideCallHandler",we="ui-disabled",xe="ui-btn-active",Ce=":jqmData(role=header)",Me=function(e){var t=e.pageId,n=e.tabId,i=e.text;return'\n      <li>\n        <a id="'+t+"-"+n+'" class="to-'+n+'" href="#'+n+'" data-theme="b">\n          '+G(i)+"\n        </a>\n      </li>"},Ie=!1,Ae=!1,Oe=!1,Le=void 0,Ne=void 0,Fe=void 0,Pe=void 0,qe=void 0,_e=void 0,Re=void 0,Be=void 0,Ue=!0,He=void 0;return He={delete:new d("%lexicon(schedule:day.delete)%",function(){Re.removeBlock(Re.getSelectedBlock())}),all_day:new d("%lexicon(schedule:day.all_day)%",function(){var e=Re.getSelectedBlock();Re.allDayEvent(e?e.value:Le.getNewBlockValue())}),apply_weekdays:new d("%lexicon(schedule:day.apply_weekdays)%",function(){Le.applyMF(Re)}),copy_day:new d("%lexicon(schedule:day.copy_day)%",function(){Be=Re}),clear_day:new d("%lexicon(schedule:day.clear_day)%",function(){Re.empty()}),clear_week:new d("%lexicon(schedule:day.clear_week)%",function(){return Le.empty(),H(_e)}),paste_day:new d("%lexicon(schedule:day.paste_day)%",function(){Be&&Be.copyTo(Re)})},W}),require(["jquery","bajaux/bajaux.built.min"],function(e){"use strict";e(document).on("mobileinit",function(){e.mobile.autoInitializePage=!1,e.mobile.defaultPageTransition="slide",e.mobile.transitionFallbacks.slide="none"}),require(["jquerymobile","mobile/schedule/schedule.ui"],function(e,t){t(),e.initializePage()})}),define("mobile/schedule/schedule.run",function(){});